/******************** (C) COPYRIGHT 2008 STMicroelectronics ********************
* File Name          : HSI_calibration.h
* Author             : MCD Application Team
* Version            : V1.0.0
* Date               : 02/02/2009
* Description        : This files contains the HSI calibration functions prototypes
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __HSI_CALIBRATION_H
#define __HSI_CALIBRATION_H

/* Includes ------------------------------------------------------------------*/
/* Exported types ------------------------------------------------------------*/
/* Exported constants --------------------------------------------------------*/
/* Comment this line if the RTC/64 signal (PC13) is not the reference frequency */
#define USE_Reference_RTC
#define Ref_Frequency   512 /* The reference frequency value in Hertz */
#define NbOfPeriod       10 /* NbOfPeriod must be less than
                                0xFFFFFFFF / Freq(HSITRIM)max 
                                If we assume that Freq(HSITRIM)max don't exceed
                                8600000Hz. So NbOfPeriod value must be less than
                                499 */
/* Exported macro ------------------------------------------------------------*/
/* Exported functions ------------------------------------------------------- */
void HSI_FreqMeasure(void);
s32 HSI_CalibrateMinError(void);
ErrorStatus HSI_CalibrateFixedError(u32 AllowedErrorMax, s32* Freq);
void RCC_ConfigurationForHSI(void);
void TIM_ConfigurationForHSI(void);
void RTC_ConfigurationForHSI(void);
void GPIO_ConfigurationForHSI(void);
void Restore_RCC_UserConfiguration(void);
#endif /* __HSI_CALIBRATION_H */

/******************* (C) COPYRIGHT 2008 STMicroelectronics *****END OF FILE****/
