/******************** (C) COPYRIGHT 2009 STMicroelectronics ********************
* File Name          : Driver.h
* Author             : MCD Application Team
* Version            : V2.0.0
* Date               : 02/28/2009
* Description        : Header for Driver.c
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/
/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __DRIVER_H
#define __DRIVER_H
#define DMA_Master_Transmit
//#define DMA_Master_Receive
//#define DMA_Slave_Transmit
//#define DMA_Slave_Receive
//#define IT_Master_Transmit
//#define IT_Master_Receive
//#define IT_Slave_Receive
//#define IT_Slave_Transmit
//#define Polling_Master_Transmit
//#define Polling_Master_Receive

/* Includes ------------------------------------------------------------------*/
#include "stm32f10x_lib.h"
/* Exported types ------------------------------------------------------------*/
/* Exported constants --------------------------------------------------------*/
#define SLAVE_ADDRESS     0x28
#define BufferSize            6
#define ClockSpeed            400000
#define I2C1_DR_Address    0x40005410
#define I2C2_DR_Address    0x40005810
/* Exported macro ------------------------------------------------------------*/
/* Exported functions ------------------------------------------------------- */
void I2C_Master_BufferRead(u8* pBuffer,  u16 NumByteToRead);
void I2C_Master_BufferWrite(u8* pBuffer,  u16 NumByteToWrite);
u8 I2C_Master_BufferRead1Byte(void);
void I2C_Master_BufferRead2Byte(u8* pBuffer);
void I2C_Slave_BufferRead(u8* pBuffer,  u16 NumByteToRead);
void I2C_Slave_BufferWrite(u8* pBuffer,  u16 NumByteToWrite);
void DMA_Channel7_Configuration (void);
void DMA_Channel6_Configuration (void);
void DMA_Channel5_Configuration (void);
void DMA_Channel4_Configuration (void);

#endif

/******************* (C) COPYRIGHT 2009 STMicroelectronics *****END OF FILE****/
