/******************** (C) COPYRIGHT 2009 STMicroelectronics ********************
* File Name          : stm32f10x_it.c
* Author             : MCD Application Team
* Version            : V2.0.0
* Date               : 02/28/2009
* Description        : Main Interrupt Service Routines.
*                      This file provides template for all exceptions handler
*                      and peripherals interrupt service routine.
********************************************************************************
* THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/
/* Includes ------------------------------------------------------------------*/
#include "stm32f10x_it.h"
#include "driver.h"
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define  I2C_EVENT_MASTER_BYTE_RECEIVED_NO_BUSY            ((u32)0x00000040)  /* RxNE */
#define  I2C_EVENT_SLAVE_BYTE_RECEIVED_NO_BUSY             ((u32)0x00000040)  /* RXNE */
#define  I2C_EVENT_SLAVE_BYTE_RECEIVED_STOPF               ((u32)0x00000050)  /* STOPF, RxNE */
#define  I2C_EVENT_SLAVE_BYTE_TRANSMITTING                 ((u32)0x00060080)  /* TRA, BUSY, TXE */
#define  I2C_EVENT_MASTER_BYTE_RECEIVED_BTF                ((u32)0x00030044)  /* BUSY, MSL, RXNE, BTF */
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
extern vu8 Tx_Idx, Rx_Idx;
extern vu8 NumbOfBytes;
extern u8 Master_Buffer_Tx[], Master_Buffer_Rx[];
extern u8 Slave_Buffer_Tx[], Slave_Buffer_Rx[];
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/*******************************************************************************
* Function Name  : NMIException
* Description    : This function handles NMI exception.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void NMIException(void)
{
}

/*******************************************************************************
* Function Name  : HardFaultException
* Description    : This function handles Hard Fault exception.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void HardFaultException(void)
{
    /* Go to infinite loop when Hard Fault exception occurs */
    while (1)
    {
    }
}

/*******************************************************************************
* Function Name  : MemManageException
* Description    : This function handles Memory Manage exception.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void MemManageException(void)
{
    /* Go to infinite loop when Memory Manage exception occurs */
    while (1)
    {
    }
}

/*******************************************************************************
* Function Name  : BusFaultException
* Description    : This function handles Bus Fault exception.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void BusFaultException(void)
{
    /* Go to infinite loop when Bus Fault exception occurs */
    while (1)
    {
    }
}

/*******************************************************************************
* Function Name  : UsageFaultException
* Description    : This function handles Usage Fault exception.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void UsageFaultException(void)
{
    /* Go to infinite loop when Usage Fault exception occurs */
    while (1)
    {
    }
}

/*******************************************************************************
* Function Name  : DebugMonitor
* Description    : This function handles Debug Monitor exception.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void DebugMonitor(void)
{
}

/*******************************************************************************
* Function Name  : SVCHandler
* Description    : This function handles SVCall exception.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void SVCHandler(void)
{
}

/*******************************************************************************
* Function Name  : PendSVC
* Description    : This function handles PendSVC exception.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void PendSVC(void)
{
}

/*******************************************************************************
* Function Name  : SysTickHandler
* Description    : This function handles SysTick Handler.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void SysTickHandler(void)
{

}

/*******************************************************************************
* Function Name  : WWDG_IRQHandler
* Description    : This function handles WWDG interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void WWDG_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : PVD_IRQHandler
* Description    : This function handles PVD interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void PVD_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : TAMPER_IRQHandler
* Description    : This function handles Tamper interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void TAMPER_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : RTC_IRQHandler
* Description    : This function handles RTC global interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void RTC_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : FLASH_IRQHandler
* Description    : This function handles Flash interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void FLASH_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : RCC_IRQHandler
* Description    : This function handles RCC interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void RCC_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : EXTI0_IRQHandler
* Description    : This function handles External interrupt Line 0 request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void EXTI0_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : EXTI1_IRQHandler
* Description    : This function handles External interrupt Line 1 request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void EXTI1_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : EXTI2_IRQHandler
* Description    : This function handles External interrupt Line 2 request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void EXTI2_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : EXTI3_IRQHandler
* Description    : This function handles External interrupt Line 3 request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void EXTI3_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : EXTI4_IRQHandler
* Description    : This function handles External interrupt Line 4 request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void EXTI4_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : DMA1_Channel1_IRQHandler
* Description    : This function handles DMA1 Channel 1 interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void DMA1_Channel1_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : DMA1_Channel2_IRQHandler
* Description    : This function handles DMA1 Channel 2 interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void DMA1_Channel2_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : DMA1_Channel3_IRQHandler
* Description    : This function handles DMA1 Channel 3 interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void DMA1_Channel3_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : DMA1_Channel4_IRQHandler
* Description    : This function handles DMA1 Channel 4 interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void DMA1_Channel4_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : DMA1_Channel5_IRQHandler
* Description    : This function handles DMA1 Channel 5 interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void DMA1_Channel5_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : DMA1_Channel6_IRQHandler
* Description    : This function handles DMA1 Channel 6 interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void DMA1_Channel6_IRQHandler(void)
{
    DMA_Cmd(DMA1_Channel6, DISABLE);
    DMA_ClearFlag(DMA1_FLAG_TC6);
}

/*******************************************************************************
* Function Name  : DMA1_Channel7_IRQHandler
* Description    : This function handles DMA1 Channel 7 interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void DMA1_Channel7_IRQHandler(void)
{
    DMA_Cmd(DMA1_Channel7, DISABLE);
    DMA_ClearFlag(DMA1_FLAG_TC7);
    I2C_GenerateSTOP(I2C1, ENABLE);

}

/*******************************************************************************
* Function Name  : ADC1_2_IRQHandler
* Description    : This function handles ADC1 and ADC2 global interrupts requests.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void ADC1_2_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : USB_HP_CAN_TX_IRQHandler
* Description    : This function handles USB High Priority or CAN TX interrupts
*                  requests.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void USB_HP_CAN_TX_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : USB_LP_CAN_RX0_IRQHandler
* Description    : This function handles USB Low Priority or CAN RX0 interrupts
*                  requests.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void USB_LP_CAN_RX0_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : CAN_RX1_IRQHandler
* Description    : This function handles CAN RX1 interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void CAN_RX1_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : CAN_SCE_IRQHandler
* Description    : This function handles CAN SCE interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void CAN_SCE_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : EXTI9_5_IRQHandler
* Description    : This function handles External lines 9 to 5 interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void EXTI9_5_IRQHandler(void)
{


}

/*******************************************************************************
* Function Name  : TIM1_BRK_IRQHandler
* Description    : This function handles TIM1 Break interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void TIM1_BRK_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : TIM1_UP_IRQHandler
* Description    : This function handles TIM1 overflow and update interrupt
*                  request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void TIM1_UP_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : TIM1_TRG_COM_IRQHandler
* Description    : This function handles TIM1 Trigger and commutation interrupts
*                  requests.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void TIM1_TRG_COM_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : TIM1_CC_IRQHandler
* Description    : This function handles TIM1 capture compare interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void TIM1_CC_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : TIM2_IRQHandler
* Description    : This function handles TIM2 global interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void TIM2_IRQHandler(void)
{

}

/*******************************************************************************
* Function Name  : TIM3_IRQHandler
* Description    : This function handles TIM3 global interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void TIM3_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : TIM4_IRQHandler
* Description    : This function handles TIM4 global interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void TIM4_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : I2C1_EV_IRQHandler
* Description    : This function handles I2C1 Event interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void I2C1_EV_IRQHandler(void)
{


    switch (I2C_GetLastEvent(I2C1))
    {
    case I2C_EVENT_MASTER_MODE_SELECT:                 /* EV5 */
#if defined (DMA_Master_Transmit) || defined (IT_Master_Transmit)
        /* Master Transmitter ----------------------------------------------*/
        /* Send slave Address for write */
        I2C_Send7bitAddress(I2C1, SLAVE_ADDRESS, I2C_Direction_Transmitter);
#endif
#if defined(DMA_Master_Receive) || defined(IT_Master_Receive)

        /* Master Receiver -------------------------------------------------*/
        /* Send slave Address for read */
        I2C_Send7bitAddress(I2C1, SLAVE_ADDRESS, I2C_Direction_Receiver);
#endif

        break;

        /* Master Transmitter --------------------------------------------------*/
        /* Test on I2C1 EV6 and first EV8 and clear them */
    case I2C_EVENT_MASTER_TRANSMITTER_MODE_SELECTED:
#ifdef DMA_Master_Transmit
        DMA_Cmd(DMA1_Channel6, ENABLE);
#endif
#ifdef IT_Master_Transmit
        /* Send the first data */
        I2C_SendData(I2C1, Master_Buffer_Tx[Tx_Idx++]);
        NumbOfBytes--;
        if (NumbOfBytes!=0)
        {
            I2C_SendData(I2C1, Master_Buffer_Tx[Tx_Idx++]);
            NumbOfBytes--;
        }
        if (NumbOfBytes == 0)
        {
            /* In order to not have a TxE event Interrupt */
            I2C_ITConfig(I2C1, I2C_IT_BUF , DISABLE);
        }
#endif
        break;

        /* Test on I2C1 EV8 and clear it */
    case I2C_EVENT_MASTER_BYTE_TRANSMITTING:
#ifdef IT_Master_Transmit
        /* Transmit I2C1 data */
        I2C_SendData(I2C1, Master_Buffer_Tx[Tx_Idx++]);
        NumbOfBytes--;
        if (NumbOfBytes == 0)
        {
            I2C_ITConfig(I2C1, I2C_IT_BUF , DISABLE);
        }
#endif
        break;

    case I2C_EVENT_MASTER_BYTE_TRANSMITTED:


        
        /* I2C1 STOP Condition */
        I2C1->CR1 |= 0x200;
        I2C_ITConfig(I2C1, I2C_IT_EVT, DISABLE); /* In order to not have again a BTF event IT */

        break;

        /* Master Receiver -------------------------------------------------------*/
    case I2C_EVENT_MASTER_RECEIVER_MODE_SELECTED:
#ifdef DMA_Master_Receive
        DMA_Cmd(DMA1_Channel7, ENABLE);
#endif
#ifdef IT_Master_Receive
        if (NumbOfBytes == 1)
        {
            I2C_AcknowledgeConfig(I2C1, DISABLE);
            I2C_GenerateSTOP(I2C1, ENABLE);
        }
        if (NumbOfBytes == 2)
        {
            I2C_AcknowledgeConfig(I2C1, DISABLE);
        }
#endif
        break;

#ifdef IT_Master_Receive        
	/* Test on I2C1 EV7 and clear it */
    case I2C_EVENT_MASTER_BYTE_RECEIVED:

        if ((NumbOfBytes > 3)|| (NumbOfBytes == 1)|| (NumbOfBytes == 2))
        {

            /* Store I2C1 received data */
            Master_Buffer_Rx[Rx_Idx++] = I2C_ReceiveData (I2C1);
            if (NumbOfBytes == 2)
            {
              
              I2C_GenerateSTOP(I2C1, ENABLE);
            }

            NumbOfBytes--;
            if (NumbOfBytes == 3)
            {
                I2C_ITConfig(I2C1, I2C_IT_BUF, DISABLE); /* In order to not have an RxNE event IT */
            }

        }


        break;
        /* In case the STOP is generated on the bus and the last byte remains to be read */
    case I2C_EVENT_MASTER_BYTE_RECEIVED_NO_BUSY:

        /* Store I2C1 received data */
        Master_Buffer_Rx[Rx_Idx++] = I2C_ReceiveData (I2C1);
        NumbOfBytes--;
        break;


    case I2C_EVENT_MASTER_BYTE_RECEIVED_BTF:
        if (NumbOfBytes == 3)
        {
            I2C_AcknowledgeConfig(I2C1, DISABLE);
            I2C_ITConfig(I2C1, I2C_IT_BUF, ENABLE);
            /* Store I2C1 received data */
            Master_Buffer_Rx[Rx_Idx++] = I2C_ReceiveData (I2C1); /* DataN-2 */
            NumbOfBytes--;
            I2C_GenerateSTOP(I2C1, ENABLE);
            Master_Buffer_Rx[Rx_Idx++] = I2C_ReceiveData (I2C1); /* DataN-1 */
            NumbOfBytes--; /* = 1*/
        }
        break;
#endif
    default:
        break;
    }
}
/*******************************************************************************
* Function Name  : I2C1_ER_IRQHandler
* Description    : This function handles I2C1 Error interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void I2C1_ER_IRQHandler(void)
{

    if (I2C_GetFlagStatus(I2C1, I2C_FLAG_AF))
    {
        I2C_ClearFlag(I2C1, I2C_FLAG_AF);

    }

    if (I2C_GetFlagStatus(I2C1, I2C_FLAG_BERR))
    {
        I2C_ClearFlag(I2C1, I2C_FLAG_BERR);

    }
    if (I2C_GetFlagStatus(I2C1, I2C_FLAG_OVR))
    {
        I2C_ClearFlag(I2C1, I2C_FLAG_OVR);

    }

    if (I2C_GetFlagStatus(I2C1, I2C_FLAG_ARLO))
    {
        I2C_ClearFlag(I2C1,I2C_FLAG_ARLO);

    }
}

/*******************************************************************************
* Function Name  : I2C2_EV_IRQHandler
* Description    : This function handles I2C2 Event interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void I2C2_EV_IRQHandler(void)
{


#if defined(DMA_Slave_Transmit) || defined(DMA_Slave_Receive)
    vu32 temp;
    if (I2C_GetFlagStatus(I2C2, I2C_FLAG_ADDR))
    {
        if (I2C_GetFlagStatus(I2C2, I2C_FLAG_TXE) == 1)  /* Transmission */
        {
            DMA_Cmd(DMA1_Channel4, DISABLE);
            DMA1_Channel4->CNDTR = 255;
            I2C_DMACmd(I2C2, ENABLE);
            DMA_Cmd(DMA1_Channel4, ENABLE);
            /* clear ADDR by reading SR2 */
            temp = I2C2->SR2 ;
        }
        else  /* Reception */
        {

            DMA_Cmd(DMA1_Channel5, DISABLE);
            DMA1_Channel5->CNDTR = 255;
            I2C_DMACmd(I2C2, ENABLE);
            DMA_Cmd(DMA1_Channel5, ENABLE);
            /* clear ADDR by reading SR2 */
            temp = I2C2->SR2 ;
        }
    }

    if (I2C_GetFlagStatus(I2C2, I2C_FLAG_STOPF))
    {
        I2C_Cmd(I2C2, ENABLE);
    }

#endif


#if defined(IT_Slave_Transmit) || defined(IT_Slave_Receive)

    switch (I2C_GetLastEvent(I2C2))
    {
        /* Slave Transmitter ---------------------------------------------------*/
    case I2C_EVENT_SLAVE_TRANSMITTER_ADDRESS_MATCHED:  /* EV1 */
        Tx_Idx = 0;
        break;

    case I2C_EVENT_SLAVE_BYTE_TRANSMITTING:             /* EV3 */
        /* Transmit I2C2 data */
        I2C_SendData(I2C2, Slave_Buffer_Tx[Tx_Idx++]);

        break;

        /* Slave Receiver ------------------------------------------------------*/
    case I2C_EVENT_SLAVE_RECEIVER_ADDRESS_MATCHED:
        break;

    case I2C_EVENT_SLAVE_BYTE_RECEIVED:

        Slave_Buffer_Rx[Rx_Idx++] = I2C_ReceiveData(I2C2);
        break;

        /* Case of data not yet read and STOP is generated on the bus */
    case I2C_EVENT_SLAVE_BYTE_RECEIVED_NO_BUSY:
        Slave_Buffer_Rx[Rx_Idx++] = I2C_ReceiveData(I2C2);
        break;

        /* Case of data not yet read and STOPF flag is set */
    case I2C_EVENT_SLAVE_BYTE_RECEIVED_STOPF:

        Slave_Buffer_Rx[Rx_Idx++] = I2C_ReceiveData(I2C2);
        I2C_Cmd(I2C2, ENABLE);
        break;

    case I2C_EVENT_SLAVE_STOP_DETECTED:
        /* Clear I2C2 STOPF flag: read of I2C_SR1 followed by a write on I2C_CR1 */
        I2C_Cmd(I2C2, ENABLE);
        break;

    default:
        break;
    }

#endif

}

/*******************************************************************************
* Function Name  : I2C2_ER_IRQHandler
* Description    : This function handles I2C2 Error interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void I2C2_ER_IRQHandler(void)
{

    if (I2C_GetFlagStatus(I2C2, I2C_FLAG_AF))
    {
        I2C_ClearFlag(I2C2, I2C_FLAG_AF);

    }

    if (I2C_GetFlagStatus(I2C2, I2C_FLAG_BERR))
    {
        I2C_ClearFlag(I2C2, I2C_FLAG_BERR);

    }
    if (I2C_GetFlagStatus(I2C2, I2C_FLAG_OVR))
    {
        I2C_ClearFlag(I2C2, I2C_FLAG_OVR);

    }

    if (I2C_GetFlagStatus(I2C2, I2C_FLAG_ARLO))
    {
        I2C_ClearFlag(I2C2,I2C_FLAG_ARLO);

    }


}

/*******************************************************************************
* Function Name  : SPI1_IRQHandler
* Description    : This function handles SPI1 global interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void SPI1_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : SPI2_IRQHandler
* Description    : This function handles SPI2 global interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void SPI2_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : USART1_IRQHandler
* Description    : This function handles USART1 global interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void USART1_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : USART2_IRQHandler
* Description    : This function handles USART2 global interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void USART2_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : USART3_IRQHandler
* Description    : This function handles USART3 global interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void USART3_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : EXTI15_10_IRQHandler
* Description    : This function handles External lines 15 to 10 interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void EXTI15_10_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : RTCAlarm_IRQHandler
* Description    : This function handles RTC Alarm interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void RTCAlarm_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : USBWakeUp_IRQHandler
* Description    : This function handles USB WakeUp interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void USBWakeUp_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : TIM8_BRK_IRQHandler
* Description    : This function handles TIM8 Break interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void TIM8_BRK_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : TIM8_UP_IRQHandler
* Description    : This function handles TIM8 overflow and update interrupt
*                  request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void TIM8_UP_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : TIM8_TRG_COM_IRQHandler
* Description    : This function handles TIM8 Trigger and commutation interrupts
*                  requests.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void TIM8_TRG_COM_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : TIM8_CC_IRQHandler
* Description    : This function handles TIM8 capture compare interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void TIM8_CC_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : ADC3_IRQHandler
* Description    : This function handles ADC3 global interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void ADC3_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : FSMC_IRQHandler
* Description    : This function handles FSMC global interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void FSMC_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : SDIO_IRQHandler
* Description    : This function handles SDIO global interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void SDIO_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : TIM5_IRQHandler
* Description    : This function handles TIM5 global interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void TIM5_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : SPI3_IRQHandler
* Description    : This function handles SPI3 global interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void SPI3_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : UART4_IRQHandler
* Description    : This function handles UART4 global interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void UART4_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : UART5_IRQHandler
* Description    : This function handles UART5 global interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void UART5_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : TIM6_IRQHandler
* Description    : This function handles TIM6 global interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void TIM6_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : TIM7_IRQHandler
* Description    : This function handles TIM7 global interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void TIM7_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : DMA2_Channel1_IRQHandler
* Description    : This function handles DMA2 Channel 1 interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void DMA2_Channel1_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : DMA2_Channel2_IRQHandler
* Description    : This function handles DMA2 Channel 2 interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void DMA2_Channel2_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : DMA2_Channel3_IRQHandler
* Description    : This function handles DMA2 Channel 3 interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void DMA2_Channel3_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : DMA2_Channel4_5_IRQHandler
* Description    : This function handles DMA2 Channel 4 and DMA2 Channel 5
*                  interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void DMA2_Channel4_5_IRQHandler(void)
{
}

/******************* (C) COPYRIGHT 2009 STMicroelectronics *****END OF FILE****/
