/******************** (C) COPYRIGHT 2008 STMicroelectronics ********************
* File Name          : glasslcd_RTC.h
* Author             : MCD Application Team
* Version            : V1.0.0
* Date               : 07/21/2008
* Description        : LCD glass configuration header file for RTC method.
********************************************************************************
* THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __GLASSLCD_RTC_H
#define __GLASSLCD_RTC_H

/* Includes ------------------------------------------------------------------*/
#include "stm32f10x_lib.h"
#include "SystemConfig_RTC.h"

/* Exported constants --------------------------------------------------------*/

/*----------------------- LCD user configuration -----------------------------*/
/* Incomment the define line of the used LCD and comment the other one */
#define USE_LCD_REF_PD_878    /* LCD ref: PD_878 : 8 digits 128 segments */
//#define USE_LCD_REF_CT4_098  /* LCD ref: CT4-098: 4 digits 64 segments */

/* Common lines configuration ----------------------------------------------- */
#define CommonLines_Port   GPIOC /* Port where the 4 common lines are connected */

#define CommonLines_EightHighPortPins  
                                /*  The previous line is to define where Common
                                    lines are located:
                                    - Uncomment this line: the 4 common lines  
                                      are located between PX.8 and PX.15
                                    - Comment this line: the 4 common lines  
                                      are located between PX.0 and PX.7
                                */

#define CommonLines_Pin_Offset   0   /* Pin offset (do not exceed 4: [0..4]) 
                                       (offset of eight low port pins or
                                       eight high port pins according to
                                       CommonLines_EightHighPortPins commented
                                       or not */

/* Configuration of the two GPIOs which drive the LCD (power on/off) -------- */
#define LCD_Bias_Port        GPIOC /* Port which the LCD bias plus pins are connected */


#define LCD_BiasPlus_Pin     GPIO_Pin_7  /* The number of the first GPIO (LCD bias plus)   
                                            wich will power-off the resistor bridge in 
                                            low power mode */

/* Segment lines configuration ---------------------------------------------- */
/* Port where the Low Quarter digits segment lines are connected */
#define SegmentsLines_LQD_Port   GPIOE  

/* Port where the High Quarter digits segment lines are connected */
#define SegmentsLines_HQD_Port   GPIOD  

/* Enable the used GPIOs clocks */
#define RCC_APB2Periph_Used_GPIO    RCC_APB2Periph_GPIOC \
                                  | RCC_APB2Periph_GPIOD \
                                  | RCC_APB2Periph_GPIOE 

/* LCD interrupt priority configuration ------------------------------------- */
#define LCD_Priority_Value       1

/* If the LCD interrupt is run always as priority 0 please comment this line */
#define LCD_Use_Boost_Priority 

/* LCD Contrast value settings */
/* LCDContrastValue and PeriodValue are the only parameters modifiable by the user */
#define LCDContrastValue          60  /* LCD Contrast value in percent from 0 to 100 */
#define PeriodValue               30  /* Period */

/* Parameters not modifiable by the user */
#define PulseValueForContrast     ((LCDContrastValue * PeriodValue) / 100)
#define DeadTimeValue             (PeriodValue - PulseValueForContrast)
#define PulseValueForContrastLow  (PulseValueForContrast & (u32)0x0000FFFF)
#define PulseValueForContrastHigh ((PulseValueForContrast & (u32)0xFFFF0000) >> 16)
#define DeadTimeValueLow          (DeadTimeValue & (u32)0x0000FFFF)
#define DeadTimeValueHigh         ((DeadTimeValue & (u32)0xFFFF0000) >> 16)

/*------ GPIOs Masks definitions (section not modifiable by the user) --------*/
#ifdef  CommonLines_EightHighPortPins
  #define PinsConfig         CRH
  #define ALL_COMMON_LINES  (u16)(0x000F << (CommonLines_Pin_Offset + 8))
#else
  #define PinsConfig         CRL
  #define ALL_COMMON_LINES  (u16)(0x000F << CommonLines_Pin_Offset)
#endif

#define ALL_COMMON_LINES_PP   (0x3333 << (CommonLines_Pin_Offset * 4))

#define ALL_SEGMENT_LINES      0xFFFF
#define ALL_SEGMENT_LINES_PP   0x33333333

/* Exported types ------------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
/* Exported functions ------------------------------------------------------- */
/* APPLICATION LAYER ---------------------------------------------------------*/
void LCD_GPIO_Init(void);
void Convert (char* c,u8 point);
void LCD_WriteChar (char* car, u8 point,u8 pos);
void LCD_WriteString (char* string);
void LCD_GPIO_Coms_Masks_Init(void);
u32 OffsetValue(u8 Pin_offset);

#endif /* __GLASSLCD_RTC_H */

/******************* (C) COPYRIGHT 2008 STMicroelectronics *****END OF FILE****/
