/******************** (C) COPYRIGHT 2008 STMicroelectronics ********************
* File Name          : stm32f10x_it_RTC.c
* Author             : MCD Application Team
* Version            : V1.0.0
* Date               : 07/21/2008
* Description        : Main Interrupt Service Routines.
*                      This file provides template for all exceptions handler
*                      and peripherals interrupt service routine.
********************************************************************************
* THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "stm32f10x_it.h"
#include "glasslcd_RTC.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
extern NVIC_InitTypeDef NVIC_InitStructure; 
extern GPIO_InitTypeDef GPIO_InitStructure;
extern EXTI_InitTypeDef EXTI_InitStructure;
bool EnableTask1 = TRUE;
bool EnableTask2_3 = FALSE;
extern u16 SegmentsValues_Lower_Quarter_Digits[4];
extern u16 SegmentsValues_Higher_Quarter_Digits[4];
extern const u16 CommonLine[4];
extern u32 CommonLine_OUT_PP[4];
extern u32 CommonLine_VDD_2[4];
u32 lcdcr=0;
vu32 LCDPowerOff=0;

/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/*******************************************************************************
* Function Name  : NMIException
* Description    : This function handles NMI exception.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void NMIException(void)
{
}

/*******************************************************************************
* Function Name  : HardFaultException
* Description    : This function handles Hard Fault exception.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void HardFaultException(void)
{
  /* Go to infinite loop when Hard Fault exception occurs */
  while (1)
  {
  }
}

/*******************************************************************************
* Function Name  : MemManageException
* Description    : This function handles Memory Manage exception.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void MemManageException(void)
{
  /* Go to infinite loop when Memory Manage exception occurs */
  while (1)
  {
  }
}

/*******************************************************************************
* Function Name  : BusFaultException
* Description    : This function handles Bus Fault exception.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void BusFaultException(void)
{
  /* Go to infinite loop when Bus Fault exception occurs */
  while (1)
  {
  }
}

/*******************************************************************************
* Function Name  : UsageFaultException
* Description    : This function handles Usage Fault exception.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void UsageFaultException(void)
{
  /* Go to infinite loop when Usage Fault exception occurs */
  while (1)
  {
  }
}

/*******************************************************************************
* Function Name  : DebugMonitor
* Description    : This function handles Debug Monitor exception.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void DebugMonitor(void)
{
}

/*******************************************************************************
* Function Name  : SVCHandler
* Description    : This function handles SVCall exception.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void SVCHandler(void)
{
}

/*******************************************************************************
* Function Name  : PendSVC
* Description    : This function handles PendSVC exception.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void PendSVC(void)
{
}

/*******************************************************************************
* Function Name  : SysTickHandler
* Description    : This function handles SysTick Handler.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void SysTickHandler(void)
{
}

/*******************************************************************************
* Function Name  : WWDG_IRQHandler
* Description    : This function handles WWDG interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void WWDG_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : PVD_IRQHandler
* Description    : This function handles PVD interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void PVD_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : TAMPER_IRQHandler
* Description    : This function handles Tamper interrupt request. 
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void TAMPER_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : RTC_IRQHandler
* Description    : This function handles RTC global interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void RTC_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : FLASH_IRQHandler
* Description    : This function handles Flash interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void FLASH_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : RCC_IRQHandler
* Description    : This function handles RCC interrupt request. 
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void RCC_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : EXTI0_IRQHandler
* Description    : This function handles External interrupt Line 0 request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void EXTI0_IRQHandler(void)
{
 if(EXTI_GetITStatus(EXTI_Line0) != RESET)
  {
    if(LCDPowerOff == 1)
    {
     /* Disable RTC Clock */
     RCC_RTCCLKCmd(DISABLE);

     /* Disable the RTC Alarm */
     RTC_ITConfig(RTC_IT_ALR, DISABLE);

     /* Wait until last write operation on RTC registers has finished */
     RTC_WaitForLastTask();

     /* Disable the RTC Alarm Interrupt */
     NVIC_InitStructure.NVIC_IRQChannel = RTCAlarm_IRQChannel;
     NVIC_InitStructure.NVIC_IRQChannelCmd = DISABLE;
     NVIC_Init(&NVIC_InitStructure); 

     /* All Common lines = 0 */
     CommonLines_Port->ODR &= ~ALL_COMMON_LINES;

     /* Configure all Common lines on CommonLines port pins as Out_PP */    
     CommonLines_Port->PinsConfig |= ALL_COMMON_LINES_PP;

     /* All Segment lines = 0 ( all SegmentsLines_LQD_Port pins = 0 ) */
     SegmentsLines_LQD_Port->ODR = (u16)~ALL_SEGMENT_LINES;

  #ifdef USE_LCD_REF_PD_878 
     /* All SegmentsLines_LQD_Port pins = 0 */
     SegmentsLines_HQD_Port->ODR = (u16)~ALL_SEGMENT_LINES;
  #endif  
     /* LCD Bias Plus Pin = 0V  */
     GPIO_ResetBits(LCD_Bias_Port, LCD_BiasPlus_Pin);


     /* Clear EXTI pending bit */ 
     EXTI_ClearITPendingBit(EXTI_Line0);

     LCDPowerOff = 0;
   }
   else
   {
     /* Enable the RTC Alarm */
     RTC_ITConfig(RTC_IT_ALR, ENABLE); 

     /* Wait until last write operation on RTC registers has finished */
     RTC_WaitForLastTask();

     /* Enable RTC Clock */
     RCC_RTCCLKCmd(ENABLE);

     /* Wait for RTC registers synchronization */
     RTC_WaitForSynchro();

    /* Enable the RTC Alarm Interrupt */
     NVIC_InitStructure.NVIC_IRQChannel = RTCAlarm_IRQChannel;
     NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
     NVIC_Init(&NVIC_InitStructure); 
    
     /* Power on the resistor bridge  */
     GPIO_SetBits(LCD_Bias_Port, LCD_BiasPlus_Pin);

     /* Clear EXTI pending bit */ 
     EXTI_ClearITPendingBit(EXTI_Line0);

     LCDPowerOff = 1;
   }
  }
}

/*******************************************************************************
* Function Name  : EXTI1_IRQHandler
* Description    : This function handles External interrupt Line 1 request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void EXTI1_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : EXTI2_IRQHandler
* Description    : This function handles External interrupt Line 2 request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void EXTI2_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : EXTI3_IRQHandler
* Description    : This function handles External interrupt Line 3 request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void EXTI3_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : EXTI4_IRQHandler
* Description    : This function handles External interrupt Line 4 request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void EXTI4_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : DMA1_Channel1_IRQHandler
* Description    : This function handles DMA1 Channel 1 interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void DMA1_Channel1_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : DMA1_Channel2_IRQHandler
* Description    : This function handles DMA1 Channel 2 interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void DMA1_Channel2_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : DMA1_Channel3_IRQHandler
* Description    : This function handles DMA1 Channel 3 interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void DMA1_Channel3_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : DMA1_Channel4_IRQHandler
* Description    : This function handles DMA1 Channel 4 interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void DMA1_Channel4_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : DMA1_Channel5_IRQHandler
* Description    : This function handles DMA1 Channel 5 interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void DMA1_Channel5_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : DMA1_Channel6_IRQHandler
* Description    : This function handles DMA1 Channel 6 interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void DMA1_Channel6_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : DMA1_Channel7_IRQHandler
* Description    : This function handles DMA1 Channel 7 interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void DMA1_Channel7_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : ADC1_2_IRQHandler
* Description    : This function handles ADC1 and ADC2 global interrupts requests.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void ADC1_2_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : USB_HP_CAN_TX_IRQHandler
* Description    : This function handles USB High Priority or CAN TX interrupts 
*                  requests.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void USB_HP_CAN_TX_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : USB_LP_CAN_RX0_IRQHandler
* Description    : This function handles USB Low Priority or CAN RX0 interrupts 
*                  requests.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void USB_LP_CAN_RX0_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : CAN_RX1_IRQHandler
* Description    : This function handles CAN RX1 interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void CAN_RX1_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : CAN_SCE_IRQHandler
* Description    : This function handles CAN SCE interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void CAN_SCE_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : EXTI9_5_IRQHandler
* Description    : This function handles External lines 9 to 5 interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void EXTI9_5_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : TIM1_BRK_IRQHandler
* Description    : This function handles TIM1 Break interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void TIM1_BRK_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : TIM1_UP_IRQHandler
* Description    : This function handles TIM1 overflow and update interrupt 
*                  request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void TIM1_UP_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : TIM1_TRG_COM_IRQHandler
* Description    : This function handles TIM1 Trigger and commutation interrupts 
*                  requests.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void TIM1_TRG_COM_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : TIM1_CC_IRQHandler
* Description    : This function handles TIM1 capture compare interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void TIM1_CC_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : TIM2_IRQHandler
* Description    : This function handles TIM2 global interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void TIM2_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : TIM3_IRQHandler
* Description    : This function handles TIM3 global interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void TIM3_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : TIM4_IRQHandler
* Description    : This function handles TIM4 global interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void TIM4_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : I2C1_EV_IRQHandler
* Description    : This function handles I2C1 Event interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void I2C1_EV_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : I2C1_ER_IRQHandler
* Description    : This function handles I2C1 Error interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void I2C1_ER_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : I2C2_EV_IRQHandler
* Description    : This function handles I2C2 Event interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void I2C2_EV_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : I2C2_ER_IRQHandler
* Description    : This function handles I2C2 Error interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void I2C2_ER_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : SPI1_IRQHandler
* Description    : This function handles SPI1 global interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void SPI1_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : SPI2_IRQHandler
* Description    : This function handles SPI2 global interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void SPI2_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : USART1_IRQHandler
* Description    : This function handles USART1 global interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void USART1_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : USART2_IRQHandler
* Description    : This function handles USART2 global interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void USART2_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : USART3_IRQHandler
* Description    : This function handles USART3 global interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void USART3_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : EXTI15_10_IRQHandler
* Description    : This function handles External lines 15 to 10 interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void EXTI15_10_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : RTCAlarm_IRQHandler
* Description    : This function handles RTC Alarm interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void RTCAlarm_IRQHandler(void)
{
   /* Sequence of Tasks:
   Task1 -> Task2 -> Task1 -> Task3 -> Task1 -> Task2 -> Task1 -> Task3 -> ...
  
   * Task 1: all Common Lines and all Segment Lines are in push-pull and are set to 0.
   * Task 2: - Segment_lines[lcdcr] to be turned on are loaded with the value 1 otherwise 0.
             - Common_line[lcdcr] is set to low. 
             - Other Common lines are set to Vdd/2.
   * Task 3: - Segment_lines[lcdcr] values are inverted.
             - Common_line[lcdcr] is set to high.
             - Other Common lines are set to Vdd/2.
  */ 
 
    /* Clear EXTI line17 pending bit (RTC Alarm) */
    EXTI->PR = EXTI_Line17;
     
    if(EnableTask1 == TRUE)  /*------------- Task 1 -------------*/
    {
     /* Reset RTC Counter */
     /* Set the CNF flag to enter in the Configuration Mode */
     RTC->CRL |= (u16)0x0010;
     /* Set RTC COUNTER MSB word */
     RTC->CNTH = 0x0;
     /* Set RTC COUNTER LSB word */
     RTC->CNTL = 0x0;
     /* Reset the CNF flag to exit from the Configuration Mode */
     RTC->CRL &= (u16)0xFFEF;
    
#ifdef USE_POLL_ON_RTOFF    
    /* Wait until last write operation on RTC registers has finished */
    /* Loop until RTOFF flag is set */
    while ((RTC->CRL & RTC_FLAG_RTOFF) == (u16)RESET)
    {
    }
#endif
     /* Set the next occuring time of alarm interrupt  */
     /* Set the CNF flag to enter in the Configuration Mode */
     RTC->CRL |= (u16)0x0010;
     /* Set the Dead time value */
     /* Set the ALARM MSB word */
     RTC->ALRH = DeadTimeValueHigh;
     /* Set the ALARM LSB word */
     RTC->ALRL = DeadTimeValueLow;
     /* Reset the CNF flag to exit from the Configuration Mode */
     RTC->CRL &= (u16)0xFFEF;

#ifdef USE_POLL_ON_RTOFF    
    /* Wait until last write operation on RTC registers has finished */
    /* Loop until RTOFF flag is set */
    while ((RTC->CRL & RTC_FLAG_RTOFF) == (u16)RESET)
    {
    }
#endif
    
     /* All Segment lines = 0 ( all SegmentsLines_LQD_Port pins = 0 ) */
     SegmentsLines_LQD_Port->ODR = (u16)~ALL_SEGMENT_LINES; 
    
#ifdef USE_LCD_REF_PD_878 
     SegmentsLines_HQD_Port->ODR = (u16)~ALL_SEGMENT_LINES;
#endif  
     /* All Common lines = 0 */
     CommonLines_Port->ODR &= ~ALL_COMMON_LINES;
    
     /* Configure all Common lines on CommonLines port pins as Out_PP */    
     CommonLines_Port->PinsConfig |= ALL_COMMON_LINES_PP;
      
     if(EnableTask2_3 == TRUE) /* If Task 2 has been executed previously (before Task 1) then prepare */
     {                         /* the RTC interrupt to execute Task 3 in the next interrupt */
       /* Next interrupt will execute Task 3 and avoid it to execute Task 2 */
       EnableTask2_3 = FALSE;
     }
     else  /* If Task 3 has been executed previously (before Task 1) then prepare */
     {     /* the RTC interrupt to execute Task 2 in the next interrupt */
       /* Next interrupt will execute Task 2 and avoid it to execute Task 3 */
       EnableTask2_3 = TRUE; 
     }
   
     /* Avoid next interrupt to execute Task 1, so the interrupt will execute Task 2 or Task 3 */ 
     EnableTask1 = FALSE;
    }
    else
    { 
      if(EnableTask2_3 == TRUE)  /*------------- Task 2 --------------*/
      {
       /* Reset RTC Counter */
       /* Set the CNF flag to enter in the Configuration Mode */
       RTC->CRL |= (u16)0x0010;
       /* Set RTC COUNTER MSB word to 0 */
       RTC->CNTH = 0x0;
       /* Set RTC COUNTER LSB word to 0 */
       RTC->CNTL = 0x0;
       /* Reset the CNF flag to exit from the Configuration Mode */
       RTC->CRL &= (u16)0xFFEF;
    
#ifdef USE_POLL_ON_RTOFF    
    /* Wait until last write operation on RTC registers has finished */
    /* Loop until RTOFF flag is set */
    while ((RTC->CRL & RTC_FLAG_RTOFF) == (u16)RESET)
    {
    }
#endif       
       /* Set the next occuring time of alarm interrupt */
       /* Set the CNF flag to enter in the Configuration Mode */
       RTC->CRL |= (u16)0x0010;
       /* Set the ALARM MSB word */
       RTC->ALRH = PulseValueForContrastHigh;
       /* Set the ALARM LSB word */
       RTC->ALRL = PulseValueForContrastLow;
       /* Reset the CNF flag to exit from the Configuration Mode */
       RTC->CRL &= (u16)0xFFEF;

#ifdef USE_POLL_ON_RTOFF    
    /* Wait until last write operation on RTC registers has finished */
    /* Loop until RTOFF flag is set */
    while ((RTC->CRL & RTC_FLAG_RTOFF) == (u16)RESET)
    {
    }
#endif
       /* Segment_lines[lcdcr] to be turned on are loaded with the value 1 otherwise 0 */
       SegmentsLines_LQD_Port->ODR = SegmentsValues_Lower_Quarter_Digits[lcdcr];  

#ifdef USE_LCD_REF_PD_878        
       SegmentsLines_HQD_Port->ODR = SegmentsValues_Higher_Quarter_Digits[lcdcr];
#endif 
       /* Common_line[lcdcr] is set to low */
       CommonLines_Port->BRR = CommonLine[lcdcr];
       
       /* Other Common lines set to Vdd/2 */
       CommonLines_Port->PinsConfig &= CommonLine_VDD_2[lcdcr];
       
       /* Set Common_line[lcdcr] out push pull */
       CommonLines_Port->PinsConfig |= CommonLine_OUT_PP[lcdcr];
       
       /* Next interrupt will execute Task 1 */
       EnableTask1 = TRUE;
      
    }
    else                   /*------------- Task 3 -------------*/
    {
     /* Reset RTC Counter */
     /* Set the CNF flag to enter in the Configuration Mode */
     RTC->CRL |= (u16)0x0010;
     /* Set RTC COUNTER MSB word */
     RTC->CNTH = 0x0;
     /* Set RTC COUNTER LSB word */
     RTC->CNTL = 0x0;
     /* Reset the CNF flag to exit from the Configuration Mode */
     RTC->CRL &= (u16)0xFFEF;
    
#ifdef USE_POLL_ON_RTOFF    
    /* Wait until last write operation on RTC registers has finished */
    /* Loop until RTOFF flag is set */
    while ((RTC->CRL & RTC_FLAG_RTOFF) == (u16)RESET)
    {
    }
#endif
    
     /* Set the next occuring time of alarm interrupt */
     /* Set the CNF flag to enter in the Configuration Mode */
     RTC->CRL |= (u16)0x0010;
     /* Set the ALARM MSB word */
     RTC->ALRH = PulseValueForContrastHigh;
     /* Set the ALARM LSB word */
     RTC->ALRL = PulseValueForContrastLow;
     /* Reset the CNF flag to exit from the Configuration Mode */
     RTC->CRL &= (u16)0xFFEF;     

#ifdef USE_POLL_ON_RTOFF    
    /* Wait until last write operation on RTC registers has finished */
    /* Loop until RTOFF flag is set */
    while ((RTC->CRL & RTC_FLAG_RTOFF) == (u16)RESET)
    {
    }
#endif
    
     /* Segment_lines[lcdcr] values are inverted */ 
     SegmentsLines_LQD_Port->ODR = ~SegmentsValues_Lower_Quarter_Digits[lcdcr];  
     
#ifdef USE_LCD_REF_PD_878      
     SegmentsLines_HQD_Port->ODR = ~SegmentsValues_Higher_Quarter_Digits[lcdcr];
#endif 
     
     /* Common_line[lcdcr] is set to high */
     CommonLines_Port->BSRR = CommonLine[lcdcr];
     
     /* Other Common lines set to Vdd/2 */
     CommonLines_Port->PinsConfig &= CommonLine_VDD_2[lcdcr];
     
     /* Other Common lines out push pull */
     CommonLines_Port->PinsConfig |= CommonLine_OUT_PP[lcdcr];
     
     /* Next interrupt will execute Task 1 */
     EnableTask1 = TRUE;  
       
     lcdcr++;
      
     if(lcdcr>3)
     {
       lcdcr = 0;
     }
   }
  }
}

/*******************************************************************************
* Function Name  : USBWakeUp_IRQHandler
* Description    : This function handles USB WakeUp interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void USBWakeUp_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : TIM8_BRK_IRQHandler
* Description    : This function handles TIM8 Break interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void TIM8_BRK_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : TIM8_UP_IRQHandler
* Description    : This function handles TIM8 overflow and update interrupt 
*                  request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void TIM8_UP_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : TIM8_TRG_COM_IRQHandler
* Description    : This function handles TIM8 Trigger and commutation interrupts 
*                  requests.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void TIM8_TRG_COM_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : TIM8_CC_IRQHandler
* Description    : This function handles TIM8 capture compare interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void TIM8_CC_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : ADC3_IRQHandler
* Description    : This function handles ADC3 global interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void ADC3_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : FSMC_IRQHandler
* Description    : This function handles FSMC global interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void FSMC_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : SDIO_IRQHandler
* Description    : This function handles SDIO global interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void SDIO_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : TIM5_IRQHandler
* Description    : This function handles TIM5 global interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void TIM5_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : SPI3_IRQHandler
* Description    : This function handles SPI3 global interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void SPI3_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : UART4_IRQHandler
* Description    : This function handles UART4 global interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void UART4_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : UART5_IRQHandler
* Description    : This function handles UART5 global interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void UART5_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : TIM6_IRQHandler
* Description    : This function handles TIM6 global interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void TIM6_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : TIM7_IRQHandler
* Description    : This function handles TIM7 global interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void TIM7_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : DMA2_Channel1_IRQHandler
* Description    : This function handles DMA2 Channel 1 interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void DMA2_Channel1_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : DMA2_Channel2_IRQHandler
* Description    : This function handles DMA2 Channel 2 interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void DMA2_Channel2_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : DMA2_Channel3_IRQHandler
* Description    : This function handles DMA2 Channel 3 interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void DMA2_Channel3_IRQHandler(void)
{
}

/*******************************************************************************
* Function Name  : DMA2_Channel4_5_IRQHandler
* Description    : This function handles DMA2 Channel 4 and DMA2 Channel 5
*                  interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void DMA2_Channel4_5_IRQHandler(void)
{
}

/******************* (C) COPYRIGHT 2008 STMicroelectronics *****END OF FILE****/
