/******************** (C) COPYRIGHT 2007 STMicroelectronics ********************
* File Name          : eeprom.h
* Author             : MCD Application Team
* Version            : V1.0.0
* Date               : 12/23/2008
* Description        : This file contains  the functions prototypes for the
*                      EEPROM emulation firmware for Time Stamping in Clock/Calendar
*                      application
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __EEPROM_H
#define __EEPROM_H

/* Includes ------------------------------------------------------------------*/
#include "stm32f10x_lib.h"

/* Exported types ------------------------------------------------------------*/
/* Exported constants --------------------------------------------------------*/
/* Page size */
#define PAGE_SIZE  (u16)0x400  /* 1KByte */

/* EEPROM start address in Flash */
#define EEPROM_START_ADDRESS  (u32)0x0801F000

/* Pages 0 and 1 base and end addresses */
#define PAGE0_BASE_ADDRESS  (u32)(EEPROM_START_ADDRESS + 0x000)
#define PAGE0_END_ADDRESS   (u32)(EEPROM_START_ADDRESS + (PAGE_SIZE - 1))

/* Used Flash pages for EEPROM emulation */
#define PAGE0    (u16)0x0000

/* No valid page define */
#define NO_VALID_PAGE    (u16)0x00AB

/* Page full define */
#define PAGE_FULL    (u8)0x80

/* Exported macro ------------------------------------------------------------*/
/* Exported functions ------------------------------------------------------- */
FLASH_Status EE_Format(void);
u16 EE_WriteVariable(u16);
u16 EE_ReadValue(void);

#endif /* __EEPROM_H */

/******************* (C) COPYRIGHT 2008 STMicroelectronics *****END OF FILE****/
