/******************** (C) COPYRIGHT 2008 STMicroelectronics ********************
* File Name          : menu.h
* Author             : MCD Application Team
* Version            : V1.0.0
* Date               : 12/23/2008
* Description        : This file consists of the function prtotypes for menu
*                      implementation
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __MENU_H
#define __MENU_H

/* Includes ------------------------------------------------------------------*/
/* Exported types ------------------------------------------------------------*/
extern vu32 vu32_TimingDelay;
extern u8 u8_TimeDateDisplay;
extern u8  u8_DisplayTimeFlag;
extern u32 u32_Dummy;
extern u8 u8_DisplayDateFlag;
extern u8  u8_AlarmStatus;
extern u8 u8_TotalMenuPointer;
extern u8 u8_FlagKey;
extern u8 u8_MenuLevelPointer;
extern u8 u8_TamperEvent;
extern u8 u8_TamperNumber;
extern float f32_Frequency;
extern u8 u8_BatteryRemoved;
extern u16 u16_SummerTimeCorrect;
extern u8 u8_AlarmDate;
extern u32 u32_TimerFrequency;
extern u8 u8_ArrayTime[8];

/* Exported constants --------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
#define NOKEY 0x01
#define LEFT 0x02
#define RIGHT 0x03
#define SEL 0x04
#define UP 0x05
#define DOWN 0x06
#define ASCII_COLON 58
#define ASCII_SLASH 47

/* Exported functions ------------------------------------------------------- */
void UpFunction(void);
void DownFunction(void);
void LeftFunction(void);
void RightFunction(void);
void SelFunction(void);
void MenuInit(void);
void SelIntExtOnOffConfig(FunctionalState);
void UpDownIntOnOffConfig(FunctionalState NewState);
void RightLeftIntExtOnOffConfig(FunctionalState NewState);
void NVIC_JoyStickConfig(void);
void MenuManage(void);
void InitialiseTime(void);
void InitialiseDate(void);
u8 ReadKey(void);
#endif   /*__MENU_H */

/******************* (C) COPYRIGHT 2008 STMicroelectronics *****END OF FILE****/
