/******************** (C) COPYRIGHT 2008 STMicroelectronics ********************
* File Name          : eeprom.c
* Author             : MCD Application Team
* Version            : V1.0.0
* Date               : 12/23/2008
* Description        : This file provides the EEPROM emulation firmware functions
*                      used for Time Stamping in Clock/Calendar Application
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "eeprom.h"
#include "stm32f10x_lib.h"
#include "lcd.h"
#include "menu.h"

/* Private variables ---------------------------------------------------------*/
u16 u16_Value;

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/
/*******************************************************************************
* Function Name  : EE_Format
* Description    : Erases EEPROM Page
* Input          : None
* Output         : None
* Return         : Status of the last operation (Flash write or erase) done during
*                  EEPROM formating
*******************************************************************************/
FLASH_Status EE_Format(void)
{
  FLASH_Status FlashStatus = FLASH_COMPLETE;
  
  u8_TamperNumber=1;
  BKP_WriteBackupRegister(BKP_DR5,u8_TamperNumber);
  /* Erase Page */
  FlashStatus = FLASH_ErasePage(PAGE0_BASE_ADDRESS);
  
  /* If erase operation was failed, a Flash error code is returned */
  if (FlashStatus != FLASH_COMPLETE)
  {
    return FlashStatus;
  }
  
  return FlashStatus;
}

/*******************************************************************************
* Function Name  : EE_WriteVariable
* Description    : Writes variable data in EEPROM.
* Input          : Data: 16 bit data to be written
* Output         : None
* Return         : - Success or error status:
*                      - FLASH_COMPLETE: on success,
*                      - PAGE_FULL: if valid page is full
*                      - Flash error code: on write Flash error
*******************************************************************************/
u16 EE_WriteVariable(u16 u16_Data)
{
  u32 u32_LoggingTimer;
  FLASH_Status FlashStatus = FLASH_COMPLETE;
  
  /* Get the valid Page start Address */
  u32 u32_Address;
  u32 u32_PageEndAddress;
  u32_Address = (u32)(PAGE0_BASE_ADDRESS);
  /* Get the valid Page end Address */
  u32_PageEndAddress = (u32)(PAGE0_END_ADDRESS);
  /* Check each active page address starting from begining */
  while (u32_Address < u32_PageEndAddress)
  {
    /* Verify if Address and Address+2 contents are 0xFFFFFFFF */
    if ((*(vu32*)u32_Address) == 0xFFFFFFFF)
    {
      /* Set variable data */
      FlashStatus = FLASH_ProgramHalfWord(u32_Address, u16_Data);
      /* If program operation was failed, a Flash error code is returned */
      if (FlashStatus != FLASH_COMPLETE)
      {
        return FlashStatus;
      }
      /* Return program operation status */
      return FlashStatus;
    }
    else
    {
      /* Next address location */
      u32_Address = u32_Address + 2;
    }
  }
  
  LCD_Clear(Red);
  LCD_SetBackColor(Red);
  LCD_DisplayString(Line4,Column5,"MEMORY FULL");
  LCD_DisplayString(Line5,Column4,"ERASING LOG");
  EE_Format();
  u32_LoggingTimer=RTC_GetCounter();
  
  while((RTC_GetCounter() - u32_LoggingTimer) < 2)
  {
  }
  
  MenuInit();
  return PAGE_FULL;
}

/*******************************************************************************
* Function Name  : EE_ReadVariable
* Description    : Returns the stored variable data

* Input          : None
* Output         : None
* Return         : - Success or error status:
*                      - 0: if variable was found
*                      - 1: if the variable was not found
*******************************************************************************/
u16 EE_ReadValue(void)
{
  u16 u16_Value;
  u8 u8_DisplayArrayPos=0;
  u16 u16_ReadStatus = 1;
  u32 u32_Address,u32_PageStartAddress;
  u8 u8_DisplayLine;
  /*Buffer for storing time stamp read from the flash memory and to be
  displayed on the LCD screen*/
  u8 u8_EventLogArray[20]={0,0,0,0,255,0,0,255,0,0,0,0,0,0,10,0,0,10,0,0};
  
  u8_DisplayLine=0;
  /* Get the valid Page start Address */
  u32_PageStartAddress = PAGE0_BASE_ADDRESS;
  /* Get the valid Page end Address */
  u32_Address = u32_PageStartAddress;
  u16_Value = *(vu16*)(u32_Address);
  
  /*If first element is emplty means whole page is empty */
  if(u16_Value == 0xFFFF)
  {
    LCD_DisplayString(Line4,Column5,"NO STORED");
    LCD_DisplayString(Line5,Column2,"TAMPER EVENTS");
    return(u16_ReadStatus);
  }
  
  LCD_SetTextColor(Yellow);
  
  /* Check each active page address starting from beginning */
  while (((*(vu16*)(u32_Address))!=0xFFFF) && (u32_Address < PAGE0_END_ADDRESS))
  {
    if(u8_DisplayArrayPos==4)
    {
      u8_DisplayArrayPos=5;
    }
    if(u8_DisplayArrayPos==7)
    {
      u8_DisplayArrayPos=8;
    }
    if(u8_DisplayArrayPos==11)
    {
      u8_DisplayArrayPos=12;
    }
    if(u8_DisplayArrayPos==14)
    {
      u8_DisplayArrayPos=15;
    }
    if(u8_DisplayArrayPos==17)
    {
      u8_DisplayArrayPos=18;
    }
    
    u16_Value = (*(vu16*)(u32_Address));
    /* In case variable value is read, reset u16_ReadStatus flag */
    u16_ReadStatus = 0;
    u32_Address=u32_Address +2;
    u8_EventLogArray[u8_DisplayArrayPos]=u16_Value/10;
    u8_EventLogArray[u8_DisplayArrayPos+1]=u16_Value%10;
    
    if(u8_DisplayArrayPos==18)
    {
      LCD_DisplayStringLine(u8_DisplayLine,u8_EventLogArray);
      u8_DisplayArrayPos=0;
      u8_DisplayLine=u8_DisplayLine + 24;
      
      /* If Line9 is already reached start rewriting from the beginning */
      if(u8_DisplayLine == 240)
      {
        LCD_SetTextColor(White);
        /*Draw Vertical Line Starting from:0: X Cood,287:Y-Cood, 260:Length*/
        LCD_DrawLine(0,287,260,Vertical);
        /*Draw Vertical Line Starting from:0: X Cood,287:Y-Cood, 260:Length*/
        LCD_DrawLine(0,125,260,Vertical);
 
        if((*(vu16*)(u32_Address)) != 0xFFFF)
        {
          while(ReadKey() != SEL)
          {
          }
        
          LCD_SetTextColor(Yellow);
          LCD_Clear(Blue2);
          u8_DisplayLine=0;
        }
      }
    }
    else
    {
      u8_DisplayArrayPos=u8_DisplayArrayPos+2;
    }
  }
  
  LCD_SetTextColor(White);
  /*Draw Vertical Line Starting from:0: X Cood,287:Y-Cood, 260:Length*/
  LCD_DrawLine(0,287,260,Vertical);
  /*Draw Vertical Line Starting from:0: X Cood,287:Y-Cood, 260:Length*/
  LCD_DrawLine(0,125,260,Vertical);
  /* Return u16_ReadStatus value: (0: variable exist, 1: variable doesn't exist) */
  return u16_ReadStatus;
}

/******************* (C) COPYRIGHT 2008 STMicroelectronics *****END OF FILE****/
