/******************** (C) COPYRIGHT 2008 STMicroelectronics ********************
* File Name          : menu.c
* Author             : MCD Application Team
* Version            : V1.0.0
* Date               : 12/23/2008
* Description        : This file contains the basic routines for MENU 
*                      inmplementation
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "stm32f10x_lib.h"
#include "clock_calendar.h"
#include "lcd.h"
#include "menu.h"
#include "eeprom.h"
#include "application_rtc.h"

/* Private variables----------------------------------------------------------*/
u8 u8_DisplayCurrentPos;
u8 u8_DisplayPrevPos;
u32 u32_Dummy;
u16 u16_Counter=0;
u8 u8_ArrayTime[8]={0,0,0,0,0,0,0,0};
u8 u8_CounterPosition=0;
u8 u8_MenuLevelPointer=1;
u8 u8_TotalMenuPointer=1;
u8 u8_TamperNumber; /* Keeps the number of tamper Events already happened */
u8 u8_AlarmDate=0;
u8 u8_TimeDateDisplay=0;
u32 u32_TimerFrequency;

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/
/*******************************************************************************
* Function Name  : UpFunction
* Description    : This Function is executed when Joystick Up Button is pressed
* Input          : None
* Output         : None
* Return         : None

*******************************************************************************/
void UpFunction(void)
{
  u8 u8_CounterMax=0, u8_CounterMin=0;
  /* Determine maximum and minimum allowed values for the elements of time */
  if(u8_TotalMenuPointer==1 || u8_TotalMenuPointer==2)
  {
    u8_CounterMin=0;
   
    if(u8_CounterPosition==0)
    {
      if(u8_ArrayTime[1]<4)
      {
        u8_CounterMax=2;
      }
      else
      {
        u8_CounterMax=1;
      }
    }
    else if(u8_CounterPosition==1)
    {
      if(u8_ArrayTime[0]==2)
      {
        u8_CounterMax=3;
      }
      else
      {
        u8_CounterMax=9;
      }
    }
    else if(u8_CounterPosition==2 || u8_CounterPosition==4)
    {
      u8_CounterMax=5;
    }
    else if(u8_CounterPosition==3 || u8_CounterPosition==5)
    {
      u8_CounterMax=9;
    }
  }
  /* Determine maximum and minimum allowed values for the elements of Date */
  else if(u8_TotalMenuPointer==3)
  {
    if(u8_CounterPosition==0)
    {
      if(u8_ArrayTime[1]>1)
      {
        u8_CounterMax=2;
      }
      else
      {
        u8_CounterMax=3;
      }
      if(u8_ArrayTime[1]==0)
      {
        u8_CounterMin=1;
      }
      else
      {
        u8_CounterMin=0;
      }
    }
    else if(u8_CounterPosition==1)
    {
      if(u8_ArrayTime[0]==3)
      {
        u8_CounterMax=1;
      }
      else
      {
        u8_CounterMax=9;
      }
      if(u8_ArrayTime[0]==0)
      {
        u8_CounterMin=1;
      }
      else
      {
        u8_CounterMin=0;
      }
    }
    else if(u8_CounterPosition==2)
    {
      if(u8_ArrayTime[3]>2)
      {
        u8_CounterMax=0;
      }
      else
      {
        u8_CounterMax=1;
      }
      if(u8_ArrayTime[3]==0)
      {
        u8_CounterMin=1;
      }
      else
      {
        u8_CounterMin=0;
      }
    }
    else if(u8_CounterPosition==3)
    {
      if(u8_ArrayTime[2]==1)
      {
        u8_CounterMax=2;
      }
      else
      {
        u8_CounterMax=9;
      }
      if(u8_ArrayTime[2]==0)
      {
        u8_CounterMin=1;
      }
      else
      {
        u8_CounterMin=0;
      }
    }
    else if(u8_CounterPosition==4)
    {
      u8_CounterMax=2;
      u8_CounterMin=2;
    }
    else if( u8_CounterPosition==5 || u8_CounterPosition==6 || u8_CounterPosition==7)
    {
      u8_CounterMax=9;
      u8_CounterMin=0;
    }
  }
  else
  {
    u8_CounterMax=9;
    u8_CounterMin=0;
  }
  
  u16_Counter=u8_ArrayTime[u8_CounterPosition];
  u16_Counter++;
  
  if(u16_Counter>u8_CounterMax)
  {
    u16_Counter=u8_CounterMin;
  }
  
  u8_ArrayTime[u8_CounterPosition]=u16_Counter;
  LCD_DisplayChar(Line4,Column6-(u8_DisplayCurrentPos*16),\
                    u8_ArrayTime[u8_CounterPosition] + 0x30);
}

/*******************************************************************************
* Function Name  : DownFunction
* Description    : This Function is executed when Joystick Down Button is pressed
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void DownFunction(void)
{
  u8 u8_CounterMax=0, u8_CounterMin=0;
  
  /* Determine maximum and minimum allowed values for the elements of time */
  if(u8_TotalMenuPointer==1 || u8_TotalMenuPointer==2)
  {
    u8_CounterMin=0;
    if(u8_CounterPosition==0)
    {
      if(u8_ArrayTime[1]<4)
      {
        u8_CounterMax=2;
      }
      else
      {
        u8_CounterMax=1;
      }
    }
    else if(u8_CounterPosition==1)
    {
      if(u8_ArrayTime[0]==2)
      {
        u8_CounterMax=3;
      }
      else
      {
         u8_CounterMax=9;
      }
    }
    else if(u8_CounterPosition==2 || u8_CounterPosition==4)
    {
      u8_CounterMax=5;
    }
    else if(u8_CounterPosition==3 || u8_CounterPosition==5)
    {
      u8_CounterMax=9;
    }
  }
  /* Determine maximum and minimum allowed values for the elements of date*/
  else if(u8_TotalMenuPointer==3)
  {
    if(u8_CounterPosition==0)
    {
      if(u8_ArrayTime[1]>1)
      {
        u8_CounterMax=2;
      }
      else
      {
        u8_CounterMax=3;
      }

      if(u8_ArrayTime[1]==0)
      {
        u8_CounterMin=1;
      }
      else
      {
        u8_CounterMin=0;
      }
    }
    else if(u8_CounterPosition==1)
    {
      if(u8_ArrayTime[0]==3)
      {
        u8_CounterMax=1;
      }
      else
      {
        u8_CounterMax=9;
      }

      if(u8_ArrayTime[0]==0)
      {
        u8_CounterMin=1;
      }
      else
      {
        u8_CounterMin=0;
      }
    }
    else if(u8_CounterPosition==2)
    {
      if(u8_ArrayTime[3]>2)
      {
        u8_CounterMax=0;
      }
      else
      {
        u8_CounterMax=1;
      }
      
      if(u8_ArrayTime[3]==0)
      {
        u8_CounterMin=1;
      }
      else
      {
        u8_CounterMin=0;
      }
    }
    else if(u8_CounterPosition==3)
    {
      if(u8_ArrayTime[2]==1)
      {
        u8_CounterMax=2;
      }
      else
      {
        u8_CounterMax=9;
      }
      
      if(u8_ArrayTime[2]==0)
      {
        u8_CounterMin=1;
      }
      else
      {
        u8_CounterMin=0;
      }
    }
    else if(u8_CounterPosition==4)
    {
      u8_CounterMax=2;
      u8_CounterMin=2;
    }
    else if(u8_CounterPosition==5 || u8_CounterPosition==6 \
              || u8_CounterPosition==7)
    {
      u8_CounterMax=9;
      u8_CounterMin=0;
    }
  }
  else
  {
    u8_CounterMax=9;
    u8_CounterMin=0;
  }
  
  u16_Counter=u8_ArrayTime[u8_CounterPosition];
  
  if(u16_Counter==u8_CounterMin)
  {
    u16_Counter=u8_CounterMax+1;
  }
  
  u16_Counter-=1;
  u8_ArrayTime[u8_CounterPosition]=u16_Counter;
  LCD_DisplayChar(Line4,Column6-(u8_DisplayCurrentPos*16),\
                  u8_ArrayTime[u8_CounterPosition] + 0x30);
}

/*******************************************************************************
* Function Name  : RightFunction
* Description    : This Function is executed when Joystick Right Button is pressed
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void RightFunction(void)
{
  u8 u8_PrevElement=0;

  switch(u8_MenuLevelPointer)
  {
    case 1: u8_TotalMenuPointer++;
            if(u8_TotalMenuPointer > 9)
            {
              u8_TotalMenuPointer=1;
            }
            if(u8_TotalMenuPointer==2)
            {
              LCD_SetTextColor(Green);
              LCD_DisplayString(Line0,Column1,"CLOCK/CALENDAR SET");
              LCD_DisplayString(Line3,Column5,"FEATURES");
              LCD_DisplayString(Line6,Column1,"CLOCK SOURCE SELECT");
              LCD_SetTextColor(White);
              LCD_SetBackColor(Green);
              LCD_DisplayString(Line1,Column7,"Alarm");
              LCD_SetBackColor(Blue2);
              LCD_DisplayString(Line1,Column1,"Time");
              LCD_DisplayString(Line1,Column14,"Date");
              LCD_DisplayString(Line4,Column1,"LowPower");
              LCD_DisplayString(Line4,Column11,"Tamper");
              LCD_DisplayString(Line7,Column0,"32768Hz");
              LCD_DisplayString(Line7,Column9,"50Hz");
              LCD_DisplayString(Line7,Column15,"60Hz");
              LCD_DisplayString(Line9,Column5,"CALIBRATE");
            } 
            else if (u8_TotalMenuPointer==3)
            {
              LCD_SetTextColor(Green);
              LCD_DisplayString(Line0,Column1,"CLOCK/CALENDAR SET");
              LCD_DisplayString(Line3,Column5,"FEATURES");
              LCD_DisplayString(Line6,Column1,"CLOCK SOURCE SELECT");
              LCD_SetTextColor(White);
              LCD_SetBackColor(Green);
              LCD_DisplayString(Line1,Column14,"Date");
              LCD_SetBackColor(Blue2);
              LCD_DisplayString(Line1,Column7,"Alarm");
              LCD_DisplayString(Line1,Column1,"Time");
              LCD_DisplayString(Line4,Column1,"LowPower");
              LCD_DisplayString(Line4,Column11,"Tamper");
              LCD_DisplayString(Line7,Column0,"32768Hz");
              LCD_DisplayString(Line7,Column9,"50Hz");
              LCD_DisplayString(Line7,Column15,"60Hz");
              LCD_DisplayString(Line9,Column5,"CALIBRATE");
            }
            else if (u8_TotalMenuPointer==1)
            {
              LCD_SetTextColor(Green);
              LCD_DisplayString(Line0,Column1,"CLOCK/CALENDAR SET");
              LCD_DisplayString(Line3,Column5,"FEATURES");
              LCD_DisplayString(Line6,Column1,"CLOCK SOURCE SELECT");
              LCD_SetTextColor(White);
              LCD_SetBackColor(Green);
              LCD_DisplayString(Line1,Column1,"Time");
              LCD_SetBackColor(Blue2);
              LCD_DisplayString(Line1,Column7,"Alarm");
              LCD_DisplayString(Line1,Column14,"Date");
              LCD_DisplayString(Line4,Column1,"LowPower");
              LCD_DisplayString(Line4,Column11,"Tamper");
              LCD_DisplayString(Line7,Column0,"32768Hz");
              LCD_DisplayString(Line7,Column9,"50Hz");
              LCD_DisplayString(Line7,Column15,"60Hz");
              LCD_DisplayString(Line9,Column5,"CALIBRATE");
            }
            else if(u8_TotalMenuPointer==4)
            {
              LCD_SetTextColor(Green);
              LCD_DisplayString(Line0,Column1,"CLOCK/CALENDAR SET");
              LCD_DisplayString(Line3,Column5,"FEATURES");
              LCD_DisplayString(Line6,Column1,"CLOCK SOURCE SELECT");
              LCD_SetTextColor(White);
              LCD_SetBackColor(Green);
              LCD_DisplayString(Line4,Column1,"LowPower");
              LCD_SetBackColor(Blue2);
              LCD_DisplayString(Line1,Column1,"Time");
              LCD_DisplayString(Line1,Column7,"Alarm");
              LCD_DisplayString(Line1,Column14,"Date");
              LCD_DisplayString(Line4,Column11,"Tamper");
              LCD_DisplayString(Line7,Column0,"32768Hz");
              LCD_DisplayString(Line7,Column9,"50Hz");
              LCD_DisplayString(Line7,Column15,"60Hz");
              LCD_DisplayString(Line9,Column5,"CALIBRATE");
            }
            else if(u8_TotalMenuPointer==5)
            {
              LCD_SetTextColor(Green);
              LCD_DisplayString(Line0,Column1,"CLOCK/CALENDAR SET");
              LCD_DisplayString(Line3,Column5,"FEATURES");
              LCD_DisplayString(Line6,Column1,"CLOCK SOURCE SELECT");
              LCD_SetTextColor(White);
              LCD_SetBackColor(Green);
              LCD_DisplayString(Line4,Column11,"Tamper");
              LCD_SetBackColor(Blue2);
              LCD_DisplayString(Line1,Column1,"Time");
              LCD_DisplayString(Line1,Column7,"Alarm");
              LCD_DisplayString(Line1,Column14,"Date");
              LCD_DisplayString(Line4,Column1,"LowPower");
              LCD_DisplayString(Line7,Column0,"32768Hz");
              LCD_DisplayString(Line7,Column9,"50Hz");
              LCD_DisplayString(Line7,Column15,"60Hz");
              LCD_DisplayString(Line9,Column5,"CALIBRATE");
            }
            else if(u8_TotalMenuPointer==6)
            {
              LCD_SetTextColor(Green);
              LCD_DisplayString(Line0,Column1,"CLOCK/CALENDAR SET");
              LCD_DisplayString(Line3,Column5,"FEATURES");
              LCD_DisplayString(Line6,Column1,"CLOCK SOURCE SELECT");
              LCD_SetTextColor(White);
              LCD_SetBackColor(Green);
              LCD_DisplayString(Line7,Column0,"32768Hz");
              LCD_SetBackColor(Blue2);
              LCD_DisplayString(Line1,Column1,"Time");
              LCD_DisplayString(Line1,Column7,"Alarm");
              LCD_DisplayString(Line1,Column14,"Date");
              LCD_DisplayString(Line4,Column1,"LowPower");
              LCD_DisplayString(Line4,Column11,"Tamper");
              LCD_DisplayString(Line7,Column9,"50Hz");
              LCD_DisplayString(Line7,Column15,"60Hz");
              LCD_DisplayString(Line9,Column5,"CALIBRATE");
            }
            else if(u8_TotalMenuPointer==7)
            {
              LCD_SetTextColor(Green);
              LCD_DisplayString(Line0,Column1,"CLOCK/CALENDAR SET");
              LCD_DisplayString(Line3,Column5,"FEATURES");
              LCD_DisplayString(Line6,Column1,"CLOCK SOURCE SELECT");
              LCD_SetTextColor(White);
              LCD_SetBackColor(Green);
              LCD_DisplayString(Line7,Column9,"50Hz");
              LCD_SetBackColor(Blue2);
              LCD_DisplayString(Line1,Column1,"Time");
              LCD_DisplayString(Line1,Column7,"Alarm");
              LCD_DisplayString(Line1,Column14,"Date");
              LCD_DisplayString(Line4,Column1,"LowPower");
              LCD_DisplayString(Line4,Column11,"Tamper");
              LCD_DisplayString(Line7,Column0,"32768Hz");
              LCD_DisplayString(Line7,Column15,"60Hz");
              LCD_DisplayString(Line9,Column5,"CALIBRATE");
            }
            else if(u8_TotalMenuPointer==8)
            {
              LCD_SetTextColor(Green);
              LCD_DisplayString(Line0,Column1,"CLOCK/CALENDAR SET");
              LCD_DisplayString(Line3,Column5,"FEATURES");
              LCD_DisplayString(Line6,Column1,"CLOCK SOURCE SELECT");
              LCD_SetTextColor(White);
              LCD_SetBackColor(Green);
              LCD_DisplayString(Line7,Column15,"60Hz");
              LCD_SetBackColor(Blue2);
              LCD_DisplayString(Line1,Column1,"Time");
              LCD_DisplayString(Line1,Column7,"Alarm");
              LCD_DisplayString(Line1,Column14,"Date");
              LCD_DisplayString(Line4,Column1,"LowPower");
              LCD_DisplayString(Line4,Column11,"Tamper");
              LCD_DisplayString(Line7,Column0,"32768Hz");
              LCD_DisplayString(Line7,Column9,"50Hz");
              LCD_DisplayString(Line9,Column5,"CALIBRATE");
            }
            else if(u8_TotalMenuPointer==9)
            {
              LCD_SetTextColor(Green);
              LCD_DisplayString(Line0,Column1,"CLOCK/CALENDAR SET");
              LCD_DisplayString(Line3,Column5,"FEATURES");
              LCD_DisplayString(Line6,Column1,"CLOCK SOURCE SELECT");
              LCD_SetTextColor(White);
              LCD_SetBackColor(Green);
              LCD_DisplayString(Line9,Column5,"CALIBRATE");
              LCD_SetBackColor(Blue2);
              LCD_DisplayString(Line1,Column1,"Time");
              LCD_DisplayString(Line1,Column7,"Alarm");
              LCD_DisplayString(Line1,Column14,"Date");
              LCD_DisplayString(Line4,Column1,"LowPower");
              LCD_DisplayString(Line4,Column11,"Tamper");
              LCD_DisplayString(Line7,Column0,"32768Hz");
              LCD_DisplayString(Line7,Column9,"50Hz");
              LCD_DisplayString(Line7,Column15,"60Hz");
            }
        break;
        
    case 2: if(u8_TotalMenuPointer==1 || u8_TotalMenuPointer==2 \
                          || u8_TotalMenuPointer==3)
            {
              u8_CounterPosition++;

              if(u8_TotalMenuPointer==1 || u8_TotalMenuPointer==2)
              {
                if(u8_CounterPosition==6)
                {
                  u8_CounterPosition=0;
                  u8_PrevElement=5;
                }
                else
                {
                  u8_PrevElement=u8_CounterPosition-1;
                }
              }
              else if(u8_TotalMenuPointer==3)
              {
                if(u8_CounterPosition==8)
                {
                  u8_CounterPosition=0;
                  u8_PrevElement=7;
                }
                else
                {
                  u8_PrevElement=u8_CounterPosition-1;
                }
              }
                  
              u16_Counter=u8_ArrayTime[u8_CounterPosition];
                  
              if(u8_TotalMenuPointer == 1 || u8_TotalMenuPointer == 2)
              {
                if(u8_DisplayCurrentPos==0x07)
                {
                  u8_DisplayCurrentPos=255;
                }
              }
              else if(u8_TotalMenuPointer == 3)
              {
                if(u8_DisplayCurrentPos==0x09)
                {
                  u8_DisplayCurrentPos=0xFF;
                }
              }

              if(u8_CounterPosition==2 || u8_CounterPosition==4)
              {
                u8_DisplayCurrentPos+=2;
                u8_DisplayPrevPos=u8_DisplayCurrentPos-2;
              }
              else
              {
                u8_DisplayCurrentPos++;
                u8_DisplayPrevPos=u8_DisplayCurrentPos-1;
              }
                
              if(u8_TotalMenuPointer==1 || u8_TotalMenuPointer==2)
              {
                if(u8_DisplayPrevPos==255)
                {
                  u8_DisplayPrevPos=7;
                }
              }
              else if(u8_TotalMenuPointer==3)
              {
                if(u8_DisplayPrevPos==255)
                {
                  u8_DisplayPrevPos=9;
                }
              }

              LCD_DisplayCount(Line4,Column6-((u8_DisplayPrevPos)*16),0,\
                                    u8_ArrayTime[u8_PrevElement] + 0x30);
              LCD_DisplayCount(Line4,Column6-(u8_DisplayCurrentPos*16),1,\
                                    u8_ArrayTime[u8_CounterPosition] + 0x30);
            }

             if((u8_TotalMenuPointer==9 || u8_TotalMenuPointer==12) && u8_MenuLevelPointer==2)
             {
                if(u8_TotalMenuPointer==9)
                  {
                    u8_TotalMenuPointer=12;
                  }
                  else if(u8_TotalMenuPointer==12)
                  {
                    u8_TotalMenuPointer=9;
                  }
                 if(u8_TotalMenuPointer==9)
                  {
                    LCD_SetBackColor(Green);
                    LCD_DisplayString(Line4,Column2,"MANUAL");
                    LCD_SetBackColor(Blue2);
                    LCD_DisplayString(Line4,Column12,"AUTO");
                  }
                  else if(u8_TotalMenuPointer==12)
                  {
                    LCD_SetBackColor(Green);
                    LCD_DisplayString(Line4,Column12,"AUTO");
                    LCD_SetBackColor(Blue2);
                    LCD_DisplayString(Line4,Column2,"MANUAL");
                  }
              }

              if(u8_TotalMenuPointer==11 || u8_TotalMenuPointer==10)
              {
                if(u8_TotalMenuPointer==11)
                {
                  u8_TotalMenuPointer=10;
                }
                else if(u8_TotalMenuPointer==10)
                {
                   u8_TotalMenuPointer=11;
                }
                if(u8_TotalMenuPointer==10)
                {
                  LCD_SetBackColor(Green);
                  LCD_DisplayString(Line4,Column4,"STOP");
                  LCD_SetBackColor(Blue2);
                  LCD_DisplayString(Line4,Column10,"STANDBY");
                }
                else if(u8_TotalMenuPointer==11)
                {
                  LCD_SetBackColor(Green);
                  LCD_DisplayString(Line4,Column10,"STANDBY");
                  LCD_SetBackColor(Blue2);
                  LCD_DisplayString(Line4,Column4,"STOP");
                }
               }

               if(u8_TotalMenuPointer==5 || u8_TotalMenuPointer==6)
               {
                 if(u8_TotalMenuPointer==5)
                 {
                   u8_TotalMenuPointer=6;
                 }
                 else if(u8_TotalMenuPointer==6)
                 {
                   u8_TotalMenuPointer=5;
                 }
                 if(u8_TotalMenuPointer==5)
                 {
                   LCD_SetBackColor(Green);
                   LCD_DisplayString(Line4,Column4,"VIEW");
                   LCD_SetBackColor(Blue2);
                   LCD_DisplayString(Line4,Column10,"ERASE");
                 }
                 else if(u8_TotalMenuPointer==6)
                 {
                   LCD_SetBackColor(Green);
                   LCD_DisplayString(Line4,Column10,"ERASE");
                   LCD_SetBackColor(Blue2);
                   LCD_DisplayString(Line4,Column4,"VIEW");
                  }
                }
              break;
              
    case 3: if(u8_TotalMenuPointer==9)
            {
              u8_CounterPosition++;

              if(u8_CounterPosition==3)
              {
                u8_CounterPosition=0;
                u8_PrevElement=2;
              }
              else
              {
                u8_PrevElement=u8_CounterPosition-1;
              }
               
              u16_Counter=u8_ArrayTime[u8_CounterPosition];
               
              if(u8_DisplayCurrentPos==0x02)
              {
                u8_DisplayCurrentPos=0xFF;
              }
               
              u8_DisplayCurrentPos++;
              u8_DisplayPrevPos=u8_DisplayCurrentPos-1;
               
              if(u8_DisplayPrevPos==255)
              {
                u8_DisplayPrevPos=2;
              }
              
              LCD_DisplayCount(Line4,Column6-((u8_DisplayPrevPos)*16),0,\
                                  u8_ArrayTime[u8_PrevElement] + 0x30);
              LCD_DisplayCount(Line4,Column6-(u8_DisplayCurrentPos*16),1,\
                                  u8_ArrayTime[u8_CounterPosition] + 0x30);
            }
          break;
  }
}

/*******************************************************************************
* Function Name  : LeftFunction
* Description    : This Function is executed when Left Button is pressed
* Input          : None
* Output         : None
* Return         : None

*******************************************************************************/
void LeftFunction(void)
{
  u8 u8_PrevElement=0;
  
  switch(u8_MenuLevelPointer)
  {
    case 1: u8_TotalMenuPointer--;
           if(u8_TotalMenuPointer==0)
           {
             u8_TotalMenuPointer=9;
           }

           if(u8_TotalMenuPointer==2)
           {
             LCD_SetTextColor(Green);
             LCD_DisplayString(Line0,Column1,"CLOCK/CALENDAR SET");
             LCD_DisplayString(Line3,Column5,"FEATURES");
             LCD_DisplayString(Line6,Column1,"CLOCK SOURCE SELECT");
             LCD_SetTextColor(White);
             LCD_SetBackColor(Green);
             LCD_DisplayString(Line1,Column7,"Alarm");
             LCD_SetBackColor(Blue2);
             LCD_DisplayString(Line1,Column1,"Time");
             LCD_DisplayString(Line1,Column14,"Date");
             LCD_DisplayString(Line4,Column1,"LowPower");
             LCD_DisplayString(Line4,Column11,"Tamper");
             LCD_DisplayString(Line7,Column0,"32768Hz");
             LCD_DisplayString(Line7,Column9,"50Hz");
             LCD_DisplayString(Line7,Column15,"60Hz");
             LCD_DisplayString(Line9,Column5,"CALIBRATE");
           }
           else if (u8_TotalMenuPointer==3)
           {
             LCD_SetTextColor(Green);
             LCD_DisplayString(Line0,Column1,"CLOCK/CALENDAR SET");
             LCD_DisplayString(Line3,Column5,"FEATURES");
             LCD_DisplayString(Line6,Column1,"CLOCK SOURCE SELECT");
             LCD_SetTextColor(White);
             LCD_SetBackColor(Green);
             LCD_DisplayString(Line1,Column14,"Date");
             LCD_SetBackColor(Blue2);
             LCD_DisplayString(Line1,Column7,"Alarm");
             LCD_DisplayString(Line1,Column1,"Time");
             LCD_DisplayString(Line4,Column1,"LowPower");
             LCD_DisplayString(Line4,Column11,"Tamper");
             LCD_DisplayString(Line7,Column0,"32768Hz");
             LCD_DisplayString(Line7,Column9,"50Hz");
             LCD_DisplayString(Line7,Column15,"60Hz");
             LCD_DisplayString(Line9,Column5,"CALIBRATE");
           }
           else if (u8_TotalMenuPointer==1)
           {
             LCD_SetTextColor(Green);
             LCD_DisplayString(Line0,Column1,"CLOCK/CALENDAR SET");
             LCD_DisplayString(Line3,Column5,"FEATURES");
             LCD_DisplayString(Line6,Column1,"CLOCK SOURCE SELECT");
             LCD_SetTextColor(White);
             LCD_SetBackColor(Green);
             LCD_DisplayString(Line1,Column1,"Time");
             LCD_SetBackColor(Blue2);
             LCD_DisplayString(Line1,Column7,"Alarm");
             LCD_DisplayString(Line1,Column14,"Date");
             LCD_DisplayString(Line4,Column1,"LowPower");
             LCD_DisplayString(Line4,Column11,"Tamper");
             LCD_DisplayString(Line7,Column0,"32768Hz");
             LCD_DisplayString(Line7,Column9,"50Hz");
             LCD_DisplayString(Line7,Column15,"60Hz");
             LCD_DisplayString(Line9,Column5,"CALIBRATE");
           }
           else if (u8_TotalMenuPointer==4)
           {
             LCD_SetTextColor(Green);
             LCD_DisplayString(Line0,Column1,"CLOCK/CALENDAR SET");
             LCD_DisplayString(Line3,Column5,"FEATURES");
             LCD_DisplayString(Line6,Column1,"CLOCK SOURCE SELECT");
             LCD_SetTextColor(White);
             LCD_SetBackColor(Green);
             LCD_DisplayString(Line4,Column1,"LowPower");
             LCD_SetBackColor(Blue2);
             LCD_DisplayString(Line1,Column7,"Alarm");
             LCD_DisplayString(Line1,Column14,"Date");
             LCD_DisplayString(Line1,Column1,"Time");
             LCD_DisplayString(Line4,Column11,"Tamper");
             LCD_DisplayString(Line7,Column0,"32768Hz");
             LCD_DisplayString(Line7,Column9,"50Hz");
             LCD_DisplayString(Line7,Column15,"60Hz");
             LCD_DisplayString(Line9,Column5,"CALIBRATE");
           }
           else if(u8_TotalMenuPointer==5)
           {
             LCD_SetTextColor(Green);
             LCD_DisplayString(Line0,Column1,"CLOCK/CALENDAR SET");
             LCD_DisplayString(Line3,Column5,"FEATURES");
             LCD_DisplayString(Line6,Column1,"CLOCK SOURCE SELECT");
             LCD_SetTextColor(White);
             LCD_SetBackColor(Green);
             LCD_DisplayString(Line4,Column11,"Tamper");
             LCD_SetBackColor(Blue2);
             LCD_DisplayString(Line1,Column1,"Time");
             LCD_DisplayString(Line1,Column7,"Alarm");
             LCD_DisplayString(Line1,Column14,"Date");
             LCD_DisplayString(Line4,Column1,"LowPower");
             LCD_DisplayString(Line7,Column0,"32768Hz");
             LCD_DisplayString(Line7,Column9,"50Hz");
             LCD_DisplayString(Line7,Column15,"60Hz");
             LCD_DisplayString(Line9,Column5,"CALIBRATE");
           }
           else if(u8_TotalMenuPointer==6)
           {
             LCD_SetTextColor(Green);
             LCD_DisplayString(Line0,Column1,"CLOCK/CALENDAR SET");
             LCD_DisplayString(Line3,Column5,"FEATURES");
             LCD_DisplayString(Line6,Column1,"CLOCK SOURCE SELECT");
             LCD_SetTextColor(White);
             LCD_SetBackColor(Green);
             LCD_DisplayString(Line7,Column0,"32768Hz");
             LCD_SetBackColor(Blue2);
             LCD_DisplayString(Line1,Column1,"Time");
             LCD_DisplayString(Line1,Column7,"Alarm");
             LCD_DisplayString(Line1,Column14,"Date");
             LCD_DisplayString(Line4,Column1,"LowPower");
             LCD_DisplayString(Line4,Column11,"Tamper");
             LCD_DisplayString(Line7,Column9,"50Hz");
             LCD_DisplayString(Line7,Column15,"60Hz");
             LCD_DisplayString(Line9,Column5,"CALIBRATE");
           }
           else if(u8_TotalMenuPointer==7)
           {
             LCD_SetTextColor(Green);
             LCD_DisplayString(Line0,Column1,"CLOCK/CALENDAR SET");
             LCD_DisplayString(Line3,Column5,"FEATURES");
             LCD_DisplayString(Line6,Column1,"CLOCK SOURCE SELECT");
             LCD_SetTextColor(White);
             LCD_SetBackColor(Green);
             LCD_DisplayString(Line7,Column9,"50Hz");
             LCD_SetBackColor(Blue2);
             LCD_DisplayString(Line1,Column1,"Time");
             LCD_DisplayString(Line1,Column7,"Alarm");
             LCD_DisplayString(Line1,Column14,"Date");
             LCD_DisplayString(Line4,Column1,"LowPower");
             LCD_DisplayString(Line4,Column11,"Tamper");
             LCD_DisplayString(Line7,Column0,"32768Hz");
             LCD_DisplayString(Line7,Column15,"60Hz");
             LCD_DisplayString(Line9,Column5,"CALIBRATE");
           }
           else if(u8_TotalMenuPointer==8)
           {
             LCD_SetTextColor(Green);
             LCD_DisplayString(Line0,Column1,"CLOCK/CALENDAR SET");
             LCD_DisplayString(Line3,Column5,"FEATURES");
             LCD_DisplayString(Line6,Column1,"CLOCK SOURCE SELECT");
             LCD_SetTextColor(White);
             LCD_SetBackColor(Green);
             LCD_DisplayString(Line7,Column15,"60Hz");
             LCD_SetBackColor(Blue2);
             LCD_DisplayString(Line1,Column1,"Time");
             LCD_DisplayString(Line1,Column7,"Alarm");
             LCD_DisplayString(Line1,Column14,"Date");
             LCD_DisplayString(Line4,Column1,"LowPower");
             LCD_DisplayString(Line4,Column11,"Tamper");
             LCD_DisplayString(Line7,Column0,"32768Hz");
             LCD_DisplayString(Line7,Column9,"50Hz");
             LCD_DisplayString(Line9,Column5,"CALIBRATE");
           }
           else if(u8_TotalMenuPointer==9)
           {
             LCD_SetTextColor(Green);
             LCD_DisplayString(Line0,Column1,"CLOCK/CALENDAR SET");
             LCD_DisplayString(Line3,Column5,"FEATURES");
             LCD_DisplayString(Line6,Column1,"CLOCK SOURCE SELECT");
             LCD_SetTextColor(White);
             LCD_SetBackColor(Green);
             LCD_DisplayString(Line9,Column5,"CALIBRATE");
             LCD_SetBackColor(Blue2);
             LCD_DisplayString(Line1,Column1,"Time");
             LCD_DisplayString(Line1,Column7,"Alarm");
             LCD_DisplayString(Line1,Column14,"Date");
             LCD_DisplayString(Line4,Column1,"LowPower");
             LCD_DisplayString(Line4,Column11,"Tamper");
             LCD_DisplayString(Line7,Column0,"32768Hz");
             LCD_DisplayString(Line7,Column9,"50Hz");
             LCD_DisplayString(Line7,Column15,"60Hz");
           }
         break;
         
    case 2: if(u8_TotalMenuPointer == 1 || u8_TotalMenuPointer == 2 \
                      || u8_TotalMenuPointer == 3)
            {
              u8_CounterPosition--;

              if(u8_CounterPosition==0xFF)
              {
                if(u8_TotalMenuPointer == 1 || u8_TotalMenuPointer == 2)
                {
                  u8_CounterPosition=5;
                  u8_PrevElement=0;
                }
                else if(u8_TotalMenuPointer == 3)
                {
                  u8_CounterPosition=7;
                  u8_PrevElement=0;
                }
              }
              else
              {
                u8_PrevElement=u8_CounterPosition+1;
              }

              if(u8_CounterPosition==3 || u8_CounterPosition==1)
              {
                u8_DisplayCurrentPos=u8_DisplayCurrentPos-2;
                u8_DisplayPrevPos=u8_DisplayCurrentPos+2;
              }
              else
              {
                u8_DisplayCurrentPos=u8_DisplayCurrentPos-1;
                u8_DisplayPrevPos=u8_DisplayCurrentPos+1;
              }

              u16_Counter=u8_ArrayTime[u8_CounterPosition];
              
              if(u8_DisplayCurrentPos==0xFF)
              {
                if(u8_TotalMenuPointer == 1 || u8_TotalMenuPointer == 2)
                {
                  u8_DisplayCurrentPos=7;
                }
                else if (u8_TotalMenuPointer == 3)
                {
                  u8_DisplayCurrentPos=9;
                }
              }

              LCD_DisplayCount(Line4,Column6-((u8_DisplayPrevPos)*16),0,\
                            u8_ArrayTime[u8_PrevElement] + 0x30);
              LCD_DisplayCount(Line4,Column6-(u8_DisplayCurrentPos*16),1,\
                            u8_ArrayTime[u8_CounterPosition] + 0x30);
            }

            if((u8_TotalMenuPointer==9 || u8_TotalMenuPointer==12) && u8_MenuLevelPointer==2)
            {
              if(u8_TotalMenuPointer==9)
              {
                u8_TotalMenuPointer=12;
              }
              else if(u8_TotalMenuPointer==12)
              {
                u8_TotalMenuPointer=9;
              }
   
              if(u8_TotalMenuPointer==9)
              {
                LCD_SetBackColor(Green);
                LCD_DisplayString(Line4,Column2,"MANUAL");
                LCD_SetBackColor(Blue2);
                LCD_DisplayString(Line4,Column12,"AUTO");
              }
              else if(u8_TotalMenuPointer==12)
              {
                LCD_SetBackColor(Green);
                LCD_DisplayString(Line4,Column12,"AUTO");
                LCD_SetBackColor(Blue2);
                LCD_DisplayString(Line4,Column2,"MANUAL");
              }
            }

            if(u8_TotalMenuPointer==11 || u8_TotalMenuPointer==10)
            {
              if(u8_TotalMenuPointer==11)
              {
                u8_TotalMenuPointer=10;
              }
              else if(u8_TotalMenuPointer==10)
              {
                u8_TotalMenuPointer=11;
              }

              if(u8_TotalMenuPointer==10)
              {
                LCD_SetBackColor(Green);
                LCD_DisplayString(Line4,Column4,"STOP");
                LCD_SetBackColor(Blue2);
                LCD_DisplayString(Line4,Column10,"STANDBY");
              }
              else if(u8_TotalMenuPointer==11)
              {
                LCD_SetBackColor(Green);
                LCD_DisplayString(Line4,Column10,"STANDBY");
                LCD_SetBackColor(Blue2);
                LCD_DisplayString(Line4,Column4,"STOP");
              }
            }
     
            if(u8_TotalMenuPointer==5 || u8_TotalMenuPointer==6)
            {
              if(u8_TotalMenuPointer==5)
                {
                  u8_TotalMenuPointer=6;
                }
                else if(u8_TotalMenuPointer==6)
                {
                  u8_TotalMenuPointer=5;
                }
            
              if(u8_TotalMenuPointer==5)
              {
                LCD_SetBackColor(Green);
                LCD_DisplayString(Line4,Column4,"VIEW");
                LCD_SetBackColor(Blue2);
                LCD_DisplayString(Line4,Column10,"ERASE");
              }
              else if(u8_TotalMenuPointer==6)
              {
                LCD_SetBackColor(Green);
                LCD_DisplayString(Line4,Column10,"ERASE");
                LCD_SetBackColor(Blue2);
                LCD_DisplayString(Line4,Column4,"VIEW");
              }
            }
          break;

    case 3: if(u8_TotalMenuPointer==9)
            {
              u8_CounterPosition--;

              if(u8_CounterPosition==0xFF)
              {
                u8_CounterPosition=2;
                u8_PrevElement=0;
              }
              else
              {
                u8_PrevElement=u8_CounterPosition+1;
              }

              u8_DisplayCurrentPos=u8_DisplayCurrentPos-1;
              u8_DisplayPrevPos=u8_DisplayCurrentPos+1;
              u16_Counter=u8_ArrayTime[u8_CounterPosition];

              if(u8_DisplayCurrentPos==0xFF)
              {
                u8_DisplayCurrentPos=2;
              }

              LCD_DisplayCount(Line4,Column6-((u8_DisplayPrevPos)*16),0,\
                                    u8_ArrayTime[u8_PrevElement] + 0x30);
              LCD_DisplayCount(Line4,Column6-(u8_DisplayCurrentPos*16),1,\
                                    u8_ArrayTime[u8_CounterPosition] + 0x30);
            }
          break;
  }
}

/*******************************************************************************
* Function Name  : SelFunction
* Description    : This Function is executed when Sel Button is pressed
* Input          : None
* Output         : None
* Return         : None

*******************************************************************************/
void SelFunction(void)
{
  u32 u32_EventTimer;
  u8 u8_ArrayPos;
  u16 u16_CalibrationValue;
  u8 u8_DisplayPos=0;
  
  u8_MenuLevelPointer++;
  
  if(u8_MenuLevelPointer !=0)
  {
    u8_TimeDateDisplay=1;
  }
  
  if(u8_MenuLevelPointer==1)
  {
    BKP_TamperPinCmd(DISABLE);
    LCD_Clear(Blue2);
    LCD_SetTextColor(Green);
    LCD_DisplayString(Line0,Column1,"CLOCK/CALENDAR SET");
    LCD_DisplayString(Line3,Column5,"FEATURES");
    LCD_DisplayString(Line6,Column1,"CLOCK SOURCE SELECT");
    LCD_SetTextColor(White);
    LCD_SetBackColor(Green);
    LCD_DisplayString(Line1,Column1,"Time");
    LCD_SetBackColor(Blue2);
    LCD_DisplayString(Line1,Column7,"Alarm");
    LCD_DisplayString(Line1,Column14,"Date");
    LCD_DisplayString(Line4,Column1,"LowPower");
    LCD_DisplayString(Line4,Column11,"Tamper");
    LCD_DisplayString(Line7,Column0,"32768Hz");
    LCD_DisplayString(Line7,Column9,"50Hz");
    LCD_DisplayString(Line7,Column15,"60Hz");
    LCD_DisplayString(Line9,Column5,"CALIBRATE");
    RightLeftIntExtOnOffConfig(ENABLE);
  }

  /* Enter the System Time */
  if(u8_MenuLevelPointer==2 && u8_TotalMenuPointer==1)
  {
    UpDownIntOnOffConfig(ENABLE);
    LCD_Clear(Blue2);
    LCD_SetTextColor(Green);
    LCD_DisplayString(Line2,Column6,"Set Time ");
    LCD_SetTextColor(White);
    /* Display two colons (:) for seperating hours, minutes and seconds */
    LCD_DisplayChar(Line4,Column8,ASCII_COLON);
    LCD_DisplayChar(Line4,Column11,ASCII_COLON);
    InitialiseTime();
    LCD_DisplayCount(Line4,Column6,1,u8_ArrayTime[0]+0x30);
    LCD_SetBackColor(Blue2);
    
    for(u8_ArrayPos=1;u8_ArrayPos<=5;u8_ArrayPos++)
    {
      if(!((u8_ArrayPos==2) || (u8_ArrayPos==4)))
      {
        u8_DisplayPos ++;
      }
      else
      {
        u8_DisplayPos+=2;
      }
      LCD_DisplayChar(Line4,Column6-(16*u8_DisplayPos),u8_ArrayTime[u8_ArrayPos]+0x30);
    }
    
    LCD_DisplayString(Line6,Column6,"To Quit");
    LCD_DisplayString(Line7,Column0,"Do not press any key");
    LCD_DisplayString(Line8,Column3,"for 8 seconds");
    LCD_SetBackColor(Green);
  }

  /* Enter the Alarm Time */
  if(u8_MenuLevelPointer==2 && u8_TotalMenuPointer==2)
  {
    UpDownIntOnOffConfig(ENABLE);
    LCD_Clear(Blue2);
    LCD_SetTextColor(Green);
    LCD_DisplayString(Line2,Column2,"Set Alarm Time");
    LCD_SetTextColor(White);
    /* Display two colons (:) for seperating hours, minutes and seconds */
    LCD_DisplayChar(Line4,Column8,ASCII_COLON);
    LCD_DisplayChar(Line4,Column11,ASCII_COLON);
    InitialiseTime();
    LCD_DisplayCount(Line4,Column6,1,u8_ArrayTime[0]+0x30);
    LCD_SetBackColor(Blue2);
    
    for(u8_ArrayPos=1;u8_ArrayPos<=5;u8_ArrayPos++)
    {
      if(!((u8_ArrayPos==2) || (u8_ArrayPos==4)))
      {
        u8_DisplayPos ++;
      }
      else
      {
        u8_DisplayPos+=2;
      }
      LCD_DisplayChar(Line4,Column6-(16*u8_DisplayPos),u8_ArrayTime[u8_ArrayPos]+0x30);
    }
    
    LCD_DisplayString(Line6,Column6,"To Quit");
    LCD_DisplayString(Line7,Column0,"Do not press any key");
    LCD_DisplayString(Line8,Column3,"for 8 seconds");
    LCD_SetBackColor(Green);
  }

  /* Enter the System Date/Alarm Date */
  if(u8_MenuLevelPointer==2 && u8_TotalMenuPointer==3)
  {
    UpDownIntOnOffConfig(ENABLE);
    LCD_Clear(Blue2);
    LCD_SetTextColor(Green);
    
    if(u8_AlarmDate==0)
    {
      LCD_DisplayString(Line2,Column7,"Set Date ");
    }
    else
    {
      LCD_DisplayString(Line2,Column4,"Set Alarm Date ");
    }
    
    LCD_SetTextColor(White);
    InitialiseDate();
    LCD_DisplayChar(Line4,Column8,ASCII_SLASH);
    LCD_DisplayChar(Line4,Column11,ASCII_SLASH);
    LCD_DisplayCount(Line4,Column6,1,(u8_ArrayTime[0]+0x30));
    LCD_SetBackColor(Blue2);
    
    for(u8_ArrayPos=1;u8_ArrayPos <= 7;u8_ArrayPos++)
    {
      if(!((u8_ArrayPos==2) || (u8_ArrayPos==4)))
      {
        u8_DisplayPos++;
      }
      else
      {
        u8_DisplayPos+=2;
      }

      LCD_DisplayChar(Line4,Column6-(16*u8_DisplayPos),u8_ArrayTime[u8_ArrayPos]+0x30);
    }
    
    LCD_DisplayString(Line6,Column6,"To Quit");
    LCD_DisplayString(Line7,Column0,"Do not press any key");
    LCD_DisplayString(Line8,Column3,"for 8 seconds");
    LCD_SetBackColor(Green);
  }


  /* Enter into Low Power Mode(STOP/STANDBY) selection (LowPowerMode is selected) */
  if(u8_MenuLevelPointer==2 && u8_TotalMenuPointer==4)
  {
    LCD_Clear(Blue2);
    LCD_SetBackColor(Green);
    LCD_DisplayString(Line4,Column4,"STOP");
    LCD_SetBackColor(Blue2);
    LCD_DisplayString(Line4,Column10,"STANDBY");
    u8_TotalMenuPointer=10;
  }

  /* Enter into STOP MODE */
  if(u8_MenuLevelPointer==3 && u8_TotalMenuPointer==10)
  {
    LCD_Clear(Blue2);
    LCD_DisplayString(Line3,Column2,"MCU IN STOP MODE");
    LCD_DisplayString(Line6,Column1,"PRESS SEL TO EXIT");
    RightLeftIntExtOnOffConfig(DISABLE);
    /* LED D4 Glows */
    GPIO_SetBits(GPIOC, GPIO_Pin_9);
    PWR_EnterSTOPMode(PWR_Regulator_ON,PWR_STOPEntry_WFI);
    ReturnFromStopMode();
    CheckForDaysElapsed();
  }

  /* Enter into STANDBY MODE  */
  if(u8_MenuLevelPointer==3 && u8_TotalMenuPointer==11)
  {
    LCD_Clear(Blue2);
    LCD_DisplayString(Line3,Column0-5,"MCU IN STANDBY MODE");
    LCD_DisplayString(Line6,Column0-2,"PRESS WAKEUP TO EXIT");
    /* Enable Wake up pin for waking the micro from standby mode */
    PWR_WakeUpPinCmd(ENABLE);
    /* Enter into standby mode  */
    PWR_EnterSTANDBYMode();
  }

  /* Tamper events section  */
  if(u8_MenuLevelPointer==2 && u8_TotalMenuPointer==5)
  {
    LCD_Clear(Blue2);
    LCD_SetBackColor(Green);
    LCD_DisplayString(Line4,Column4,"VIEW");
    LCD_SetBackColor(Blue2);
    LCD_DisplayString(Line4,Column10,"ERASE");
  }

  /*Read Tamper events and display on the LCD*/
  if(u8_MenuLevelPointer==3 && u8_TotalMenuPointer==5)
  {
    SelIntExtOnOffConfig(DISABLE);
    LCD_Clear(Blue2);
    EE_ReadValue();

    while(ReadKey() != SEL)
    {
    }
    MenuInit();
  }

  /*Erase Tamper Log */
  if(u8_MenuLevelPointer==3 && u8_TotalMenuPointer==6)
  {
    SelIntExtOnOffConfig(DISABLE);
    EE_Format();
    LCD_Clear(Red);
    LCD_SetBackColor(Red);
    LCD_DisplayString(Line4,Column1,"TAMPER LOG ERASED");
    u8_TamperNumber=0;
    BKP_WriteBackupRegister(BKP_DR5,u8_TamperNumber);
    u32_EventTimer= RTC_GetCounter();
    while((RTC_GetCounter()-u32_EventTimer) < 2)
    {
    }
    MenuInit();
  }

 /* Clock Source Select - Selection_32768Hz   */
  if(u8_MenuLevelPointer==2 && u8_TotalMenuPointer==6)
  {
    BKP_WriteBackupRegister(BKP_DR1, CONFIGURATION_RESET);
    RTC_Configuration();
    MenuInit();
  }

 /* Clock Source Select - Selection_50Hz   */
  if(u8_MenuLevelPointer==2 && u8_TotalMenuPointer==7)
  {
    BKP_WriteBackupRegister(BKP_DR1, CONFIGURATION_RESET);
    RTC_Configuration();
    MenuInit();
  }
   /* Clock Source Select - Selection_50Hz   */
  if(u8_MenuLevelPointer==2 && u8_TotalMenuPointer==8)
  {
    BKP_WriteBackupRegister(BKP_DR1, CONFIGURATION_RESET);
    RTC_Configuration();
    MenuInit();
  }

  /* Clock Calibration Menu */
  if(u8_MenuLevelPointer==2 && u8_TotalMenuPointer==9)
  {
    /* Calibration is done only in case external crystal oscillator - 32 KHz is used */
    if(BKP_ReadBackupRegister(BKP_DR6) == 1)
    {
      LCD_Clear(Blue2);
      LCD_SetBackColor(Green);
      LCD_DisplayString(Line4,Column2,"MANUAL");
      LCD_SetBackColor(Blue2);
      LCD_DisplayString(Line4,Column12,"AUTO");
    }
    else
    {
      /* Probably 50/60 Hz external clock source is selected */
      LCD_Clear(Red);
      LCD_SetBackColor(Red);
      LCD_DisplayString(Line3,Column1, "No Calibration in");
      LCD_DisplayString(Line4,Column1,"case of 50/60Hz  ");
      LCD_DisplayString(Line6,Column1,"clock source");
    }
  }

  /* Manual Calibration Routine  */
  if(u8_MenuLevelPointer==3 && u8_TotalMenuPointer==9)
  {
    ManualClockCalibration();
  }

  /* Auto Calibration Routine */
  if(u8_MenuLevelPointer==3 && u8_TotalMenuPointer==12)
  {
    AutoClockCalibration();
  }
  
  if(u8_MenuLevelPointer==4 && u8_TotalMenuPointer==9)
  {
    u16_CalibrationValue=(u8_ArrayTime[0]*100)+(u8_ArrayTime[1]*10)+u8_ArrayTime[2];
  
    if(u16_CalibrationValue<=121)
    {
      BKP_SetRTCCalibrationValue(u16_CalibrationValue);
    }
    else
    {
      LCD_Clear(Red);
      LCD_SetBackColor(Red);
      LCD_DisplayString(Line4,Column4,"Invalid Value !");
      u32_EventTimer= RTC_GetCounter();
      
      while(RTC_GetCounter()-u32_EventTimer < 2)
      {
      }
    }
    MenuInit();
  }

  /*Set System time */
  if(u8_MenuLevelPointer==3 && u8_TotalMenuPointer==1)
  {
    SetTime((u8_ArrayTime[0]*10)+u8_ArrayTime[1],(u8_ArrayTime[2]*10)+\
    u8_ArrayTime[3],(u8_ArrayTime[4]*10)+u8_ArrayTime[5]);
    MenuInit();
    u8_CounterPosition=0;
    UpDownIntOnOffConfig(DISABLE);
    u8_TimeDateDisplay=0;
  }

 /*Set Alarm Time and Date*/
  if(u8_MenuLevelPointer==3 && u8_TotalMenuPointer==2)
  {
    SetAlarm((u8_ArrayTime[0]*10)+u8_ArrayTime[1],(u8_ArrayTime[2]*10)+u8_ArrayTime[3],\
      (u8_ArrayTime[4]*10)+u8_ArrayTime[5]);
    u8_AlarmDate=1;
    u8_MenuLevelPointer=1;
    u8_TotalMenuPointer=3;
    
    for(u8_ArrayPos=0;u8_ArrayPos<7;u8_ArrayPos++)
    {
      u8_ArrayTime[u8_ArrayPos]=0;
    }
    
    u8_CounterPosition=0;
    u8_DisplayCurrentPos=0;
    u8_DisplayPrevPos=0;
    u16_Counter=0;
    LCD_SetBackColor(Blue2);
    /* For entering Alarm date */
    SelFunction();
  }

  /*Set System date */
  if(u8_MenuLevelPointer==3 && u8_TotalMenuPointer==3)
  {
    SetDate((u8_ArrayTime[0]*10)+u8_ArrayTime[1],(u8_ArrayTime[2]*10)+u8_ArrayTime[3],\
      ((u8_ArrayTime[4]*1000)+(u8_ArrayTime[5]*100)+(u8_ArrayTime[6]*10)+u8_ArrayTime[7]));
    MenuInit();
    
    for(u8_ArrayPos=0;u8_ArrayPos<6;u8_ArrayPos++)
    {
      u8_ArrayTime[u8_ArrayPos]=0;
    }
    
    u8_CounterPosition=0;
    UpDownIntOnOffConfig(DISABLE);
    u8_TimeDateDisplay=0;
  }
}

/*******************************************************************************
* Function Name  : InitialiseTime
* Description    : Initialises ArrayTime[] buffer to current time
* Input          : None
* Output         : None
* Return         : None

*******************************************************************************/
void InitialiseTime(void)
{
   u8_ArrayTime[0]=s_TimeStructVar.u8_HourHigh;
   u8_ArrayTime[1]=s_TimeStructVar.u8_HourLow;
   u8_ArrayTime[2]=s_TimeStructVar.u8_MinHigh;
   u8_ArrayTime[3]=s_TimeStructVar.u8_MinLow;
   u8_ArrayTime[4]=s_TimeStructVar.u8_SecHigh;
   u8_ArrayTime[5]=s_TimeStructVar.u8_SecLow;
 }

/*******************************************************************************
* Function Name  : InitialiseDate
* Description    : Initialises ArrayTime[] buffer to current date
* Input          : None
* Output         : None
* Return         : None

*******************************************************************************/
void InitialiseDate(void)
{
   u8_ArrayTime[0]=s_DateStructVar.u8_Day/10;
   u8_ArrayTime[1]=s_DateStructVar.u8_Day%10;
   u8_ArrayTime[2]=s_DateStructVar.u8_Month/10;
   u8_ArrayTime[3]=s_DateStructVar.u8_Month%10;
   u8_ArrayTime[4]=s_DateStructVar.u16_Year/1000;
   u8_ArrayTime[5]=(s_DateStructVar.u16_Year/100)%10;
   u8_ArrayTime[6]=(s_DateStructVar.u16_Year/10)%10;
   u8_ArrayTime[7]=s_DateStructVar.u16_Year%10;
}

/*******************************************************************************
* Function Name  : MenuInit
* Description    : Menu Initialisation routine
* Input          : None
* Output         : None
* Return         : None

*******************************************************************************/
void MenuInit(void)
{
  u8 u8_ArrayCounter;
  LCD_Clear(Blue2);
  LCD_SetBackColor(Blue2);
  LCD_SetTextColor(Yellow);
  /*Draw a rectangle with-79:Start X-Cood,255:Start Y-Cood,100:Length,200:Width*/
  LCD_DrawRect(79,255,100,200);
  LCD_SetTextColor(Cyan);
  /*Draw a rectangle with-74:Start X-Cood,260:Start Y-Cood,110:Length,210:Width*/
  LCD_DrawRect(74,260,110,210);
  LCD_SetTextColor(Green);
  LCD_DisplayString(Line0,Column7,"STM32");
  LCD_DisplayString(Line1,Column2,"RTC AND CALENDAR");
  LCD_DisplayString(Line2,Column3,"IMPLEMENTATION");
  /*Display Colon : Ascii code:58 in decimal */
  LCD_DisplayChar(Line4,Column8,ASCII_COLON);
  LCD_DisplayChar(Line4,Column11,ASCII_COLON);
  LCD_SetTextColor(White);
  LCD_SetBackColor(Green);
  LCD_DisplayString(Line8,Column8,"MENU");
  LCD_SetBackColor(Blue2);
  u8_DisplayDateFlag=1;
  u16_Counter=0;
  u8_MenuLevelPointer=0;
  u8_TimeDateDisplay=0;
  u8_TotalMenuPointer=1;
  u8_DisplayCurrentPos=0;
  u8_DisplayPrevPos=0;
  u8_CounterPosition=0;
  
  for(u8_ArrayCounter=0;u8_ArrayCounter<6;u8_ArrayCounter++)
  {
    u8_ArrayTime[u8_ArrayCounter]=0;
  }
  
  BKP_RTCOutputConfig(BKP_RTCOutputSource_None);
  SelIntExtOnOffConfig(ENABLE);
  UpDownIntOnOffConfig(DISABLE);
  RightLeftIntExtOnOffConfig(DISABLE);
  BKP_TamperPinCmd(ENABLE);
}

/*******************************************************************************
* Function Name  : MenuManage
* Description    : Menu Management Routine
* Input          : None
* Output         : None
* Return         : None

*******************************************************************************/
void MenuManage(void)
{
  u32 u32_Timer;
  
  if(u8_FlagKey & 0x01)
  {
    u8_FlagKey &=0xFE;
    SelFunction();
  }
  
  if(u8_FlagKey & 0x02)
  {
    u8_FlagKey &=0xFD;
    UpFunction();
  }
  
  if(u8_FlagKey & 0x04)
  {
    u8_FlagKey &= 0xFB;
    DownFunction();
  }
  
 if(u8_FlagKey & 0x08)
  {
    u8_FlagKey &=0xF7;
    RightFunction();
  }
  
 if(u8_FlagKey & 0x10)
  {
    u8_FlagKey &=0xEF;
    LeftFunction();
  }
  
  /* Automatic return to the home screen if any of the joystick key
  is not pressed for 8 seconds */
  if(u8_FlagKey==0x00 && (u8_MenuLevelPointer == 1 || u8_MenuLevelPointer==2) \
    /*&& (u8_TotalMenuPointer !=9)*/)
  {
    u32_Timer=RTC_GetCounter();

    while(ReadKey()==NOKEY)
    {
      if((RTC_GetCounter()-u32_Timer)>=8)
      {
        MenuInit();
        break;
      }
    }
  }
}

/*******************************************************************************
* Function Name  : UpDownIntOnOffConfig
* Description    : Enables or disables EXTI for the menu navigation keys :
*                  EXTI lines 8 and 14 which correpond respectively
*                  to Up and Down.
* Input          : New State-can be ENABLE or DISABLE
* Output         : None
* Return         : None

*******************************************************************************/
void UpDownIntOnOffConfig(FunctionalState NewState)
{
  EXTI_InitTypeDef EXTI_InitStructure;

  /* Initializes the EXTI_InitStructure */
  EXTI_StructInit(&EXTI_InitStructure);

  /* Disable the EXTI line 8 and 14 on falling edge */
  if(NewState == DISABLE)
  {
    EXTI_InitStructure.EXTI_Line = EXTI_Line8 |  EXTI_Line14;
    EXTI_InitStructure.EXTI_LineCmd = DISABLE;
    EXTI_Init(&EXTI_InitStructure);
  }
  else
  {
    EXTI_ClearITPendingBit(EXTI_Line8  | EXTI_Line14 );
    EXTI_InitStructure.EXTI_Mode = EXTI_Mode_Interrupt;
    EXTI_InitStructure.EXTI_Line = EXTI_Line8 | EXTI_Line14;
    EXTI_InitStructure.EXTI_Trigger = EXTI_Trigger_Falling;
    EXTI_InitStructure.EXTI_LineCmd = ENABLE;
    EXTI_Init(&EXTI_InitStructure);
  }
}

/*******************************************************************************
* Function Name  : RightLeftIntExtOnOffConfig
* Description    : Enables or disables EXTI for the menu navigation keys :
*                  EXTI lines 0 and 1 which correpond respectively
*                  to Right and Left.
* Input          : NewState: New state of the navigation keys. This parameter
*                  can be: ENABLE or DISABLE.
* Output         : None
* Return         : None
*******************************************************************************/
void RightLeftIntExtOnOffConfig(FunctionalState NewState)
{
  EXTI_InitTypeDef EXTI_InitStructure;

  /* Initializes the EXTI_InitStructure */
  EXTI_StructInit(&EXTI_InitStructure);

  /* Disable the EXTI line 0 and 1 on falling edge */
  if(NewState == DISABLE)
  {
    EXTI_InitStructure.EXTI_Line = EXTI_Line0 | EXTI_Line1;
    EXTI_InitStructure.EXTI_LineCmd = DISABLE;
    EXTI_Init(&EXTI_InitStructure);
  }
  /* Enable the EXTI line 0 and 1 on falling edge */
  else
  {
    /* Clear the the EXTI line 0 and 1 interrupt pending bit */
    EXTI_ClearITPendingBit(EXTI_Line0 | EXTI_Line1 );
    EXTI_InitStructure.EXTI_Mode = EXTI_Mode_Interrupt;
    EXTI_InitStructure.EXTI_Line = EXTI_Line0 | EXTI_Line1;
    EXTI_InitStructure.EXTI_Trigger = EXTI_Trigger_Falling;
    EXTI_InitStructure.EXTI_LineCmd = ENABLE;
    EXTI_Init(&EXTI_InitStructure);
  }
}

/*******************************************************************************
* Function Name  : SelIntExtOnOffConfig
* Description    : Enables or disables EXTI for the menu navigation keys :
*                  EXTI lines  12
*                  "SEL"
* Input          : NewState: New state of the navigation keys. This parameter
*                  can be: ENABLE or DISABLE.
* Output         : None
* Return         : None
*******************************************************************************/
void SelIntExtOnOffConfig(FunctionalState NewState)
{
  EXTI_InitTypeDef EXTI_InitStructure;

  /* Initializes the EXTI_InitStructure */
  EXTI_StructInit(&EXTI_InitStructure);

  /* Disable the EXTI line  12  on falling edge */
  if(NewState == DISABLE)
  {
    EXTI_InitStructure.EXTI_Line = EXTI_Line12 ;
    EXTI_InitStructure.EXTI_LineCmd = DISABLE;
    EXTI_Init(&EXTI_InitStructure);
  }
  /* Enable the EXTI line 12 on falling edge */
  else
  {
    /* Clear the the EXTI line 12  interrupt pending bit */
    EXTI_ClearITPendingBit( EXTI_Line12 );
    EXTI_InitStructure.EXTI_Mode = EXTI_Mode_Interrupt;
    EXTI_InitStructure.EXTI_Line = EXTI_Line12 ;
    EXTI_InitStructure.EXTI_Trigger = EXTI_Trigger_Falling;
    EXTI_InitStructure.EXTI_LineCmd = ENABLE;
    EXTI_Init(&EXTI_InitStructure);
  }
}

/*******************************************************************************
* Function Name  : NVIC_JoyStickConfig
* Description    : Joystick interrupts NVIC Configuration
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void NVIC_JoyStickConfig(void)
{
  NVIC_InitTypeDef NVIC_InitStructure;
  EXTI_InitTypeDef EXTI_InitStructure;
  
  /* Enable the EXTI9_5 Interrupt */
  NVIC_InitStructure.NVIC_IRQChannel = EXTI9_5_IRQChannel;
  NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 2;
  NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;
  NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
  NVIC_Init(&NVIC_InitStructure);
  /* Enable the EXTI0 Interrupt */
  NVIC_InitStructure.NVIC_IRQChannel =EXTI0_IRQChannel;
  NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 2;
  NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;
  NVIC_Init(&NVIC_InitStructure);
  /* Enable the EXTI1 Interrupt */
  NVIC_InitStructure.NVIC_IRQChannel = EXTI1_IRQChannel;
  NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 2;
  NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;
  NVIC_Init(&NVIC_InitStructure);
  /* Enable the  EXTI15_10 Interrupt */
  NVIC_InitStructure.NVIC_IRQChannel = EXTI15_10_IRQChannel;
  NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 2;
  NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;
  NVIC_Init(&NVIC_InitStructure);
  /* Enable EXTI_Line7 Interrupt */
  /* Used for Battery removal/restore simulated detection */
  EXTI_ClearITPendingBit( EXTI_Line7 );
  EXTI_InitStructure.EXTI_Mode = EXTI_Mode_Interrupt;
  EXTI_InitStructure.EXTI_Line = EXTI_Line7 ;
  EXTI_InitStructure.EXTI_Trigger = EXTI_Trigger_Rising_Falling;
  EXTI_InitStructure.EXTI_LineCmd = ENABLE;
  EXTI_Init(&EXTI_InitStructure);
}

/*******************************************************************************
* Function Name  : ReadKey
* Description    : Reads key from demoboard.
* Input          : None
* Output         : None
* Return         : Return RIGHT, LEFT, SEL, UP, DOWN or NOKEY
*******************************************************************************/
u8 ReadKey(void)
{
  /* "right" key is pressed */
  if(!GPIO_ReadInputDataBit(GPIOE, GPIO_Pin_0))
  {
    while(GPIO_ReadInputDataBit(GPIOE,GPIO_Pin_0) == Bit_RESET)
    {
    }
    return RIGHT;
  }
  /* "left" key is pressed */
  if(!GPIO_ReadInputDataBit(GPIOE, GPIO_Pin_1))
  {
    while(GPIO_ReadInputDataBit(GPIOE,GPIO_Pin_1) == Bit_RESET)
    {
    }
    return LEFT;
  }
  /* "up" key is pressed */
  if(!GPIO_ReadInputDataBit(GPIOD, GPIO_Pin_8))
  {
    while(GPIO_ReadInputDataBit(GPIOD,GPIO_Pin_8) == Bit_RESET)
    {
    }
    return UP;
  }
  /* "down" key is pressed */
  if(!GPIO_ReadInputDataBit(GPIOD, GPIO_Pin_14))
  {
    while(GPIO_ReadInputDataBit(GPIOD,GPIO_Pin_14) == Bit_RESET)
    {
    }
    return DOWN;
  }
  /* "sel" key is pressed */
  if(!GPIO_ReadInputDataBit(GPIOD, GPIO_Pin_12))
  {
    while(GPIO_ReadInputDataBit(GPIOD,GPIO_Pin_12) == Bit_RESET)
    {
    }
    return SEL;
  }
  /* No key is pressed */
  else
  {
    return NOKEY;
  }
}

/******************* (C) COPYRIGHT 2008 STMicroelectronics *****END OF FILE****/
