/**
 ******************************************************************************
 * @file    main.c
 * @author  EMEA AMS/IPD Marketing & Application - VE
 * @version V1.0.1
 * @date    June-2012
 * @brief   Demo program entry file.
 ******************************************************************************
 * @copy
 *
 * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
 * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
 * TIME. AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY
 * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
 * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
 * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
 *
 * <h2><center>&copy; COPYRIGHT 2012 STMicroelectronics</center></h2>
 */

/* Includes ------------------------------------------------------------------*/
#include "main.h"
#include "easyspin.h"
#include "eMotionControl.h"
#include "easyspin_target_config.h"
#include "clock.h"

/** @addtogroup Examples
 * @{
 */

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
uint32_t easySPIN_rx_data = 0;

/* Private function prototypes -----------------------------------------------*/
void delay(__IO uint32_t nCount);

/* Private functions ---------------------------------------------------------*/

/**
 * @brief  Main program.
 * @param  None
 * @retval None
 */
int main(void) {
	/*!< At this stage the microcontroller clock setting is already configured, 
	 this is done through SystemInit() function which is called from startup
	 file (startup_stm32f10x_xx.s) before to branch to application main.
	 To reconfigure the default setting of SystemInit() function, refer to
	 system_stm32f10x.c file
	 */
	
	/* Configure the System clock frequency, HCLK, PCLK2 and PCLK1 prescalers */
	SetSysClock();

	/* eMotionControl module initialization */
	eMotionControl_Init();

	/* Customize target stepper-motor specific registers at easySPIN module level */
	/* TVAL register setup */ 
	easySPIN_SetParam(easySPIN_TVAL, 0x00);

	/* T_FAST register setup */
	easySPIN_SetParam(easySPIN_STEP_MODE, easySPIN_STEP_SEL_1
			| easySPIN_SYNC_SEL_1_2);

	/* TON_MIN register setup */
	easySPIN_SetParam(easySPIN_TON_MIN, 0x00);

	/* TOFF_MIN register setup */
	easySPIN_SetParam(easySPIN_TOFF_MIN, 0x00);

	/* OCD_TH register setup */
	easySPIN_SetParam(easySPIN_OCD_TH, easySPIN_OCD_TH_375mA);

	/* STEP_MODE register setup  */
	easySPIN_SetParam(easySPIN_STEP_MODE, easySPIN_STEP_SEL_1
			| easySPIN_SYNC_SEL_1_2);

	/* ALARM_EN register setup  */
	easySPIN_SetParam(easySPIN_ALARM_EN, easySPIN_ALARM_EN_OVERCURRENT
			| easySPIN_ALARM_EN_THERMAL_SHUTDOWN
			| easySPIN_ALARM_EN_THERMAL_WARNING
			| easySPIN_ALARM_EN_UNDERVOLTAGE | easySPIN_ALARM_EN_SW_TURN_ON
			| easySPIN_ALARM_EN_WRONG_NPERF_CMD);

	/* CONFIG register setup */
	easySPIN_SetParam(easySPIN_CONFIG, easySPIN_CONFIG_INT_16MHZ
			| easySPIN_CONFIG_EN_TQREG_INT_REG | easySPIN_CONFIG_OC_SD_ENABLE
			| easySPIN_CONFIG_SR_180V_us | easySPIN_CONFIG_TSW_8_us);

	/* Read STATUS register */
	easySPIN_rx_data = easySPIN_Get_Status();

	/* GoHome command example */
	eMotionControl_GoHome();
	eMotionControl_WaitWhileActive();
	currentPosition = easySPIN_GetParam(easySPIN_ABS_POS);

	/* GoTo command example */
	eMotionControl_GoTo(-65);
	eMotionControl_WaitWhileActive();
	currentPosition = easySPIN_GetParam(easySPIN_ABS_POS);

	eMotionControl_GoTo(0);
	eMotionControl_WaitWhileActive();
	currentPosition = easySPIN_GetParam(easySPIN_ABS_POS);

	eMotionControl_GoTo(65);
	eMotionControl_WaitWhileActive();
	currentPosition = easySPIN_GetParam(easySPIN_ABS_POS);

	eMotionControl_GoTo(0);
	eMotionControl_WaitWhileActive();
	currentPosition = easySPIN_GetParam(easySPIN_ABS_POS);

	/* Move command example */
	eMotionControl_Move(DIR_Forward, 200);
	eMotionControl_WaitWhileActive();

	eMotionControl_Move(DIR_Reverse, 200);
	eMotionControl_WaitWhileActive();

	/* Run command example */
	eMotionControl_Run(DIR_Forward, MAX_STEPS_PER_SEC);
	
	/* Wait few seconds - motor turns */
	delay(0x03FFFFFF);
	
	/* SoftStop command example */
	while(eMotionControl_GetState() != Steady);
	eMotionControl_SoftStop();
	eMotionControl_WaitWhileActive();
	
	/* Disable power stage */
	easySPIN_Disable();

	while (1)
		;
}

/**
  * @brief  Inserts a delay time.
  * @param  nCount: specifies the delay time length.
  * @retval None
  */
void delay(__IO uint32_t nCount) {
  for(; nCount!= 0;nCount--);
}

#ifdef  USE_FULL_ASSERT
/**
 * @brief  Reports the name of the source file and the source line number
 *         where the assert_param error has occurred.
 * @param  file: pointer to the source file name
 * @param  line: assert_param error line source number
 * @retval None
 */
void assert_failed(uint8_t* file, uint32_t line)
{
	/* User can add his own implementation to report the file name and line number,
	 ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	/* Infinite loop */
	while (1)
	{
	}
}
#endif

/**
 * @}
 */

/**
 * @}
 */

/******************* (C) COPYRIGHT 2012 STMicroelectronics *****END OF FILE****/
