/**
  ******************************************************************************
  * @file    easyspin_target_config.h 
  * @author  EMEA AMS-IPD Marketing & Application, Prague - VE
  * @version V1.0.1
  * @date    June-2012
  * @brief   Configuration header for easySPIN library
  ******************************************************************************
  * @copy
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  *
  * <h2><center>&copy; COPYRIGHT 2012 STMicroelectronics</center></h2>
  */ 

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __EASYSPIN_TARGET_CONFIG_H
#define __EASYSPIN_TARGET_CONFIG_H

/* Includes ------------------------------------------------------------------*/
/* Exported constants --------------------------------------------------------*/

/* Select one of the following two evalboard options, comment the other one --*/
#define STEVAL_PCC009V2
//#define STM32_VL_Discovery

/* Specify volume of each transition (acceleration/deceleration) buffers 
   (arrays of uin16_t values) according to your application needs and amount
   of RAM available. */
#define MAX_ACC_TRANSITION_VOLUME	1000
#define MAX_DEC_TRANSITION_VOLUME	1000

/* Motor configuration configuration for easyspin_motion_control.c module.
   Specify the integer values in accordance with application needs. */
#define 	MIN_STEPS_PER_SEC		10	/* [steps/sec] */
#define 	MAX_STEPS_PER_SEC		200	/* [steps/sec] */

#define 	ACCELERATION_RATE		120 /* [steps/sec^2] */ 
#define 	DECELERATION_RATE		120	/* [steps/sec^2] */

#define 	DEFAULT_PERIOD_VALUE	(2500 - 1)

#define 	INT_CK_FREQ				24000000
#define 	TIM_COUNTER_CLK			10000  /* Counter freq = 10kHz */


/** @defgroup easySPIN signals - Used for connection with STEVAL-PCC009V2 evalboard
  *
  * {
  */
#ifdef STEVAL_PCC009V2
	#define easySPIN_SPI				SPI2
	
	#define easySPIN_SCK_Pin			GPIO_Pin_13
	#define easySPIN_SCK_Port			GPIOB
	
	#define easySPIN_MOSI_Pin			GPIO_Pin_15
	#define easySPIN_MOSI_Port			GPIOB
	
	#define easySPIN_MISO_Pin			GPIO_Pin_14
	#define easySPIN_MISO_Port			GPIOB
	
	#define easySPIN_nSS_Pin			GPIO_Pin_12
	#define easySPIN_nSS_Port			GPIOB
	
	#define easySPIN_DIR_Pin			GPIO_Pin_10
	#define easySPIN_DIR_Port			GPIOB
	
	#define easySPIN_FLAG_Pin			GPIO_Pin_11
	#define easySPIN_FLAG_Port			GPIOB
	
	#define easySPIN_STCK_Pin			GPIO_Pin_0
	#define easySPIN_STCK_Port			GPIOB
	
	#define easySPIN_STBY_RESET_Pin		GPIO_Pin_1
	#define easySPIN_STBY_RESET_Port	GPIOB

	#define POWER_LED_Pin				GPIO_Pin_4
	#define POWER_LED_Port				GPIOC
	
	/* List all the peripherals, which CLKs have to be enabled! */
	#define easySPIN_PERIPHERAL_CLKs_APB1	(RCC_APB1Periph_SPI2)
	#define easySPIN_PERIPHERAL_CLKs_APB2	(RCC_APB2Periph_GPIOB | RCC_APB2Periph_GPIOC)
#endif
/**
  * @}
  */

/** @defgroup easySPIN signals - Used for connection with STM32 discovery kit
  *  If another control board is used, please change the following settings
  *  according to the application board wiring diagram.
  *  Do not touch if STEVAL-PCC009V2 is used, see defs below for that evalboard.
  * {
  */
#ifdef STM32_VL_Discovery
	#define easySPIN_SPI				SPI1
										
	#define easySPIN_SCK_Pin			GPIO_Pin_5
	#define easySPIN_SCK_Port			GPIOA
	
	#define easySPIN_MOSI_Pin			GPIO_Pin_7
	#define easySPIN_MOSI_Port			GPIOA
	
	#define easySPIN_MISO_Pin			GPIO_Pin_6
	#define easySPIN_MISO_Port			GPIOA
	
	#define easySPIN_nSS_Pin			GPIO_Pin_4
	#define easySPIN_nSS_Port			GPIOA
		
	#define easySPIN_DIR_Pin			GPIO_Pin_4
	#define easySPIN_DIR_Port			GPIOC
	
	#define easySPIN_FLAG_Pin			GPIO_Pin_5
	#define easySPIN_FLAG_Port			GPIOC
	
	#define easySPIN_STCK_Pin			GPIO_Pin_1
	#define easySPIN_STCK_Port			GPIOA
	
	#define easySPIN_STBY_RESET_Pin		GPIO_Pin_0
	#define easySPIN_STBY_RESET_Port	GPIOB
	
	/* List all the peripherals, which CLKs have to be enabled! */
	#define easySPIN_PERIPHERAL_CLKs_APB1	(0x00)
	#define easySPIN_PERIPHERAL_CLKs_APB2	(RCC_APB2Periph_GPIOA | RCC_APB2Periph_GPIOB | RCC_APB2Periph_GPIOC | RCC_APB2Periph_SPI1)
#endif
/**
  * @}
  */

/* Exported types ------------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/

#endif /* __EASYSPIN_TARGET_CONFIG_H */

/******************* (C) COPYRIGHT 2012 STMicroelectronics *****END OF FILE****/

