/**
  ******************************************************************************
  * @file    app_ethernet.c
  * @author  MCD Application Team
  * @version V1.0.0
  * @date    31-July-2012
  * @brief   This file contains the Ethernet applications process.
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; COPYRIGHT 2012 STMicroelectronics</center></h2>
  *
  * Licensed under MCD-ST Liberty SW License Agreement V2, (the "License");
  * You may not use this file except in compliance with the License.
  * You may obtain a copy of the License at:
  *
  *        http://www.st.com/software_license_agreement_liberty_v2
  *
  * Unless required by applicable law or agreed to in writing, software 
  * distributed under the License is distributed on an "AS IS" BASIS, 
  * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  ******************************************************************************
  */ 

/* Includes ------------------------------------------------------------------*/
#include "lwip/opt.h"
#include "lwip/arch.h"
#include "lwip/api.h"
#include "fs.h"
#include "string.h"
#include "app_ethernet.h"
#include "mod_ethernet.h"
#include "mod_ethernet_config.h"
#include "dcmi_ov9655.h"
#include "dcmi_ov2640.h"
#include "mod_system.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define MAX_DHCP_TRIES 5
#define IPCAM_TIME_WAITING_FOR_INPUT	((portTickType) 100)

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/***************************** Netconn variables ******************************/
struct netif xnetif;
extern ETHERNET_SETTINGS_TypeDef  EthCfg;
extern xTaskHandle  DHCP_Task_Handle;
extern __IO uint8_t EthLinkStatus;
extern xTaskHandle Task_Handle;

/**************************** Web server variables ****************************/
struct netconn *conn, *newconn;
uint32_t nPageHits = 0;
uint32_t IPaddress;
extern ETHERNET_SettingsTypeDef  EthernetSettings;
extern xTaskHandle HTTP_Task_Handle;

/* Format of dynamic web page: the page header */
static const unsigned char PAGE_START[] = 
{
0x3c,0x21,0x44,0x4f,0x43,0x54,0x59,0x50,0x45,0x20,0x68,0x74,0x6d,0x6c,0x20,0x50,
0x55,0x42,0x4c,0x49,0x43,0x20,0x22,0x2d,0x2f,0x2f,0x57,0x33,0x43,0x2f,0x2f,0x44,
0x54,0x44,0x20,0x48,0x54,0x4d,0x4c,0x20,0x34,0x2e,0x30,0x31,0x2f,0x2f,0x45,0x4e,
0x22,0x20,0x22,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x77,0x77,0x77,0x2e,0x77,0x33,
0x2e,0x6f,0x72,0x67,0x2f,0x54,0x52,0x2f,0x68,0x74,0x6d,0x6c,0x34,0x2f,0x73,0x74,
0x72,0x69,0x63,0x74,0x2e,0x64,0x74,0x64,0x22,0x3e,0x0a,0x3c,0x68,0x74,0x6d,0x6c,
0x3e,0x3c,0x68,0x65,0x61,0x64,0x3e,0x3c,0x74,0x69,0x74,0x6c,0x65,0x3e,0x53,0x54,
0x4d,0x33,0x32,0x54,0x41,0x53,0x4b,0x53,0x3c,0x2f,0x74,0x69,0x74,0x6c,0x65,0x3e,
0x0d,0x0a,0x0d,0x0a,0x3c,0x6d,0x65,0x74,0x61,0x20,0x68,0x74,0x74,0x70,0x2d,0x65,
0x71,0x75,0x69,0x76,0x3d,0x22,0x43,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x2d,0x54,0x79,
0x70,0x65,0x22,0x20,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x3d,0x22,0x74,0x65,0x78,
0x74,0x2f,0x68,0x74,0x6d,0x6c,0x3b,0x20,0x63,0x68,0x61,0x72,0x73,0x65,0x74,0x3d,
0x77,0x69,0x6e,0x64,0x6f,0x77,0x73,0x2d,0x31,0x32,0x35,0x32,0x22,0x3e,0x0d,0x0a,
0x3c,0x6d,0x65,0x74,0x61,0x20,0x68,0x74,0x74,0x70,0x2d,0x65,0x71,0x75,0x69,0x76,
0x3d,0x22,0x72,0x65,0x66,0x72,0x65,0x73,0x68,0x22,0x20,0x63,0x6f,0x6e,0x74,0x65,
0x6e,0x74,0x3d,0x22,0x31,0x22,0x3e,0x0d,0x0a,0x3c,0x6d,0x65,0x74,0x61,0x20,0x63,
0x6f,0x6e,0x74,0x65,0x6e,0x74,0x3d,0x22,0x4d,0x53,0x48,0x54,0x4d,0x4c,0x20,0x36,
0x2e,0x30,0x30,0x2e,0x32,0x38,0x30,0x30,0x2e,0x31,0x35,0x36,0x31,0x22,0x20,0x6e,
0x61,0x6d,0x65,0x3d,0x22,0x47,0x45,0x4e,0x45,0x52,0x41,0x54,0x4f,0x52,0x22,0x3e,
0x0d,0x0a,0x3c,0x73,0x74,0x79,0x6c,0x65,0x20,0x3d,0x22,0x66,0x6f,0x6e,0x74,0x2d,
0x77,0x65,0x69,0x67,0x68,0x74,0x3a,0x20,0x6e,0x6f,0x72,0x6d,0x61,0x6c,0x3b,0x20,
0x66,0x6f,0x6e,0x74,0x2d,0x66,0x61,0x6d,0x69,0x6c,0x79,0x3a,0x20,0x56,0x65,0x72,
0x64,0x61,0x6e,0x61,0x3b,0x22,0x3e,0x3c,0x2f,0x73,0x74,0x79,0x6c,0x65,0x3e,0x3c,
0x2f,0x68,0x65,0x61,0x64,0x3e,0x0d,0x0a,0x3c,0x62,0x6f,0x64,0x79,0x3e,0x0d,0x0a,
0x3c,0x68,0x34,0x3e,0x3c,0x73,0x6d,0x61,0x6c,0x6c,0x20,0x73,0x74,0x79,0x6c,0x65,
0x3d,0x22,0x66,0x6f,0x6e,0x74,0x2d,0x66,0x61,0x6d,0x69,0x6c,0x79,0x3a,0x20,0x56,
0x65,0x72,0x64,0x61,0x6e,0x61,0x3b,0x22,0x3e,0x3c,0x73,0x6d,0x61,0x6c,0x6c,0x3e,
0x3c,0x62,0x69,0x67,0x3e,0x3c,0x62,0x69,0x67,0x3e,0x3c,0x62,0x69,0x67,0x20,0x73,
0x74,0x79,0x6c,0x65,0x3d,0x22,0x66,0x6f,0x6e,0x74,0x2d,0x77,0x65,0x69,0x67,0x68,
0x74,0x3a,0x20,0x62,0x6f,0x6c,0x64,0x3b,0x22,0x3e,0x3c,0x62,0x69,0x67,0x3e,0x3c,
0x73,0x74,0x72,0x6f,0x6e,0x67,0x3e,0x3c,0x65,0x6d,0x3e,0x3c,0x73,0x70,0x61,0x6e,
0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x66,0x6f,0x6e,0x74,0x2d,0x73,0x74,0x79,
0x6c,0x65,0x3a,0x20,0x69,0x74,0x61,0x6c,0x69,0x63,0x3b,0x22,0x3e,0x53,0x54,0x4d,
0x33,0x32,0x20,0x4c,0x69,0x73,0x74,0x20,0x6f,0x66,0x20,0x74,0x61,0x73,0x6b,0x73,
0x20,0x61,0x6e,0x64,0x0d,0x0a,0x74,0x68,0x65,0x69,0x72,0x20,0x73,0x74,0x61,0x74,
0x75,0x73,0x3c,0x2f,0x73,0x70,0x61,0x6e,0x3e,0x3c,0x2f,0x65,0x6d,0x3e,0x3c,0x2f,
0x73,0x74,0x72,0x6f,0x6e,0x67,0x3e,0x3c,0x2f,0x62,0x69,0x67,0x3e,0x3c,0x2f,0x62,
0x69,0x67,0x3e,0x3c,0x2f,0x62,0x69,0x67,0x3e,0x3c,0x2f,0x62,0x69,0x67,0x3e,0x3c,
0x2f,0x73,0x6d,0x61,0x6c,0x6c,0x3e,0x3c,0x2f,0x73,0x6d,0x61,0x6c,0x6c,0x3e,0x3c,
0x2f,0x68,0x34,0x3e,0x0d,0x0a,0x3c,0x68,0x72,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,
0x22,0x77,0x69,0x64,0x74,0x68,0x3a,0x20,0x31,0x30,0x30,0x25,0x3b,0x20,0x68,0x65,
0x69,0x67,0x68,0x74,0x3a,0x20,0x32,0x70,0x78,0x3b,0x22,0x3e,0x3c,0x73,0x70,0x61,
0x6e,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x66,0x6f,0x6e,0x74,0x2d,0x77,0x65,
0x69,0x67,0x68,0x74,0x3a,0x20,0x62,0x6f,0x6c,0x64,0x3b,0x22,0x3e,0x3c,0x2f,0x73,
0x70,0x61,0x6e,0x3e,0x3c,0x73,0x70,0x61,0x6e,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,
0x22,0x66,0x6f,0x6e,0x74,0x2d,0x77,0x65,0x69,0x67,0x68,0x74,0x3a,0x20,0x62,0x6f,
0x6c,0x64,0x3b,0x22,0x3e,0x3c,0x2f,0x73,0x70,0x61,0x6e,0x3e,0x0d,0x0a,0x3c,0x74,
0x61,0x62,0x6c,0x65,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x4d,0x73,0x6f,0x4e,
0x6f,0x72,0x6d,0x61,0x6c,0x54,0x61,0x62,0x6c,0x65,0x22,0x20,0x73,0x74,0x79,0x6c,
0x65,0x3d,0x22,0x77,0x69,0x64,0x74,0x68,0x3a,0x20,0x39,0x31,0x36,0x70,0x78,0x3b,
0x20,0x68,0x65,0x69,0x67,0x68,0x74,0x3a,0x20,0x32,0x38,0x70,0x78,0x3b,0x22,0x20,
0x62,0x6f,0x72,0x64,0x65,0x72,0x3d,0x22,0x31,0x22,0x20,0x63,0x65,0x6c,0x6c,0x70,
0x61,0x64,0x64,0x69,0x6e,0x67,0x3d,0x22,0x30,0x22,0x3e,0x0d,0x0a,0x3c,0x74,0x62,
0x6f,0x64,0x79,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,
0x22,0x22,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,
0x70,0x61,0x64,0x64,0x69,0x6e,0x67,0x3a,0x20,0x31,0x2e,0x35,0x70,0x74,0x3b,0x20,
0x62,0x61,0x63,0x6b,0x67,0x72,0x6f,0x75,0x6e,0x64,0x3a,0x20,0x72,0x67,0x62,0x28,
0x35,0x31,0x2c,0x20,0x35,0x31,0x2c,0x20,0x32,0x35,0x35,0x29,0x20,0x6e,0x6f,0x6e,
0x65,0x20,0x72,0x65,0x70,0x65,0x61,0x74,0x20,0x73,0x63,0x72,0x6f,0x6c,0x6c,0x20,
0x30,0x25,0x20,0x35,0x30,0x25,0x3b,0x20,0x2d,0x6d,0x6f,0x7a,0x2d,0x62,0x61,0x63,
0x6b,0x67,0x72,0x6f,0x75,0x6e,0x64,0x2d,0x63,0x6c,0x69,0x70,0x3a,0x20,0x69,0x6e,
0x69,0x74,0x69,0x61,0x6c,0x3b,0x20,0x2d,0x6d,0x6f,0x7a,0x2d,0x62,0x61,0x63,0x6b,
0x67,0x72,0x6f,0x75,0x6e,0x64,0x2d,0x6f,0x72,0x69,0x67,0x69,0x6e,0x3a,0x20,0x69,
0x6e,0x69,0x74,0x69,0x61,0x6c,0x3b,0x20,0x2d,0x6d,0x6f,0x7a,0x2d,0x62,0x61,0x63,
0x6b,0x67,0x72,0x6f,0x75,0x6e,0x64,0x2d,0x69,0x6e,0x6c,0x69,0x6e,0x65,0x2d,0x70,
0x6f,0x6c,0x69,0x63,0x79,0x3a,0x20,0x69,0x6e,0x69,0x74,0x69,0x61,0x6c,0x3b,0x20,
0x74,0x65,0x78,0x74,0x2d,0x61,0x6c,0x69,0x67,0x6e,0x3a,0x20,0x63,0x65,0x6e,0x74,
0x65,0x72,0x3b,0x20,0x68,0x65,0x69,0x67,0x68,0x74,0x3a,0x20,0x32,0x36,0x70,0x78,
0x3b,0x20,0x77,0x69,0x64,0x74,0x68,0x3a,0x20,0x32,0x32,0x39,0x70,0x78,0x3b,0x22,
0x3e,0x3c,0x73,0x70,0x61,0x6e,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x66,0x6f,
0x6e,0x74,0x2d,0x73,0x69,0x7a,0x65,0x3a,0x20,0x31,0x30,0x70,0x74,0x3b,0x20,0x66,
0x6f,0x6e,0x74,0x2d,0x66,0x61,0x6d,0x69,0x6c,0x79,0x3a,0x20,0x56,0x65,0x72,0x64,
0x61,0x6e,0x61,0x3b,0x20,0x66,0x6f,0x6e,0x74,0x2d,0x73,0x74,0x79,0x6c,0x65,0x3a,
0x20,0x69,0x74,0x61,0x6c,0x69,0x63,0x3b,0x20,0x66,0x6f,0x6e,0x74,0x2d,0x77,0x65,
0x69,0x67,0x68,0x74,0x3a,0x20,0x62,0x6f,0x6c,0x64,0x3b,0x22,0x3e,0x3c,0x61,0x20,
0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x69,0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d,
0x6c,0x22,0x3e,0x3c,0x73,0x70,0x61,0x6e,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,
0x63,0x6f,0x6c,0x6f,0x72,0x3a,0x20,0x77,0x68,0x69,0x74,0x65,0x3b,0x22,0x3e,0x48,
0x6f,0x6d,0x65,0x0d,0x0a,0x70,0x61,0x67,0x65,0x3c,0x2f,0x73,0x70,0x61,0x6e,0x3e,
0x3c,0x2f,0x61,0x3e,0x3c,0x2f,0x73,0x70,0x61,0x6e,0x3e,0x0d,0x0a,0x3c,0x2f,0x74,
0x64,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x70,
0x61,0x64,0x64,0x69,0x6e,0x67,0x3a,0x20,0x31,0x2e,0x35,0x70,0x74,0x3b,0x20,0x62,
0x61,0x63,0x6b,0x67,0x72,0x6f,0x75,0x6e,0x64,0x3a,0x20,0x72,0x67,0x62,0x28,0x35,
0x31,0x2c,0x20,0x35,0x31,0x2c,0x20,0x32,0x35,0x35,0x29,0x20,0x6e,0x6f,0x6e,0x65,
0x20,0x72,0x65,0x70,0x65,0x61,0x74,0x20,0x73,0x63,0x72,0x6f,0x6c,0x6c,0x20,0x30,
0x25,0x20,0x35,0x30,0x25,0x3b,0x20,0x2d,0x6d,0x6f,0x7a,0x2d,0x62,0x61,0x63,0x6b,
0x67,0x72,0x6f,0x75,0x6e,0x64,0x2d,0x63,0x6c,0x69,0x70,0x3a,0x20,0x69,0x6e,0x69,
0x74,0x69,0x61,0x6c,0x3b,0x20,0x2d,0x6d,0x6f,0x7a,0x2d,0x62,0x61,0x63,0x6b,0x67,
0x72,0x6f,0x75,0x6e,0x64,0x2d,0x6f,0x72,0x69,0x67,0x69,0x6e,0x3a,0x20,0x69,0x6e,
0x69,0x74,0x69,0x61,0x6c,0x3b,0x20,0x2d,0x6d,0x6f,0x7a,0x2d,0x62,0x61,0x63,0x6b,
0x67,0x72,0x6f,0x75,0x6e,0x64,0x2d,0x69,0x6e,0x6c,0x69,0x6e,0x65,0x2d,0x70,0x6f,
0x6c,0x69,0x63,0x79,0x3a,0x20,0x69,0x6e,0x69,0x74,0x69,0x61,0x6c,0x3b,0x20,0x74,
0x65,0x78,0x74,0x2d,0x61,0x6c,0x69,0x67,0x6e,0x3a,0x20,0x63,0x65,0x6e,0x74,0x65,
0x72,0x3b,0x20,0x68,0x65,0x69,0x67,0x68,0x74,0x3a,0x20,0x32,0x36,0x70,0x78,0x3b,
0x20,0x77,0x69,0x64,0x74,0x68,0x3a,0x20,0x32,0x32,0x39,0x70,0x78,0x3b,0x22,0x3e,
0x3c,0x62,0x3e,0x3c,0x69,0x3e,0x3c,0x73,0x70,0x61,0x6e,0x20,0x73,0x74,0x79,0x6c,
0x65,0x3d,0x22,0x66,0x6f,0x6e,0x74,0x2d,0x73,0x69,0x7a,0x65,0x3a,0x20,0x31,0x30,
0x70,0x74,0x3b,0x20,0x66,0x6f,0x6e,0x74,0x2d,0x66,0x61,0x6d,0x69,0x6c,0x79,0x3a,
0x20,0x56,0x65,0x72,0x64,0x61,0x6e,0x61,0x3b,0x22,0x3e,0x3c,0x73,0x70,0x61,0x6e,
0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x63,0x6f,0x6c,0x6f,0x72,0x3a,0x20,0x77,
0x68,0x69,0x74,0x65,0x3b,0x22,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x4c,0x69,0x73,
0x74,0x0d,0x0a,0x6f,0x66,0x20,0x74,0x61,0x73,0x6b,0x73,0x3c,0x2f,0x73,0x70,0x61,
0x6e,0x3e,0x3c,0x2f,0x73,0x70,0x61,0x6e,0x3e,0x3c,0x2f,0x69,0x3e,0x3c,0x2f,0x62,
0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x20,0x73,0x74,0x79,0x6c,
0x65,0x3d,0x22,0x70,0x61,0x64,0x64,0x69,0x6e,0x67,0x3a,0x20,0x31,0x2e,0x35,0x70,
0x74,0x3b,0x20,0x62,0x61,0x63,0x6b,0x67,0x72,0x6f,0x75,0x6e,0x64,0x3a,0x20,0x72,
0x67,0x62,0x28,0x35,0x31,0x2c,0x20,0x35,0x31,0x2c,0x20,0x32,0x35,0x35,0x29,0x20,
0x6e,0x6f,0x6e,0x65,0x20,0x72,0x65,0x70,0x65,0x61,0x74,0x20,0x73,0x63,0x72,0x6f,
0x6c,0x6c,0x20,0x30,0x25,0x20,0x35,0x30,0x25,0x3b,0x20,0x2d,0x6d,0x6f,0x7a,0x2d,
0x62,0x61,0x63,0x6b,0x67,0x72,0x6f,0x75,0x6e,0x64,0x2d,0x63,0x6c,0x69,0x70,0x3a,
0x20,0x69,0x6e,0x69,0x74,0x69,0x61,0x6c,0x3b,0x20,0x2d,0x6d,0x6f,0x7a,0x2d,0x62,
0x61,0x63,0x6b,0x67,0x72,0x6f,0x75,0x6e,0x64,0x2d,0x6f,0x72,0x69,0x67,0x69,0x6e,
0x3a,0x20,0x69,0x6e,0x69,0x74,0x69,0x61,0x6c,0x3b,0x20,0x2d,0x6d,0x6f,0x7a,0x2d,
0x62,0x61,0x63,0x6b,0x67,0x72,0x6f,0x75,0x6e,0x64,0x2d,0x69,0x6e,0x6c,0x69,0x6e,
0x65,0x2d,0x70,0x6f,0x6c,0x69,0x63,0x79,0x3a,0x20,0x69,0x6e,0x69,0x74,0x69,0x61,
0x6c,0x3b,0x20,0x74,0x65,0x78,0x74,0x2d,0x61,0x6c,0x69,0x67,0x6e,0x3a,0x20,0x63,
0x65,0x6e,0x74,0x65,0x72,0x3b,0x20,0x68,0x65,0x69,0x67,0x68,0x74,0x3a,0x20,0x32,
0x36,0x70,0x78,0x3b,0x20,0x77,0x69,0x64,0x74,0x68,0x3a,0x20,0x32,0x32,0x39,0x70,
0x78,0x3b,0x22,0x3e,0x3c,0x73,0x70,0x61,0x6e,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,
0x22,0x66,0x6f,0x6e,0x74,0x2d,0x73,0x69,0x7a,0x65,0x3a,0x20,0x31,0x30,0x70,0x74,
0x3b,0x20,0x66,0x6f,0x6e,0x74,0x2d,0x66,0x61,0x6d,0x69,0x6c,0x79,0x3a,0x20,0x56,
0x65,0x72,0x64,0x61,0x6e,0x61,0x3b,0x22,0x3e,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,
0x3d,0x22,0x2f,0x53,0x54,0x4d,0x33,0x32,0x49,0x50,0x43,0x41,0x4d,0x2e,0x68,0x74,
0x6d,0x6c,0x22,0x3e,0x3c,0x73,0x70,0x61,0x6e,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,
0x22,0x63,0x6f,0x6c,0x6f,0x72,0x3a,0x20,0x77,0x68,0x69,0x74,0x65,0x3b,0x22,0x3e,
0x3c,0x73,0x70,0x61,0x6e,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x66,0x6f,0x6e,
0x74,0x2d,0x77,0x65,0x69,0x67,0x68,0x74,0x3a,0x20,0x62,0x6f,0x6c,0x64,0x3b,0x20,
0x66,0x6f,0x6e,0x74,0x2d,0x73,0x74,0x79,0x6c,0x65,0x3a,0x20,0x69,0x74,0x61,0x6c,
0x69,0x63,0x3b,0x22,0x3e,0x49,0x50,0x20,0x43,0x41,0x4d,0x3c,0x2f,0x73,0x70,0x61,
0x6e,0x3e,0x3c,0x2f,0x73,0x70,0x61,0x6e,0x3e,0x3c,0x2f,0x61,0x3e,0x3c,0x2f,0x73,
0x70,0x61,0x6e,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x74,
0x72,0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x62,0x6f,0x64,0x79,0x3e,0x0d,0x0a,0x3c,0x2f,
0x74,0x61,0x62,0x6c,0x65,0x3e,0x0d,0x0a,0x3c,0x73,0x70,0x61,0x6e,0x20,0x73,0x74,
0x79,0x6c,0x65,0x3d,0x22,0x66,0x6f,0x6e,0x74,0x2d,0x77,0x65,0x69,0x67,0x68,0x74,
0x3a,0x20,0x62,0x6f,0x6c,0x64,0x3b,0x22,0x3e,0x3c,0x2f,0x73,0x70,0x61,0x6e,0x3e,
0x3c,0x73,0x6d,0x61,0x6c,0x6c,0x3e,0x3c,0x73,0x70,0x61,0x6e,0x20,0x73,0x74,0x79,
0x6c,0x65,0x3d,0x22,0x66,0x6f,0x6e,0x74,0x2d,0x66,0x61,0x6d,0x69,0x6c,0x79,0x3a,
0x20,0x56,0x65,0x72,0x64,0x61,0x6e,0x61,0x3b,0x22,0x3e,0x3c,0x62,0x72,0x3e,0x0d,
0x0a,0x54,0x68,0x69,0x73,0x0d,0x0a,0x70,0x61,0x67,0x65,0x20,0x61,0x6c,0x6c,0x6f,
0x77,0x73,0x20,0x79,0x6f,0x75,0x20,0x74,0x6f,0x20,0x67,0x65,0x74,0x20,0x64,0x79,
0x6e,0x61,0x6d,0x69,0x63,0x20,0x73,0x79,0x73,0x74,0x65,0x6d,0x20,0x69,0x6e,0x66,
0x6f,0x72,0x6d,0x61,0x74,0x69,0x6f,0x6e,0x20,0x61,0x62,0x6f,0x75,0x74,0x20,0x65,
0x61,0x63,0x68,0x20,0x52,0x54,0x4f,0x53,0x20,0x74,0x61,0x73,0x6b,0x0d,0x0a,0x69,
0x2e,0x65,0x2e,0x20,0x6e,0x61,0x6d,0x65,0x2c,0x20,0x73,0x74,0x61,0x74,0x75,0x73,
0x2c,0x20,0x70,0x72,0x69,0x6f,0x72,0x69,0x74,0x79,0x2c,0x20,0x73,0x74,0x61,0x63,
0x6b,0x20,0x6d,0x65,0x6d,0x6f,0x72,0x79,0x20,0x61,0x6e,0x64,0x20,0x6e,0x75,0x6d,
0x62,0x65,0x72,0x2e,0x3c,0x2f,0x73,0x70,0x61,0x6e,0x3e,0x3c,0x2f,0x73,0x6d,0x61,
0x6c,0x6c,0x3e,0x3c,0x73,0x6d,0x61,0x6c,0x6c,0x3e,0x3c,0x73,0x70,0x61,0x6e,0x20,
0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x66,0x6f,0x6e,0x74,0x2d,0x66,0x61,0x6d,0x69,
0x6c,0x79,0x3a,0x20,0x56,0x65,0x72,0x64,0x61,0x6e,0x61,0x3b,0x22,0x3e,0x3c,0x62,
0x72,0x3e,0x0d,0x0a,0x3c,0x62,0x72,0x3e,0x0d,0x0a,0x4e,0x75,0x6d,0x62,0x65,0x72,
0x20,0x6f,0x66,0x20,0x70,0x61,0x67,0x65,0x20,0x68,0x69,0x74,0x73,0x3a,0x20,0x0d,
0x0a,0x00};

static const unsigned char PAGE_START_DC[] = 
{
0x3c,0x21,0x44,0x4f,0x43,0x54,0x59,0x50,0x45,0x20,0x68,0x74,0x6d,0x6c,0x20,0x50,
0x55,0x42,0x4c,0x49,0x43,0x20,0x22,0x2d,0x2f,0x2f,0x57,0x33,0x43,0x2f,0x2f,0x44,
0x54,0x44,0x20,0x48,0x54,0x4d,0x4c,0x20,0x34,0x2e,0x30,0x31,0x2f,0x2f,0x45,0x4e,
0x22,0x20,0x22,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x77,0x77,0x77,0x2e,0x77,0x33,
0x2e,0x6f,0x72,0x67,0x2f,0x54,0x52,0x2f,0x68,0x74,0x6d,0x6c,0x34,0x2f,0x73,0x74,
0x72,0x69,0x63,0x74,0x2e,0x64,0x74,0x64,0x22,0x3e,0x0a,0x3c,0x68,0x74,0x6d,0x6c,
0x3e,0x3c,0x68,0x65,0x61,0x64,0x3e,0x3c,0x74,0x69,0x74,0x6c,0x65,0x3e,0x53,0x54,
0x4d,0x33,0x32,0x54,0x41,0x53,0x4b,0x53,0x44,0x43,0x3c,0x2f,0x74,0x69,0x74,0x6c,
0x65,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x6d,0x65,0x74,0x61,0x20,0x68,0x74,0x74,0x70,
0x2d,0x65,0x71,0x75,0x69,0x76,0x3d,0x22,0x43,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x2d,
0x54,0x79,0x70,0x65,0x22,0x20,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x3d,0x22,0x74,
0x65,0x78,0x74,0x2f,0x68,0x74,0x6d,0x6c,0x3b,0x20,0x63,0x68,0x61,0x72,0x73,0x65,
0x74,0x3d,0x77,0x69,0x6e,0x64,0x6f,0x77,0x73,0x2d,0x31,0x32,0x35,0x32,0x22,0x3e,
0x0d,0x0a,0x3c,0x6d,0x65,0x74,0x61,0x20,0x68,0x74,0x74,0x70,0x2d,0x65,0x71,0x75,
0x69,0x76,0x3d,0x22,0x72,0x65,0x66,0x72,0x65,0x73,0x68,0x22,0x20,0x63,0x6f,0x6e,
0x74,0x65,0x6e,0x74,0x3d,0x22,0x31,0x22,0x3e,0x0d,0x0a,0x3c,0x6d,0x65,0x74,0x61,
0x20,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x3d,0x22,0x4d,0x53,0x48,0x54,0x4d,0x4c,
0x20,0x36,0x2e,0x30,0x30,0x2e,0x32,0x38,0x30,0x30,0x2e,0x31,0x35,0x36,0x31,0x22,
0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x47,0x45,0x4e,0x45,0x52,0x41,0x54,0x4f,0x52,
0x22,0x3e,0x0d,0x0a,0x3c,0x73,0x74,0x79,0x6c,0x65,0x20,0x3d,0x22,0x66,0x6f,0x6e,
0x74,0x2d,0x77,0x65,0x69,0x67,0x68,0x74,0x3a,0x20,0x6e,0x6f,0x72,0x6d,0x61,0x6c,
0x3b,0x20,0x66,0x6f,0x6e,0x74,0x2d,0x66,0x61,0x6d,0x69,0x6c,0x79,0x3a,0x20,0x56,
0x65,0x72,0x64,0x61,0x6e,0x61,0x3b,0x22,0x3e,0x3c,0x2f,0x73,0x74,0x79,0x6c,0x65,
0x3e,0x3c,0x2f,0x68,0x65,0x61,0x64,0x3e,0x0d,0x0a,0x3c,0x62,0x6f,0x64,0x79,0x3e,
0x0d,0x0a,0x3c,0x68,0x34,0x3e,0x3c,0x73,0x6d,0x61,0x6c,0x6c,0x20,0x73,0x74,0x79,
0x6c,0x65,0x3d,0x22,0x66,0x6f,0x6e,0x74,0x2d,0x66,0x61,0x6d,0x69,0x6c,0x79,0x3a,
0x20,0x56,0x65,0x72,0x64,0x61,0x6e,0x61,0x3b,0x22,0x3e,0x3c,0x73,0x6d,0x61,0x6c,
0x6c,0x3e,0x3c,0x62,0x69,0x67,0x3e,0x3c,0x62,0x69,0x67,0x3e,0x3c,0x62,0x69,0x67,
0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x66,0x6f,0x6e,0x74,0x2d,0x77,0x65,0x69,
0x67,0x68,0x74,0x3a,0x20,0x62,0x6f,0x6c,0x64,0x3b,0x22,0x3e,0x3c,0x62,0x69,0x67,
0x3e,0x3c,0x73,0x74,0x72,0x6f,0x6e,0x67,0x3e,0x3c,0x65,0x6d,0x3e,0x3c,0x73,0x70,
0x61,0x6e,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x66,0x6f,0x6e,0x74,0x2d,0x73,
0x74,0x79,0x6c,0x65,0x3a,0x20,0x69,0x74,0x61,0x6c,0x69,0x63,0x3b,0x22,0x3e,0x53,
0x54,0x4d,0x33,0x32,0x20,0x4c,0x69,0x73,0x74,0x20,0x6f,0x66,0x20,0x72,0x75,0x6e,
0x6e,0x69,0x6e,0x67,0x20,0x74,0x61,0x73,0x6b,0x73,0x20,0x61,0x6e,0x64,0x0d,0x0a,
0x74,0x68,0x65,0x69,0x72,0x20,0x73,0x74,0x61,0x74,0x75,0x73,0x3c,0x2f,0x73,0x70,
0x61,0x6e,0x3e,0x3c,0x2f,0x65,0x6d,0x3e,0x3c,0x2f,0x73,0x74,0x72,0x6f,0x6e,0x67,
0x3e,0x3c,0x2f,0x62,0x69,0x67,0x3e,0x3c,0x2f,0x62,0x69,0x67,0x3e,0x3c,0x2f,0x62,
0x69,0x67,0x3e,0x3c,0x2f,0x62,0x69,0x67,0x3e,0x3c,0x2f,0x73,0x6d,0x61,0x6c,0x6c,
0x3e,0x3c,0x2f,0x73,0x6d,0x61,0x6c,0x6c,0x3e,0x3c,0x2f,0x68,0x34,0x3e,0x0d,0x0a,
0x3c,0x68,0x72,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x77,0x69,0x64,0x74,0x68,
0x3a,0x20,0x31,0x30,0x30,0x25,0x3b,0x20,0x68,0x65,0x69,0x67,0x68,0x74,0x3a,0x20,
0x32,0x70,0x78,0x3b,0x22,0x3e,0x3c,0x73,0x70,0x61,0x6e,0x20,0x73,0x74,0x79,0x6c,
0x65,0x3d,0x22,0x66,0x6f,0x6e,0x74,0x2d,0x77,0x65,0x69,0x67,0x68,0x74,0x3a,0x20,
0x62,0x6f,0x6c,0x64,0x3b,0x22,0x3e,0x3c,0x2f,0x73,0x70,0x61,0x6e,0x3e,0x3c,0x73,
0x70,0x61,0x6e,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x66,0x6f,0x6e,0x74,0x2d,
0x77,0x65,0x69,0x67,0x68,0x74,0x3a,0x20,0x62,0x6f,0x6c,0x64,0x3b,0x22,0x3e,0x3c,
0x2f,0x73,0x70,0x61,0x6e,0x3e,0x0d,0x0a,0x3c,0x74,0x61,0x62,0x6c,0x65,0x20,0x63,
0x6c,0x61,0x73,0x73,0x3d,0x22,0x4d,0x73,0x6f,0x4e,0x6f,0x72,0x6d,0x61,0x6c,0x54,
0x61,0x62,0x6c,0x65,0x22,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x77,0x69,0x64,
0x74,0x68,0x3a,0x20,0x39,0x31,0x36,0x70,0x78,0x3b,0x20,0x68,0x65,0x69,0x67,0x68,
0x74,0x3a,0x20,0x32,0x38,0x70,0x78,0x3b,0x22,0x20,0x62,0x6f,0x72,0x64,0x65,0x72,
0x3d,0x22,0x31,0x22,0x20,0x63,0x65,0x6c,0x6c,0x70,0x61,0x64,0x64,0x69,0x6e,0x67,
0x3d,0x22,0x30,0x22,0x3e,0x0d,0x0a,0x3c,0x74,0x62,0x6f,0x64,0x79,0x3e,0x0d,0x0a,
0x3c,0x74,0x72,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x22,0x3e,0x0d,0x0a,0x3c,
0x74,0x64,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x70,0x61,0x64,0x64,0x69,0x6e,
0x67,0x3a,0x20,0x31,0x2e,0x35,0x70,0x74,0x3b,0x20,0x62,0x61,0x63,0x6b,0x67,0x72,
0x6f,0x75,0x6e,0x64,0x3a,0x20,0x72,0x67,0x62,0x28,0x35,0x31,0x2c,0x20,0x35,0x31,
0x2c,0x20,0x32,0x35,0x35,0x29,0x20,0x6e,0x6f,0x6e,0x65,0x20,0x72,0x65,0x70,0x65,
0x61,0x74,0x20,0x73,0x63,0x72,0x6f,0x6c,0x6c,0x20,0x30,0x25,0x20,0x35,0x30,0x25,
0x3b,0x20,0x2d,0x6d,0x6f,0x7a,0x2d,0x62,0x61,0x63,0x6b,0x67,0x72,0x6f,0x75,0x6e,
0x64,0x2d,0x63,0x6c,0x69,0x70,0x3a,0x20,0x69,0x6e,0x69,0x74,0x69,0x61,0x6c,0x3b,
0x20,0x2d,0x6d,0x6f,0x7a,0x2d,0x62,0x61,0x63,0x6b,0x67,0x72,0x6f,0x75,0x6e,0x64,
0x2d,0x6f,0x72,0x69,0x67,0x69,0x6e,0x3a,0x20,0x69,0x6e,0x69,0x74,0x69,0x61,0x6c,
0x3b,0x20,0x2d,0x6d,0x6f,0x7a,0x2d,0x62,0x61,0x63,0x6b,0x67,0x72,0x6f,0x75,0x6e,
0x64,0x2d,0x69,0x6e,0x6c,0x69,0x6e,0x65,0x2d,0x70,0x6f,0x6c,0x69,0x63,0x79,0x3a,
0x20,0x69,0x6e,0x69,0x74,0x69,0x61,0x6c,0x3b,0x20,0x74,0x65,0x78,0x74,0x2d,0x61,
0x6c,0x69,0x67,0x6e,0x3a,0x20,0x63,0x65,0x6e,0x74,0x65,0x72,0x3b,0x20,0x68,0x65,
0x69,0x67,0x68,0x74,0x3a,0x20,0x32,0x36,0x70,0x78,0x3b,0x20,0x77,0x69,0x64,0x74,
0x68,0x3a,0x20,0x32,0x32,0x39,0x70,0x78,0x3b,0x22,0x3e,0x3c,0x73,0x70,0x61,0x6e,
0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x66,0x6f,0x6e,0x74,0x2d,0x73,0x69,0x7a,
0x65,0x3a,0x20,0x31,0x30,0x70,0x74,0x3b,0x20,0x66,0x6f,0x6e,0x74,0x2d,0x66,0x61,
0x6d,0x69,0x6c,0x79,0x3a,0x20,0x56,0x65,0x72,0x64,0x61,0x6e,0x61,0x3b,0x20,0x66,
0x6f,0x6e,0x74,0x2d,0x73,0x74,0x79,0x6c,0x65,0x3a,0x20,0x69,0x74,0x61,0x6c,0x69,
0x63,0x3b,0x20,0x66,0x6f,0x6e,0x74,0x2d,0x77,0x65,0x69,0x67,0x68,0x74,0x3a,0x20,
0x62,0x6f,0x6c,0x64,0x3b,0x22,0x3e,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,
0x2f,0x53,0x54,0x4d,0x33,0x32,0x44,0x43,0x2e,0x68,0x74,0x6d,0x6c,0x22,0x3e,0x3c,
0x73,0x70,0x61,0x6e,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x63,0x6f,0x6c,0x6f,
0x72,0x3a,0x20,0x77,0x68,0x69,0x74,0x65,0x3b,0x22,0x3e,0x44,0x69,0x73,0x74,0x61,
0x6e,0x74,0x20,0x43,0x6f,0x6e,0x74,0x72,0x6f,0x6c,0x3c,0x2f,0x73,0x70,0x61,0x6e,
0x3e,0x3c,0x2f,0x61,0x3e,0x3c,0x2f,0x73,0x70,0x61,0x6e,0x3e,0x0d,0x0a,0x3c,0x2f,
0x74,0x64,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,
0x70,0x61,0x64,0x64,0x69,0x6e,0x67,0x3a,0x20,0x31,0x2e,0x35,0x70,0x74,0x3b,0x20,
0x62,0x61,0x63,0x6b,0x67,0x72,0x6f,0x75,0x6e,0x64,0x3a,0x20,0x72,0x67,0x62,0x28,
0x35,0x31,0x2c,0x20,0x35,0x31,0x2c,0x20,0x32,0x35,0x35,0x29,0x20,0x6e,0x6f,0x6e,
0x65,0x20,0x72,0x65,0x70,0x65,0x61,0x74,0x20,0x73,0x63,0x72,0x6f,0x6c,0x6c,0x20,
0x30,0x25,0x20,0x35,0x30,0x25,0x3b,0x20,0x2d,0x6d,0x6f,0x7a,0x2d,0x62,0x61,0x63,
0x6b,0x67,0x72,0x6f,0x75,0x6e,0x64,0x2d,0x63,0x6c,0x69,0x70,0x3a,0x20,0x69,0x6e,
0x69,0x74,0x69,0x61,0x6c,0x3b,0x20,0x2d,0x6d,0x6f,0x7a,0x2d,0x62,0x61,0x63,0x6b,
0x67,0x72,0x6f,0x75,0x6e,0x64,0x2d,0x6f,0x72,0x69,0x67,0x69,0x6e,0x3a,0x20,0x69,
0x6e,0x69,0x74,0x69,0x61,0x6c,0x3b,0x20,0x2d,0x6d,0x6f,0x7a,0x2d,0x62,0x61,0x63,
0x6b,0x67,0x72,0x6f,0x75,0x6e,0x64,0x2d,0x69,0x6e,0x6c,0x69,0x6e,0x65,0x2d,0x70,
0x6f,0x6c,0x69,0x63,0x79,0x3a,0x20,0x69,0x6e,0x69,0x74,0x69,0x61,0x6c,0x3b,0x20,
0x74,0x65,0x78,0x74,0x2d,0x61,0x6c,0x69,0x67,0x6e,0x3a,0x20,0x63,0x65,0x6e,0x74,
0x65,0x72,0x3b,0x20,0x68,0x65,0x69,0x67,0x68,0x74,0x3a,0x20,0x32,0x36,0x70,0x78,
0x3b,0x20,0x77,0x69,0x64,0x74,0x68,0x3a,0x20,0x32,0x32,0x39,0x70,0x78,0x3b,0x22,
0x3e,0x3c,0x62,0x3e,0x3c,0x69,0x3e,0x3c,0x73,0x70,0x61,0x6e,0x20,0x73,0x74,0x79,
0x6c,0x65,0x3d,0x22,0x66,0x6f,0x6e,0x74,0x2d,0x73,0x69,0x7a,0x65,0x3a,0x20,0x31,
0x30,0x70,0x74,0x3b,0x20,0x66,0x6f,0x6e,0x74,0x2d,0x66,0x61,0x6d,0x69,0x6c,0x79,
0x3a,0x20,0x56,0x65,0x72,0x64,0x61,0x6e,0x61,0x3b,0x22,0x3e,0x3c,0x73,0x70,0x61,
0x6e,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x63,0x6f,0x6c,0x6f,0x72,0x3a,0x20,
0x77,0x68,0x69,0x74,0x65,0x3b,0x22,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x52,0x75,
0x6e,0x6e,0x69,0x6e,0x67,0x20,0x54,0x61,0x73,0x6b,0x73,0x3c,0x2f,0x73,0x70,0x61,
0x6e,0x3e,0x3c,0x2f,0x73,0x70,0x61,0x6e,0x3e,0x3c,0x2f,0x69,0x3e,0x3c,0x2f,0x62,
0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x0d,0x0a,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x74,0x72,
0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x62,0x6f,0x64,0x79,0x3e,0x0d,0x0a,0x3c,0x2f,0x74,
0x61,0x62,0x6c,0x65,0x3e,0x0d,0x0a,0x3c,0x73,0x70,0x61,0x6e,0x20,0x73,0x74,0x79,
0x6c,0x65,0x3d,0x22,0x66,0x6f,0x6e,0x74,0x2d,0x77,0x65,0x69,0x67,0x68,0x74,0x3a,
0x20,0x62,0x6f,0x6c,0x64,0x3b,0x22,0x3e,0x3c,0x2f,0x73,0x70,0x61,0x6e,0x3e,0x3c,
0x73,0x6d,0x61,0x6c,0x6c,0x3e,0x3c,0x73,0x70,0x61,0x6e,0x20,0x73,0x74,0x79,0x6c,
0x65,0x3d,0x22,0x66,0x6f,0x6e,0x74,0x2d,0x66,0x61,0x6d,0x69,0x6c,0x79,0x3a,0x20,
0x56,0x65,0x72,0x64,0x61,0x6e,0x61,0x3b,0x22,0x3e,0x3c,0x62,0x72,0x3e,0x0d,0x0a,
0x54,0x68,0x69,0x73,0x0d,0x0a,0x70,0x61,0x67,0x65,0x20,0x61,0x6c,0x6c,0x6f,0x77,
0x73,0x20,0x79,0x6f,0x75,0x20,0x74,0x6f,0x20,0x67,0x65,0x74,0x20,0x64,0x79,0x6e,
0x61,0x6d,0x69,0x63,0x20,0x73,0x79,0x73,0x74,0x65,0x6d,0x20,0x69,0x6e,0x66,0x6f,
0x72,0x6d,0x61,0x74,0x69,0x6f,0x6e,0x20,0x61,0x62,0x6f,0x75,0x74,0x20,0x65,0x61,
0x63,0x68,0x20,0x52,0x54,0x4f,0x53,0x20,0x74,0x61,0x73,0x6b,0x0d,0x0a,0x69,0x2e,
0x65,0x2e,0x20,0x6e,0x61,0x6d,0x65,0x2c,0x20,0x73,0x74,0x61,0x74,0x75,0x73,0x2c,
0x20,0x70,0x72,0x69,0x6f,0x72,0x69,0x74,0x79,0x2c,0x20,0x73,0x74,0x61,0x63,0x6b,
0x20,0x6d,0x65,0x6d,0x6f,0x72,0x79,0x20,0x61,0x6e,0x64,0x20,0x6e,0x75,0x6d,0x62,
0x65,0x72,0x2e,0x3c,0x2f,0x73,0x70,0x61,0x6e,0x3e,0x3c,0x2f,0x73,0x6d,0x61,0x6c,
0x6c,0x3e,0x3c,0x73,0x6d,0x61,0x6c,0x6c,0x3e,0x3c,0x73,0x70,0x61,0x6e,0x20,0x73,
0x74,0x79,0x6c,0x65,0x3d,0x22,0x66,0x6f,0x6e,0x74,0x2d,0x66,0x61,0x6d,0x69,0x6c,
0x79,0x3a,0x20,0x56,0x65,0x72,0x64,0x61,0x6e,0x61,0x3b,0x22,0x3e,0x3c,0x62,0x72,
0x3e,0x0d,0x0a,0x3c,0x62,0x72,0x3e,0x0d,0x0a,0x4e,0x75,0x6d,0x62,0x65,0x72,0x20,
0x6f,0x66,0x20,0x70,0x61,0x67,0x65,0x20,0x68,0x69,0x74,0x73,0x3a,0x20,0x0d,0x0a,
0x00};

/***************************** IPCAM variables ********************************/
const uint8_t QQVGAImageHeader[ ] =
{
  /* HTTP header */
  0x48, 0x54, 0x54, 0x50, 0x2F, 0x31, 0x2E, 0x30, 0x20,                   /* HTTP/1.0 */ 
  0x32, 0x30, 0x30, 0x20, 0x4F, 0x4B, 0x0D, 0x0A,                         /* 200 OK\r\n */
  0x43, 0x6F, 0x6E, 0x74, 0x65, 0x6E, 0x74, 0x20,                         /* Content */
  0x54, 0x79, 0x70, 0x65, 0x3A, 0x20,                                     /* Type */
  0x69, 0x6D, 0x61, 0x67, 0x65, 0x2F, 0x62, 0x6D, 0x70, 0x0D, 0x0A,       /* image/bmp\r\n */
  0x43, 0x61, 0x63, 0x68, 0x65, 0x2D,                                     /* cache- */
  0x43, 0x6F, 0x6E, 0x74, 0x72, 0x6F, 0x6C, 0x3A, 0x20,                   /* Control: */
  0x6E, 0x6F, 0x2D, 0x63, 0x61, 0x63, 0x68, 0x65, 0x0D, 0x0A,             /* no-cache\r\n */
  0x45, 0x78, 0x70, 0x69, 0x72, 0x65, 0x73, 0x3A, 0x20, 0x30, 0x0D, 0x0A, /* Expires: 0\r\n */
  0x43, 0x6F, 0x6E, 0x74, 0x65, 0x6E, 0x74, 0x2D,                         /* Content- */
  0x4C, 0x65, 0x6E, 0x67, 0x74, 0x68, 0x3A, 0x20, 0x20,                   /* Length: */
  0x35, 0x37, 0x36, 0x30, 0x30,                                           /* 57 600 */
  0x0D, 0x0A, 0x0D, 0x0A,                                                 /* End */

  /* Image BMP header */
  0x42, 0x4D,              /* Offet0: BMP Magic Number */
  0x36, 0xE1, 0x00, 0x00,  /* Offset2 : filesz : Size of the BMP file 120*160*3 + 54 */
  0x00, 0x00, 0x00, 0x00,  /* Offset6, Offset8 : Reserved0, Reserved1 =0 */
  0x36, 0x00, 0x00, 0x00,  /* Offset10 : bmp_offset: Offset of bitmap data (pixels)  = 54 = 0x36 */
  0x28, 0x00, 0x00, 0x00,  /* Offset14 : header_sz : The number of bytes in the header (from this point) */
  0xA0, 0x00, 0x00, 0x00,  /* Offset18 : width 160 */
  0x78, 0x00, 0x00, 0x00,  /* Offset2 : height 120 */
  0x01, 0x00,              /* Offset26 : nplanes */
  0x18, 0x00,              /* Offset24: Bits per Pixels */
  0x00, 0x00, 0x00, 0x00,  /* Offset30: compress_type = 0  */
  0x00, 0x58, 0x02, 0x00,  /* Offset34 : bmp bytes size*/
  0x00, 0x00, 0x00, 0x00,  /* Offset38 : X Resolution : Pixel per meters = 0 */
  0x00, 0x00, 0x00, 0x00,  /* Offset42 : Y Resolution : Pixel per meters */
  0x00, 0x00, 0x00, 0x00,  /* Offset46 : Number of Colours = 0 */
  0x00, 0x00, 0x00, 0x00,  /* Offset50 : Important Colours = 0 */
};

const uint8_t QVGAImageHeader[ ] =
{
  /* HTTP header */
  0x48, 0x54, 0x54, 0x50, 0x2F, 0x31, 0x2E, 0x30, 0x20,                   /* HTTP/1.0 */ 
  0x32, 0x30, 0x30, 0x20, 0x4F, 0x4B, 0x0D, 0x0A,                         /* 200 OK\r\n */
  0x43, 0x6F, 0x6E, 0x74, 0x65, 0x6E, 0x74, 0x20,                         /* Content */
  0x54, 0x79, 0x70, 0x65, 0x3A, 0x20,                                     /* Type */
  0x69, 0x6D, 0x61, 0x67, 0x65, 0x2F, 0x62, 0x6D, 0x70, 0x0D, 0x0A,       /* image/bmp\r\n */
  0x43, 0x61, 0x63, 0x68, 0x65, 0x2D,                                     /* cache- */
  0x43, 0x6F, 0x6E, 0x74, 0x72, 0x6F, 0x6C, 0x3A, 0x20,                   /* Control: */
  0x6E, 0x6F, 0x2D, 0x63, 0x61, 0x63, 0x68, 0x65, 0x0D, 0x0A,             /* no-cache\r\n */
  0x45, 0x78, 0x70, 0x69, 0x72, 0x65, 0x73, 0x3A, 0x20, 0x30, 0x0D, 0x0A, /* Expires: 0\r\n */
  0x43, 0x6F, 0x6E, 0x74, 0x65, 0x6E, 0x74, 0x2D,                         /* Content- */
  0x4C, 0x65, 0x6E, 0x67, 0x74, 0x68, 0x3A, 0x20, 0x20,                   /* Length: */
  0x32, 0x33, 0x30, 0x34, 0x30, 0x30,                                     /* 230 400 */
  0x0D, 0x0A, 0x0D, 0x0A,                                                 /* End */

  /* Image BMP header */
  0x42, 0x4D,              /* Offet0: BMP Magic Number */
  0x36, 0x84, 0x03, 0x00,  /* Offset2 : filesz : Size of the BMP file 240*320*3 + 54 */
  0x00, 0x00, 0x00, 0x00,  /* Offset6, Offset8 : Reserved0, Reserved1 =0 */
  0x36, 0x00, 0x00, 0x00,  /* Offset10 : bmp_offset: Offset of bitmap data (pixels)  = 54 = 0x36 */
  0x28, 0x00, 0x00, 0x00,  /* Offset14 : header_sz : The number of bytes in the header (from this point) */
  0x40, 0x01, 0x00, 0x00,  /* Offset18 : width 320 */
  0xF0, 0x00, 0x00, 0x00,  /* Offset2 : height 240 */
  0x01, 0x00,              /* Offset26 : nplanes */
  0x18, 0x00,              /* Offset24: Bits per Pixels */
  0x00, 0x00, 0x00, 0x00,  /* Offset30: compress_type = 0  */
  0x00, 0x96, 0x00, 0x00,  /* Offset34 : bmp bytes size*/
  0x00, 0x00, 0x00, 0x00,  /* Offset38 : X Resolution : Pixel per meters = 0 */
  0x00, 0x00, 0x00, 0x00,  /* Offset42 : Y Resolution : Pixel per meters */
  0x00, 0x00, 0x00, 0x00,  /* Offset46 : Number of Colours = 0 */
  0x00, 0x00, 0x00, 0x00,  /* Offset50 : Important Colours = 0 */
};

extern void eth_Camera_Config(void);
extern void ETHERNET_UpdateCameraInit (void);

IPCAM_ImageBuffer_TypeDef IPCAM_ImageBuffer;
OV9655_IDTypeDef OV9655_Camera_ID;
OV2640_IDTypeDef OV2640_Camera_ID;
SYSTEM_CONFIG_TypeDef DC_Global_Config;
/* Private function prototypes -----------------------------------------------*/
static void DynWebPage(struct netconn *conn);
static void http_ipcam_serve(struct netconn *conn);
static void http_ipcam_thread(void *arg);
static void IPCAM_PrepareImage(void);
static void IPCAM_RGB16toRGB24(void);
static void IPCAM_CaptureNextImage(void);

/* Private functions ---------------------------------------------------------*/

/*******************************************************************************
                            Web Server Section 
*******************************************************************************/
/**
  * @brief serve tcp connection  
  * @param conn: pointer on connection structure 
  * @retval None
  */
static void http_ipcam_serve(struct netconn *conn)
{
  struct netbuf *inbuf;
  char* buf;
  uint16_t buflen;
  uint16_t index;
  struct fs_file * file;
  static  uint32_t RequestIndex = 0;


 /* Read the data from the port, blocking if nothing yet there. 
   We assume the request (the part we care about) is in one netbuf */
  inbuf = netconn_recv(conn);

  if (inbuf != NULL)
  {
    if (netconn_err(conn) == ERR_OK)
    {
      netbuf_data(inbuf, (void**)&buf, &buflen);

      /* Is this an HTTP GET command? (only check the first 5 chars, since
      there are other formats for GET, and we're keeping it very simple )*/
      if ((buflen >=5) && (strncmp(buf, "GET /", 5) == 0))
      {
        if((Global_Config.b.DistantControlEnabled != 0) && \
           (Global_Config.b.BackgroundModeEnabled != 0) && \
           (EthernetSettings.DistantControlEnabled == 1))
        {
          if (strncmp(buf, "GET /cmds", 9) == 0)
          {
            index = 9;
            DC_Global_Config.d32 = 0;

            while(buf[index] != 0x20) /* */
            {
              index++; 
              if (buf[index] == 0x63) /* c */
              {
                index++;
                if (buf[index] ==  0x6d) /* m */
                {
                  index++;
                  if (buf[index] ==  0x64) /* d*/
                  {
                    index+=2;

                    if(buf[index]==0x31) /* 1: Distant Control Cmd */
                    {
                      DC_Global_Config.b.DistantControlEnabled = 1;
                    }
                    if(buf[index]==0x32) /* 2: Background Mode Cmd */
                    {
                      DC_Global_Config.b.BackgroundModeEnabled = 1;
                    }
                    if(buf[index]==0x33) /* 3: Low Power Mode Cmd */
                    {
                      DC_Global_Config.b.LowPowerModeEnabled = 1;
                    }
                    if(buf[index]==0x34) /* 4: LCD Power Saving Cmd */
                    {
                      DC_Global_Config.b.LCDPowerSavingEnabled = 1;
                    }
                  }
                }
              }
            }
            if(Global_Config.b.LCDPowerSavingEnabled != DC_Global_Config.b.LCDPowerSavingEnabled)
            {
              Global_Config.b.LCDPowerSavingEnabled = DC_Global_Config.b.LCDPowerSavingEnabled;
              MOD_SetParam(GLOBAL_SETTINGS_MEM , &Global_Config.d32);
              Global_Config.b.Configuration_Changed = 1;
              SYSTEM_RefreshSetting();
            }

            if(DC_Global_Config.b.DistantControlEnabled == 0)
            {
              EthernetSettings.DisableDControlLater = 1;
            }

            if(DC_Global_Config.b.BackgroundModeEnabled == 0)
            {
              EthernetSettings.DisableBackgroundLater = 1;
            }

            /* Open the STM32DC.html */
            file = fs_open("/STM32DC.html");
            netconn_write(conn, (const unsigned char*)(file->data), (size_t)file->len, NETCONN_NOCOPY);
            fs_close(file);
          }
          /* Check if request to get ST logo.jpg */
          else if (strncmp((char const *)buf, "GET /STM32_files/logo.jpg", 25) == 0)
          {
            file = fs_open("/STM32_files/logo.jpg");
            netconn_write(conn, (const unsigned char*)(file->data), (size_t)file->len, NETCONN_NOCOPY);
            fs_close(file);
          }
          /* Check if request to get STM32TASKS.html */
          else if((strncmp(buf, "GET /STM32TASKS.html", 20) == 0)||(strncmp(buf, "GET /STM32TASKSDC.html", 22) == 0))
          {
            /* Load dynamic page */
            DynWebPage(conn);
          }
          /* Check if request to get STM32DC.html */
          else if((strncmp(buf, "GET /STM32DC.html", 17) == 0) || (strncmp(buf, "GET / ", 6) == 0))
          {
            file = fs_open("/STM32DC.html");
            netconn_write(conn, (const unsigned char*)(file->data), (size_t)file->len, NETCONN_NOCOPY);
            fs_close(file);
          }
          /* Load Error page */
          else
          {
            file = fs_open("/404.html");
            netconn_write(conn, (const unsigned char*)(file->data), (size_t)file->len, NETCONN_NOCOPY);
            fs_close(file);
          }
        }
        else
        {
          if ((strncmp((char const *)buf, "GET /STM32_files/CamImage.bmp", 29)==0)||(strncmp(buf, "GET /CamImage.bmp", 17) == 0))
          {
            if(IPCAM_ImageBuffer.BufferStatus == BUFFER_FILLED)
            {
              /* Prepare the received image for transfer */
              IPCAM_PrepareImage();
              netconn_write(conn, (const unsigned char*)(IPCAM_ImageBuffer.ImageHeader), (size_t)IPCAM_ImageBuffer.ImageHeaderLen, NETCONN_NOCOPY);
              netconn_write(conn, (const unsigned char*)IPCAM_ImageBuffer.ImageData, IPCAM_ImageBuffer.MaxImageLen, NETCONN_NOCOPY);

              /* Start new image capture */
              IPCAM_CaptureNextImage();
              RequestIndex = 0;
            }
            else
            {
              RequestIndex++;
              if(RequestIndex == 10)
              {
                RequestIndex = 0;
                file = fs_open("/STM32F4x7_files/Error.jpg");
                netconn_write(conn, (const unsigned char*)(file->data), (size_t)file->len, NETCONN_NOCOPY);
                fs_close(file);
              }
              /* Start new image capture */
              IPCAM_CaptureNextImage();
              netconn_close(conn);
              netbuf_delete(inbuf);
            }
          }
          /* Check if request to get ST.gif */ 
          else if (strncmp((char const *)buf, "GET /STM32_files/ST.gif", 23)==0)
          {
            file = fs_open("/STM32_files/ST.gif"); 
            netconn_write(conn, (const unsigned char*)(file->data), (size_t)file->len, NETCONN_NOCOPY);
            fs_close(file);
          }
          /* Check if request to get stm32f4.jpeg */
          else if (strncmp((char const *)buf, "GET /STM32_files/stm32f4.jpg", 28)==0)
          {
            file = fs_open("/STM32_files/stm32f4.jpg"); 
            netconn_write(conn, (const unsigned char*)(file->data), (size_t)file->len, NETCONN_NOCOPY);
            fs_close(file);
          }
          /* Check if request to get stm32f2.jpeg */
          else if (strncmp((char const *)buf, "GET /STM32_files/stm32f2.jpg", 28)==0)
          {
            file = fs_open("/STM32_files/stm32f2.jpg");
            netconn_write(conn, (const unsigned char*)(file->data), (size_t)file->len, NETCONN_NOCOPY);
            fs_close(file);
          }
          /* Check if request to get ST logo.jpg */
          else if (strncmp((char const *)buf, "GET /STM32_files/logo.jpg", 25) == 0)
          {
            file = fs_open("/STM32_files/logo.jpg"); 
            netconn_write(conn, (const unsigned char*)(file->data), (size_t)file->len, NETCONN_NOCOPY);
            fs_close(file);
          }
          /* Check if request to get STM32TASKS.html */
          else if((strncmp(buf, "GET /STM32TASKS.html", 20) == 0)||(strncmp(buf, "GET /STM32TASKSDC.html", 22) == 0))
          {
            /* Load dynamic page */
            DynWebPage(conn);
          }
          /* Check if request to get STM32IPCAM.html */
          else if(strncmp(buf, "GET /STM32IPCAM.html", 20) == 0)
          {
            file = fs_open("/STM32IPCAM.html");
            netconn_write(conn, (const unsigned char*)(file->data), (size_t)file->len, NETCONN_NOCOPY);
            fs_close(file);
          }
          /* Check if request to get STM32F4x7.html */
          else if((strncmp(buf, "GET /index.html", 15) == 0)||(strncmp(buf, "GET / ", 6) == 0))
          {
            #if defined (STM32F2XX)
             file = fs_open("/STM32F2x7.html");
            #elif defined (STM32F4XX)
             file = fs_open("/STM32F4x7.html");
            #endif
            netconn_write(conn, (const unsigned char*)(file->data), (size_t)file->len, NETCONN_NOCOPY);
            fs_close(file);
          }
          /* Load Error page */
          else
          {
            file = fs_open("/404.html");
            netconn_write(conn, (const unsigned char*)(file->data), (size_t)file->len, NETCONN_NOCOPY);
            fs_close(file);
          }
        }
      }
    }
  }
  netconn_close(conn);
  netconn_delete(conn);
  netbuf_delete(inbuf);
}

/**
  * @brief  http server thread
  * @param arg: pointer on argument(not used here)
  * @retval None
  */
static void http_ipcam_thread(void *arg)
{
//  struct netconn *conn, *newconn;
  static __IO uint8_t connflag = 0;

  if(connflag == 0)
  {
    /* Create a new TCP connection handle */
    conn = netconn_new(NETCONN_TCP);

    /* Bind to port 80 (HTTP) with default IP address */
    netconn_bind(conn, NULL, 80);

    /* Put the connection into LISTEN state */
    netconn_listen(conn);
    connflag = 1;
  }
  /* Infinite loop */
  for ( ;;)
  {
    /* Accept any icoming connection */
    newconn = netconn_accept(conn);

    if(newconn != NULL)
    {
      /* Serve the icoming connection */
      http_ipcam_serve(newconn);
    }
  }
}

/**
  * @brief  Initialize the HTTP server (start its thread) 
  * @param  None
  * @retval None
  */
void http_init()
{
  nPageHits = 0;
  if(HTTP_Task_Handle == NULL)
  {
    HTTP_Task_Handle = sys_thread_new("HTTP", http_ipcam_thread, NULL, HTTP_THREAD_STACK_SIZE, HTTP_THREAD_PRIO);
  }
}

/**
  * @brief  Create and send a dynamic Web Page. This page contains the list of
  *         running tasks and the number of page hits. 
  * @param  conn pointer on connection structure 
  * @retval None
  */
static void DynWebPage(struct netconn *conn)
{
  portCHAR PAGE_BODY[800];
  portCHAR pagehits[10] = {0};

  memset(PAGE_BODY, 0,512);

  /* Update the hit count */
  nPageHits++;
  sprintf(pagehits, "%d", (int)nPageHits);
  strcat(PAGE_BODY, pagehits);
  strcat((char *)PAGE_BODY, "<pre><br>Name          State  Priority  Stack   Num" );
  strcat((char *)PAGE_BODY, "<br>---------------------------------------------<br>");

  /* The list of tasks and their status */
  vTaskList((signed char *)PAGE_BODY + strlen(PAGE_BODY));
  strcat((char *)PAGE_BODY, "<br><br>---------------------------------------------");
  strcat((char *)PAGE_BODY, "<br>B : Blocked, R : Ready, D : Deleted, S : Suspended<br>");

  /* Send the dynamically generated page */
  if((Global_Config.b.DistantControlEnabled != 0) && \
     (Global_Config.b.BackgroundModeEnabled != 0) && \
     (EthernetSettings.DistantControlEnabled == 1))
  {
    netconn_write(conn, PAGE_START_DC, strlen((char*)PAGE_START_DC), NETCONN_COPY);
  }
  else
  {
    netconn_write(conn, PAGE_START, strlen((char*)PAGE_START), NETCONN_COPY);
  }
  netconn_write(conn, PAGE_BODY, strlen(PAGE_BODY), NETCONN_COPY);
}

/*******************************************************************************
                            IPCAM Section 
*******************************************************************************/
/**
  * @brief  Initialize image capture process (start its thread) 
  * @param  None
  * @retval None
  */
void IPCAM_ImageCaptureInit(void)
{
  /* Initializes the DCMI interface (I2C and GPIO) used to configure the camera */
  OV2640_HW_Init();

  /* Read the OV9655/OV2640 Manufacturer identifier */
  OV9655_ReadID(&OV9655_Camera_ID);
  OV2640_ReadID(&OV2640_Camera_ID);

  if(OV9655_Camera_ID.PID  == 0x96)
  {
    IPCAM_ImageBuffer.Camera = OV9655_CAMERA;
  }
  else if(OV2640_Camera_ID.PIDH  == 0x26)
  {
    IPCAM_ImageBuffer.Camera = OV2640_CAMERA;
  }
  else
  {
    ETHERNET_UpdateCameraInit();
    return;
  }

  if (IPCAM_ImageBuffer.ImageFormat == BMP_QQVGA)
  {
    /* Initialize the camera structure */
    IPCAM_ImageBuffer.ImageHeaderLen = 159;
    IPCAM_ImageBuffer.ImageHeader = (uint8_t*)QQVGAImageHeader;
    IPCAM_ImageBuffer.ImageLen = (160*120*2);
    IPCAM_ImageBuffer.MaxImageLen = (160*120*3);
    IPCAM_ImageBuffer.ImageData = (uint8_t*)FSMC_SRAM_ADDRESS;
    IPCAM_ImageBuffer.BufferStatus = BUFFER_EMPTY;
  }
  else if (IPCAM_ImageBuffer.ImageFormat == BMP_QVGA)
  {
    /* Initialize the camera structure */
    IPCAM_ImageBuffer.ImageHeaderLen = 160;
    IPCAM_ImageBuffer.ImageHeader = (uint8_t*)QVGAImageHeader;
    IPCAM_ImageBuffer.ImageLen = (320*240*2);
    IPCAM_ImageBuffer.MaxImageLen = (320*240*3);
    IPCAM_ImageBuffer.ImageData = (uint8_t*)FSMC_SRAM_ADDRESS;
    IPCAM_ImageBuffer.BufferStatus = BUFFER_EMPTY;
  }

  /* Configure camera module mounted on STM322xG-EVAL board */
  eth_Camera_Config();

  /* Clears the DCMI's and DMA's pending bits */
  DCMI_ClearITPendingBit(DCMI_IT_FRAME | DCMI_IT_OVF);
  DMA_ClearITPendingBit(DMA2_Stream1, DMA_IT_TCIF1 | DMA_IT_TEIF1);

  /* Enable DMA2 stream 1 and DCMI interface then start image capture */
  DMA_Cmd(DMA2_Stream1, ENABLE);
  DCMI_Cmd(ENABLE);
  DCMI_CaptureCmd(ENABLE);
}

/**
  * @brief  Provide the Filled Image to HTTP Layer.
  * @param  none
  * @retval none
*/
static void IPCAM_PrepareImage(void)
{
  uint32_t index;
  uint8_t temp;

  for (index = 0; index < (IPCAM_ImageBuffer.ImageLen)/2; index++)
  {
    temp = IPCAM_ImageBuffer.ImageData[index];
    IPCAM_ImageBuffer.ImageData[index] = IPCAM_ImageBuffer.ImageData[IPCAM_ImageBuffer.ImageLen - index];
    IPCAM_ImageBuffer.ImageData[IPCAM_ImageBuffer.ImageLen - index] = temp;
  }

  /* Convert RGB16 image to RGB24 format */
  IPCAM_RGB16toRGB24();
}

/**
  * @brief  Enable the DMA and DCMI interface to capture new image
  * @param  None
  * @retval None
  */
static void IPCAM_CaptureNextImage(void)
{
  /* Mark Image buffer as empty */
  IPCAM_ImageBuffer.BufferStatus = BUFFER_EMPTY;

  /* Clears the DCMI's and DMA's pending bits */
  DCMI_ClearITPendingBit(DCMI_IT_FRAME | DCMI_IT_OVF);
  DMA_ClearITPendingBit(DMA2_Stream1, DMA_IT_TCIF1 | DMA_IT_TEIF1);

  /* Enable DMA2 stream 1 then start new image capture */
  DCMI_CaptureCmd(ENABLE);
  DMA_Cmd(DMA2_Stream1, ENABLE);

}

/**
* @brief  Convert RGB16 image to RGB24 format.
* @param  ImageData: Pointer of Buffer containing the Camera Image in RGB16 format
* @retval none
*/
static void IPCAM_RGB16toRGB24(void)
{
  uint16_t *source;
  uint8_t *destination;
  uint32_t index = 0;
  uint16_t value;

  source = (uint16_t*)&IPCAM_ImageBuffer.ImageData[IPCAM_ImageBuffer.ImageLen];
  destination  = (uint8_t*)&IPCAM_ImageBuffer.ImageData[IPCAM_ImageBuffer.MaxImageLen];
  destination--;
  source--;

  for(index = IPCAM_ImageBuffer.ImageLen; index >0; index-=2)
  {
    value = (uint16_t) *source;
    *destination-- = ((value & 0xF800)>> 11) << 3;
    *destination-- = ((value & 0x07E0) >> 5) << 2;
    *destination-- = (value & 0x001F) << 3;
    source--;
  }
}

/**
  * @brief  This function handles DMA2 Stream1 Interrupt
  * @param  None
  * @retval None
  */
void Ethernet_IRQHandler(void)
{
  /* This DMA is used for transferring the DCMI Data */
  if(DMA_GetITStatus(DMA2_Stream1, DMA_IT_TCIF1) != RESET)
  {
    /* Mark buffer as filled */
    IPCAM_ImageBuffer.BufferStatus = BUFFER_FILLED;

    /* Clear interrupt pending bit */
    DMA_ClearITPendingBit(DMA2_Stream1, DMA_IT_TCIF1);
  }
  /* Half Transfer complete interrupt */
  else if (DMA_GetFlagStatus(DMA2_Stream1, DMA_FLAG_HTIF1) != RESET)
  {
    /* Clear the Interrupt flag */
    DMA_ClearFlag(DMA2_Stream1, DMA_FLAG_HTIF1);
  }
  /* FIFO Error interrupt */
  else if (DMA_GetFlagStatus(DMA2_Stream1, DMA_FLAG_FEIF1) != RESET)
  {
    /* Clear the Interrupt flag */
    DMA_ClearFlag(DMA2_Stream1, DMA_FLAG_FEIF1);
  }
  /* Tranfer error interrupt */
  else if (DMA_GetFlagStatus(DMA2_Stream1, DMA_FLAG_TEIF1) != RESET)
  {
    DCMI_ClearFlag(DCMI_FLAG_OVFRI);

    /* Clear interrupt pending bit */
    DMA_ClearITPendingBit(DMA2_Stream1, DMA_IT_TEIF1);

    /* Mark buffer as empty */
    IPCAM_ImageBuffer.BufferStatus = BUFFER_EMPTY;
  }
}

/*******************************************************************************
                            Netconn Section 
*******************************************************************************/
/**
  * @brief  Initializes the lwIP stack
  * @param  None
  * @retval None
  */
void LwIP_Init(void)
{
  struct ip_addr ipaddr;
  struct ip_addr netmask;
  struct ip_addr gw;
  uint8_t iptxt[20];

  /* Create tcp_ip stack thread */
  tcpip_init(NULL, NULL);

  /* IP address setting */
  MOD_GetParam(3, &EthCfg.d32);

  if(EthCfg.b.DHCPEnable == 1)
  {
    ipaddr.addr = 0;
    netmask.addr = 0;
    gw.addr = 0;
  }
  else
  {
    IP4_ADDR(&ipaddr, IP_ADDR0, IP_ADDR1, IP_ADDR2, IP_ADDR3);
    IP4_ADDR(&netmask, NETMASK_ADDR0, NETMASK_ADDR1 , NETMASK_ADDR2, NETMASK_ADDR3);
    IP4_ADDR(&gw, GW_ADDR0, GW_ADDR1, GW_ADDR2, GW_ADDR3);

    sprintf((char*)iptxt, "%d.%d.%d.%d", IP_ADDR0, IP_ADDR1, IP_ADDR2, IP_ADDR3);
    ETHERNET_UpdateDHCPState(6,iptxt);
  }

  low_level_MAC_init();

  netif_add(&xnetif, &ipaddr, &netmask, &gw, NULL, &ethernetif_init, &tcpip_input);

  /*  Registers the default network interface. */
  netif_set_default(&xnetif);

  /* When the netif is fully configured this function must be called.*/
  netif_set_up(&xnetif);
}

/**
  * @brief  LwIP_DHCP_Process_Handle
  * @param  None
  * @retval None
  */
void LwIP_DHCP_task(void * pvParameters)
{
  struct ip_addr ipaddr;
  struct ip_addr netmask;
  struct ip_addr gw;

  uint8_t iptab[4];
  uint8_t iptxt[20];
  uint8_t index = 0;
  uint8_t DHCP_state;  
  DHCP_state = DHCP_START;

  for (;;)
  {
    switch (DHCP_state)
    {
      case DHCP_START:
      {
        dhcp_start(&xnetif);
        IPaddress = 0;
        DHCP_state = DHCP_WAIT_ADDRESS;
        ETHERNET_UpdateDHCPState(0,NULL);
        ETHERNET_UpdateIcon(ethernet_dhcp_icon);
      }
      break;

      case DHCP_WAIT_ADDRESS:
      {
        /* Read the new IP address */
        IPaddress = xnetif.ip_addr.addr;
        index++;
        if(index == 4)
        {
          index = 0;
        }
        ETHERNET_UpdateDHCPState(index,NULL);

        if (IPaddress!=0)
        {
          DHCP_state = DHCP_ADDRESS_ASSIGNED;	

          /* Stop DHCP */
          dhcp_stop(&xnetif);

          iptab[0] = (uint8_t)(IPaddress >> 24);
          iptab[1] = (uint8_t)(IPaddress >> 16);
          iptab[2] = (uint8_t)(IPaddress >> 8);
          iptab[3] = (uint8_t)(IPaddress);

          sprintf((char*)iptxt, "%d.%d.%d.%d", iptab[3], iptab[2], iptab[1], iptab[0]);
          ETHERNET_UpdateDHCPState(4,iptxt);
          ETHERNET_UpdateIcon(ethernet_conn_icon);

          vTaskPrioritySet(Task_Handle, (configMAX_PRIORITIES - 7));//5//7
          /* End of DHCP process */
          DHCP_Task_Handle = NULL;
          vTaskDelete(NULL);
        }
        else
        {
          /* DHCP timeout */
          if (xnetif.dhcp->tries > MAX_DHCP_TRIES)
          {
            DHCP_state = DHCP_TIMEOUT;

            /* Stop DHCP */
            dhcp_stop(&xnetif);

            /* Static address used */
            IP4_ADDR(&ipaddr, IP_ADDR0 ,IP_ADDR1 , IP_ADDR2 , IP_ADDR3 );
            IP4_ADDR(&netmask, NETMASK_ADDR0, NETMASK_ADDR1, NETMASK_ADDR2, NETMASK_ADDR3);
            IP4_ADDR(&gw, GW_ADDR0, GW_ADDR1, GW_ADDR2, GW_ADDR3);
            netif_set_addr(&xnetif, &ipaddr , &netmask, &gw);

            sprintf((char*)iptxt, "%d.%d.%d.%d", IP_ADDR0, IP_ADDR1, IP_ADDR2, IP_ADDR3);
            ETHERNET_UpdateDHCPState(5,iptxt);
            ETHERNET_UpdateIcon(ethernet_conn_icon);

            vTaskPrioritySet(Task_Handle, (configMAX_PRIORITIES - 7));//5
            /* End of DHCP process */
            DHCP_Task_Handle = NULL;
            vTaskDelete(NULL);
          }
        }
        if(EthLinkStatus != 0)
        {
          ETHERNET_DHCPFailState();
          /* End of DHCP process */
          DHCP_Task_Handle = NULL;
          vTaskDelete(NULL);
        }
      }
      break;
      default: break;
    }
    /* Wait 250 ms */
    vTaskDelay(250);
  }
}

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
