/******************** (C) COPYRIGHT 2007 STMicroelectronics ********************
* File Name          : main.c
* Author             : MCD Application Team
* Version            : V4.0
* Date               : 10/09/2007
* Description        : Main program body
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "71x_lib.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/*******************************************************************************
* Function Name  : main
* Description    : Main program
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
int main (void)
{
#ifdef DEBUG
  debug();
#endif /* DEBUG */

  
  /* System clocks configuration ---------------------------------------------*/
  /* MCLK = PCLK1 = PCLK2 = 8MHz*/ 
  
  /* Configure PCLK1 = RCLK / 1 */
  RCCU_PCLK1Config (RCCU_DEFAULT);

  /* Configure PCLK2 = RCLK / 1 */
  RCCU_PCLK2Config (RCCU_DEFAULT);

  /* Configure MCLK clock for the CPU, RCCU_DEFAULT = RCLK /1 */
  RCCU_MCLKConfig (RCCU_DEFAULT);
   
  /* Configure the PLL1 ( * 12 , / 4 ) */
  RCCU_PLL1Config (RCCU_PLL1_Mul_12, RCCU_Div_4) ;

  while(RCCU_FlagStatus(RCCU_PLL1_LOCK) == RESET)
  {
    /* Wait PLL to lock */
  }
  /* Select PLL1_Output as RCLK clock */
  RCCU_RCLKSourceConfig (RCCU_PLL1_Output) ;
    
  /* Enable ADC12 and GPIO0 clocks on APB2 */
  APB_ClockConfig (APB2, ENABLE, ADC12_Periph | GPIO0_Periph | GPIO1_Periph);
  
  /* GPIO configuration ------------------------------------------------------*/

  /*  Configure the used analog input as HI_AIN_TRI */
  GPIO_Config (GPIO1, 0x0001, GPIO_HI_AIN_TRI);

  /*  Configure GPIO0 pins as output push-pull  */
  GPIO_Config (GPIO0, 0xFFFF, GPIO_OUT_PP);

  /* EIC configuration -------------------------------------------------------*/

  /* Configure the EIC channel interrupt */
  EIC_IRQChannelPriorityConfig(ADC_IRQChannel, 1);
  EIC_IRQChannelConfig(ADC_IRQChannel, ENABLE);
  EIC_IRQConfig(ENABLE);

  /* ADC12 configuration  ----------------------------------------------------*/

  /*  Initialize the conveter register. */
  ADC12_Init();

  /*  Configure the prescaler register with a sampling frequency = 500Hz */
  ADC12_PrescalerConfig(500);

  /*  Select the conversion mode=single channel */
  ADC12_ModeConfig (ADC12_SINGLE);

  /*  Select the channel to be converted */
  ADC12_ChannelSelect(ADC12_CHANNEL0);

  /* Enable the ADC12 intruupts */
  ADC12_ITConfig (ENABLE);

  /*  Start the Converter */
  ADC12_ConversionStart();


  while (1)
  {
    /* Infinite loop */
  }
}

/******************* (C) COPYRIGHT 2007 STMicroelectronics *****END OF FILE****/
