/******************** (C) COPYRIGHT 2007 STMicroelectronics ********************
* File Name          : main.c
* Author             : MCD Application Team
* Version            : V4.0
* Date               : 10/09/2007
* Description        : Main program body
********************************************************************************
 THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS WITH
 CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
 AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT
 OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE CONTENT
 OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING INFORMATION
 CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "71x_lib.h"
#include "main.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
canmsg RxCanMsg; /* buffer for receive messages*/

/* array of pre-defined transmit messages*/
canmsg TxCanMsg[2] = 
{
  { CAN_STD_ID,      0x123, 4, { 0x01, 0x02, 0x04, 0x08 } },
  { CAN_EXT_ID, 0x12345678, 8, { 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 
  0x17 } }
};

/* Private function prototypes -----------------------------------------------*/
void GPIO_Configuration(void);
void Delay(void);
void Demo_Polling(void);
void Demo_Interrupt(void);

/* Private functions ---------------------------------------------------------*/

/*******************************************************************************
* Function Name  : main
* Description    : Main program
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
int main(void)
{
  #ifdef DEBUG
  debug();
  #endif

  /* System clocks configuration ---------------------------------------------*/
  /* MCLK = PCLK1 = PCLK2 = 8MHz*/ 
  
  /* Enable CAN clock on APB1 */
  APB_ClockConfig (APB1, ENABLE, CAN_Periph );
 
  /* Enable GPIO0, GPIO1 and GPIO2 clock on APB2 */
  APB_ClockConfig (APB2, ENABLE, GPIO0_Periph |GPIO1_Periph | GPIO2_Periph);
  
  /* initialize the I/O ports for the CAN pins*/
  GPIO_Configuration();

  Demo_Polling();

  Demo_Interrupt();

  while (1)
  { 
       /* if the program has run properly, 8 LEDs must be ON */
  }
 
}

/*******************************************************************************
* Function Name  : GPIO_Configuration
* Description    : Configures the TX and RX pins for the CAN and the GPIO pins
*                  used for leds
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void GPIO_Configuration(void)
{
  /* Configure GPIO 1.11 (CAN RX pin) as input Tristate CMOS*/
   GPIO_Config( GPIO1, 1<<11 , GPIO_IN_TRI_CMOS);

  /* Configure GPIO 1.12 (CAN TX pin) as output alternate Push-pull*/   
  GPIO_Config(GPIO1, 1<<12 ,  GPIO_AF_PP);
  
  /* Configure the GPIO pins used for the leds as output push pull */
  GPIO_Config(GPIO0, 0x100F , GPIO_OUT_PP);
  GPIO_WordWrite( GPIO0, 0x0000);
  GPIO_Config(GPIO1, 0x8070 , GPIO_OUT_PP);
  GPIO_BitWrite( GPIO1, 4, 0);
  GPIO_BitWrite( GPIO1, 5, 0);
  GPIO_BitWrite( GPIO1, 6, 0);
  GPIO_BitWrite( GPIO1, 15, 0);
  GPIO_Config(GPIO2, 0xFE00 , GPIO_OUT_PP);
  GPIO_WordWrite( GPIO2, 0x0000);  
}

/*******************************************************************************
* Function Name  : Delay
* Description    : Delay function.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void Delay(void)
{
  vu32 i;
  for (i = 0; i < 100000L; i++) {}
}

/*******************************************************************************
* Function Name  : Demo_Polling
* Description    : Polling mode demonstration function.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void Demo_Polling(void)
{
  /* initialize the CAN at a standard bitrate, interrupts disabled*/
  CAN_Init(0, CAN_BITRATE_100K);

  /* switch into Loopback+Silent mode (self-test)*/
  CAN_EnterTestMode(CAN_TESTR_LBACK | CAN_TESTR_SILENT);

  /* configure the message objects*/
  CAN_SetUnusedAllMsgObj();
  CAN_SetTxMsgObj(CAN_TX_MSGOBJ, CAN_STD_ID, DISABLE);
  CAN_SetRxMsgObj(CAN_RX_MSGOBJ, CAN_STD_ID, 0, CAN_LAST_STD_ID, TRUE);

  /* swicth on led 0 */
  GPIO_BitWrite( GPIO0, 3, 1);
  
  /* send a pre-defined data frame*/
  (void)CAN_SendMessage(CAN_TX_MSGOBJ, &TxCanMsg[0]);

  /* wait until end of transmission*/
  CAN_WaitEndOfTx();
  
   /* swicth on led 1 */
  GPIO_BitWrite( GPIO0, 2, 1);

  /* wait for reception of a data frame*/
  while (!CAN_ReceiveMessage(CAN_RX_MSGOBJ, FALSE, &RxCanMsg))
  {
    /* add a time-out handling here, if necessary*/
  }

   /* swicth on led 2 */
   GPIO_BitWrite( GPIO0, 1, 1);

  /* release the message objects*/
  CAN_ReleaseTxMessage(CAN_TX_MSGOBJ);
  CAN_ReleaseRxMessage(CAN_RX_MSGOBJ);

  /* switch on led 3 */
  GPIO_BitWrite( GPIO0, 0, 1);

  /* switch back into Normal mode*/
  CAN_LeaveTestMode();
}

/*******************************************************************************
* Function Name  : Demo_Interrupt
* Description    : Interrupt mode demonstration function.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void Demo_Interrupt(void)
{
  /* initialize the interrupt controller*/
  EIC_IRQChannelConfig(CAN_IRQChannel, ENABLE);
  EIC_IRQChannelPriorityConfig(CAN_IRQChannel, 1);
  EIC_IRQConfig(ENABLE);

  /* initialize the CAN at a standard bitrate, interrupts enabled*/
  CAN_Init(CAN_CR_IE, CAN_BITRATE_500K);

  /* switch into Loopback+Silent mode (self-test)*/
  CAN_EnterTestMode(CAN_TESTR_LBACK | CAN_TESTR_SILENT);

  /* configure the message objects*/
  CAN_SetUnusedAllMsgObj();
  CAN_SetTxMsgObj(CAN_TX_MSGOBJ, CAN_EXT_ID, DISABLE);
  CAN_SetRxMsgObj(CAN_RX_MSGOBJ, CAN_EXT_ID, 0, CAN_LAST_EXT_ID, TRUE);

   /* switch on led 4 */
   GPIO_BitWrite( GPIO0, 12, 1);

  /* send a pre-defined data frame*/
  (void)CAN_SendMessage(CAN_TX_MSGOBJ, &TxCanMsg[1]);

  /* reception and release are done in the interrupt handler*/

  Delay();

  /*switch on led 7 */
  GPIO_BitWrite( GPIO2, 10, 1); 

  /* switch back into Normal mode*/
  CAN_LeaveTestMode();

  /* disable interrupts globally*/
  EIC_IRQConfig(DISABLE);
}

/******************* (C) COPYRIGHT 2007 STMicroelectronics *****END OF FILE****/
