/******************** (C) COPYRIGHT 2007 STMicroelectronics ********************
* File Name          : main.c
* Author             : MCD Application Team
* Version            : V4.0
* Date               : 10/09/2007
* Description        : Main program body
********************************************************************************
 THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS WITH
 CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
 AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT
 OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE CONTENT
 OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING INFORMATION
 CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "71x_lib.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void Delay(vu32 nCount);

/* Private functions ---------------------------------------------------------*/

/*******************************************************************************
* Function Name  : main
* Description    : Main program
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
int main(void)
{
  #ifdef DEBUG
  debug();
  #endif
  
  /* System clocks configuration ---------------------------------------------*/

  /* MCLK = PCLK1 = PCLK2 = 24MHz*/ 
  /* Configure PCLK1 = RCLK / 1 */
  RCCU_PCLK1Config (RCCU_DEFAULT);

  /* Configure PCLK2 = RCLK / 1 */
  RCCU_PCLK2Config (RCCU_DEFAULT);

  /* Configure MCLK clock for the CPU, RCCU_DEFAULT = RCLK /1 */
  RCCU_MCLKConfig (RCCU_DEFAULT);
   
  /* Configure the PLL1 ( * 12 , / 4 ) */
  RCCU_PLL1Config (RCCU_PLL1_Mul_12, RCCU_Div_4) ;

  while(RCCU_FlagStatus(RCCU_PLL1_LOCK) == RESET)
  {
    /* Wait PLL to lock */
  }
  /* Select PLL1_Output as RCLK clock */
  RCCU_RCLKSourceConfig (RCCU_PLL1_Output) ;
  
  /* Enable GPIO0 and GPIO1 clocks on APB2 */
  APB_ClockConfig (APB2, ENABLE, GPIO0_Periph | GPIO1_Periph);
  
  /* GPIO configuration ------------------------------------------------------*/
  /* Configure P0.0 to P0.7 as Output Push-Pull */
  GPIO_Config(GPIO0, 0x00FF, GPIO_OUT_PP);

  /* Configure P0.7 to P0.15 as Input TTL */
  GPIO_Config(GPIO0, 0xFF00 , GPIO_IN_TRI_TTL);

  /* Configure P1.4 as Output Push-Pull */
  GPIO_Config(GPIO1, 0x0010, GPIO_OUT_PP);

  /* Configure P1.1 as Input TTL */
  GPIO_Config(GPIO1, 0x0001, GPIO_IN_TRI_TTL);

  GPIO_WordWrite(GPIO0, 0xFF00);

  /*  infinite loop */
  while(1)
  {
     /* Insert delay */
    Delay(0xFFFFF);

   /* GPIO_ByteWrite(GPIO0, GPIO_LSB, ~GPIO_ByteRead(GPIO0, GPIO_LSB)); */

    /* GPIO_BitWrite(GPIO1, 4, ~GPIO_BitRead(GPIO1, 4)); */

    /*  Toggle the GPIO0 port pins */
    GPIO_WordWrite(GPIO0, ~GPIO_WordRead(GPIO0));
  }
}

/*******************************************************************************
* Function Name  : Delay
* Description    : Inserts a delay time.
* Input          : nCount: specifies the delay time length.
* Output         : None
* Return         : None
*******************************************************************************/
void Delay(vu32 nCount)
{
  for(; nCount != 0; nCount--);
}

/******************* (C) COPYRIGHT 2007 STMicroelectronics *****END OF FILE****/
