/******************** (C) COPYRIGHT 2007 STMicroelectronics ********************
* File Name          : i2c_ee.h
* Author             : MCD Application Team
* Version            : V4.0
* Date First Issued  : 10/09/2007
* Description        : Header for i2c_ee.c module
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
********************************************************************************/
/* Define to prevent recursive inclusion ------------------------------------ */
#ifndef __I2C_EE_H
#define __I2C_EE_H

/* Includes ------------------------------------------------------------------*/
#include "71x_lib.h"

/* Exported types ------------------------------------------------------------*/
/* Exported constants --------------------------------------------------------*/
/* The M24C08W contains 4 blocks (128byte each) with the adresses below */
/* EEPROM Addresses defines */
#define EEPROM_Block0_ADDRESS   0xA8  /* E2 = 1 */
//#define EEPROM_Block1_ADDRESS   0xAA
//#define EEPROM_Block2_ADDRESS   0xAC
//#define EEPROM_Block3_ADDRESS   0xAE

/* Exported macro ------------------------------------------------------------*/
/* Exported functions ------------------------------------------------------- */
void I2C_EEPROM_Config(I2C_TypeDef *I2Cx);
void EEPROM_Receive(I2C_TypeDef *I2Cx, char *PtrToBuffer,
                     u8 InternalAddress, u8 NbOfBytes);
void EEPROM_WaitForLastTask(I2C_TypeDef *I2Cx);
void EEPROM_Send_Byte(I2C_TypeDef *I2Cx, u8* pBuffer, u8 WriteAddr);
void EEPROM_Send(I2C_TypeDef *I2Cx, char *PtrToBuffer, u8 NbOfBytes, 
                 u8 InternalAddress);
void EEPROM_BufferWrite(I2C_TypeDef *I2Cx, char* pBuffer, 
                          u8 WriteAddr, u16 NumByteToWrite);

#endif /* __I2C_EE_H */

/******************* (C) COPYRIGHT 2007 STMicroelectronics *****END OF FILE****/


