/******************** (C) COPYRIGHT 2007 STMicroelectronics ********************
* File Name          : main.c
* Author             : MCD Application Team
* Version            : V4.0
* Date               : 10/09/2007
* Description        : Main program body
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "71x_lib.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void GPIO_PinToggle(u8 GPIO_PIN, u32 DELAY);
void Delay(vu32 nCount);

/* Private functions ---------------------------------------------------------*/

/*******************************************************************************
* Function Name  : main
* Description    : Main program
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
int main(void)
{
  #ifdef DEBUG
  debug();
  #endif
  
  
  /* System clocks configuration ---------------------------------------------*/
   /* select CLK2 as RCCU clock source  MCLK=PCLK1=PCLK2= 8 MHZ*/
  RCCU_RCLKSourceConfig(RCCU_CLOCK2);
    
  /* Enable GPIO0 and GPIO1 clock on APB2 */
   APB_ClockConfig (APB2, ENABLE, GPIO0_Periph|GPIO1_Periph );
   /* Enable XTI and EIC clock on APB2 */
   APB_ClockConfig (APB2, ENABLE, XTI_Periph);
   
  /* GPIO configuration ------------------------------------------------------*/
  /* Configure P0.0 as Output Push-Pull */
  GPIO_Config(GPIO0, 1, GPIO_OUT_PP);
  GPIO_BitWrite(GPIO0, 0, 0);

  /* Configure P0.15 wakeup button as input TTL */
  GPIO_Config (GPIO0 , 0x8000, GPIO_IN_TRI_TTL);
  /* Configure the P1.9 NXT button as input TTL */
  GPIO_Config(GPIO1, (0x0001 << 9), GPIO_IN_TRI_TTL);
  
  /* XTI configuration -------------------------------------------------------*/
  
  /* Initialize the XTI */
  XTI_Init(); 
   /* Configure the line 15 mode ,select Rising edge trig */
  XTI_LineModeConfig(XTI_Line15, XTI_FallingEdge);
   /* Enable line 15 Wake-Up interrupts */
  XTI_LineConfig(XTI_Line15, ENABLE);
   /* Enable Wake-Up mode in the XTI */
  XTI_ModeConfig(XTI_WakeUpInterrupt, ENABLE);

  /* EIC configuration -------------------------------------------------------*/
  
  /* Congigure the EIC to acknowledg XTI interrupt */
  EIC_IRQChannelPriorityConfig(XTI_IRQChannel,1);
  EIC_IRQChannelConfig(XTI_IRQChannel, ENABLE);
  /* Enable the IRQ */
  EIC_IRQConfig(ENABLE);

  /* Set the MVR disabled and the FLASH in PWD mode during STOP mode */
  PCU_LPModesConfig(DISABLE, DISABLE, DISABLE, ENABLE, LPWFI_CK_AF);


  while(1)
  {
    
   /* Toggle a P0.0 pin */
   GPIO_PinToggle(0, 0xFFFF);

    /* switch on P0.0 */ 
    GPIO_BitWrite(GPIO0, 0, 1);

  /* Press the NXT button to go into stop mode */   
   while(GPIO_BitRead(GPIO1, 9))
   {
   }
   /*  Go into  STOP mode  */
   PCU_STOP();
    
    
     
     }
}

/*******************************************************************************
* Function Name  : GPIO_PinToggle
* Description    : P0.0 toggling 
* Input1         : pin number 
* Input2         : Delay value
* Output         : None
* Return         : None
*******************************************************************************/
void GPIO_PinToggle(u8 GPIO_PIN, u32 DELAY)
{
  u8 counter = 10;

  while(counter)
  {
    GPIO_BitWrite (GPIO0, GPIO_PIN, 1);
    Delay(DELAY);
    GPIO_BitWrite (GPIO0, GPIO_PIN, 0);
    Delay(DELAY);
    counter--;
  } 
}

/*******************************************************************************
* Function Name  : Delay
* Description    : Inserts a delay time.
* Input          : nCount: specifies the delay time length.
* Output         : None
* Return         : None
*******************************************************************************/
void Delay(vu32 nCount)
{
  for(; nCount != 0; nCount--);
}

/******************* (C) COPYRIGHT 2007 STMicroelectronics *****END OF FILE****/
