/******************** (C) COPYRIGHT 2007 STMicroelectronics ********************
* File Name          : main.c
* Author             : MCD Application Team
* Version            : V4.0
* Date               : 10/09/2007
* Description        : Example of using the RTC firmware library
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "71x_lib.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Define the RTC prescaler 0x7FFF to have 1 second basic clock */
#define RTC_Prescaler 0x7FFF 

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/*******************************************************************************
* Function Name  : main
* Description    : main program.
* Input          : None.
* Return         : None.
*******************************************************************************/
int main (void)
{
  #ifdef DEBUG
    debug();
  #endif
  
  /* System clocks configuration ---------------------------------------------*/
  /* MCLK = PCLK1 = PCLK2 = 8MHz*/ 
    
  /* Enable RTC and GPIO0 clocks on APB2 */
  APB_ClockConfig (APB2, ENABLE, RTC_Periph | GPIO0_Periph);
  
  /*  Configure RTC prescaler */
  RTC_PrescalerConfig(RTC_Prescaler);

  /*  Clear Pending Flags */
  RTC_FlagClear(RTC_OWIR);
  RTC_FlagClear(RTC_AIR);
  RTC_FlagClear(RTC_SIR);
  RTC_FlagClear(RTC_GIR);

  /*  Enable RTC IRQ channel */
  EIC_IRQChannelConfig(RTC_IRQChannel, ENABLE);
  EIC_IRQChannelPriorityConfig(RTC_IRQChannel, 1);
  EIC_IRQConfig(ENABLE);

  /*  Enable Second Interrupt */
  RTC_ITConfig(RTC_SIT, ENABLE);
  RTC_ITConfig(RTC_GIT, ENABLE);

  /*  Configure Port 0 pins */
  GPIO_Config(GPIO0, 0xFFFF, GPIO_OUT_PP);
  GPIO0->PD = 0x0000;

 /* Infinite loop */
  while (1)
  {
  }
}

/******************* (C) COPYRIGHT 2007 STMicroelectronics *****END OF FILE****/
