/******************** (C) COPYRIGHT 2007 STMicroelectronics ********************
* File Name          : main.c
* Author             : MCD Application Team
* Version            : V4.0
* Date               : 10/09/2007
* Description        : Main program body
********************************************************************************
 THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS WITH
 CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
 AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT
 OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE CONTENT
 OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING INFORMATION
 CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "71x_lib.h"
#include <stdio.h> 

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define T3_ICAP_A            0x02

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
u32 Fpclk2 ;
u16 Tmp1 = 0x0;
u16 Tmp2 = 0x0;
u16 Prescaler;
u32 Frequency;
u32 DutyCycle;

/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/
int main(void)
{
  #ifdef DEBUG
  debug ();
  #endif
  
  
  /* System clocks configuration ---------------------------------------------*/

  /* MCLK = PCLK1 = PCLK2 = 32MHz*/ 
  /* Configure PCLK1 = RCLK / 1 */
  RCCU_PCLK1Config (RCCU_DEFAULT);

  /* Configure PCLK2 = RCLK / 1 */
  RCCU_PCLK2Config (RCCU_DEFAULT);

  /* Configure MCLK clock for the CPU, RCCU_DEFAULT = RCLK /1 */
  RCCU_MCLKConfig (RCCU_DEFAULT);

  /* Configure the PLL1 ( * 12 , / 3 ) */
  RCCU_PLL1Config (RCCU_PLL1_Mul_12, RCCU_Div_3) ;

  
  while(RCCU_FlagStatus(RCCU_PLL1_LOCK) == RESET)
  { 
  /* Wait PLL to lock */
  }

  /* Select PLL1_Output as RCLK clock */
  RCCU_RCLKSourceConfig (RCCU_PLL1_Output);

   /* Enable TIM3 and GPIO1 clocks on APB2 */
  APB_ClockConfig (APB2, ENABLE, TIM3_Periph | GPIO1_Periph);
  
  
  /* GPIO configuration ------------------------------------------------------*/
  /*  Timer 3 Input Capture A function pin (P1.1) configured as Input
      Tristate TTL */
  GPIO_Config (GPIO1, T3_ICAP_A, GPIO_IN_TRI_TTL);

  /*  Initialize the Timer */
  TIM_Init (TIM3);

  /* TIM3 configuration ------------------------------------------------------*/

  /*  Configure the prescaler */
  TIM_PrescalerConfig (TIM3, 0x00);
 
  /*  Configure the PWM input Mode */
  TIM_PWMIModeConfig (TIM3, TIM_RISING);

  /*  Start the Counter */
  TIM_CounterConfig (TIM3, TIM_START);

  /*  Get the APB2 Frequency */
  Fpclk2 = RCCU_FrequencyValue(RCCU_PCLK2);

  while(1)
   {
     
      while (TIM_FlagStatus(TIM3, TIM_ICFB) == RESET)
      {
      /* Wait until ICFB flag is set  */
      }
      Tmp1 = TIM3->ICBR;

      
      while (TIM_FlagStatus(TIM3, TIM_ICFA) == RESET)
      {
      /* Wait until ICFA flag is set  */
      }
      Tmp2 = TIM3->ICAR;    

      /*  Compute the input signal Frequency and DutyCycle */ 
      Frequency = Fpclk2 / (0x1 * Tmp2);
      DutyCycle = 100 * Tmp1 / Tmp2;

      /*  Clear TIMER Flags */ 
      TIM_FlagClear(TIM3, TIM_ICFA);
      TIM_FlagClear(TIM3, TIM_ICFB);

      /*  Display on the debugger output window the Frequency and 
          the DutyCycle of the input signal */ 
      printf("Frequency = %dHz DutyCycle = %2d%%\n", Frequency, DutyCycle);
   }

}
/******************* (C) COPYRIGHT 2006 STMicroelectronics *****END OF FILE****/
