/******************** (C) COPYRIGHT 2007 STMicroelectronics ********************
* File Name          : main.c
* Author             : MCD Application Team
* Version            : V4.0
* Date               : 10/09/2007
* Description        : Main program body
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "71x_lib.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define UART0_Rx_Pin (0x0001 << 8)  /*TQFP 64: pin N 63, TQFP 144 pin N 143*/
#define UART0_Tx_Pin (0x0001 << 9)  /*TQFP 64: pin N 64, TQFP 144 pin N 144*/
#define UART_SEND_MAX_DATA  16

/* Messages to display on the hyperterminal */
#define MESSAGE1 "This example returns the sum of 8 numbers " 
#define MESSAGE2 "\n\rPlease type 8 numbers:\n\r "

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
u16 i;
u32 StringSize;
u8 *TransferData;
vu32 DataSent;
vu32 Data_Sent_Status = FALSE;
vu32 Response_Received = FALSE;
u8 Response[8];
u8 Result[34]= {'0',' ','+',' ','0',' ','+',' ','0',' ','+',' ','0',' ','+',' ',
                '0',' ','+',' ','0',' ','+',' ','0',' ','+',' ','0',' ','=',' ',
                '0','0'};

/* Private function prototypes -----------------------------------------------*/
void Send_Data (u8 Nb_bytes);

/* Private functions ---------------------------------------------------------*/

/*******************************************************************************
* Function Name  : main
* Description    : Main program
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
int main(void)
{
  u32 i; 
  u8 Sum = 0;
 #ifdef DEBUG
  debug();
  #endif
  
  /* System clocks configuration ---------------------------------------------*/
  /* MCLK = PCLK1 = PCLK2 = 24MHz*/ 
  
  /* Configure PCLK1 = RCLK / 1 */
  RCCU_PCLK1Config (RCCU_DEFAULT);

  /* Configure PCLK2 = RCLK / 1 */
  RCCU_PCLK2Config (RCCU_DEFAULT);

  /* Configure MCLK clock for the CPU, RCCU_DEFAULT = RCLK /1 */
  RCCU_MCLKConfig (RCCU_DEFAULT);
   
  /* Configure the PLL1 ( * 12 , / 4 ) */
  RCCU_PLL1Config (RCCU_PLL1_Mul_12, RCCU_Div_4) ;

  while(RCCU_FlagStatus(RCCU_PLL1_LOCK) == RESET)
  {
    /* Wait PLL to lock */
  }
  /* Select PLL1_Output as RCLK clock */
  RCCU_RCLKSourceConfig (RCCU_PLL1_Output) ;  
  
  /* Enable UART0 clock on APB1 */
  APB_ClockConfig (APB1, ENABLE, UART0_Periph );
 
  /* Enable GPIO0 clock on APB2 */
  APB_ClockConfig (APB2, ENABLE, GPIO0_Periph );
  
  /* GPIO configuration ------------------------------------------------------*/

  /*  Configure the GPIO pins */
  GPIO_Config(GPIO0, UART0_Tx_Pin, GPIO_AF_PP);
  GPIO_Config(GPIO0, UART0_Rx_Pin, GPIO_IN_TRI_CMOS);
  
  /* UART configuration ----------------------------------------------------- */
  UART_Init(UART0);
  
  
  /* Disable FIFOs */      
  UART_FifoConfig (UART0, ENABLE);
  
  /* Reset the UART_RxFIFO */      
  UART_FifoReset (UART0 , UART_RxFIFO);
  
  /* Reset the UART_TxFIFO */ 
  UART_FifoReset (UART0 , UART_TxFIFO);
 
  /* Disable Loop Back */ 
  UART_LoopBackConfig(UART0, DISABLE);                                           
 
 /* Configure the UART0 as following:
                              - Baudrate = 9600 Bps
                              - No parity
                              - 8 data bits
                              - 1 stop bit */
  UART_Config(UART0, 9600, UART_NO_PARITY, UART_1_StopBits, UARTM_8D);
          
  /* EIC configuration -------------------------------------------------------*/

  /* Configure the EIC channel interrupt */
  EIC_IRQChannelPriorityConfig(UART0_IRQChannel, 1);
  EIC_IRQChannelConfig(UART0_IRQChannel, ENABLE);
  EIC_IRQConfig(ENABLE);
  
  StringSize = sizeof(MESSAGE1) ;
  TransferData = MESSAGE1;
  Send_Data (UART_SEND_MAX_DATA); 

  StringSize = sizeof(MESSAGE2) ;
  TransferData = MESSAGE2;
  Send_Data (UART_SEND_MAX_DATA); 
  
  /* Reset the UART_RxFIFO */      
  UART_FifoConfig (UART0, ENABLE);
  UART_FifoReset (UART0 , UART_RxFIFO);
  UART_OnOffConfig(UART0, ENABLE); 
  UART_RxConfig(UART0, ENABLE);
  UART_ItConfig(UART0, UART_RxHalfFull, ENABLE);  
  
  
  while(Response_Received != TRUE)
  {
    /* Waiting for user responce */
  }
  
  for (i = 8; i > 0; i--)
    Sum += Response[i-1] - 0x30;

  
  for (i = 0; i < 34; i+=4)
  {
    Result[i] = Response [i/4];
  }
  
  Result[32] = (Sum / 10) + 0x30;
  Result[33] = (Sum % 10) + 0x30;
  
  StringSize = 34 ;
  TransferData = (u8*)(&Result[0]);
  Send_Data (UART_SEND_MAX_DATA);
  
  while(1)
  {
    /* Infinite Loop*/
  }
  
  
}

/*******************************************************************************
* Function Name  : Send_Data
* Description    : send data under UART
* Input          : Nb_bytes: number of bytes to send.
* Output         : None
* Return         : None
*******************************************************************************/
void Send_Data (u8 Nb_bytes)
{
  
  UART_DataSend(UART0, TransferData, Nb_bytes);
  DataSent = Nb_bytes;
  UART_OnOffConfig(UART0, ENABLE); 
  UART_ItConfig(UART0, UART_TxHalfEmpty, ENABLE);
  UART_ItConfig(UART0, UART_TxEmpty, ENABLE);
  while (Data_Sent_Status == FALSE)
  {
    /* wait until the end of transission */
  }
  Data_Sent_Status = FALSE;
}

/******************* (C) COPYRIGHT 2007 STMicroelectronics *****END OF FILE****/
