/******************** (C) COPYRIGHT 2007 STMicroelectronics ********************
* File Name          : main.c
* Author             : MCD Application Team
* Version            : V4.0
* Date               : 10/09/2007
* Description        : Main program body
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "71x_lib.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
//#define Timer_Mode          /*  Free running Timer Mode */
#define WDG_Mode             /*  Watchdog mode */
#define Refresh_Time     32768   

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
RCCU_ResetSources RST_SRC;
u32 i;

/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/*******************************************************************************
* Function Name  : main
* Description    : Main program
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
int main(void)
{
  #ifdef DEBUG
    debug();
  #endif
  
  #ifdef WDG_Mode
  u32 counter = 0xFFFFF;
  #endif

  /* System clocks configuration ---------------------------------------------*/
  /* MCLK = PCLK1 = PCLK2 = 8MHz*/  
      
  /* Enable GPIO0 and GPIO1 clocks on APB2 */
  APB_ClockConfig (APB2, ENABLE, GPIO0_Periph | GPIO1_Periph);
  
 
#ifdef Timer_Mode 

  /******************* Free running Timer mode  *******************************/
  
  /* GPIO configuration ------------------------------------------------------*/
  GPIO_Config (GPIO0, 0xFFFF, GPIO_OUT_PP);
  GPIO_WordWrite(GPIO0,0x0);
  
  /* WDG configuration -------------------------------------------------------*/
  /* Disable the end of count interrupt */  
  WDG_ECITConfig (DISABLE);
  
  /* Stop the free auto-reload timer to count down */
  WDG_CntOnOffConfig (DISABLE);
  
  /* Set the prescaler and counter reload value based on the needed time */
  WDG_PeriodValueConfig (12345);	/*  12.345 ms */
  
  /* EIC configuration -------------------------------------------------------*/
  /* The interrupt handler toggles an I/O port */  
  
  /* Configure the WDG_IRQChannel priority */   
  EIC_IRQChannelPriorityConfig(WDG_IRQChannel, 1);
  
  /* Enable the WDG_IRQChannel */  
  EIC_IRQChannelConfig(WDG_IRQChannel, ENABLE);
  
  /* Enable IRQ interrupts */
  EIC_IRQConfig(ENABLE);
  
  /* Enable the end of count interrupt */ 
  WDG_ECITConfig (ENABLE);
  
  /* The free auto-reload timer starts to count down */  
  WDG_CntOnOffConfig (ENABLE);
  
  while(1)
  {
  /* infinite loop */
  }
#endif /* Timer_Mode */


#ifdef WDG_Mode

  /********************* Watchdog mode ****************************************/
  
  /* Enable EIC clock on APB2 */
  APB_ClockConfig (APB2, ENABLE, TIM3_Periph);
  
  /* GPIO configuration ------------------------------------------------------*/
  /* Configure all GPIO0 pins as Output push-pull */
  GPIO_Config (GPIO0, 0xFFFF, GPIO_OUT_PP);
 
  /* Configure GPIO 1.15 pin as Output push-pull */
  GPIO_Config (GPIO1, 0x8000, GPIO_OUT_PP);
  
  /* P1.15 is OFF ( LD9 on STR71x EVAL board) */
  GPIO_BitWrite(GPIO1, 15, 0);
  
  /* All GPIO0 pins OFF */
  GPIO_WordWrite (GPIO0, 0x0000);
 
  /* Read the reset source */
  RST_SRC = RCCU_ResetSource();
       
  /* If a WDG reset has been occured toggle P1.15 */
  if (RST_SRC == RCCU_WDGReset)  
  {   
    /* Set P1.15 ON */
      GPIO_BitWrite(GPIO1, 15, 1);
      
      /* Delay */
      for (i=0; i<0x3FFF; i++);
      
    /* P1.15 is OFF */
    GPIO_BitWrite(GPIO1, 15, 0);
  }       
    
   /*  Enable the IRQ0 for timer 3 */
   EIC_IRQChannelConfig(T3TIMI_IRQChannel, ENABLE );
   EIC_IRQChannelPriorityConfig(T3TIMI_IRQChannel, 1);
   EIC_IRQConfig(ENABLE);

   /*TIM configuration -------------------------------------------------------*/
   /*  Initialize the Timer 3 registers to reset values */
   TIM_Init (TIM3);

   /*  Configure the TIM Prescaler */
   TIM_PrescalerConfig (TIM3, 0x7F);

   /*  Enable the Output Compare for the TIM3 peripheral */
   TIM_ITConfig (TIM3, TIM_OCA_IT, ENABLE);
   
   /*  Configure the TIM3 Output Compare Function */
   TIM_OCMPModeConfig (TIM3, TIM_CHANNEL_A, 0, TIM_WAVE, TIM_HIGH);
   
  /* WDG configuration -------------------------------------------------------*/
  
  /* Set the counter prescaler value */
  WDG_PrescalerConfig (0xFF);
  
  /* Configure the counter pre-load value */  
  WDG_CntReloadUpdate (Refresh_Time);

  while(counter--)
  {
  }
  /* Enable the watchdog mode */
  WDG_Enable();

  while(1)
  {
   /* Toggle GPIO0 pins */
   GPIO_WordWrite (GPIO0, ~GPIO_WordRead(GPIO0));
  
   /* Delay */
   for(counter=0; counter<0xFFFF; counter++);
  }
  
#endif /* WDG_Mode */
}

/******************* (C) COPYRIGHT 2007 STMicroelectronics *****END OF FILE****/

