/******************** (C) COPYRIGHT 2006 STMicroelectronics ********************
* File Name          : boardselftest.h
* Author             : MCD Application Team
* Date First Issued  : 03/10/2006
* Description        : This file contains all the functions prototypes for the
*                      boardselftest software driver.
********************************************************************************
* History:
* 07/17/2006 : V1.0
* 03/10/2006 : V0.1
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __BOARDSELFTEST_H
#define __BOARDSELFTEST_H

/* Includes ------------------------------------------------------------------*/
#include "75x_lib.h"

/* Exported types ------------------------------------------------------------*/
typedef u8* string;
typedef enum { FAILED = 0, PASSED = !FAILED } TestStatus;

/* Exported constants --------------------------------------------------------*/
#define RIGHTmsg             "   Press ^RIGHT^ "
#define LEFTmsg              "   Press ^LEFT^  "
#define SELmsg               "   Press ^SEL^   "
#define UPmsg                "    Press ^UP^   "
#define DOWNmsg              "   Press ^DOWN^  "
#define WAKEUPmsg            " Press ^WAKE-UP^ "
#define KEYmsg               "   Press ^KEY^   "

#define Passmsg              "  ^SEL^ : Passed "
#define Failmsg              "  ^LEFT^: Failed "
#define Passedmsg            "  ***Passed***   "
#define Failedmsg            "  !!!Failed!!!   "
#define TestFailedmsg        " Test failed     "
#define Overalltestmsg       "  Overall test   "
#define Bordtestnotdonemsg1  " Board test not  "
#define Bordtestnotdonemsg2  "   done yet!!!   "

/* Exported macro ------------------------------------------------------------*/
/* Exported functions ------------------------------------------------------- */
TestStatus PushButtons_Test(void);
TestStatus JoyStick_Test(void);
TestStatus Leds_Test(void);
TestStatus MIC_Speaker_Test(void);
TestStatus VarResistor_Test(void);
TestStatus OSC32K_Test(void);
TestStatus OSC4M_Test(void);
TestStatus SMI_Flash_Test(void);
TestStatus UART0_UART1_Test(void);
TestStatus UART1_UART2_Test(void);
void BoardSelfTest(void);
void TestReport(void);
TestStatus msgcmp(u8* Tx_msg, u8* Rx_msg, u16 msglength);
TestStatus IsTestOk(void);

#endif /* __BOARDSELFTEST_H */

/******************* (C) COPYRIGHT 2006 STMicroelectronics *****END OF FILE****/
