/******************** (C) COPYRIGHT 2006 STMicroelectronics ********************
* File Name          : usb_pwr.h
* Author             : MCD Application Team
* Date First Issued  : 03/10/2006
* Description        : Connection/disconnection & power management
********************************************************************************
* History:
* 07/17/2006 : V1.0
* 03/10/2006 : V0.1
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

typedef enum _RESUME_STATE{
	RESUME_EXTERNAL,
	RESUME_INTERNAL,
	RESUME_LATER,
	RESUME_WAIT,
	RESUME_START,
	RESUME_ON,
	RESUME_OFF,
	RESUME_ESOF
} RESUME_STATE;

typedef enum _DEVICE_STATE{
	UNCONNECTED,
	ATTACHED,
	POWERED,
	DEFAULT,
	ADDRESSED,
	CONFIGURED
} DEVICE_STATE;

extern volatile BYTE bDeviceState; /* USB device status */
extern DWORD dwLedVal; /* alpha-display value */
extern volatile BOOL fSuspendEnabled;  /* true when suspend is possible */

/* function prototypes */
void Suspend(void);
void Resume_Init(void);
void Resume(RESUME_STATE eResumeSetVal);

/******************* (C) COPYRIGHT 2006 STMicroelectronics *****END OF FILE****/
