/******************** (C) COPYRIGHT 2006 STMicroelectronics ********************
* File Name          : voicerecorder.h
* Author             : MCD Application Team
* Date First Issued  : 03/10/2006
* Description        : This file contains all the functions prototypes for the
*                      voice recorder software driver.
********************************************************************************
* History:
* 07/17/2006 : V1.0
* 03/10/2006 : V0.1
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/


/* Define to prevent recursive inclusion ---------------------------------------*/
#ifndef __VOICERECORDER_H
#define __VOICERECORDER_H

/* Includes --------------------------------------------------------------------*/
#include "75x_lib.h"

/* Exported types --------------------------------------------------------------*/
/* Exported constants ----------------------------------------------------------*/
#define MaxRecordDataLength    0xB0000  /* Max SMI size dedicated for voice recording */
                                        /* in this case 11sector*64Kbit (~=30sec) */

#define MaxBoardTestDataLength 0x10000  /* Max SMI size dedicated for bord test recording */

/* Exported macro --------------------------------------------------------------*/
/* Exported functions ----------------------------------------------------------*/
void VoiceRec_Init(void);
void VoiceRec_Start(void);
void VoiceRec_Stop(void);
void VoiceRec_SMIErase(void);
void VoiceRec_GlobalVarReset(void);

#endif /*__VOICERECORDER_H */

/******************* (C) COPYRIGHT 2006 STMicroelectronics *****END OF FILE******/
