/******************** (C) COPYRIGHT 2006 STMicroelectronics ********************
* File Name          : joystickHID.c
* Author             : MCD Application Team
* Date First Issued  : 03/10/2006
* Description        : This file includes the joystickHID driver for the 
*                      STR75x-EVAL demonstration. 
********************************************************************************
* History:
* 07/17/2006 : V1.0
* 03/10/2006 : V0.1
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "main.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/

// directions of transfer for CopyBuffer
#define USR_TO_PMA 0
#define PMA_TO_USR 1

// key codes for direction
#define  KEY_NOKEY  0
#define  KEY_SEL    1
#define  KEY_RIGHT  2
#define  KEY_LEFT   3
#define  KEY_UP     4
#define  KEY_DOWN   5

#define CURSOR_STEP     10
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/


/*******************************************************************************
* Function Name  : JoyStickHID_Init
* Description    : Initializes JoyStick HID application.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void JoyStickHID_Init(void)
{
  wInterrupt_Mask = IMR_MSK;
}

/*******************************************************************************
* Function Name : CopyBuffer
* Description   : Transfers a packet of data from/to PMA to/from user memory
* Input 1       : iTrDirection: USR_TO_PMA or PMA_TO_USR
* Input 2       : EpNum: endpoint number
* Input 3       : Usr_buffer: a pointer to user memory
* Input 4       : Nbytes: number of bytes to transfer
* Output        : None
* Return value  : None
*******************************************************************************/
void CopyBuffer(int iTrDirection, BYTE EpNum, BYTE *Usr_buffer, int Nbytes)
{
  DWORD *pTxBuff;
  WORD wTra;
  BYTE *pbTra;
  int i;

  if (iTrDirection == USR_TO_PMA)
  {
    pTxBuff = (DWORD *)(PMAAddr + (BYTE *)(GetEPTxAddr(EpNum)*2));
   	for(i = 0; i < Nbytes;)
   	{
	   	pbTra = (BYTE *)&wTra;
   		*pbTra++ = *Usr_buffer++;
   		i++;
   		if (i < Nbytes) /* check for ODD transfers */
	   		*pbTra = *Usr_buffer++;
	   	else
	   		*pbTra = 0;
   		*pTxBuff++ = wTra;
	   	i++;
	}
  }

} /* CopyBuffer */


/*******************************************************************************
* Function Name : Mouse_Send
* Description   : Decodes commands arriving from serial and
*                 prepares buffer to be sent containing mouse event infos
* Input         : Keys: keys received from terminal
* Output        : None
* Return value  : None
*******************************************************************************/
void Mouse_Send(BYTE Keys)
{
  BYTE Mouse_Buffer[3] = {0,0,0};
  char X = 0, Y = 0;

  switch (Keys)
  {
	case KEY_LEFT:
	  X -= CURSOR_STEP;
	  break;
	case KEY_RIGHT:
	  X += CURSOR_STEP;
	  break;
	case KEY_UP:
	  Y -= CURSOR_STEP;
	  break;
	case KEY_DOWN:
	  Y += CURSOR_STEP;
	  break;
	default:
	  return;
  }

  /* prepare buffer to send */
  Mouse_Buffer[1] = X;
  Mouse_Buffer[2] = Y;
  CopyBuffer(USR_TO_PMA, ENDP1, Mouse_Buffer, 3);

  /* enable endpoint for transmission */
  SetEPTxAddr(ENDP1, ENDP1_TXADDR);
  SetEPTxCount(ENDP1, 4);
  SetEPTxValid(ENDP1);

} /* Mouse_Send */

/*******************************************************************************
* Function Name  : ReadUSBKeys
* Description    : Reads key from demoboard.
* Input          : None
* Output         : None
* Return         : Return KEY_RIGHT, KEY_LEFT, KEY_SEL, KEY_UP, KEY_DOWN or KEY_NOKEY
*******************************************************************************/
u8 ReadUSBKeys (void)
{
  /* "RIGHT" key is pressed */
  if(!GPIO_ReadBit(GPIO1, GPIO_Pin_13))
  {
       return KEY_RIGHT;
  }
  /* "LEFT" key is pressed */
  if(!GPIO_ReadBit(GPIO1, GPIO_Pin_12))
  {
      return KEY_LEFT;
  }
  /* "SEL" key is pressed */
  if(!GPIO_ReadBit(GPIO0, GPIO_Pin_2))
  {
    return KEY_SEL;
  }
  /* "UP" key is pressed */
  if(!GPIO_ReadBit(GPIO0, GPIO_Pin_8))
  {
        return KEY_UP;
  }
  /* "DOWN" key is pressed */
  if(!GPIO_ReadBit(GPIO1, GPIO_Pin_7))
  {
       return KEY_DOWN;
  }
  /* No key is pressed */
  else
  {
    return KEY_NOKEY;
  }
}

/*******************************************************************************
* Function Name  : JoyStickHID_Start
* Description    : Starts the joystick HID demo.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void JoyStickHID_Start (void)
{
  /* Clear the LCD screen */
  LCD_Clear();
  /* Display the "  Plug the USB   " message */
  LCD_DisplayString(Line1, "  Plug the USB   ", BlackText);
  /* Display the "  cable          " message */
  LCD_DisplayString(Line2, "      cable      ", BlackText);
  /* Intialize the USB cell */
  USB_Init();
  /* Clear the LCD screen */
  LCD_Clear();
  /* Display the "Move the Joystick" message */
  LCD_DisplayString(Line1, "Move the Joystick", BlackText);
  /* Display the "To stop Press SEL" message */
  LCD_DisplayString(Line2, "To stop Press SEL", BlackText);
  /* Loop until SEL key pressed */
  while(ReadUSBKeys() != KEY_SEL)
  {
    /* Move the cursor according the read Joystixk Key */
    Mouse_Send(ReadUSBKeys());
  }
  /* Display the menu */
  DisplayMenu();
}

/******************* (C) COPYRIGHT 2006 STMicroelectronics *****END OF FILE****/
