/******************** (C) COPYRIGHT 2006 STMicroelectronics ********************
* File Name          : lowpower.c
* Author             : MCD Application Team
* Date First Issued  : 03/10/2006
* Description        : This file includes the low power driver for the STR75x-EVAL
*                      demonstration. 
********************************************************************************
* History:
* 07/17/2006 : V1.0
* 03/10/2006 : V0.1
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "main.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/

  /* Peripherals InitStructure define */
  extern GPIO_InitTypeDef   GPIO_InitStructure;
  extern EXTIT_InitTypeDef  EXTIT_InitStructure;

  vu32 STOPModeStatus = 0; /* Low Power Stop mode global status */

/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/*******************************************************************************
* Function Name  : LowPower_Init
* Description    : Initializes Low Power application. 
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void LowPower_Init(void)
{  
  /* Configure P0.1 as alternate function (MCO) */
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_1;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP;
  GPIO_Init(GPIO0, &GPIO_InitStructure);
  
  /* Enable No Clock Detected interrupt */
  MRCC_ITConfig(MRCC_IT_NCKD, ENABLE); 

  /* Set BKP1 register value */
  MRCC_WriteBackupRegister(MRCC_BKP1, 0xFFFFFFFF);
}

/*******************************************************************************
* Function Name  : SetSysClockTo60
* Description    : Sets the system clock to 60 MHz, using the external 4 MHz 
*                  oscillator.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void SetSysClockTo60(void)
{
  /* Set CKSYS to 60MHz */
  MRCC_CKSYSConfig(MRCC_CKSYS_OSC4MPLL, MRCC_PLL_Mul_15);
}

/*******************************************************************************
* Function Name  : SetSysClockTo56
* Description    : Sets the system clock to 56 MHz, using the external 4 MHz 
*                  oscillator.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void SetSysClockTo56(void)
{    
  /* Set CKSYS to 56 MHz */
  MRCC_CKSYSConfig(MRCC_CKSYS_OSC4MPLL, MRCC_PLL_Mul_14);
}

/*******************************************************************************
* Function Name  : SetSYSClockTo48
* Description    : Sets the system clock to 48 MHz, using the external 4 MHz 
*                  oscillator.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void SetSysClockTo48(void)
{    
  /* Set CKSYS to 48 MHz */
  MRCC_CKSYSConfig(MRCC_CKSYS_OSC4MPLL, MRCC_PLL_Mul_12);  
}

/*******************************************************************************
* Function Name  : SetSysClockTo4
* Description    : Sets the system clock to 4 MHz, using the external 4 MHz 
*                  oscillator.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void SetSysClockTo4(void)
{   
  /* Set CKSYS to 4 MHz */
  MRCC_CKSYSConfig(MRCC_CKSYS_OSC4M, MRCC_PLL_NoChange);
}

/*******************************************************************************
* Function Name  : EnterSTOPMode_EXTIT
* Description    : Enters MCU in STOP mode. The wake-up from STOP mode is 
*                  performed by an external interrupt.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void EnterSTOPMode_EXTIT(void)
{  
  /* Set STOPModeStatus to exit STOP mode by pressing "KEY" */  
  STOPModeStatus = 1;

  /* Store time before STOP mode entrance: to detect a missed alarm */
  MRCC_WriteBackupRegister(MRCC_BKP1, RTC_GetCounter());
 
  /* Clear the interrupt pending bit line 7 */
  EXTIT_ClearITPendingBit(EXTIT_ITLine7);
  /* Enable EXTIT line 7 on falling edge */
  EXTIT_InitStructure.EXTIT_ITLine = EXTIT_ITLine7;
  EXTIT_InitStructure.EXTIT_ITTrigger = EXTIT_ITTrigger_Falling;
  EXTIT_InitStructure.EXTIT_ITLineCmd = ENABLE;
  EXTIT_Init(&EXTIT_InitStructure);

  /* Enter STOP mode(FLASH on, OSC4M on, MVREG on) */
  MRCC_EnterSTOPMode(MRCC_STOPParam_Default);    

  /* Check if there is a missed Alarm: Display message */
  Alarm_Check();

  /* Disable EXTIT line 7 on falling edge */
  EXTIT_InitStructure.EXTIT_ITLine = EXTIT_ITLine7;
  EXTIT_InitStructure.EXTIT_ITLineCmd = DISABLE;
  EXTIT_Init(&EXTIT_InitStructure);   
}

/*******************************************************************************
* Function Name  : EnterSTOPMode_RTCAlarm
* Description    : Enters MCU in STOP mode. The wake-up from STOP mode is 
*                  performed by an RTC Alarm.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void EnterSTOPMode_RTCAlarm(void)
{  
  /* Display the current time as alarm value: to be adjusted */
  MRCC_WriteBackupRegister(MRCC_BKP0, RTC_GetCounter());

  /* Clear EXTIT Line15 pending bit */
  EXTIT_ClearITPendingBit(EXTIT_ITLine15);
  /* Enable EXTIT line 15 on rising edge */
  EXTIT_InitStructure.EXTIT_ITLine = EXTIT_ITLine15;
  EXTIT_InitStructure.EXTIT_ITTrigger = EXTIT_ITTrigger_Rising;
  EXTIT_InitStructure.EXTIT_ITLineCmd = ENABLE;
  EXTIT_Init(&EXTIT_InitStructure);

  /* Set the RTC Alarm Register */
  Alarm_Adjust();

  /* Displayed while waiting Alarm */
  LCD_DisplayString(Line2, " Wait for ALARM  ", BlackText);

  /* Enter STOP mode(FLASH on, OSC4M on, MVREG on) */
  MRCC_EnterSTOPMode(MRCC_STOPParam_Default);    
  
  /* Clear EXTIT Line15 pending bit: "WAKUP" pushbutton or RTC Alarm */
  EXTIT_ClearITPendingBit(EXTIT_ITLine15);
  
  /* Display current menu */
  DisplayMenu();
  
  /* Disable EXTIT line 15 */
  EXTIT_InitStructure.EXTIT_ITLine = EXTIT_ITLine15;
  EXTIT_InitStructure.EXTIT_ITLineCmd = DISABLE;
  EXTIT_Init(&EXTIT_InitStructure);
}

/*******************************************************************************
* Function Name  : EnterSTANDBYMode_WAKEUP
* Description    : Enters MCU in STANDBY mode. The wake-up from STANDBY mode is 
*                  performed when a rising edge is detected on WKP_STDBY pin.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void EnterSTANDBYMode_WAKEUP(void)
{     
  /* Store time before STANDBY mode entrance: to detect a missed alarm */
  MRCC_WriteBackupRegister(MRCC_BKP1, RTC_GetCounter());

  /* Clear WKP flag */
  MRCC_ClearFlag(MRCC_FLAG_WKP);

  /* Enter STANDBY mode */
  MRCC_EnterSTANDBYMode();       
}

/*******************************************************************************
* Function Name  : EnterSTANDBYMode_RTCAlarm
* Description    : Enters MCU in STANDBY mode. The wake-up from STANDBY mode is 
*                  performed by an RTC Alarm event.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void EnterSTANDBYMode_RTCAlarm(void)
{  
  /* Display the current time as alarm value */
  MRCC_WriteBackupRegister(MRCC_BKP0, RTC_GetCounter());

  /* Wait until last write operation on RTC registers has finished */
  RTC_WaitForLastTask();
  /* Clear RTC Alarm */
  RTC_ClearFlag(RTC_FLAG_Alarm | RTC_FLAG_Second);  

  /* Set the RTC Alarm Register */
  Alarm_Adjust();

  /* Displayed while waiting Alarm */
  LCD_DisplayString(Line1, "  STANDBY Mode   ", WhiteText);
  LCD_DisplayString(Line2, " Wait for ALARM  ", BlackText);

  /* Clear WKP flag */
  MRCC_ClearFlag(MRCC_FLAG_WKP);
     
  /* Enter STANDBY mode */
  MRCC_EnterSTANDBYMode(); 
}

/******************* (C) COPYRIGHT 2006 STMicroelectronics *****END OF FILE****/
