/******************** (C) COPYRIGHT 2006 STMicroelectronics ********************
* File Name          : main.c
* Author             : MCD Application Team
* Date First Issued  : 03/10/2006
* Description        : Main program body
********************************************************************************
* History:
* 07/17/2006 : V1.0
* 03/10/2006 : V0.1
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "main.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/

  /* ST Logo to display on all 122*32 dot matrix */
  u8 STLogo122[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xC0, 0xE0, 0xF0, 0xF8,
  0xFC, 0xFC, 0xFC, 0xFC, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x3C, 0x3C, 0x3C,
  0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C,
  0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C,
  0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C,
  0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C,
  0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x1C, 0x0C,
  0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xC0, 0xE0, 0xF0, 0xF8, 0xFC, 0xFE, 0xFF,
  0xFF, 0xFF, 0xFF, 0xE7, 0xC1, 0xC1, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x18,
  0x3C, 0x3C, 0x3C, 0x7C, 0x7C, 0x7C, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC,
  0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC,
  0xFC, 0xFC, 0xFC, 0xFC, 0x7C, 0x3C, 0x1C, 0x0C, 0x04, 0x00, 0x00, 0x00, 0x00,
  0x80, 0xC0, 0xE0, 0xF0, 0xF8, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC,
  0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0x7C, 0x3C, 0x1C, 0x0C, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x40, 0x60, 0x70, 0x78, 0x7C, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F,
  0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
  0x7F, 0x7F, 0x7E, 0x7E, 0x7C, 0x7C, 0x78, 0x78, 0x70, 0x70, 0x60, 0x60, 0x00,
  0x00, 0x01, 0x01, 0x01, 0x03, 0x03, 0x87, 0x87, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0x7F, 0x3F, 0x1F, 0x0F, 0x07, 0x03, 0x01, 0x00, 0x00, 0x80, 0xC0, 0xE0,
  0xF0, 0xF8, 0xFC, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0x7F, 0x3F, 0x1F, 0x0F, 0x07, 0x03, 0x81, 0xC0, 0xC0, 0xC0, 0x80,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x08, 0x08, 0x08, 0x0C, 0x0C, 0x0C, 0x0E, 0x0E, 0x0E, 0x0F, 0x0F, 0x0F, 0x0F,
  0x0F, 0x0F, 0x07, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0C,
  0x0E, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
  0x0F, 0x0F, 0x0F, 0x07, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x1F,
  0x3F, 0x60, 0x7A, 0x65, 0x3F, 0x1F, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

  /* Peripherals InitStructure define */
  GPIO_InitTypeDef    GPIO_InitStructure ;
  EXTIT_InitTypeDef   EXTIT_InitStructure;
  EIC_IRQInitTypeDef  EIC_IRQInitStructure;
  EIC_FIQInitTypeDef  EIC_FIQInitStructure;
  TB_InitTypeDef      TB_InitStructure;

  extern WAVE_FormatTypeDef  WAVE_FormatPlaying;
  extern WAVE_FormatTypeDef  WAVE_PromoFormat;
  extern u8 STLogo61[];                /* ST Logo on 32*61 pixels */
  vu32 SELStatus = 0;      /* SEL pushbutton global Status */
  vu32 ScreenStatus = 0;   /* Screen saver global Status */
  vu32 LedShowStatus = 0;  /* Led show global Status */
  extern vu32 SMIReadAddr ;  /* SMI read address global address */
  vu16 PlayIntroDelay = 20;  /* Play Intro delay: 2sec */
  extern vu32 RecordStatus;  /* Voice recorder global Status */
  extern volatile ErrorCode WaveFileStatusPromo;  /* SMI wave file load status */
  ErrorStatus OSC4MStartUpStatus01;

/* Private function prototypes -----------------------------------------------*/
/* Interface functions -------------------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/*******************************************************************************
* Function Name  : main
* Description    : main function, where program start.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void main(void)
{

#ifdef DEBUG
  debug();
#endif

  /* Initialize the demonstration application */
  Demo_Init();

  /* Check if there is a missed alarm (if we were in standby mode) */
  Alarm_Check();

  /* Enable Led toggling during all the demonstration application */
  LedShow(ENABLE);

  /* Play the STR750 Intro: ST Logo and STR750 promotion speech */
  PlayIntro();

  /* Initialize screen saver mode: WDG timer */
  ScreenSaver_Init();

  /* Display the first menu item */
  DisplayMenu();

  /* Endless loop: detect SEL pushbutton and screen saver */
  while(1)
  {
    /* If SEL pushbutton is pressed */
    if(SELStatus == 1)
    {
      /* External Interrupt Disable */
      IntExtOnOffConfig(DISABLE);
      /* Disable ScreenSaver */
      ScreenSaver_Cmd(DISABLE);
      /* Execute Sel Function */
      SelFunc();
      /* Enable ScreenSaver */
      ScreenSaver_Cmd(ENABLE);
      /* External Interrupt Enable */
      IntExtOnOffConfig(ENABLE);
      /* Reset SELStatus value */
      SELStatus = 0;
    }
    /* If screen saver is activated */
    if (ScreenStatus == 1)
    {
      /* External Interrupt Disable */
      IntExtOnOffConfig(DISABLE);
      /* Clear all LCD */
      LCD_Clear();
      /* Show screen saver */
      ScreenSaver_Show();
      /* Clear all LCD */
      LCD_Clear();
      /* Recuperate the old display screen before displaying screen saver */
      DisplayMenu();
      /* External Interrupt Enable */
      IntExtOnOffConfig(ENABLE);
      /* Reset ScreenStatus value */
      ScreenStatus = 0;
    }
  }
}

/*******************************************************************************
* Function Name  : Demo_Init
* Description    : Initializes the demonstration application.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void Demo_Init(void)
{
  /*-------------------- System Clock Config ---------------------------------*/
  /* MRCC system reset */
  MRCC_DeInit();

  /* Wait for OSC4M start-up */
  OSC4MStartUpStatus01 = MRCC_WaitForOSC4MStartUp();

  if(OSC4MStartUpStatus01 == SUCCESS)
  {
    /* Set HCLK to 60MHz */
    MRCC_HCLKConfig(MRCC_CKSYS_Div1);

    /* Set CKTIM to 60MHz */
    MRCC_CKTIMConfig(MRCC_HCLK_Div1);

    /* Set PCLK to 30MHz */
    MRCC_PCLKConfig(MRCC_CKTIM_Div2);

    /* Enable Flash Burst mode */
    CFG_FLASHBurstConfig(CFG_FLASHBurst_Enable);

    /* Set CK_SYS to 60 MHz */
    MRCC_CKSYSConfig(MRCC_CKSYS_OSC4MPLL, MRCC_PLL_Mul_15);
  }

  /* Set USB kernel clock to 48 MHz */
  MRCC_CKUSBConfig(MRCC_CKUSB_Internal);

  /*--------------------- I/O Voltage Range ----------------------------------*/
  /* GPIO pins optimized for 3V3 operation */
  MRCC_IOVoltageRangeConfig(MRCC_IOVoltageRange_3V3);

  /*------------------ Peripheral Clock Enable -------------------------------*/
  /* GPIO clock source enable */
  MRCC_PeripheralClockConfig(MRCC_Peripheral_GPIO, ENABLE);
  /* ADC clock source enable */
  MRCC_PeripheralClockConfig(MRCC_Peripheral_ADC, ENABLE);
  /* TIM0, TIM1 and TIM2 clocks sources enable */
  MRCC_PeripheralClockConfig(MRCC_Peripheral_TIM0 | MRCC_Peripheral_TIM1 |
                             MRCC_Peripheral_TIM2, ENABLE);
  /* EXTIT clock source enable */
  MRCC_PeripheralClockConfig(MRCC_Peripheral_EXTIT, ENABLE);
  /* TB clock source enable */
  MRCC_PeripheralClockConfig(MRCC_Peripheral_TB, ENABLE);
  /* USB clock source enable */
  MRCC_PeripheralClockConfig(MRCC_Peripheral_USB, ENABLE);

  /*------------------- Drivers Initialization -------------------------------*/
  /* SMI Configuration; this function is called before any access to the SMI FALSH */
  SMI_FLASH_Init();
  /* Initialize Leds */
  LedShow_Init();
  /* Interrupt Config */
  InterruptConfig();
  /* Initialize the demonstration menu */
  Menu_Init();
  /* Initialize LCD driver */
  LCD_Init();
  /* Initialize low power application */
  LowPower_Init();
  /* Initialize time application */
  Calendar_Init();
  /* Initialize voice recorder application */
  VoiceRec_Init();
  /* Initialize Wave Player application */
  WavePlayer_Init();
  /* Initialize System timer */
  SystemTimer_Init();
  /* Initialize Period measure application */
  PeriodMeasure_Init();
  /* Initialize Joystick mouse application */
  JoyStickHID_Init();

  /*--------------------- Interrupts Enable ----------------------------------*/
  /* Enable IRQ output request to CPU */
  EIC_IRQCmd(ENABLE);
  /* Enable FIQ output request to CPU */
  EIC_FIQCmd(ENABLE);
}

/*******************************************************************************
* Function Name  : SystemTimer_Init
* Description    : Implements a system timer that generates an event each 100
*                  millisecondes (100ms).
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void SystemTimer_Init(void)
{
  /* TB configuration */
  TB_InitStructure.TB_Mode = TB_Mode_Timing;
  TB_InitStructure.TB_CounterMode = TB_CounterMode_Down;
  TB_InitStructure.TB_Prescaler = 0x5A;
  TB_InitStructure.TB_AutoReload = 0xFFFF;
  TB_Init(&TB_InitStructure);
  /* Enable TB Update interrupt */
  TB_ITConfig(TB_IT_Update, ENABLE);
  /* Clear TB Update interrupt pending bit */
  TB_ClearITPendingBit(TB_IT_Update);
  /* Enable TB */
  TB_Cmd(ENABLE);
}

/*******************************************************************************
* Function Name  : LedShow_Init
* Description    : Configure the leds pins as output pushpull: LED2, LED3, LED4
*                  and LED5
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void LedShow_Init(void)
{
  /* Configure LED3 */
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_16;
  GPIO_Init(GPIO0,&GPIO_InitStructure);
  /* Configure LED2 */
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_1;
  GPIO_Init(GPIO1, &GPIO_InitStructure);
  /* Configure LED4 and LED5 */
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_18 | GPIO_Pin_19;
  GPIO_Init(GPIO2, &GPIO_InitStructure);
}

/*******************************************************************************
* Function Name  : LedShow
* Description    : Enables or disables LED2, LED3, LED4 and LED5 toggling
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void LedShow(FunctionalState NewState)
{
  /* Enable LEDs toggling */
  if(NewState == ENABLE)
  {
    LedShowStatus = 1;
  }
  /* Disable LEDs toggling */
  else
  {
    LedShowStatus = 0;
  }
}

/*******************************************************************************
* Function Name  : PlayIntro
* Description    : Draw ST Logo on all LCD and play STR750 promotion speech at
*                  demonstartion startup
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void PlayIntro(void)
{
  WAVE_FormatPlaying = WAVE_PromoFormat;

  /* Set SMI start read address on first STR750 promotion speech data  */
  SMIReadAddr = IntroReadAddr;
  
  /* Start playing STR750 promotion speech */
  WavePlayer_Start();
  
  /* Initialize */
  PlayIntroDelay = 20;
  /* Clear entire display */
  LCD_Clear();
  /* Display ST Logo */
  LCD_DrawGraphic(STLogo122);
  /* Wait 2sec */
  while(PlayIntroDelay != 0);
  /* Reinitialize PlayIntroDelay value */
  PlayIntroDelay = 20;
  /* Clear entire display */
  LCD_Clear();
  /* Display "  Welcome to the " message */
  LCD_DisplayString(Line1, "  Welcome to the ", BlackText);
  /* Display "   STR750 Demo   " message */
  LCD_DisplayString(Line2, "   STR750 Demo   ", BlackText);
  /* Wait 2sec */
  while(PlayIntroDelay != 0);
  /* If the STR750 promotion speech wave file is available in the SMI FLASH */
  if(WaveFileStatusPromo == Valid_WAVE_File)
  {
    /* Reinitialize PlayIntroDelay value */
    PlayIntroDelay = 20;
    /* Clear entire display */
    LCD_Clear();
    /* Display "To Skip" message */
    LCD_DisplayString(Line1, "         To Skip:", BlackText);
    /* Display "Press SEL" message */
    LCD_DisplayString(Line2, "         Push SEL", BlackText);
    /* Display ST Logo on 32*61 pixels */
    LCD_DrawMasterGraphic(STLogo61);

    /* Wait any press on joystick pushbuttons to skip Intro */
    /* Or wait the end of Intro playing: no key was pressed */
    while((ReadKey() != SEL) && (RecordStatus == 0))
    {
      /* Disable ScreenSaver */
      ScreenSaver_Cmd(DISABLE);
    }
  }
  /* If all wave file was played and stopped don't stop it again */
  if(RecordStatus == 0)
  {
    /* Stop playing STR750 promotion speech */
    WavePlayer_Stop();
  }

  if(WaveFileStatusPromo != Valid_WAVE_File)
  {
    /* Simulate 2 Right push button action: to show "Help" menu  */
    RightFunc();
    RightFunc();
  }
  /* External Interrup Enable */
  IntExtOnOffConfig(ENABLE);
}


/*******************************************************************************
* Function Name  : InterruptConfig
* Description    : Configure the used IRQChannel and set their priority
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void InterruptConfig(void)
{
  /*---------------------- FIQ Interrupts -----------------------*/
  /* Clear the EXTIT Line0 pending bit */
  EXTIT_ClearITPendingBit(EXTIT_ITLine0);
  /* Enable EXTIT for "SEL" pushbutton */
  EIC_FIQInitStructure.EIC_FIQChannel = EXTIT_Line0_FIQChannel;
  EIC_FIQInitStructure.EIC_FIQChannelCmd = ENABLE;
  EIC_FIQInit(&EIC_FIQInitStructure);

  /* Clear WDG end of Count interrupt pending bit */
  WDG_ClearITPendingBit();
  /* Enable the WDG FIQ Channel */
  EIC_FIQInitStructure.EIC_FIQChannel = WATCHDOG_FIQChannel;
  EIC_FIQInit(&EIC_FIQInitStructure);

  /*---------------------- IRQ Interrupts -----------------------*/
  /* Enable and configure the priority of the RTC IRQ Channel */
  EIC_IRQInitStructure.EIC_IRQChannel = RTC_IRQChannel;
  EIC_IRQInitStructure.EIC_IRQChannelPriority = 15;
  EIC_IRQInitStructure.EIC_IRQChannelCmd = ENABLE;
  EIC_IRQInit(&EIC_IRQInitStructure);

  /* Enable and configure the priority of the MRCC IRQ Channel */
  EIC_IRQInitStructure.EIC_IRQChannel = MRCC_IRQChannel;
  EIC_IRQInitStructure.EIC_IRQChannelPriority = 14;
  EIC_IRQInit(&EIC_IRQInitStructure);

  /* Enable and configure the priority of the EXTIT IRQ Channel */
  EIC_IRQInitStructure.EIC_IRQChannel = EXTIT_IRQChannel;
  EIC_IRQInitStructure.EIC_IRQChannelPriority = 4;
  EIC_IRQInit(&EIC_IRQInitStructure);

  /* Enable and configure the priority of the TIM0 IRQ Channel */
  EIC_IRQInitStructure.EIC_IRQChannel = TIM0_UP_IRQChannel;
  EIC_IRQInitStructure.EIC_IRQChannelPriority = 3;
  EIC_IRQInit(&EIC_IRQInitStructure);

  /* Enable and configure the priority of the USB_LP IRQ Channel*/
  EIC_IRQInitStructure.EIC_IRQChannel = USB_LP_IRQChannel;
  EIC_IRQInitStructure.EIC_IRQChannelPriority = 2;
  EIC_IRQInit(&EIC_IRQInitStructure);

  /* Enable and configure the priority of the TB IRQ Channel */
  EIC_IRQInitStructure.EIC_IRQChannel = TB_IRQChannel;
  EIC_IRQInitStructure.EIC_IRQChannelPriority = 1;
  EIC_IRQInit(&EIC_IRQInitStructure);
}

/*******************************************************************************
* Function Name  : KeyButtonOn
* Description    : Enable EXTIT for Key pushbutton
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void KeyButtonOn(void)
{
  /* Clear the interrupt pending bit line 7 */
  EXTIT_ClearITPendingBit(EXTIT_ITLine7);
  /* Enable EXTIT for Key pushbutton on falling edge */
  EXTIT_InitStructure.EXTIT_ITLine = EXTIT_ITLine7;
  EXTIT_InitStructure.EXTIT_ITTrigger = EXTIT_ITTrigger_Falling;
  EXTIT_InitStructure.EXTIT_ITLineCmd = ENABLE;
  EXTIT_Init(&EXTIT_InitStructure);
}

/*******************************************************************************
* Function Name  : KeyButtonOff
* Description    : Disable EXTIT for Key pushbutton
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void KeyButtonOff(void)
{
  /* Disable EXTIT for Key pushbutton */
  EXTIT_InitStructure.EXTIT_ITLine = EXTIT_ITLine7;
  EXTIT_InitStructure.EXTIT_ITLineCmd = DISABLE;
  EXTIT_Init(&EXTIT_InitStructure);
}

/*******************************************************************************
* Function Name  : IntExtOnOffConfig
* Description    : Enables or disables EXTIT for the menu navigation keys :
*                  EXTIT lines 0, 3, 8, 12 and 13 which correpond respectively
*                  to "SEL", "UP", "DOWN", "LEFT" and "RIGHT".
* Input          : NewState: New state of the navigation keys. This parameter
*                  can be: ENABLE or DISABLE.
* Output         : None
* Return         : None
*******************************************************************************/
void IntExtOnOffConfig(FunctionalState NewState)
{
  /* Disable the EXTIT line 0, 3, 8, 12 and 13 on falling edge */
  if(NewState == DISABLE)
  {
    EXTIT_InitStructure.EXTIT_ITLine = EXTIT_ITLine0 | EXTIT_ITLine3 |
                                       EXTIT_ITLine8 | EXTIT_ITLine12 |
                                       EXTIT_ITLine13;
    EXTIT_InitStructure.EXTIT_ITLineCmd = DISABLE;
    EXTIT_Init(&EXTIT_InitStructure);
  }
  /* Enable the EXTIT line 0, 3, 8, 12 and 13 on falling edge */
  else
  {
    /* Clear the the EXTIT line 0, 3, 8, 12 and 13 interrupt pending bit */
    EXTIT_ClearITPendingBit(EXTIT_ITLine0 | EXTIT_ITLine3 | EXTIT_ITLine8 |
                            EXTIT_ITLine12 | EXTIT_ITLine13);
    EXTIT_InitStructure.EXTIT_ITLine = EXTIT_ITLine0 | EXTIT_ITLine3 |
                                       EXTIT_ITLine8 | EXTIT_ITLine12 |
                                       EXTIT_ITLine13;
    EXTIT_InitStructure.EXTIT_ITTrigger = EXTIT_ITTrigger_Falling;
    EXTIT_InitStructure.EXTIT_ITLineCmd = ENABLE;
    EXTIT_Init(&EXTIT_InitStructure);
  }
}

/*******************************************************************************
* Function Name  : Delay
* Description    : Inserts a delay time.
* Input          : nCount: specifies the delay time length.
* Output         : None
* Return         : None
*******************************************************************************/
void Delay(u32 nCount)
{
  /* Decrement nCount value */
  for(; nCount != 0; nCount--);
}

/******************* (C) COPYRIGHT 2006 STMicroelectronics *****END OF FILE****/
