/******************** (C) COPYRIGHT 2006 STMicroelectronics ********************
* File Name          : periodmeasure.c
* Author             : MCD Application Team
* Date First Issued  : 03/10/2006
* Description        : This file includes the period measure driver for the
*                      STR75x-EVAL demonstration.
********************************************************************************
* History:
* 07/17/2006 : V1.0
* 03/10/2006 : V0.1
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "main.h"
#include "75x_lib.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/

  /* Peripherals InitStructure define */
  extern TIM_InitTypeDef  TIM_InitStructure;
  GPIO_InitTypeDef        GPIO0_InitStructure;

  u16 TIMCounter = 0;           /* TIM1 counter value */
  u16 SignalFrequency = 0;      /* Signal Frequency value */
  u16 SignalDuty = 0;           /* Signal Duty cycle value */
  vu16 PeriodmeasureDelay = 0;  /* Counter for period mesure values refresh */

/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/*******************************************************************************
* Function Name  : PeriodMeasure_Init
* Description    : Initializes the period measure application
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void PeriodMeasure_Init(void)
{
  /* TIM1_TI2 (P0.31) configuration */
  GPIO0_InitStructure.GPIO_Mode = GPIO_Mode_IN_FLOATING;
  GPIO0_InitStructure.GPIO_Pin = GPIO_Pin_31;
  GPIO_Init(GPIO0, &GPIO0_InitStructure);

  /* TIM1 configuration */
  TIM_InitStructure.TIM_Mode = TIM_Mode_PWMI;
  TIM_InitStructure.TIM_CounterMode = TIM_CounterMode_Up;
  TIM_InitStructure.TIM_Prescaler = 0x1;
  TIM_InitStructure.TIM_Period = 0xFFFF;
  TIM_InitStructure.TIM_ClockSource = TIM_ClockSource_Internal;
  TIM_InitStructure.TIM_PWMI_ICSelection = TIM_PWMI_ICSelection_TI2;
  TIM_InitStructure.TIM_PWMI_ICPolarity = TIM_PWMI_ICPolarity_Falling;
  TIM_Init(TIM1, &TIM_InitStructure);
  /* Clear all TIM1 flags */
  TIM_ClearFlag(TIM1, TIM_FLAG_OC1| TIM_FLAG_OC2| TIM_FLAG_Update|
                TIM_FLAG_IC1|TIM_FLAG_IC2);
  /* Enable TIM1 update interrupt */
  TIM_ITConfig(TIM1, TIM_IT_Update, ENABLE);
}

/*******************************************************************************
* Function Name  : PeriodMeasure_Start
* Description    : Starts period measurement
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void PeriodMeasure_Start(void)
{
  /* Start TIM1 counter */
  TIM_Cmd(TIM1, ENABLE);

  /* Clear TIM1 flags */
  TIM_ClearFlag(TIM1, TIM_FLAG_IC1 | TIM_FLAG_IC2 | TIM_FLAG_Update);

  /* Dispaly " Exit: UP / Down " on Line2 */
  LCD_DisplayString(Line2, " Exit: UP / Down ", BlackText);

  /* Wait any press on "UP" or "DOWN" pushbuttons */
  while((ReadKey() & UP) != UP)
  {
    /* Check if there is no signal on TIM1_TI2 (P0.31) pin */
    if((TIM_GetFlagStatus(TIM1, TIM_FLAG_IC1) == RESET)&&
    (TIM_GetFlagStatus(TIM1, TIM_FLAG_IC2) == RESET))
    {
      /* If no signal is detected, display "no signal" */
      LCD_DisplayString(Line1, "  !!no signal!!  ", BlackText);
      /* Dispaly " Exit: UP / Down " on Line2 */
      LCD_DisplayString(Line2, " Exit: UP / Down ", BlackText);
    }

    /* On each TIM1 period */
    if(TIM_GetFlagStatus(TIM1, TIM_FLAG_Update) == SET)
    {
      if(TIM_GetFlagStatus(TIM1, TIM_FLAG_IC1) == SET)
      {
        /* If no IC2 is detected, display "out of range" */
        LCD_DisplayString(Line1, "  Out of range!! ", BlackText);
        LCD_DisplayString(Line2, " Freq < 458 HZ   ", BlackText);    	
      }
    }
    else
    {
      if((TIM_GetFlagStatus(TIM1, TIM_FLAG_IC1) == SET) &&
         (TIM_GetFlagStatus(TIM1, TIM_FLAG_IC2) == SET))
      {	
        /* Capture the period value */
        TIMCounter = TIM_GetPWMIPeriod(TIM1);

        /* Calculate the frequency and the duty cycle values */
        SignalFrequency = (30000000 / TIMCounter);
        SignalDuty = ((TIMCounter-TIM_GetPWMIPulse(TIM1))*100 / TIMCounter);

        if(SignalFrequency >= 10000)
        {
          /* If frequency > 10 KHz display "out of range " */
          LCD_DisplayString(Line1, " Out of range!!  ", BlackText);
          LCD_DisplayString(Line2, " Freq > 10 KHz   ", BlackText);
        }
        else
        {
          /* Display the corresponding frequency and duty cycle */
          LCD_DisplayString(Line1, "Duty Cycle:    % ", BlackText);
          LCD_DisplayChar(Line1, 91, (SignalDuty/10)+48, BlackText);
          LCD_DisplayChar(Line1, 98, (SignalDuty%10)+48, BlackText);                    	
          LCD_DisplayString(Line2, "Freq:         Hz ", BlackText);
          LCD_DisplayChar(Line2, 63, ((SignalFrequency%10000)/1000)+48, BlackText);
          LCD_DisplayChar(Line2, 70, ((SignalFrequency%1000)/100)+48, BlackText);
          LCD_DisplayChar(Line2, 77, ((SignalFrequency%100)/10)+48, BlackText);
          LCD_DisplayChar(Line2, 84, (SignalFrequency%10)+48, BlackText);
        }
      }
    }
    /* Clear pending bit to prepare the new capture */
    TIM_ClearFlag(TIM1, TIM_FLAG_IC1 | TIM_FLAG_IC2 | TIM_FLAG_Update);

    /* Wait 600 ms */
    while(PeriodmeasureDelay < PeriodSampling)
    {
      /* If any press on "UP" or "DOWN" pushbuttons is detected */
      if((ReadKey() & UP) == UP)
      {
        /* Execute UpDownFunc function to display the upper menu */
        UpDownFunc();
        /* Exit the while loop */
        return;
      }
    }
  }
  /* Execute UpDownFunc function to display the upper menu */
  UpDownFunc();
}

/*******************************************************************************
* Function Name  : PeriodMeasure_Stop
* Description    : Stops period measurement
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void PeriodMeasure_Stop(void)
{
  /* Stop TIM1 counter */
  TIM_Cmd(TIM1, DISABLE);
}

/******************* (C) COPYRIGHT 2006 STMicroelectronics *****END OF FILE****/
