/******************** (C) COPYRIGHT 2006 STMicroelectronics ********************
* File Name          : voicerecorder.c
* Author             : MCD Application Team
* Date First Issued  : 03/10/2006
* Description        : This file includes the voice recorder driver for the
*                      STR75x-EVAL demonstration.
********************************************************************************
* History:
* 07/17/2006 : V1.0
* 03/10/2006 : V0.1
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "main.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define  SectorSize     0x10000  /* SMI sector size define: 64k */

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/

  /* Peripherals InitStructure define */
  extern EXTIT_InitTypeDef  EXTIT_InitStructure;
  extern GPIO_InitTypeDef   GPIO_InitStructure;
  ADC_InitTypeDef           ADC_InitStructure;

  extern u32 RecordDataLength;        /* Voice recorder global data length */
  extern vu8 SelectedWave;            /* Osiris or recorded wave playing select */
  vu8  VoiceRecord = 0;               /* Boardself test record or voice recordering select */
  extern vu32 SMIWriteAddr;           /* SMI write address global address */
  extern vu32 RecordStatus;  /* Voice recorder global Status */
  extern vu32 AlarmStatus;   /* Alarm melody global status */
  u32 SectorOffset = 0x400000;        /* SMI voice recording sector offset for erasing */
  u32 SelectedMaxRecordDataLength=0;  /* Selected max SMI size dedicated */
                                      /* for voice recording or board test */
  extern u16 PromoTIM0_OCR1_Value;
  
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/*******************************************************************************
* Function Name  : VoiceRec_Init
* Description    : Initialize
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void VoiceRec_Init(void)
{
  /* Configure P1.2 as alternate function (TIM2_OC2) */
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP;
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_2;
  GPIO_Init(GPIO1, &GPIO_InitStructure);

  /* EXTIT for Key pushbutton configuration */
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN_FLOATING;
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_5;
  GPIO_Init(GPIO1, &GPIO_InitStructure);

  /* ADC Channel 15 pin configuration */
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AIN;
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_14 ;
  GPIO_Init(GPIO1, &GPIO_InitStructure);

  /* ADC configuration */
  ADC_InitStructure.ADC_ConversionMode = ADC_ConversionMode_Scan;
  ADC_InitStructure.ADC_ExtTrigger = ADC_ExtTrigger_Disable;
  ADC_InitStructure.ADC_AutoClockOff = ADC_AutoClockOff_Disable;
  ADC_InitStructure.ADC_SamplingPrescaler = 7;
  ADC_InitStructure.ADC_ConversionPrescaler = 7;
  ADC_InitStructure.ADC_FirstChannel = ADC_CHANNEL15;
  ADC_InitStructure.ADC_ChannelNumber = 1;
  ADC_Init(&ADC_InitStructure);

  /* Enable ADC */
  ADC_Cmd(ENABLE);
  /* Start calibration */
  ADC_StartCalibration(ADC_CalibAverage_Enable);
}

/*******************************************************************************
* Function Name  : VoiceRec_Start
* Description    : Start Voice recording
* Input          : None
* Output         : None
* Return         : None.
*******************************************************************************/
void VoiceRec_Start(void)
{

  /* Start conversion */
  ADC_ConversionCmd(ADC_Conversion_Start);
  while(!ADC_GetFlagStatus(ADC_FLAG_EOC));

  /* Set TIM0 period to 22050 Hz */
  TIM_SetPeriod(TIM0, 0x1C6);

  /* Enable TIM0 update interrupt */
  TIM_ITConfig(TIM0, TIM_IT_Update, ENABLE);
  /* Start TIM0 */
  TIM_Cmd(TIM0, ENABLE);

  /* Clear Line 2 */
  LCD_ClearLine(Line2);

  /* If we select to play Recorded wave */
  if(VoiceRecord == 1)
  {
    /* Select SelectedMaxRecordDataLength value for voice recording */
    SelectedMaxRecordDataLength = MaxRecordDataLength;
    /* Displayed when recording: to stop recording*/
    LCD_DisplayString(Line2, "Stop: in 30s/KEY ", BlackText);
  }
  /* If we select to play board test wave */
  else
  {
    /* Select SelectedMaxRecordDataLength value for board voice test */
    SelectedMaxRecordDataLength = MaxBoardTestDataLength;
    /* Display " Voice REC Start " to start recording */
    LCD_DisplayString(Line2, "Stop: in 3s/KEY", BlackText);
  }
}

/*******************************************************************************
* Function Name  : VoiceRec_Stop
* Description    : Stop Voice recording
* Input          : None
* Output         : None
* Return         : None.
*******************************************************************************/
void VoiceRec_Stop(void)
{
  /* Disable TIM0 update interrupt */
  TIM_ITConfig(TIM0, TIM_IT_Update, DISABLE);
  /* Disable TIM0 */
  TIM_Cmd(TIM0, DISABLE);

  /* Stop conversion */
  ADC_ConversionCmd(ADC_Conversion_Stop);

  /* Disable Key Button */
  KeyButtonOff();

  /* If we select to play Recorded wave */
  if(VoiceRecord == 1)
  {
    /* Display " Voice REC Start " to start recording */
    LCD_DisplayString(Line2, " Voice REC Start ", BlackText);
    /* External Interrupt Enable */
    IntExtOnOffConfig(ENABLE);
  }
  /* If we select to play board voice test wave */
  else
  {
    /* Display "Play test:UP/DOWN" to start recording */
    LCD_DisplayString(Line2, "Play test:UP/DOWN", BlackText);
  }

  TIM_SetPeriod(TIM0, PromoTIM0_OCR1_Value);
}

/*******************************************************************************
* Function Name  : VoiceRec_SMIErase
* Description    : Erase the SMI sectors reserved for voice recording
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void VoiceRec_SMIErase(void)
{
  u8 Sect = 0;

  /* Initialize the SMI sector offset for erasing: voice recording */
  SectorOffset = 0x700000;
  /* Stop wave playing: protect the dual SMI Flash access */
  WavePlayer_Stop();
  /* SMI Configuration */
  SMI_FLASH_Init();
  /* Set SMIWriteAddr to the Recorded wave start read write address */
  SMIWriteAddr = RecordReadWritedAddr;
  /* Display SMI erasing message */
  LCD_DisplayString(Line2, "Wait SMI erasing", BlackText);

  /* Wait until last write operation on RTC registers has finished */
  RTC_WaitForLastTask();
  /* Disable RTC Alarm interrupt */
  RTC_ITConfig(RTC_IT_Alarm, DISABLE);

  /* Erase Flash sectors to store voice recording data */
  /* 11 Flash Sectors are allowed for voice recording (704Kbits) ~= 30sec (8bits, mono, 22Khz) */
  for(Sect = 11; Sect != 0; Sect--)
  {
    /* Erase Flash sector */
    SMI_FLASH_SectorErase(SectorOffset);
    /* Select the next Flash sector address to erase */
    SectorOffset += SectorSize;
  }
  RecordDataLength = 0;
  /* If an RTC Alarm is happen during SMI erasing play it now */
  if(RTC_GetFlagStatus(RTC_FLAG_Alarm)!=RESET)
  {
    /* Start Alarm wave playing */
    WavePlayerAlarm_Start();
  }

  /* Wait until last write operation on RTC registers has finished */
  RTC_WaitForLastTask();
  /* Clear RTC Alarm interrupt pending bit */
  RTC_ClearITPendingBit(RTC_IT_Alarm);
  /* Wait until last write operation on RTC registers has finished */
  RTC_WaitForLastTask();
  /* Enable RTC Alarm interrupt bit */
  RTC_ITConfig(RTC_IT_Alarm, ENABLE);

  /* Display message to start voice recording */
  LCD_DisplayString(Line2, "Record:Press KEY", BlackText);

  /* Enable EXTIT for Key pushbutton */
  KeyButtonOn();

  while(RecordStatus != 0);

}

/*******************************************************************************
* Function Name  : VoiceRec_GlobalVarReset
* Description    : Resets the global variable VoiceRecord.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void VoiceRec_GlobalVarReset(void)
{
  /* Set VoiceRecord for voice recording */
  VoiceRecord = 1;
  /* Reset SelectedWave for voice recording */
  SelectedWave = 0;
}
/******************* (C) COPYRIGHT 2006 STMicroelectronics *****END OF FILE****/

