/**************** (c) 2006       STMicroelectronics      **********************
#
# PROJECT  : ST7263B RS232-USB Bridge
# COMPILER : HIWARE or COSMIC for ST7
#
# MODULE  :  Descript.c
# USB LIB VERSION :  4.21
#
# AUTHOR :   MICROCONTROLLER DIVISION / ST Prague
#
#*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : 	USB Descriptors file
				Up to three descriptor sets can be compiled
				
HISTORY : 08/24/00 	-> Modified all descriptors names and lenghts names to better match the spec.				
                    -> Added compiler directive "#ifdef HID_APPLICATION" before Report Desc declaration.
******************************************************************************/   
#include "USB_Opts.h"
#include "Macro.h"
#include "USB_Def.h"
#include "unicode.h"
#include "Descript.h"


/* WARNING: !!! WHEN MODIFYING THIS FILE -->> YOU MUST UPDATE THE Descript.H FILE !!!*/ 

/*******************		Call table to user segments (seg 1 & 2)		***********************/
#pragma DATA_SEG ROM_VAR
const Lib_Tab Descriptors =
{
	Manufacturer_String,
	Language_String,
#ifdef USE_ADD_STRINGS
	Additional_String,
#endif
	P1_Name_String,
	P1_Device_Desc,
	P1_Config_Desc,
#ifdef USE_SERIAL_NUMBER
	P1_Serial_String,
#endif
#ifdef HID_APPLICATION	
	P1_Report_Desc,
#ifdef USE_P1_INTERFACE1
	P1_I1_Report_Desc,
#endif
#endif
#ifdef USE_PRODUCT2	
	P2_Name_String,
	P2_Device_Desc,
	P2_Config_Desc,
#ifdef USE_SERIAL_NUMBER
	P2_Serial_String,
#endif
#ifdef HID_APPLICATION	
	P2_Report_Desc,
#ifdef USE_P2_INTERFACE1
	P2_I1_Report_Desc,
#endif
#endif
#endif
};


/********************************************************************************/
/*				DESCRIPTORS COMMON TO ALL PRODUCTS							  	*/	
/********************************************************************************/

const Byte Manufacturer_String[MANUFSTR_LEN] =	// COMMON TO ALL PRODUCTS
{
	MANUFSTR_LEN,	// Length of manuf String Descriptor 
	0x03,				// DescriptorType
	uS,					// Manufacturer
	uT,
	uM,
	ui,
	uc,
	ur,
	uo,
	ue,
	ul,
	ue,
	uc,
	ut,
	ur,
	uo,
	un,
	ui,
	uc,
	us
};

const Byte Language_String[4] =	// COMMON TO ALL PRODUCTS
{
	0x04,				// Length of String Descriptor
	0x03,				// DescriptorType
	0x09,  
	0x04				// US English
};

#ifdef USE_ADD_STRINGS
// Additional Strings (OPTIONAL) 
const Byte Additional_String[ADDISTR_LEN] = 
{
};      
#endif

/********************************************************************************/
/*				DESCRIPTORS FOR THE PRODUCT1								  	*/	
/********************************************************************************/

const Byte P1_Name_String[P1_NAMESTR_LEN] = 
{
	P1_NAMESTR_LEN,		// Length of Product String Descriptor
	0x03,				// DescriptorType
	uS,
	uT,
	u7,
	uSPACE,
	uR,
	uS,
	u2,
	u3,
	u2,
	uSPACE,
	uU,                 
	uS,
	uB,
	uSPACE,
	uB,
	uR,
	uI,
	uD,
	uG,
	uE
};

#ifdef USE_SERIAL_NUMBER
const Byte P1_Serial_String[P1_SERIALSTR_LEN] = 
{
	P1_SERIALSTR_LEN,	// Length of Serial# String Descriptor
	0x03,				// DescriptorType
	uS,
	uT
};
#endif
               
const Byte P1_Device_Desc[18] = 
{                 
    0x12,     	// bLength
    0x01,     	// bDescriptorType
    0x10,     	// bcdUSB (spec release #)
    0x01,     
    0x00,     	// bDeviceClass
    0x00,     	// bDeviceSubClass
    0x00,     	// bDeviceProtocol
    0x08,     	// bMaxPacketSize0
    0x83,     	// idVendor
    0x04,
    0x35, 		// idProduct 
    0x00,
    0x20,     	// bcdDevice
    0x01,
	INDEX_MANUFACTURER,	// Index of string Descriptor describing manufacturer
	INDEX_NAME,		// Index of string Descriptor describing product
	INDEX_SERIALNUM,	// Index of string Descriptor describing the device's serial number
	0x01				// bNumConfigurations (Only one config)
};
   
const Byte P1_Config_Desc[P1_CONFDESC_LEN] = 
{
	// Configuration descriptor                                                                      
	0x09,		// bLength: Configuration Descriptor size
	0x02,		// bDescriptorType: Configuration
	LOBYTE(P1_CONFDESC_LEN),	// Length of configuration descriptor.
	HIBYTE(P1_CONFDESC_LEN),	// Length of configuration descriptor.
	0x01,		// bNumInterfaces: 1 interface.
	0x01,		// bConfigurationValue: Configuration value = 1
	0,			// iConfiguration: Index of string descriptor describing the configuration (None)
	0x80,		// bmAttributes: Bus powered and NO Remote wakeup
//	0xA0,		// bmAttributes: Bus powered and Remote wakeup
//	0xC0,		// bmAttributes: Self powered and NO Remote wakeup
//	0xE0,		// bmAttributes: Self powered and Remote wakeup
	0x19,		// MaxPower 50 mA
//	0x00,		// 0 mA power consumption.
	// Interface descriptor (Interface 0 = DemoKit)
	0x09,		// bLength: Interface Descriptor size
	0x04,		// bDescriptorType: Interface descriptor type
	0x00,		// bInterfaceNumber: Interface Number = 0
	0x00,		// bAlternateSetting: No Alternate setting
	0x02,		// bNumEndpoints: Two endpoints used
	0x03,		// bInterfaceClass: HID
	0x00,		// bInterfaceSubClass: No subclass
	0x00,		// bInterfaceProtocol: none
	0x00,		// iInterface: Index of string descriptor (No string value)
	// HID descriptor (USB SCI Bridge)
	0x09,		// bLength: HID Descriptor size
	0x21,		// bDescriptorType: HID
	0x10,		// bcdHID(LSB): HID Class Spec release number (1.10)
	0x01,		// bcdHID(MSB)
	0x21,		// bCountryCode: Hardware target country US
	0x01,		// bNumDescriptors: Number of HID class descriptors to follow 
	0x22,		// bDescriptorType: Report
	LOBYTE(P1_REPTDESC_LEN),	// Length of report descriptor interface 0 (2 bytes)
	HIBYTE(P1_REPTDESC_LEN),	// Length of report descriptor interface 0 (2 bytes)
	// Endpoint 1 descriptor (Demokit)
	0x07,		// bLength: Endpoint Descriptor size
	0x05,		// bDescriptorType: Endpoint descriptor type
	0x81,		// bEndpointAddress: Endpoint  1 IN
	0x03,		// bmAttributes: Interrupt endpoint
	0x08,		// wMaxPacketSize(LSB): 8 Byte max (0x0008)
	0x00,		// wMaxPacketSize (MSB)
	0x0A,       // bInterval: Polling Interval (10 ms = 0x0A)
	// Endpoint 2 descriptor (Demokit)
	0x07,		// bLength: Endpoint Descriptor size
	0x05,		// bDescriptorType: Endpoint descriptor type
	0x02,		// bEndpointAddress: Endpoint  2 OUT
	0x03,		// bmAttributes: Interrupt endpoint
	0x08,		// wMaxPacketSize(LSB): 8 Byte max (0x0008)
	0x00,		// wMaxPacketSize (MSB)
	0x0A,       // bInterval: Polling Interval (10 ms = 0x0A)
};

#ifdef HID_APPLICATION	
// Report Descriptors exist only for HID devices
const Byte P1_Report_Desc[P1_REPTDESC_LEN] =	// Report desc Interface 0
{
    0x06, 0x80, 0xff,              // USAGE_PAGE (ST Page)
    0x09, 0x00,                    // USAGE (USB SCI Bridge)
    0xa1, 0x01,                    // COLLECTION (Application)
    0x75, 0x08,                    //   REPORT_SIZE (8)
    0x95, 0x08,                    //   REPORT_COUNT (8)
    0x15, 0x00,                    //   LOGICAL_MINIMUM (0)
    0x26, 0xff, 0x00,              //   LOGICAL_MAXIMUM (255)
    0x09, 0x01,                    //   USAGE (Baud Rate)
    0xb1, 0x82,                    //   FEATURE (Data,Var,Abs,Vol)
    0x09, 0x01,                    //   USAGE (RS in)
    0x81, 0x82,                    //   INPUT (Data,Var,Abs,Vol)
    0x09, 0x02,                    //   USAGE (RS out)
    0x91, 0x82,                    //   OUTPUT (Data,Var,Abs,Vol)
    0xc0                           // END_COLLECTION
};                                                  

#ifdef USE_P1_INTERFACE1
const Byte P1_I1_Report_Desc[P1_I1_REPTDESC_LEN] =	// Report desc Interface 1
{  
};
#endif	// End of Interface 1 section
#endif	// End of HID section
// End of PRODUCT1 section

#ifdef USE_PRODUCT2	
/******************************************************************************************/
/*				DESCRIPTORS FOR A RUN TIME SWITCHABLE SECOND PRODUCT	(PRODUCT2)		  */	
/******************************************************************************************/

const Byte P2_Name_String[P2_NAMESTR_LEN] =     // Product desc
{
	P2_NAMESTR_LEN,		// Length of Product String Descriptor
	0x03,				// DescriptorType
};

#ifdef USE_SERIAL_NUMBER
const Byte P2_Serial_String[P2_SERIALSTR_LEN] = 
{
	P2_SERIALSTR_LEN,	// Length of Serial# String Descriptor
	0x03,				// DescriptorType
};
#endif
               
const Byte P2_Device_Desc[18] =	    // Device desc 
{                 
};
   
const Byte P2_Config_Desc[P2_CONFDESC_LEN] =       // Configuration Descriptor
{
};

#ifdef HID_APPLICATION	
// Report Descriptors exist only for HID devices
const Byte P2_Report_Desc[P2_REPTDESC_LEN] =	// Report desc Interface 0
{
};

#ifdef USE_P2_INTERFACE1			
const Byte P2_I1_Report_Desc[P2_I1_REPTDESC_LEN] = // Report desc Interface 1
{
};
#endif  // End of Interface 1 section 
#endif	// End of HID section
#endif	// End of PRODUCT2 section


/**** (c) 2006 STMicroelectronics *******	END OF FILE	 *******  ST7263B RS232-USB Bridge  ******/