/**************** (c) 2006       STMicroelectronics      **********************
#
# PROJECT  : ST7263B RS232-USB Bridge
# COMPILER : HIWARE or COSMIC for ST7
#
# MODULE  :  Descript.h
# USB LIB VERSION :  4.21
#
# AUTHOR :   MICROCONTROLLER DIVISION / ST Prague
#
#*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : USB Descriptors header file

******************************************************************************/   
#include "lib_bits.h"
#include "USB_Opts.h"

#ifndef Descript_H
#define Descript_H

/********************************************************************************/
/*				DESCRIPTORS COMMON TO ALL PRODUCTS							  	*/	
/********************************************************************************/
#define MANUFSTR_LEN            38		// Manufacturer string length (Byte)
#define ADDISTR_LEN				0	// OPTIONAL: Additional string length (Byte) 
/**********************************************************************************/


/**********************************************************************************/
/*						DESCRIPTORS FOR THE PRODUCT1						  */	
/**********************************************************************************/
#define P1_NAMESTR_LEN      	42		// Product name string length (Byte)
#define P1_SERIALSTR_LEN     	6		// Serial number string length (Byte)
#define P1_CONFDESC_LEN			41		// Total config desc lenght (Word)
#define P1_REPTDESC_LEN			29	// Report desc interface 0 length (Word)
#define P1_I1_REPTDESC_LEN	 	NULL	// OPTIONAL: Report desc interface 1 length (Word)
/**********************************************************************************/


#ifdef USE_PRODUCT2
/**********************************************************************************/
/*				DESCRIPTORS FOR A RUN TIME SWITCHABLE SECOND PRODUCT			  */	
/**********************************************************************************/
#define P2_NAMESTR_LEN      	NULL		// Product name string length (Byte)
#define P2_SERIALSTR_LEN     	NULL		// Serial number string length (Byte)
#define P2_CONFDESC_LEN			NULL		// Total config desc lenght (Word)
#define P2_REPTDESC_LEN			NULL		// Report desc interface 0 length (Word)
#define P2_I1_REPTDESC_LEN	 	NULL		// OPTIONAL: Report desc interface 1 length (Word)
/**********************************************************************************/
#endif


/*******************		Call table to user segments (seg 1 & 2)		***********************/

typedef struct {
	Byte * Manuf;
	Byte * Lang;
#ifdef USE_ADD_STRINGS
	Byte * Add;
#endif
	Byte * P1_Name;
	Byte * P1_Device;
	Byte * P1_Config;
#ifdef USE_SERIAL_NUMBER
	Byte * P1_Serial;
#endif
#ifdef HID_APPLICATION	
	Byte * P1_Report;
#ifdef USE_P1_INTERFACE1
	Byte * P1_I1_Report;
#endif
#endif
#ifdef USE_PRODUCT2	
	Byte * P2_Name;
	Byte * P2_Device;
	Byte * P2_Config;
#ifdef USE_SERIAL_NUMBER
	Byte * P2_Serial;
#endif
#ifdef HID_APPLICATION	
	Byte * P2_Report;
#ifdef USE_P2_INTERFACE1
	Byte * P2_I1_Report;
#endif
#endif
#endif
} Lib_Tab;


/*******************		Descriptor prototypes		***********************/

#pragma DATA_SEG ROM_VAR
extern const Lib_Tab Descriptors;         
extern const Byte Manufacturer_String[];
extern const Byte Language_String[];
extern const Byte Additional_String[];
extern const Byte P1_Name_String[];
extern const Byte P1_Serial_String[];
extern const Byte P1_Device_Desc[];
extern const Byte P1_Config_Desc[];
extern const Byte P1_Report_Desc[];
extern const Byte P1_I1_Report_Desc[];
extern const Byte P2_Name_String[];
extern const Byte P2_Serial_String[];
extern const Byte P2_Device_Desc[];
extern const Byte P2_Config_Desc[];
extern const Byte P2_Report_Desc[];
extern const Byte P2_I1_Report_Desc[];
 

#endif

/**** (c) 2006 STMicroelectronics *******	END OF FILE	 *******  ST7263B RS232-USB Bridge  ******/