/**************** (c) 2006       STMicroelectronics      **********************
#
# PROJECT  : ST7263B RS232-USB Bridge
# COMPILER : HIWARE or COSMIC for ST7
#
# MODULE  :  HIDlayer.c
# USB LIB VERSION :  4.21
#
# AUTHOR :   MICROCONTROLLER DIVISION / ST Prague
#
#*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : 	Contains "Handle_HID_Requests()" 
		REM : 	This file is given as an example . It is not part of the USB lib.

HISTORY : 10/19/00 	-> 	Creation date

******************************************************************************/   
#include "USB_Var.h"
#include "USB_Opts.h"
#include "Macro.h"
#include "USB_Def.h"

#ifdef HIWARE
#include MAP_FILE
#endif

#include "usb_var.h"
#include "Lib_bits.h"
#include "USB_Lib.h"
#include "User_Def.h"
#include "User_Var.h"
#include "HIDlayer.h"
#include "UART.h"
#pragma CODE_SEG USER_ROM
/*-----------------------------------------------------------------------------
ROUTINE NAME : Handle_HID_Requests
INPUT/OUTPUT : None
DESCRIPTION  : Decode Human Interface Device requests
-----------------------------------------------------------------------------*/
void Handle_HID_Requests(void)
{
	switch (USBbRequest)
	{
#ifdef USE_HID_IDLE
	case SET_IDLE :	
		Idle_Value = USBwValue[1];		// REM: USBwValue[1] has been updated in the Setup decoding in the lib file usb.c
		USBLibStatus &= ~APP_REQUEST;	// Clear APP_REQUEST flag since the application request has been processed.
		return;
	case GET_IDLE :
		Write_EP_Buffer(0,&Idle_Value,USBwLength);
		Set_EP_Ready(0,EP_IN,USBwLength);
		USBLibStatus &= ~APP_REQUEST;	// Clear APP_REQUEST flag since the application request has been processed.
		return;
#endif
#ifdef USE_HID_PROTOCOL
	case SET_PROTOCOL :			
		Protocol_Value = USBwValue[0];  // REM: USBwValue[0] has been updated in the Setup decoding in the lib file usb.c
		USBLibStatus &= ~APP_REQUEST;	// Clear APP_REQUEST flag since the application request has been processed.
		return;
	case GET_PROTOCOL :
		Write_EP_Buffer(0,&Protocol_Value,USBwLength);
		Set_EP_Ready(0,EP_IN,USBwLength);			
		USBLibStatus &= ~APP_REQUEST;	// Clear APP_REQUEST flag since the application request has been processed.
		return;
#endif
#ifdef USE_HID_SET_REPORT
	case SET_REPORT:	
		switch (USBwValue[1])			// Decode Report Type
		{
		case SET_OUTPUT:	
			Set_Output();
			break;
		case SET_FEATURE:	
			Set_Feature();
			break;
		// REM : SET_INPUT is meaningless
		default:
		   	USBLibStatus |= USB_STALL;  // STALL invalid request. 
		   	// REM: When USB_STALL is set, APP_REQUEST flag is cleared by library
		}    
		return;  
#endif
	case GET_REPORT:        // MANDATORY REQUEST support for HID
		switch (USBwValue[1])			// Decode Report Type
		{
		case GET_OUTPUT:	
			Get_Output();
			break;
		case GET_INPUT:	
			Get_Input();
			break;
		case GET_FEATURE:	
			Get_Feature();
			break;  
		default:
		   	USBLibStatus |= USB_STALL;  // STALL invalid request. 
		   	// REM: When USB_STALL is set, APP_REQUEST flag is cleared by library
		}
		return;

	default :
	   	USBLibStatus |= USB_STALL;  // STALL invalid request. 
	   	// REM: When USB_STALL is set, APP_REQUEST flag is cleared by library
	} // End of CLASS requests decoding section	
}
          
/*-----------------------------------------------------------------------------
ROUTINE NAME : Get_Output
INPUT/OUTPUT : None
DESCRIPTION  : Build Output Report  (MANDATORY IF OUTPUT USAGE DEFINED)
-----------------------------------------------------------------------------*/     
void Get_Output(void)
{        
//***************** Example of a Get_Output processing ***********************************       
//	/* Build Report to IN_ReportArray  */
//	IN_ReportArray[0] = USBwValue[0];	// Store Report ID Number in the application variable IN_ReportArray[0]
//  IN_ReportArray[1] = ....
//  IN_ReportArray[2] = ....
//
//	/* Copy report to EP0InBuffer  */
//	Write_EP_Buffer(0, IN_ReportArray, USBwLength); // Load Data to report into DMA buffer.
//
//	/* Switch Endpoint to VALID to allow data to be sent on next "IN token" */
//	Set_EP_Ready(0, EP_IN, USBwLength);				// Prepare HW to send report IN to Host
//
//	/* If this is the last transaction of the 'DATA_STAGE_IN' ... */
//	USBLibStatus &= ~APP_REQUEST;					// Clear APP_REQUEST flag .
//******************************************************************************************
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : Get_Input
INPUT/OUTPUT : None
DESCRIPTION  : Build Input Report  (MANDATORY IF INPUT USAGE DEFINED)
-----------------------------------------------------------------------------*/     
void Get_Input(void)
{
// See Get_Output for an example
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : Get_Feature
INPUT/OUTPUT : None
DESCRIPTION  : Build feature Report  (MANDATORY IF FEATURE USAGE DEFINED)
-----------------------------------------------------------------------------*/     
void Get_Feature(void)
{
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : Set_Feature
INPUT/OUTPUT : None
DESCRIPTION  : Process feature Report 
-----------------------------------------------------------------------------*/     
void Set_Feature(void)
{
	//Read_EP_Buffer(0, Set_FeatureArray);
	Status |= SetFeat;
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : Set_Output
INPUT/OUTPUT : None
DESCRIPTION  : Process output Report
-----------------------------------------------------------------------------*/     
void Set_Output(void)
{ 
    Read_EP_Buffer(0, OUT_ReportArray);
	Status |= SetOutput;
}

/**** (c) 2006 STMicroelectronics *******	END OF FILE	 *******  ST7263B RS232-USB Bridge  ******/