/**************** (c) 2006       STMicroelectronics      **********************
#
# PROJECT  : ST7263B RS232-USB Bridge
# COMPILER : HIWARE or COSMIC for ST7
#
# MODULE  :  Int_7263B.c
# USB LIB VERSION :  4.21
#
# AUTHOR :   MICROCONTROLLER DIVISION / ST Prague
#
#*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

   DESCRIPTION : All Interrupt Service Routines  except USB's

   REM : USB ISRs are in USB_rc.c file.

******************************************************************************/   
#include "USB_Opts.h"
#include "Macro.h" 
#include "USB_Def.h"
#include "lib_bits.h"
#include "User_Var.h" 
#include "Uart.h"
#include "Lib_bits.h"
#include "USB_rc.h"
#include "USB.h"
#include "USB_lib.h"
#include "usb_var.h"
#include "User_Def.h" 
#include "Map_7263B.h"

#ifdef HIWARE
#include "hidef.h"
#include MAP_FILE
#endif

#ifdef HIWARE
#pragma CODE_SEG USER_ROM
#endif
/* ************************ INTERRUPT FUNCTIONS *******************************/

/*-----------------------------------------------------------------------------
ROUTINE NAME : INT_Trap
DESCRIPTION  : TRAP interrupt routine.
-----------------------------------------------------------------------------*/ 
#ifdef COSMIC
@interrupt void INT_Trap(void)
#endif
#ifdef HIWARE
#pragma TRAP_PROC //SAVE_REGS
void INT_Trap(void)
#endif
{
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : INT_IT1IT8
DESCRIPTION  : External Interrupts. 
-----------------------------------------------------------------------------*/ 
#ifdef COSMIC
@interrupt void INT_IT1IT8(void)
#endif
#ifdef HIWARE
#pragma TRAP_PROC //SAVE_REGS
void INT_IT1IT8(void)
#endif
{  
}

#ifdef COSMIC
@interrupt void My_INT_Usb(void)
#endif
#ifdef HIWARE      
#pragma TRAP_PROC SAVE_REGS
void My_INT_Usb(void)
#endif
{// WARNING !! DO NOT CHANGE THE ORDER OF THE FOLLOWING STATEMENTS !!
	Byte	EndPointNumber, PacketID;

	if (USBISTR & Int_Reset)
	{
		// SetBit (PBDR, 2); // For ROM test only
		UsbBusReset();					// USB Bus Reset Service routine.
		USBISTR = 0;				// Clear USBISTR (USB Reset is the highest priority).
		// ClrBit (PBDR, 2); // For ROM test only
	}

	if (USBISTR & Int_Ctr)
	{	
		EndPointNumber = (USBIDR & MASK_EP)>>4;	// Get EndPoint number.
		PacketID = (USBPIDR & TP);				// Get Packet ID.

		if (EndPointNumber == 0)		// Test if Ctr IT occured on EP0
		{   // -> decode PacketID      
			if (PacketID == TP_SETUP)
			{
				UsbCtrFlag |= Int_Ctr_SETUP;	// Set Int_Ctr_SETUP flag
			}
			else
			if (PacketID == TP_IN) 
			{   
				if (USBTransferStatus & DATA_STAGE_IN)
				{	// Data Stage IN
					SetEP0RxStatus_IT(NAK);      		// set OUT direction to NACK
                    UsbCtrFlag |= Int_Ctr_IN;       // Set Int_Ctr_IN flag
				}
				else
				{	// Data Stage OUT or No Data Stage -> Status IN
					if (USBTransferStatus & ADDRESS2SET)
					{
						SetAddress();			// Address actually set here
					}
					SetEP0TxStatus_IT(STALL);				//  Next IN will be not answered.
					SetEP0RxStatus_IT(STALL);				//  Next OUT will be stalled.
				}					
			}
			else 
			{   // PacketID = TP_OUT
#ifdef USE_ENDPOINT0_OUT
				if (USBTransferStatus & DATA_STAGE_OUT)
				{	// Data stage OUT
					SetEP0TxStatus_IT(NAK);      		// set IN direction to NACK
                    UsbCtrFlag |= Int_Ctr_OUT;      // Set Int_Ctr_OUT flag
					OUT_DataNumberEP0 = USBIDR & MASK_CNT;	// Save Number of received data.
				}
				else
#endif
				{	// No data stage (not supposed to happen!) or DATA_STAGE_IN (->status stage OUT)
					SetEP0TxStatus_IT(STALL);				//  Next IN will be not answered.
					SetEP0RxStatus_IT(STALL);				//  Next OUT will be stalled.
				}
			}
		}   // end of EP0 ISR
#ifdef USE_ENDPOINT1_OUT
		else if (EndPointNumber == 1)	// Test if Ctr IT occured on EP1
		{   
			if (PacketID == TP_OUT)
				OUT_DataNumberEP1 = USBIDR & MASK_CNT;		// Save Number of received data.
		}    // end of EP1 ISR
#endif
#ifdef USE_ENDPOINT2_OUT
		else if (EndPointNumber == 2)	// Test if Ctr IT occured on EP2
		{
			if (PacketID == TP_OUT)
				OUT_DataNumberEP2 = USBIDR & MASK_CNT;		// Save Number of received data.
		}   // end of EP2 ISR
#endif   
		USBISTR = ~Int_Ctr;					// Clear pending bit
	} // end of USB Correct Transfer (CTR) ISR

	if (USBISTR & Int_Susp)
	{                                
		USBCTLR = CtrlSusp;		// Set Suspend bit in USBCTLR to actually start logic suspend
		USBLibStatus |= USB_SUSPEND;	// Inform app code that suspend has started
		USBISTR = ~Int_Susp;			// Clear pending bit
	}
}



/*-----------------------------------------------------------------------------
ROUTINE NAME : INT_Flash
DESCRIPTION  : Flash start programming
-----------------------------------------------------------------------------*/ 
#ifdef COSMIC
@interrupt void INT_Flash(void)
#endif
#ifdef HIWARE
#pragma TRAP_PROC //SAVE_REGS
void INT_Flash(void)
#endif
{
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : INT_Timer
DESCRIPTION  : Comes from the Timer cell
-----------------------------------------------------------------------------*/ 
#ifdef COSMIC
@interrupt void INT_Timer(void)
#endif
#ifdef HIWARE
#pragma TRAP_PROC //SAVE_REGS
void INT_Timer(void)
#endif
{                               
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : INT_I2c
DESCRIPTION  : Comes from the I2C cell.
-----------------------------------------------------------------------------*/ 
#ifdef COSMIC
@interrupt void INT_I2C(void)
#endif
#ifdef HIWARE
#pragma TRAP_PROC //SAVE_REGS
void INT_I2C(void)
#endif
{ 
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : INT_Sci
DESCRIPTION  : SCI Interrupt routine.
-----------------------------------------------------------------------------*/ 
#ifdef COSMIC
@interrupt void INT_SCI(void)
#endif
#ifdef HIWARE
#pragma TRAP_PROC //SAVE_REGS
void INT_SCI(void)
#endif
{

	if (SCISR & SCI_RDRF)
    	{
		//Store the data received in the buffer
		ClrBit (PCDR, GREENLED);
	
		Buffer[Buffer_RX_ptr++] = SCIDR; 
		Buffer_RX_ptr &= BUFFER_MASK;
	
		if (Buffer_RX_ptr==Buffer_TX_ptr) //buffer full 
			Program_Status |= BUFFER_ERROR; 
		//check whether buffer is going to full
	}
}

#ifdef HIWARE
#pragma CODE_SEG DEFAULT
#endif




/**** (c) 2006 STMicroelectronics *******	END OF FILE	 *******  ST7263B RS232-USB Bridge  ******/