/**************** (c) 2006       STMicroelectronics      **********************
#
# PROJECT  : ST7263B RS232-USB Bridge
# COMPILER : HIWARE or COSMIC for ST7
#
# MODULE  :  Main.c
# USB LIB VERSION :  4.21
#
# AUTHOR :   MICROCONTROLLER DIVISION / ST Prague
#
#*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : 	Entry file

******************************************************************************/ 
#include "main.h"  
#include "USB_App.h"
#include "USB_Opts.h"
#include "lib_bits.h"
#include "Macro.h"
#include "USB_Def.h"
#include "My_Init.h"
#ifdef HIWARE
#include MAP_FILE
#endif
#include "Lib_bits.h"
#include "USB_Lib.h"
#include "User_Def.h"
#include "User_Var.h"
#include "Uart.h"

#pragma CODE_SEG USER_ROM
/*-----------------------------------------------------------------------------
ROUTINE NAME : main
INPUT/OUTPUT : None
DESCRIPTION  : The reset vector points on main().
-----------------------------------------------------------------------------*/     
void main(void)
{          
/**************		Initialization section		********************/

	/* Application init */
	Init_App_HW();			// Call user init routine

	// !!REM: USBLibStatus must be initialized prior to call Init_USB_HW()


	/* USB init */
	Init_USB_HW();          // Call USB init routine -> switch on USB cell = connect to PC
	                        // REM: Init_USB_HW() may be called anytime

	EnableInterrupts;

/**************		Main loop section		********************/
 

	while(1)
	{// main loop  
/**	Start of USB EP0 management section ******/
		if (USBLibStatus & USB_SUSPEND)
		{// We are in USB suspend ! 
			//set all unconnected port to output and state to 0
			Program_Status |= SUSPENDED;
			PADDR = 0xff;
			PBDDR = 0xff - (1 << CTS);
			PCDDR = 0xff - (1 << RX);

			PADR = 0 + (1 << YELLOWLED);
			PBDR = 0 + (1 << RTS);			// Disable receiving, turn off the ST3222E
			PCDR = 0 + (1 << GREENLED) + (1 << TX);

			//ClrBit (PBDR, PNP);   // Turn off the ST3222E

#ifdef HIWARE
			asm halt;		// If an external interrupt is used to perform a Remote Wake up,
									// then call the Do_USB_RemoteWU() function in the ext. int. ISR,
									// or use the combination of Start_USB_RemoteWU() & Stop_USB_RemoteWU()
#endif
#ifdef COSMIC
			_asm("halt");
#endif			
		}
		else
		{
			Handle_USB_Events();	            // Process USB Flow and STANDARD requests on EP0
			if (USBLibStatus & APP_REQUEST)
			{
			   Handle_APP_Requests();			// Process CLASS and VENDOR requests on EP0
			   Enable_STATUS_Stage();			// Enable ACKing/STALLing STATUS Stage according to USBLibStatus
			}	
		}
/**	End of USB EP0 management section ******/  

	    //the program resume here after USB suspend
		if (Program_Status & SUSPENDED)
		{
			SetBit (PBDR, PNP);	// Resume the power of ST3222E when USB wakes up            	
			ClrBit (PBDR, RTS);	// Allow receiving
			
			Program_Status &= ~SUSPENDED;
		}
		
/**	Following section handles transfer on EP1 & EP2  ******/
		if (USBLibStatus & USB_CONFIGURED)		// Is the device in its configured state ?
		{// REM: MUST BE CONFIGURED TO START REPORTING APPLICATION DATA
			My_Set_Feature();    //Set feature if a feature report arrives
			My_Set_Output();     //Set output if a output request arrives
			Send_Data_To_Serial();  //send data to serial port in case data arrives 

			//Fill USB buffer
			if (Test_EP_Ready(1, EP_IN)) //Checks USB Buffer Ready
			{
				Send_USB();      //Copy data to USB Buffer
	 			SetBit (PCDR, GREENLED);
			}

			if (Program_Status & USE_HANDSHAKE)
			{	//if the buffer is going to be full, set the RTS to stop the device from sending data
				DisableInterrupts;
				if (Buffer_TX_ptr<Buffer_RX_ptr)
					tmp = Buffer_TX_ptr - Buffer_RX_ptr + BUFFER_SIZE;
				else
					tmp = Buffer_TX_ptr - Buffer_RX_ptr;
				EnableInterrupts;

				if ((tmp<Buffer_Limit) && (tmp))
					SetBit (PBDR, RTS);	// Disable receiving
				else
					ClrBit (PBDR, RTS);	// Allow receiving
			}

			//if the buffer is full, the Buffer_Error will be set in INT_PortB
			if (Program_Status & BUFFER_ERROR) //buffer full
			{
				Report_Error(); //send error report to usb               
				Program_Status &= ~BUFFER_ERROR; //clear flag
			}	
		}		    
/**	End of EP1 & EP2  section *******************/

	} // End main loop
}


/**** (c) 2006 STMicroelectronics *******	END OF FILE	 *******  ST7263B RS232-USB Bridge  ******/  