/**************** (c) 2006       STMicroelectronics      **********************
#
# PROJECT  : ST7263B RS232-USB Bridge
# COMPILER : HIWARE or COSMIC for ST7
#
# MODULE  :  My_Init.c
# USB LIB VERSION :  4.21
#
# AUTHOR :   MICROCONTROLLER DIVISION / ST Prague
#
#*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : user initializations

******************************************************************************/   
#include "USB_Opts.h"
#include "User_Def.h"
#include "Macro.h"
#include "USB_Def.h"
#include "USB_Var.h"
#include "User_Var.h"
#ifdef HIWARE
#include MAP_FILE
#endif
#include "USB_Lib.h"  
#include "My_Init.h"

#pragma CODE_SEG USER_ROM

void User_MCU_Init(void)
{
}


/*-----------------------------------------------------------------------------
ROUTINE NAME : Init_App_HW
INPUT/OUTPUT : None
DESCRIPTION  : This function is called in the main.c file, prior to any other function.
				-->> It handles user initialization.
-----------------------------------------------------------------------------*/ 
void Init_App_HW(void)
{ 

	/********************************************/
	/*			USER  INITIALIZATION	        */
	/********************************************/

#ifdef USE_HID_IDLE
	Idle_Value = 0;      		// default = 0 (report data on input change only)
#endif
#ifdef USE_HID_PROTOCOL
	Protocol_Value = 1;  		// default = 1 (report protocol)
#endif
	
	//Init of the PB0 and PB7
	
	SetBit (PBDDR, RTS);		//PB.3 Request To Send output
	ClrBit (PBDR,  RTS);		//allow receiving
	
	SetBit (PADDR, YELLOWLED);
	SetBit (PCDDR, GREENLED);
	SetBit (PADR, YELLOWLED);
	SetBit (PCDR, GREENLED);	
	
	SetBit (PBDDR, PNP);	
	SetBit (PBDR, PNP);			// Turn on the ST3222E

	//UART variables
	Buffer_RX_ptr = 0;	//Byte 0 is reserved for the information of the number of bytes transmited
	Buffer_TX_ptr = 0;	//Byte 0 is reserved for the information of the number of bytes transmited
	
	// UART SCI cell settings    
	SCICR1 = 0x0;				/*Load Default value = no parity , start-8bit-stop*/
	SCICR2 = 0x20;			/* no int for transmission, int for reception, reception and transmission disabled */
	tmp = SCISR;				/*Clear all the flags in Status register*/
	tmp = SCIDR;
	//SCIDR = 0x0;
	SCIBRR = 0xD2;			//default value = 9600 bauds
	SCICR2 |= 0x0C;			// enable transmitter and receiver
	
	Set_EP_Ready(2, EP_OUT, 8);	
	
	SetEP1TxStatus(NAK);	//Int In
	
	Program_Status = 0;
	Buffer_Limit = 64;                                                      

	EP2OutBuffer[0] = 0;
	USBLibStatus = PRODUCT1;	// enumerate PRODUCT1     
}

/**** (c) 2006 STMicroelectronics *******	END OF FILE	 *******  ST7263B RS232-USB Bridge  ******/