/**************** (c) 2006       STMicroelectronics      **********************
#
# PROJECT  : ST7263B RS232-USB Bridge
# COMPILER : HIWARE or COSMIC for ST7
#
# MODULE  :  UART.c
# USB LIB VERSION :  4.21
#
# AUTHOR :   MICROCONTROLLER DIVISION / ST Prague
#
******************************************************************************/
   
#ifdef HIWARE
#include MAP_FILE
#endif
#include "UART.h" 
#include "USB_Def.h"
#include "USB_Lib.h" 
#include "USB_Var.h"   
#include "User_var.h"
#include "User_Def.h"

#ifdef HIWARE
#include "hidef.h"
#endif

#ifdef HIWARE
#pragma DATA_SEG MY_RAM0 
#pragma CODE_SEG USER_ROM
#endif

//*****************************************************************
// SendSCI() - Send the Data to RS232			
//*****************************************************************
void SendSerial(Byte Nb, Byte EnpNb)
{  
	Byte i,temp;
	
	ClrBit (PADR, YELLOWLED);
	for (i = 0; i < Nb; i++)
	{
		temp = SCISR;
		if(EnpNb == 2)
			SCIDR = EP2OutBuffer[i+1];		/*Loads the byte to be transmitted*/
		if(EnpNb == 0)
			SCIDR = OUT_ReportArray[i+1];	/*Loads the byte to be transmitted*/
    while (!(SCISR & SCI_TC));			/*Waits for the completion of transmission*/	
	}
	SetBit (PADR, YELLOWLED);
}         

//*****************************************************************
// Send_USB	()-	send data to pc through usb in case the buffer 
//				is full or the data reception finished on sci
//*****************************************************************
void Send_USB(void)
{
	signed char delta = Buffer_RX_ptr-Buffer_TX_ptr; //delta=0 not processed

	if(delta>7) // more than 7 bytes data
	{
		SendUSBData (Buffer_TX_ptr, 7); //send the data in the buffer
		Buffer_TX_ptr += 7;   
	} else if(delta>0) //0<delta<=7 less than 7 bytes data
	{
		SendUSBData (Buffer_TX_ptr, delta);
		Buffer_TX_ptr += delta;   

	} else if (delta<0) //RX rolls over but not TX
	{
		char t = BUFFER_SIZE-Buffer_TX_ptr;
			
		if (t>7)
		{
			SendUSBData (Buffer_TX_ptr, 7);
			Buffer_TX_ptr += 7;   
		}
		else
		{
			SendUSBData (Buffer_TX_ptr, t);
			Buffer_TX_ptr = 0;   
		}
	}                  
	Buffer_TX_ptr &= BUFFER_MASK;
}    

//*****************************************************************
// SendUSBData() - send data to USB
//*****************************************************************
void SendUSBData(Byte ptr, Byte size)
{
	Byte i;
	EP1InBuffer[0] = size; //number of bytes to send
	for (i=0;i<size;i++)  //copy data in the buffer to usb buffer
	{
		EP1InBuffer[i+1] = Buffer[ptr+i];          
	}
	Set_EP_Ready(1, EP_IN, 8);	

	Program_Status &= ~BUFFER_ERROR;	
}

void My_Set_Feature()
{
	//SetFeature
	if((Status & SetFeat)&&(Test_EP_Ready(0,EP_OUT)))
	{
		if(EP0OutBuffer[0] == 0)
		{	
			//9600 Bps
			SCICR2 &= 0xF3; // Recv and transmit disabled
			SCIBRR = 0xD2;	// 9600 bauds
			SCICR2 |= 0x0C; // Recv and transmit enabled
		}
		else if(EP0OutBuffer[0] == 1)
		{
			//4800 Bps
			SCICR2 &= 0xF3; // Recv and transmit disabled
			SCIBRR = 0xDB;	// 4800 bauds
			SCICR2 |= 0x0C; // Recv and transmit enabled
		}
		else if(EP0OutBuffer[0] == 2)
		{	
			//9600 Bps
			SCICR2 &= 0xF3; // Recv and transmit disabled
			SCIBRR = 0xD2;	// 9600 bauds
			SCICR2 |= 0x0C; // Recv and transmit enabled
		}	
		else if(EP0OutBuffer[0] == 3)
		{
			//19200 Bps
			SCICR2 &= 0xF3; // Recv and transmit disabled
			SCIBRR = 0xC9;	// 19200 bauds
			SCICR2 |= 0x0C; // Recv and transmit enabled
		}	
		else if(EP0OutBuffer[0] == 4)
		{
			//38400 Bps
			SCICR2 &= 0xF3; // Recv and transmit disabled
			SCIBRR = 0xC0;	// 38400 bauds
			SCICR2 |= 0x0C; // Recv and transmit enabled
		}	
		else if(EP0OutBuffer[0] == 0x0A)
		{          
			Program_Status &= ~ USE_HANDSHAKE;
			//SetBit (PBDDR, RTS);	//PB.3 Request To Send output
			ClrBit (PBDR,  RTS);	//allow receiving
		}
		else if(EP0OutBuffer[0] == 0x0B)
		{
			Program_Status |= USE_HANDSHAKE;
		}
		else if(EP0OutBuffer[0] == 0x0C)
		{
			Buffer_Limit = EP0OutBuffer[1];
		}

		Status &= ~SetFeat;
		Set_EP_Ready(0, EP_OUT, 8);
		USBLibStatus &= ~APP_REQUEST;
	}
}

//*****************************************************************
// UART_Polling() - Check for data comes from USB and send 
//					set features
//*****************************************************************

void Send_Data_To_Serial()
{
	
	if (Test_EP_Ready(2, EP_OUT))	// Test if data have been received on EP2.
	{
	//if ((USBEP2RB & 0x30) == 0x20) 	//Test if some data arrived on EP2 OUT
	//{
		while ((ValBit (PBDR, CTS))&&(Program_Status & USE_HANDSHAKE)) {
#ifdef HIWARE
		asm nop;
#endif
#ifdef COSMIC
		_asm("nop");
#endif		
		} // check sci handshake

		//If yes, send the EP2OutBuffer[0] bytes to SCI
		SendSerial (EP2OutBuffer[0], 2);
		//Put again the EP ready
		Set_EP_Ready(2, EP_OUT, 8);			
	}
}      

void My_Set_Output()
{
	if((Status & SetOutput)&&(Test_EP_Ready(0,EP_OUT)))
	{
		SendSerial(OUT_ReportArray[0], 0);
		//Set_EP_Ready(0, EP_OUT, USBwLength);
		USBLibStatus &= ~APP_REQUEST;
		Status &= ~SetOutput;
#ifdef HIWARE
		asm nop;
#endif
#ifdef COSMIC
		_asm("nop");
#endif		
	}	
}

//*****************************************************************
// Report_Error() - Send an error report to USB in case of buffer
//					full
//*****************************************************************
void Report_Error(void)
{                  
	//send an error report to USB
	EP1InBuffer[0] = ERROR_CODE; //number of bytes to send
	EP1InBuffer[1] = 0xFF; 
	EP1InBuffer[2] = 0xFF; 
	EP1InBuffer[3] = 0xFF; 
	EP1InBuffer[4] = 0xFF; 
	EP1InBuffer[5] = 0xFF; 
	EP1InBuffer[6] = 0xFF; 
	EP1InBuffer[7] = 0xFF; 
	
	while(!Test_EP_Ready(1, EP_IN)) {
#ifdef HIWARE
		asm nop;
#endif
#ifdef COSMIC
		_asm("nop");
#endif
	}
	Set_EP_Ready(1, EP_IN, 8);	
}

/**** (c) 2006 STMicroelectronics *******	END OF FILE	 *******  ST7263B RS232-USB Bridge  ******/