/**************** (c) 2006       STMicroelectronics      **********************
#
# PROJECT  : ST7263B RS232-USB Bridge
# COMPILER : HIWARE or COSMIC for ST7
#
# MODULE  :  USB_App.c
# USB LIB VERSION :  4.21
#
# AUTHOR :   MICROCONTROLLER DIVISION / ST Prague
#
#*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : 	Contains "Handle_APP_Requests()" as well as build reports functions.
		REM : 	This file is given as an example . It is not part of the USB lib.
				The functions of the example appli are;
				- Read and send to host a push button state
				- Receive from host a led state, then command led accordingly
									                                                              
HISTORY : 08/24/00 	-> 	Removed "SetEP0RxStatus(STALL);" from Handle_APP_Requests()
					-> 	Stalling extra OUT when data_stage_out is over is now handle by lib.

		  09/05/00	->	File created to match the Lib 5.x spec

******************************************************************************/   
#include "USB_App.h"
#include "HIDlayer.h"
#include "USB_Opts.h"
#include "USB_Def.h"
#include "My_Init.h"
#ifdef HIWARE
#include MAP_FILE
#endif
#include "Lib_bits.h"
#include "USB_Lib.h"
#include "User_Def.h"
#include "User_Var.h"
#include "UART.h"

#pragma CODE_SEG USER_ROM
 
/*-----------------------------------------------------------------------------
ROUTINE NAME : Handle_APP_Requests
INPUT/OUTPUT : None
DESCRIPTION  : Process Vendor and Class specific requests
-----------------------------------------------------------------------------*/     
void Handle_APP_Requests(void)
{
/************************************************************************************************* 
!! IMPORTANT !!                                                                      
---------------
** The APP_REQUEST flag is set in USBLibStatus after decoding of the SETUP token for 
** a NO_DATA_STAGE or DATA_STAGE_IN  NON STANDARD request, and after acknoledge of the first OUT token 
** for a DATA_STAGE_OUT NON STANDARD request.

** REM : USBwValue[0], USBwValue[1], USBwIndex, USBwLength  are USB lib variables updated when a SETUP token is received
**       They are used in this function to facilitate SETUP decoding.
*************************************************************************************************/

	switch (USBbmRequestType & TYPE)
	{
#ifdef USE_VENDOR_REQUESTS
	case VENDOR:
		// Process your Vendor requests here
		/********** Example code *************/     
		/* SETUP fields are already saved into 	USBbmRequestType, USBbRequest, USBwValue[0], USBwValue[1], USBwIndex, USBwLength
			-> You may use them */ 
		if (USBTransferStatus & NO_DATA_STAGE)
		{
			// Decode SETUP  here, using Lib variables: 
			// USBbmRequestType, USBbRequest, USBwValue[0], USBwValue[1], USBwIndex, USBwLength 
		}
		else if (USBTransferStatus & DATA_STAGE_OUT)
		{
		}
		else if (USBTransferStatus & DATA_STAGE_IN)
		{
			// Decode SETUP  here, using Lib variables: 
			// USBbmRequestType, USBbRequest, USBwValue[0], USBwValue[1], USBwIndex, USBwLength 
		//	Write_EP_Buffer(0, 'your in buffer', wLength); // Load Data to report into DMA buffer.
		////Got some SetFeature
		}
		USBLibStatus &= ~APP_REQUEST;	// Clear APP_REQUEST flag if data stage is over.
		return;
#endif
	case CLASS:		// CLASS specific request 
		Handle_HID_Requests();   
//		Handle_DFU_Requests(); 	// if DFU mode active
	} // End of Request Type decoding section 

	/* !!! REM: Enable_STATUS_Stage() will take care of the Status Stage */
}

/**** (c) 2006 STMicroelectronics *******	END OF FILE	 *******  ST7263B RS232-USB Bridge  ******/