/**************** (c) 2006       STMicroelectronics      **********************
#
# PROJECT  : ST7263B RS232-USB Bridge
# COMPILER : HIWARE or COSMIC for ST7
#
# MODULE  :  USB_Opts.h
# USB LIB VERSION :  4.21
#
# AUTHOR :   MICROCONTROLLER DIVISION / ST Prague
#
#*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : 	USB lib configuration file
				==>>  Configure your application USB features here (configure USB lib)

******************************************************************************/   
#ifndef USB_Opts_H
#define USB_Opts_H   
   

//#define USE_SERIAL_NUMBER		    	// Enable USB serial number reporting  (see Descript.c)

//#define USE_USB_REMOTE_WAKE_UP			// Ability for a peripheral to wake up the host

//#define USE_DEVICE_FIRMWARE_UPDATE	// Ability to download a new firmware through USB link on ST7 Flash
										// NOTE: DFU is not possible using the ST72F61
										// due to only one 4K ROM segment

#define INIT_APP_ON_END_SUSP

/********************************************************************************************/
/*			Following section concerns multiple interfaces & products support				*/
/*							------------------------------									*/
/*	Allow user to have the same ROM code for a maximum of 2 different products				*/
/*	which means a Run time selection between 2 sets of Descriptors.							*/
/*																							*/
/*	Depending on the selection below, either the PRODUCT1, or PRODUCT1 +					*/	
/*	PRODUCT2  descriptors will be compiled.													*/
/*																							*/
/*	NOTE: PRODUCT1 is  ALWAYS DEFINED														*/
/********************************************************************************************/

//#define USE_P1_INTERFACE1			// Define a second interface (interface 1) on PRODUCT1.
//#define USE_PRODUCT2				// Define a second product (PRODUCT2)
//#define USE_P2_INTERFACE1			// Define a second interface (interface 1) on PRODUCT2.


#define HID_APPLICATION			    // Human Interface Device
/********************************************************************************************/
/*					Following section concerns HID devices	only							*/
/********************************************************************************************/
//#define USE_HID_IDLE				// HID optional request (cf. HID spec).
//#define USE_HID_PROTOCOL			// HID optional request (cf. HID spec) -> Boot devices only.
#define USE_HID_SET_REPORT		// HID optional request (allow host to send a report through EP0)
/********************************************************************************************/



/********************************************************************************************/
/*				Following section concerns optional USB requests							*/
/********************************************************************************************/
//#define USE_VENDOR_REQUESTS	    // Enable Vendor Requests
//#define USE_ADD_STRINGS			// Enable reporting of additional strings
/********************************************************************************************/



/********************************************************************************************/
/*					Following section selects your USB pipes configuration					*/
/*							------------------------------									*/
/* WARNING:	When modifying the following '#define', the DMA buffers must be allocated		*/ 
/*			accordingly in the linker file (ST72xxxx.prm)									*/
/*																							*/
/*	NOTE:  USE_ENDPOINT0_IN is always defined												*/
/********************************************************************************************/

#define USE_ENDPOINT0_OUT	// Enable "Data Stage Out" on EP0 (Set_Report, Vendor_Request with Data_Out)
#define USE_ENDPOINT1_IN
//#define USE_ENDPOINT1_OUT
//#define USE_ENDPOINT2_IN
#define USE_ENDPOINT2_OUT


#endif

/**** (c) 2006 STMicroelectronics *******	END OF FILE	 *******  ST7263B RS232-USB Bridge  ******/