/**************** (c) 2006       STMicroelectronics      **********************
#
# PROJECT  : ST7263B RS232-USB Bridge
# COMPILER : HIWARE or COSMIC for ST7
#
# MODULE  :  User_Var.c
# USB LIB VERSION :  4.21
#
# AUTHOR :   MICROCONTROLLER DIVISION / ST Prague
#
#*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : Applications variables declaration

******************************************************************************/
#include "USB_Opts.h"
#include "Macro.h"
#include "User_Def.h"
#include "User_Var.h"  


// Map user variables in Page 0.
#pragma DATA_SEG SHORT MY_RAM0


#ifdef USE_HID_IDLE
Byte Idle_Value;			//  to support USE_HID_IDLE request (OPTIONAL)
#endif
#ifdef USE_HID_PROTOCOL
Byte Protocol_Value;		//  to support USE_HID_PROTOCOL request (OPTIONAL)
#endif

#pragma DATA_SEG DEFAULT_RAM
//Byte Set_FeatureArray[8];	//  to receive a Set Feature
Byte OUT_ReportArray[8];	//  to receive a report out
//Byte IN_ReportArray['your report in length'];	//  to build a rep

#pragma DATA_SEG MY_RAM0

//Status
Byte Status;
Byte Program_Status;  

//Buffer related variables
Byte Buffer[BUFFER_SIZE]; 	//buffer to store data receive from 232
Byte Buffer_RX_ptr;   		//current receive pointer of buffer
Byte Buffer_TX_ptr;   		//current transmit pointer of buffer
Byte Buffer_Limit;          //Define when to set RTS

//temporary variables
Byte tmp;

/**** (c) 2006 STMicroelectronics *******	END OF FILE	 *******  ST7263B RS232-USB Bridge  ******/