/**************** (c) 2006       STMicroelectronics      **********************
#
# PROJECT  : ST7263B RS232-USB Bridge
# COMPILER : HIWARE or COSMIC for ST7
#
# MODULE  :  User_Var.h
# USB LIB VERSION :  4.21
#
# AUTHOR :   MICROCONTROLLER DIVISION / ST Prague
#
#*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : Applications variables declaration

******************************************************************************/   
#include "lib_bits.h"
#include "User_def.h"

#ifndef User_Var_H
#define User_Var_H

// Map user variables in Page 0.
#pragma DATA_SEG SHORT MY_RAM0


#ifdef USE_HID_IDLE
extern Byte Idle_Value;			//  to support USE_HID_IDLE request (OPTIONAL)
#endif
#ifdef USE_HID_PROTOCOL
extern Byte Protocol_Value;		//  to support USE_HID_PROTOCOL request (OPTIONAL)
#endif

#pragma DATA_SEG DEFAULT_RAM
//extern Byte Set_FeatureArray[8];//  to receive a Set Feature
extern Byte OUT_ReportArray[8];	//  to receive a report out
//extern Byte IN_ReportArray['your report in length'];	//  to build a rep

#pragma DATA_SEG MY_RAM0 
//Status
extern Byte Status;
extern Byte Program_Status;  

//Buffer related variables
extern Byte Buffer[BUFFER_SIZE]; 	//buffer to store data receive from 232
extern Byte Buffer_RX_ptr;   		//current receive pointer of buffer
extern Byte Buffer_TX_ptr;   		//current transmit pointer of buffer
extern Byte Buffer_Limit;          //Define when to set RTS

//temporary variables
extern Byte tmp;            
#endif

/**** (c) 2006 STMicroelectronics *******	END OF FILE	 *******  ST7263B RS232-USB Bridge  ******/