#**************** (c) 2006       STMicroelectronics      **********************
#
# PROJECT  : ST7263B RS232-USB Bridge
# COMPILER : COSMIC for ST7
#
# MODULE  :  UART.c
# USB LIB VERSION :  4.21
#
# AUTHOR :   MICROCONTROLLER DIVISION / ST Prague
#
# DESCRIPTION : Make file for the ST7263B 8K
#
#******************************************************************************


#*** PRODUCT, SIZE AND PROGRAM MEMORY DEFINITION ***

# Here declare your product name, size and start of the Program Memory 
PRODUCT  = 7263B
PROG_MEM = 0xE000
PROJECT  = Rs232Usb

#*** PATHS DEFINITION ***

# Here you declare where you store the different tools
TOOLS_PATH = C:\COSMIC\CXST7

# Here you declare where you store your project sources
PRJ_PATH = C:\STORE\WORK\FIRMWARES\UART_BRIDGE_63B

# Here you declare where you store the Library sources
LIB_PATH = $(PRJ_PATH)\ST7USBLS-Library-V4.21

# where is stored the S19 file
S19_PATH = $(PRJ_PATH)\S19

#*** SUB PATHS DEFINITION ***

APPLI_PATH  = $(PRJ_PATH)\Appli
CONFIG_PATH = $(PRJ_PATH)\Config\Cosmic
OBJ_PATH    = $(PRJ_PATH)\Objects

USB_PATH   = $(LIB_PATH)\Usb
MACRO_PATH = $(LIB_PATH)\Macro
MICRO_PATH = $(LIB_PATH)\Micro

#*** I/O FILES DEFINITION ***

LKF_FILE = $(CONFIG_PATH)\ST7263B.lkf
MAK_FILE = $(CONFIG_PATH)\ST7263B.mak

ST7_FILE = $(OBJ_PATH)\$(PROJECT).st7
ELF_FILE = $(OBJ_PATH)\$(PROJECT).elf
S19_FILE = $(S19_PATH)\$(PROJECT).s19
MAP_FILE = $(OBJ_PATH)\$(PROJECT).map
 
#*** COMMANDS DEFINITION ***

# Here you declare which tool will be used : C Compiler, Assembler, Linker, etc...
COMP = $(TOOLS_PATH)\cxst7.exe 
ASM  = $(TOOLS_PATH)\cast7.exe
LINK = $(TOOLS_PATH)\clnk.exe
CONV = $(TOOLS_PATH)\cvdwarf.exe
CHEX = $(TOOLS_PATH)\chex.exe

# Here you declare which options are to be used by the different tools
# To be used for uncrypted sources
CFLAGS  = +modmm +scov +debug -co $(OBJ_PATH) -i $(APPLI_PATH) -i $(MACRO_PATH) -i $(MICRO_PATH) -i $(USB_PATH) \
          -l -v -dCOSMIC -dST$(PRODUCT) -p -hMap_$(PRODUCT).h

# To be used for crypted sources
CFLAGSY = +modmm +scov        -co $(OBJ_PATH) -i $(APPLI_PATH) -i $(MACRO_PATH) -i $(MICRO_PATH) -i $(USB_PATH) \
             -v -dCOSMIC -dST$(PRODUCT) -p -hMap_$(PRODUCT).c
AFLAGS  = -xx -l -v -dCOSMIC
LFLAGS  = -o $(ST7_FILE) -m $(MAP_FILE)
HFLAGS  = -e $(PROG_MEM) -o $(S19_FILE)

# Commands set-up
CC  = $(COMP) $(CFLAGS)
CCY = $(COMP) $(CFLAGSY)
AS  = $(ASM) $(AFLAGS)
LK  = $(LINK) $(LFLAGS)
CV  = $(CONV)
HX  = $(CHEX) $(HFLAGS)

#*** OBJECT FILES DEFINITION ***

# Here you define all the application objects and their location
OBJ_LIST = $(OBJ_PATH)\Descript.o $(OBJ_PATH)\HIDLayer.o \
 $(OBJ_PATH)\Int_$(PRODUCT).o $(OBJ_PATH)\Main.o \
 $(OBJ_PATH)\My_Init.o $(OBJ_PATH)\UART.o $(OBJ_PATH)\USB_App.o $(OBJ_PATH)\User_Var.o \
 $(OBJ_PATH)\Vect_$(PRODUCT).o \
 $(OBJ_PATH)\Map_$(PRODUCT).o \
 $(OBJ_PATH)\USB.o $(OBJ_PATH)\USB_Lib.o \
 $(OBJ_PATH)\USB_Rc.o $(OBJ_PATH)\USB_Var.o $(OBJ_PATH)\USB_Rwu.o

#*** EPB FILE CREATION ***

# Here, Conversion from COSMIC format (.ST7) to Hexadecimal format (.S19) for EPB
$(S19_FILE): $(ELF_FILE)
	$(HX) $(ST7_FILE)
             
#*** COSMIC TO STVD7 CONVERSION ***
             
# Here, Conversion from COSMIC format (.ST7) to STVD7 format (.ELF)
$(ELF_FILE): $(ST7_FILE)
	$(CV) $(ST7_FILE)
        
#*** LINKING ***  
        
# Here, all the object files are linked all together to create a .ST7 file 
$(ST7_FILE): $(OBJ_LIST)
	$(LK) $(LKF_FILE) 	      

#*** COMPILATION ***

#-----------------
# APPLI DIRECTORY
#-----------------

$(OBJ_PATH)\Descript.o: $(APPLI_PATH)\Descript.c 
	$(CC) $(APPLI_PATH)\Descript.c

$(OBJ_PATH)\HIDLayer.o: $(APPLI_PATH)\HIDLayer.c 
	$(CC) $(APPLI_PATH)\HIDLayer.c

$(OBJ_PATH)\Int_$(PRODUCT).o: $(APPLI_PATH)\Int_$(PRODUCT).c
	$(CC) $(APPLI_PATH)\Int_$(PRODUCT).c
					
$(OBJ_PATH)\Main.o: $(APPLI_PATH)\Main.c 
	$(CC) $(APPLI_PATH)\Main.c

$(OBJ_PATH)\My_Init.o: $(APPLI_PATH)\My_Init.c 
	$(CC) $(APPLI_PATH)\My_Init.c

$(OBJ_PATH)\UART.o: $(APPLI_PATH)\UART.c 
	$(CC) $(APPLI_PATH)\UART.c
	
$(OBJ_PATH)\USB_App.o: $(APPLI_PATH)\USB_App.c 
	$(CC) $(APPLI_PATH)\USB_App.c

$(OBJ_PATH)\User_Var.o: $(APPLI_PATH)\User_Var.c 
	$(CC) $(APPLI_PATH)\User_Var.c

#------------------
# CONFIG DIRECTORY
#------------------

$(OBJ_PATH)\Vect_$(PRODUCT).o: $(CONFIG_PATH)\Vect_$(PRODUCT).c
	$(CC) $(CONFIG_PATH)\Vect_$(PRODUCT).c

# ----------------
# MICRO DIRECTORY
# ----------------
                               
$(OBJ_PATH)\Map_$(PRODUCT).o:	$(MICRO_PATH)\Map_$(PRODUCT).c 
	$(CC) $(MICRO_PATH)\Map_$(PRODUCT).c

#---------------
# USB DIRECTORY
#---------------

$(OBJ_PATH)\USB.o: $(USB_PATH)\USB.c
	$(CC) $(USB_PATH)\USB.c	

$(OBJ_PATH)\USB_Lib.o: $(USB_PATH)\USB_Lib.c
	$(CC) $(USB_PATH)\USB_Lib.c
	
$(OBJ_PATH)\USB_Rc.o: $(USB_PATH)\USB_Rc.c
	$(CC) $(USB_PATH)\USB_Rc.c

$(OBJ_PATH)\USB_Var.o: $(USB_PATH)\USB_Var.c
	$(CC) $(USB_PATH)\USB_Var.c

$(OBJ_PATH)\USB_Rwu.o: $(USB_PATH)\USB_Rwu.c
	$(CC) $(USB_PATH)\USB_Rwu.c
      
#*** COMMANDS CALLED BEFORE 'REBUILD ALL' PROCESS ***
      
clean :                         
	del $(OBJ_PATH)\*.o
	del $(OBJ_PATH)\*.st7
	del $(OBJ_PATH)\*.elf
	del $(S19_PATH)\*.s19
	del $(OBJ_PATH)\*.ls
	del $(OBJ_PATH)\*.lst
	del $(OBJ_PATH)\*.map
	$(MAKE) -f $(MAK_FILE)
	
#**** (c) 2006 STMicroelectronics *******	END OF FILE	 *******  ST7263B RS232-USB Bridge  *******