/**************** (c) 2006       STMicroelectronics      **********************
#
# PROJECT  : ST7263B RS232-USB Bridge
# COMPILER : COSMIC for ST7
#
# MODULE  :  Vect_7263B.c
# USB LIB VERSION :  4.21
#
# AUTHOR :   MICROCONTROLLER DIVISION / ST Prague
#
#*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : ST7263B Interrupt vectors call table.

******************************************************************************/ 


#include "Main.h"
   
// Define interrupt service routines as external functions

//extern void _stext(); 		// -> use with startup file crts*.s
extern void INT_Flash();
extern void INT_EndSusp();
extern void INT_IT1IT8();
extern void INT_Timer();
extern void My_INT_Usb();
extern void INT_Trap();
extern void INT_SCI();
extern void INT_I2C();


// Assign ISR to interrupt vectors

#pragma section const {vector}

void (* const _vectab[])() = 
{          
	My_INT_Usb,
	INT_SCI,  
	INT_I2C,
	INT_Timer,
	INT_IT1IT8,
	INT_EndSusp,
	INT_Flash,
	INT_Trap,
	main              // FFFEh-FFFFh : reset vector    (or use _text with asm startup file)
};                     

/**** (c) 2006 STMicroelectronics *******	END OF FILE	 *******  ST7263B RS232-USB Bridge  ******/