#**************** (c) 2006       STMicroelectronics      **********************
#
# PROJECT  : ST7263B RS232-USB Bridge
# COMPILER : HIWARE for ST7
#
# MODULE  :  ST7263B.mak
# USB LIB VERSION :  4.21
#
# AUTHOR :   MICROCONTROLLER DIVISION / ST Prague
#
# DESCRIPTION : Make file for the ST7263B
#
#******************************************************************************


#*** PRODUCT AND SIZE DEFINITION ***

# Here declare your product name and size 
PRODUCT = 7263B
SIZE    = 16K

#*** PATHS DEFINITION ***

# Here you declare the different tools location
TOOLS_PATH = C:\HIWARE\prog

#*** I/O FILES DEFINITION ***

ENV_FILE = Default.env
PRM_FILE = ST$(PRODUCT).prm
BURN_FILE = Burner.cmd
ABS_FILE = Rs232Usb.abs

#*** COMMANDS DEFINITION ***

COMP = $(TOOLS_PATH)\Cst7.exe
LINK = $(TOOLS_PATH)\Linker.exe
BURN = $(TOOLS_PATH)\Burner.exe

#*** COMPILER OPTIONS AND SET-UP ***

# Basic
COMPOPTIONS = -N -Cc -Ml -F7 -Lasm=%n.lst
# Highest density code
#COMPOPTIONS = -N -Cc -Ml -F7 -Lasm=%n.lst -Os -Ou -Of -Ol0 -OnPMNC -Or
# Lowest debug complexity
#COMPOPTIONS = -N -Cc -Ml -F7 -Lm -Lasm=%n.lst -Os -Onu -Onf -Ol0 -Onbt -Onca -Oncn -One -Ont=

CC = $(COMP) $(COMPOPTIONS) -DMAP_FILE="Map_$(PRODUCT).h" -DST$(PRODUCT) -DHIWARE

#*** OBJECTS FILES DEFINITION ***

OBJ_LIST = Descript.o HIDLayer.o Int_$(PRODUCT).o Main.o My_Init.o UART.o USB_App.o User_Var.o \
	 USB.o USB_Lib.o USB_Rc.o USB_Var.o USB_Rwu.o\
	 Map_$(PRODUCT).o
	    
#*** LINKING ***

$(ABS_FILE) :	$(ENV_FILE) $(OBJ_LIST) $(PRM_FILE)
		$(LINK) $(PRM_FILE)

#*** BURNING ***

		$(BURN) -f $(BURN_FILE)

#*** COMPILATION ***

# ----------------
# APPLI DIRECTORY
# ----------------

Descript.o :	$(ENV_FILE) Descript.c
		$(CC) Descript.c

HIDLayer.o :	$(ENV_FILE) HIDLayer.c
		$(CC) HIDLayer.c

Int_$(PRODUCT).o :	$(ENV_FILE) Int_$(PRODUCT).c
			$(CC) Int_$(PRODUCT).c
											
Main.o :	$(ENV_FILE) Main.c 
		$(CC) Main.c

My_Init.o :	$(ENV_FILE) My_Init.c
		$(CC) My_Init.c 

UART.o :	$(ENV_FILE) UART.c 
		$(CC) UART.c
		
USB_App.o :	$(ENV_FILE) USB_App.c
		$(CC) USB_App.c
		
User_Var.o :	$(ENV_FILE) User_Var.c
		$(CC) User_Var.c 

# ----------------
# MICRO DIRECTORY
# ----------------
                               
Map_$(PRODUCT).o :	$(ENV_FILE) Map_$(PRODUCT).c 
			$(CC) Map_$(PRODUCT).c

# --------------
# USB DIRECTORY
# --------------

USB.o :		$(ENV_FILE) USB.c 
		$(CC) USB.c

#USB_DFUD.o :	$(ENV_FILE) USB_DFUD.c 
#		$(CC) USB_DFUD.c
				
USB_Lib.o :	$(ENV_FILE) USB_Lib.c 
		$(CC) USB_Lib.c  

USB_Rc.o :	$(ENV_FILE) USB_Rc.c 
		$(CC) USB_Rc.c  

USB_Var.o :	$(ENV_FILE) USB_Var.c 
		$(CC) USB_Var.c

USB_Rwu.o :	$(ENV_FILE) USB_Rwu.c 
		$(CC) USB_Rwu.c


#**** (c) 2006 STMicroelectronics *******	END OF FILE	 *******  ST7263B RS232-USB Bridge  *******