/*** (c) STMicroelectronics ***************************************************
#
# PROJECT : ST7 USB LOW SPEED LIBRARY
#
# COMPILER : COSMIC / HIWARE
#
# VERSION : 4.21
#
# DESCRIPTION : USB lib interface file
#         -->> CONTAINS ALL (AND ONLY) FUNCTIONS ACCESSIBLE BY THE APPLICATION LAYER. 
#				- see the description of available functions below -
#
# HISTORY : 10/19/00 	-> Creation date
#
******************************************************************************/   

/*-----------------------------------------------------------------------------
ROUTINE NAME : Init_USB_HW
INPUT/OUTPUT : None
DESCRIPTION  : Switch on ST7 USB cell (Connect to the bus) and initialize library variables.  
-----------------------------------------------------------------------------
ROUTINE NAME : Disable_USB_HW
INPUT/OUTPUT : None
DESCRIPTION  : Switch off ST7 USB cell (Disconnect from the bus) and reset library variables.
-----------------------------------------------------------------------------
ROUTINE NAME : Handle_USB_Events
INPUT/OUTPUT : None
DESCRIPTION  : Manage USB flow on Endpoint0 (standard requests only)	
-----------------------------------------------------------------------------
ROUTINE NAME : Enable_STATUS_Stage
INPUT/OUTPUT : None
DESCRIPTION  : Allow ST7 to ACK or STALL incoming Status Stage after completion of a non standard request
-----------------------------------------------------------------------------
ROUTINE NAME : Test_EP_Ready
INPUT/OUTPUT : Endpoint#, Direction
DESCRIPTION  : Check if Endpoint buffer is ready to be written or read
				-> Return TRUE if ready
-----------------------------------------------------------------------------
ROUTINE NAME : Set_EP_Ready
INPUT/OUTPUT : Endpoint#, EP dir, Data Payload
DESCRIPTION  : Set Transmit byte counter and Set EPTx to VALID, 
				or Set EPRx to VALID (ignore 'data payload' param for direction EP_OUT)
-----------------------------------------------------------------------------
ROUTINE NAME : Write_EP_Buffer
INPUT/OUTPUT : Endpoint#, Data Source (pointer), Number of bytes to transmit
DESCRIPTION  : Write data from '*DataSource' into the USB DMA RAM Transmit buffer
-----------------------------------------------------------------------------
ROUTINE NAME : Read_EP_Buffer
INPUT/OUTPUT : Endpoint#, Data Destination (pointer)
DESCRIPTION  : Read data from the USB DMA Receive buffer into '*DataDestination'
-----------------------------------------------------------------------------
ROUTINE NAME : 	Do_USB_RemoteWU
INPUT/OUTPUT : 	None
DESCRIPTION  : 	Send a complete Remote Wake-up signaling sequence to the Host (Reset USB_SUSPEND flag)
		REM : 	While sending the resume signaling, all interrupts are disable for 10ms
		      	In case you don't want all interrupts to be masked for 10ms, when exiting suspend,
				use the 'Start_USB_RemoteWU' & 'Stop_USB_RemoteWU' functions.
-----------------------------------------------------------------------------
ROUTINE NAME : Start_USB_RemoteWU
INPUT/OUTPUT : None
DESCRIPTION  : Start a Remote Wake-up signaling to the Host 
			-> Application code must call the Stop_USB_RemoteWU() function after a 10ms delay !!
-----------------------------------------------------------------------------
ROUTINE NAME : Stop_USB_RemoteWU
INPUT/OUTPUT : None
DESCRIPTION  : End Remote Wake-up signaling , initiated by Start_USB_RemoteWU().
				(Reset USB_SUSPEND flag)
-----------------------------------------------------------------------------*/

/******************		Functions prototypes	***********************************/

#ifndef USB_LIB_H
#define USB_LIB_H

#include "Lib_Bits.h"

#ifdef HIWARE
#pragma CODE_SEG USBLIB_ROM     
#endif

extern void Init_USB_HW (void);
extern void Disable_USB_HW (void);
extern void Handle_USB_Events(void);
extern void Enable_STATUS_Stage(void);
extern Bool Test_EP_Ready(Byte Endpoint, Byte Direction);
extern void Set_EP_Ready(Byte Endpoint, Byte Direction, Byte Length);
extern void Write_EP_Buffer (Byte Endpoint, Byte *Data, Byte DataLength);
extern void Read_EP_Buffer (Byte Endpoint, Byte *DataDestination);
extern void Write_EP_Buffer_NP (void);
extern void Read_EP_Buffer_NP (void);
extern void Set_EP_Ready_NP (void);
extern Bool Test_EP_Ready_NP (void);

#ifdef HIWARE
#pragma CODE_SEG DEFAULT     
#endif

#endif // USB_LIB_H

/*** END OF FILE ***/