/******************** (C) COPYRIGHT 2005 STMicroelectronics ********************
* File Name          : 91x_map.h
* Author             : Deepak Sharma
* Date First Issued  : 05/26/2005
* Description        : Peripherals memory mapping and registers structures
********************************************************************************
* History:
*  05/26/2005 : V0.1		initial version
*******************************************************************************
 THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS WITH
 CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
 AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT
 OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE CONTENT
 OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING INFORMATION
 CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/
#ifndef __91x_map_H
#define __91x_map_H

#ifndef EXT
  #define EXT extern
#endif

#include "91x_conf.h"
#include "91x_type.h"

/* List all of the elements needed for USB configuration  */


enum UsbState {USB_UNKNOWN_STATE, USB_POWERED_STATE, USB_DEFAULT_STATE, USB_ADDRESSED_STATE, USB_CONFIGURED_STATE, USB_SUSPENDED_STATE};
enum EpDirState {USB_EP_TX, USB_EP_RX, USB_EP_BDIR};
enum EpBuffState {USB_EP_SINGLE, USB_EP_DOUBLE};
enum EpTypeState {USB_EP_CTRL, USB_EP_ISO, USB_EP_BULK, USB_EP_INT};
enum EpModeState {USB_EP_CPU, USB_EP_DMA_LNK, USB_EP_DMA_UNLK};
enum EpState {USB_EP_DISABLED, USB_EP_STALL, USB_EP_NAK, USB_EP_VALID} ;
#define USB_DADDRESS    0x0
#define EP_NUM          0x1
#define EP0					0
#define EP1					1
#define EP2					2
#define EP3					3
#define EP4					4
#define SYS_STIM_BYTE1_MASK     (0x000000FF)
#define SYS_STIM_BYTE2_MASK     (0x0000FF00)
#define SYS_STIM_BYTE3_MASK     (0x00FF0000)
#define SYS_STIM_BYTE4_MASK     (0xFF000000)
#define USB_MASTER_PORT         (0x00000000)   /* M1 port */
#define SMEM_MASTER_PORT        (0x00000000)   /* M1 port */
#define USB_PERIPH_RX_REQ       (0x00000000)   /*  0 .. 15 request identifier  */
#define USB_PERIPH_TX_REQ       (0x00000001)   /*  0 ..15  request identifier  */
#define DMA_ENDIAN_M1           (0x00000000)   /* little endian M1 port */
#define DMA_ENDIAN_M2           (0x00000000)   /* little endian M2 port */
/*************************************************************
******************* IP registers structures ******************
*************************************************************/


/****** Struct containing the SYSCNTR Register File  ********/
typedef volatile struct  __SYSCNTR_RFS {
							
		u32 clk_cntr;        /* 0x00   - clock control reg                       */
		u32 pll_conf;        /* 0x04   - pll config reg                          */
		u32 sys_status;      /* 0x08   - status reg                              */
		u32 pwr_mng;         /* 0x0C   - power manag. reg                        */
		u32 itc_msk;         /* 0x10   - interrupt mask reg                      */
		u32 pcgr0;           /* 0x14   - peripheral clock gating reg0            */
		u32 pcgr1;           /* 0x18   - peripheral clock gating reg1            */
		u32 prr0;            /* 0x1C   - peripheral reset reg0                   */
		u32 prr1;            /* 0x20   - peripheral reset reg1                   */
		u32 mgr0;            /* 0x24   - mask gating reg0                        */
		u32 mgr1;            /* 0x28   - mask gating reg1                        */
		u32 pecgr0;          /* 0x2C   - peripheral clock gating emulation reg0  */
		u32 pecgr1;          /* 0x30   - peripheral clock gating emulation reg1  */
		u32 scr0;            /* 0x34   - system controller reg0                  */
		u32 scr1;            /* 0x38   - system controller reg1                  */
		u32 scr2;            /* 0x3C   - system controller reg2                  */
		u32 scr3;            /* 0x40   - system controller reg3                  */
		u32 gpio_out0;       /* 0x44   - gpio output reg0                        */
		u32 gpio_out1;       /* 0x48   - gpio output reg1                        */
		u32 gpio_out2;       /* 0x4C   - gpio output reg2                        */
		u32 gpio_out3;       /* 0x50   - gpio output reg3                        */
		u32 gpio_out4;       /* 0x54   - gpio output reg4                        */
		u32 gpio_out5;       /* 0x58   - gpio output reg5                        */
		u32 gpio_out6;       /* 0x5C   - gpio output reg6                        */
		u32 gpio_out7;       /* 0x60   - gpio output reg7                        */
		u32 gpio_in0;        /* 0x64   - gpio input reg0                         */
		u32 gpio_in1;        /* 0x68   - gpio input reg1                         */
		u32 gpio_in2;        /* 0x6C   - gpio input reg2                         */
		u32 gpio_in3;        /* 0x70   - gpio input reg3                         */
		u32 gpio_in4;        /* 0x74   - gpio input reg4                         */
		u32 gpio_in5;        /* 0x78   - gpio input reg5                         */
		u32 gpio_in6;        /* 0x7C   - gpio input reg6                         */
		u32 gpio_in7;        /* 0x80   - gpio input reg7                         */
		u32 gpio_type0;      /* 0x84   - gpio type reg0                          */
		u32 gpio_type1;      /* 0x88   - gpio type reg1                          */
		u32 gpio_type2;      /* 0x8C   - gpio type reg2                          */
		u32 gpio_type3;      /* 0x90   - gpio type reg3                          */
		u32 gpio_type4;      /* 0x94   - gpio type reg4                          */
		u32 gpio_type5;      /* 0x98   - gpio type reg5                          */
		u32 gpio_type6;      /* 0x9C   - gpio type reg6                          */
		u32 gpio_type7;      /* 0xA0   - gpio type reg7                          */
		u32 gpio_type8;      /* 0xA4   - gpio type reg8                          */
		u32 gpio_type9;      /* 0xA8   - gpio type reg9                          */
		u32 gpio_emi;        /* 0xAC   - gpio Emi                                */
		u32 wukp_sel;        /* 0xB0   - Wake-up lines selection                 */
		u32 usb_tst;         /* 0xB4   - USB Test register                       */
		u32 lock_reg;        /* 0xB8   - Lock register for USB Test register     */
		u32 gpio4_ana;       /* 0xBC   - GPIO4 Analog Mode register              */
	} __SYSCNTR_Reg_File;


/******** Struct containing the VIC Register File  *************/
typedef volatile struct  __VICAPB_RFS {

    u32 VICIRQStatus;     /*  =  0x00   IRQ Status                          */
    u32 VICFIQStatus;     /*  =  0x04   FIQ Status                          */
    u32 VICRawIntr;       /*  =  0x08   Raw Interrupt status                */
    u32 VICIntSelect;     /*  =  0x0C   Interrupt select                    */
    u32 VICIntEnable;     /*  =  0x10   Interrupt enable                    */
    u32 VICIntEnClear;    /*  =  0x14   Interrupt enable clear              */
    u32 VICSoftInt;       /*  =  0x18   Software interrupt                  */
    u32 VICSoftIntClear;  /*  =  0x1C   Software interrupt clear            */
    u32 VICProtection;    /*  =  0x20   Protection enable                   */
    u32 reserved_array0[3];  /*  =  0x24-28-2C  dummy empty locations       */
    u32 VICVectAddr;         /*  =  0x30   Vector Address                   */
    u32 VICDefVectAddr;      /*  =  0x34   Default vector Address           */
    u32 reserved_array1[50];  /*  =  0x38-3C-...-0FC  dummy empty locations */
    u32 VICVectAddrV[16];      /*  =  0x100-0x13C  Vector Address 0-15       */
    u32 reserved_array2[48];  /*  =  0x140-...-1FC  dummy empty locations   */
    u32 VICVectCntlV[16];      /*  =  0x200-0x23C   Vector control 0-15      */
    u32 reserved_array3[48];  /*  =  0x240-..-2FC  dummy empty locations    */
    u32 VICITCR;          /*  =  0x300   Test control                       */
    u32 VICITIP1;         /*  =  0x304   Test input                         */
    u32 VICITIP2;         /*  =  0x308   Test input                         */
    u32 VICITOP1;         /*  =  0x30C   Test output                        */
    u32 VICITOP2;         /*  =  0x310   Test output                        */
    u32 reserved_array4[819]; /*  =  0x314-...-FDC  dummy empty locations   */
    u32 VICPeriphID0;     /*  =  0xFE0   Peripheral identification (7:0)    */
    u32 VICPeriphID1;     /*  =  0xFE4   Peripheral identification (15:8)   */
    u32 VICPeriphID2;     /*  =  0xFE8   Peripheral identification (23:16)  */
    u32 VICPeriphID3;     /*  =  0xFEC   Peripheral identification (31:24)  */
    u32 VICPCellID0;      /*  =  0xFF0   PrimeCell identification (7:0)     */
    u32 VICPCellID1;      /*  =  0xFF4   PrimeCell identification (15:8)    */
    u32 VICPCellID2;      /*  =  0xFF8   PrimeCell identification (23:16)   */
    u32 VICPCellID3;      /*  =  0xFFC   PrimeCell identification (31:24)   */

} __VICAPB_Reg_File;


/*********Struct containing the UART Register File  *************/
typedef volatile struct  __UARTAPB_RFS {
	//                    Uart Register Map
	// ---------------------------------------------------------------------

    u32 UartDR;          /* 0x00 - Data read or written from the interface */
    u32 UartRSR;         /* 0x04 - Receive Status Register (Read)          */
    u32 UartLCR_H;       /* 0x08 - Line Control Register, High byte        */
    u32 UartLCR_M;       /* 0x0c - Line Control Register, Middle byte      */
    u32 UartLCR_L;       /* 0x10 - Line Control Register, Low byte         */
    u32 UartCR;          /* 0x14 - control register                        */
    u32 UartFR;          /* 0x18 - Flag register (Read only)               */
    u32 Reserved;        /* 0x1c -                                         */
    u32 UartILPR;        /* 0x20 - IrDA low power counter Register         */
    u32 UartIBRD;        /* 0x24 - BAud Rate Divisor Register              */
    u32 UartFBRD;        /* 0x28 - BAud Rate Divisor Register              */
    u32 UartLCR_H_new;   /* 0x2C - Line Control Register, High byte        */
    u32 UartCR_new;      /* 0x30 - Control register(new)                   */
    u32 UartIFLS;        /* 0x34 - Interrupt fifo level select register    */
    u32 UartIMSC;        /* 0x38 - Interrupt Mask Set/Clear                */
    u32 UartRIS;         /* 0x3C - Raw Interrupt Status                    */
    u32 UartMIS;         /* 0x40 - Masked Interrupt Status                 */
    u32 UartICR;         /* 0x44 - Interrupt Clear Register                */
    u32 UartDMACR;       /* 0x48 - DMA Control Register                    */

} __UARTAPB_Reg_File;

/*********Struct containing the CAN ID Register File ***********/
typedef volatile struct
{
  vu16 CRR;
  vu16 EMPTY1;
  vu16 CMR;
  vu16 EMPTY2;
  vu16 M1R;
  vu16 EMPTY3;
  vu16 M2R;
  vu16 EMPTY4;
  vu16 A1R;
  vu16 EMPTY5;
  vu16 A2R;
  vu16 EMPTY6;
  vu16 MCR;
  vu16 EMPTY7;
  vu16 DA1R;
  vu16 EMPTY8;
  vu16 DA2R;
  vu16 EMPTY9;
  vu16 DB1R;
  vu16 EMPTY10;
  vu16 DB2R;
  vu16 EMPTY11[27];
} CAN_MsgObj_TypeDef;

typedef volatile struct
{
  vu16 CR;
  vu16 EMPTY1;
  vu16 SR;
  vu16 EMPTY2;
  vu16 ERR;
  vu16 EMPTY3;
  vu16 BTR;
  vu16 EMPTY4;
  vu16 IDR;
  vu16 EMPTY5;
  vu16 TESTR;
  vu16 EMPTY6;
  vu16 BRPR;
  vu16 EMPTY7[3];
  CAN_MsgObj_TypeDef sMsgObj[2];
  vu16 EMPTY8[16];
  vu16 TR1R;
  vu16 EMPTY9;
  vu16 TR2R;
  vu16 EMPTY10[13];
  vu16 ND1R;
  vu16 EMPTY11;
  vu16 ND2R;
  vu16 EMPTY12[13];
  vu16 IP1R;
  vu16 EMPTY13;
  vu16 IP2R;
  vu16 EMPTY14[13];
  vu16 MV1R;
  vu16 EMPTY15;
  vu16 MV2R;
  vu16 EMPTY16;
} CAN_TypeDef;
/*********Struct containing the UART ID Register File ***********/
typedef volatile struct  __UARTAPB_IDRFS {
    u32 UartPeripID0;          /* 0xe0 - UART Periph ID0[8 bits) */
    u32 UartPeripID1;          /* 0xe4 - UART Periph ID1[8 bits) */
    u32 UartPeripID2;          /* 0xe8 - UART Periph ID2[8 bits) */
    u32 UartPeripID3;          /* 0xec - UART Periph ID3[8 bits) */
    u32 UartPCellID0;          /* 0xf0 - UART Prime Cell ID0[8 bits) */
    u32 UartPCellID1;          /* 0xf4 - UART Prime Cell ID1[8 bits) */
    u32 UartPCellID2;          /* 0xf8 - UART Prime Cell ID2[8 bits) */
    u32 UartPCellID3;          /* 0xfc - UART Prime Cell ID3[8 bits) */

} __UARTAPB_IDReg_File;

/***** Struct containing the Extended Function Timer Register File ********/

typedef volatile struct  __EFTAPB_RFS {

    u32 Eft_IC1R;             /* 0x00 - Eft Input Capture 1           */
    u32 Eft_IC2R;             /* 0x04 - Eft Input Capture 2           */
    u32 Eft_OC1R;             /* 0x08 - Eft Output Compare 1          */
    u32 Eft_OC2R;             /* 0x0C - Eft Output Compare 2          */
    u32 Eft_CNTR;             /* 0x10 - Eft Counter                   */
    u32 Eft_CR1;              /* 0x14 - Eft Control Register 1        */
    u32 Eft_CR2;              /* 0x18 - Eft Control Register 2        */
    u32 Eft_SR;               /* 0x1C - Eft Status Register           */

} __EFTAPB_Reg_File;

/***** Struct containing the SPI Register File ********/

typedef volatile struct  __SPIAPB_RFS {

    u32 Sspcr0;                      /* 0x00 - SPI Control Register 0         */
    u32 Sspcr1;                      /* 0x04 - SPI Control Register 1         */
    u32 Sspdr;                       /* 0x08 - SPI Data Register    */
    u32 Sspsr;                       /* 0x0C - SPI Status Register          */
    u32 Sspcpsr;                     /* 0x10 - SPI Clock Prescaler Register           */
    u32 Sspimsc;                     /* 0x14 - SPI Interrupt Mask and Clear Register             */
    u32 Sspris;                      /* 0x18 - SPI Raw interrupt status Register              */
    u32 Sspmis;                      /* 0x1C - SPI Masked interrupt status register             */
    u32 Sspicr;                      /* 0x20 - SPI Interrupt clear Register              */
    u32 Sspdmacr;                    /* 0x24 - SPI DMA control Register              */

} __SPIAPB_Reg_File;

/************* Struct containing the USB Register File *************/
typedef struct  __USB_EP_CONF {
		u32           epConfigured;         /* TRUE or FALSE setting for the EP configuration         */
		u32           epAddr; 	           /* Endpoint address (0 ..15)     */
		enum EpDirState  epDir; 	           /* Endpoint direction            */
		enum EpBuffState epBuffer; 	           /* Endpoint buffer type          */
		enum EpModeState epMode; 	           /* Endpoint mode                 */
		enum EpTypeState epType; 	           /* Endpoint type                 */		
		u32           epMaxPackSize; 	   /* Endpoint max packet size      */
		u32           epTxChannel; 	           /* EndpointTx channel (1, 2, 3)  */
		s32            dmaTxCh; 	           /* PL080 Dma Tx channel 0 ..7 to be used, -1 => not used  */
		s32            dmaRxCh; 	           /* PL080 Dma Rx channel 0 ..7 to be used, -1 => not used  */
		u32           dblBufId; 	           /* double buffer identifier (0 .. 1) significative only in
                                                  case of double buffer (EpBuffState=USB_EP_DOUBLE) and
                                                  epMode = USB_EP_CPU. It must be toggled every time a TX
                                                  buffer is transmitted */
                u32           flgDblBuff;   /* flag double buffer (0,1) significative only in
                                                  case of double buffer and epMode = USB_EP_CPU or USB_EP_DMA_UNLK */
	} __EP_CONF;


typedef struct  __USB_CD {
		enum UsbState   state;                /* { USB_UNKNOWN, USB_POWERED_STATE, USB_DEFAULT_STATE, */
		                            	      /*  USB_ADDRESSED_STATE, USB_CONFIGURED_STATE,          */
						                      /*  USB_SUSPENDED_STATE }                               */
		u32          endpointNum;	      /* Endpoint number                                      */
		u32          endpointConfCount;    /* Endpoint configured counter                          */
		__EP_CONF       endpointConf[16];     /* Enpoint Configuration data structure related to the
		                                         EP_ID identifier                                     */
		u32          PackMemPt;            /* Point the first free entry of the packet memory      */
		s32           dmaTxCh; 	          /* PL080 Dma Tx enabled channel 0 ..7, -1 => not used   */
		s32           dmaRxCh; 	          /* PL080 Dma Rx enabled channel 0 ..7, -1 => not used   */
		u32          epId[16]; 	          /* array containing the endpoint Id  */
	} __USB_Configuration_Data;


/* Struct containing the USB Register File : */
typedef volatile struct  __USB_RFS {
							
		u32 pbuff[512];      /* 0x000 0x7FE - Packet Buffer Memory  	            */
		u32 ep0r;            /* 0x800       - Endpoint  Register EP0   	        */
		u32 ep1r;            /* 0x804       - Endpoint  Register EP1   	        */
		u32 ep2r;            /* 0x808       - Endpoint  Register EP2   	        */
		u32 ep3r;            /* 0x80C       - Endpoint  Register EP3   	        */
		u32 ep4r;            /* 0x810       - Endpoint  Register EP4   	        */
		u32 ep5r;            /* 0x814       - Endpoint  Register EP5   	        */
		u32 ep6r;            /* 0x818       - Endpoint  Register EP6   	        */
		u32 ep7r;            /* 0x81C       - Endpoint  Register EP7   	        */
		u32 ep8r;            /* 0x820       - Endpoint  Register EP8   	        */
		u32 ep9r;            /* 0x824       - Endpoint  Register EP9   	        */
		u32 ep10r;           /* 0x828       - Endpoint  Register EP10   	        */
		u32 ep11r;           /* 0x82C       - Endpoint  Register EP11   	        */
		u32 ep12r;           /* 0x830       - Endpoint  Register EP12   	        */
		u32 ep13r;           /* 0x834       - Endpoint  Register EP13   	        */
		u32 ep14r;           /* 0x838       - Endpoint  Register EP14   	        */
		u32 ep15r;           /* 0x83C       - Endpoint  Register EP15   	        */
		u32 cntr;            /* 0x840       - Control   Register    	                */
		u32 istr;            /* 0x844       - Interrupt Status     Register          */
		u32 fnr;             /* 0x848       - Frame     Number     Register          */
		u32 daddr;           /* 0x84C       - Device    Address    Register          */
		u32 btable;          /* 0x850       - Buffer Table Address Register          */
		u32 dma_cntr1;       /* 0x854       - DMA Control(1)   Register              */
		u32 dma_cntr2;       /* 0x858       - DMA Control(2)   Register              */
		u32 dma_cntr3;       /* 0x85C       - DMA Control(3)   Register              */
		u32 dma_bsize;       /* 0x860       - DMA Bsize   Register    	        */
		u32 dma_lli;         /* 0x864       - DMA LLI     Register    	        */
	} __USB_RF;
/************ Struct containing the PL080 Register File **************** */
typedef volatile struct  __PL080_RFS {
							
   u32 dmacIntStatus;         /* 0x00  - DMA Interrupt Status Register	         */
   u32 dmacIntTCStatus;       /* 0x04  - DMA Interrupt Terminal Count Status Register */
   u32 dmacIntTCclear;        /* 0x08  - DMA Interrupt Terminal Count Clear Register  */
   u32 dmacIntErrorStatus;    /* 0x0C  - DMA Interrupt Error Status Register          */
   u32 dmacIntErrClr;         /* 0x10  - DMA Interrupt Error Clear Register           */
   u32 dmacRawIntTCStatus;    /* 0x14  - DMA Raw Int. Terminal Count Status Register  */
   u32 dmacRawIntErrorStatus; /* 0x18  - DMA Raw Int. Error  Status Register          */
   u32 dmacEnbldChns;         /* 0x1C  - DMA Enabled Channels Register                */
   u32 dmacSoftBReq;          /* 0x20  - DMA Software Burst Request Register          */
   u32 dmacSoftSReq;          /* 0x24  - DMA Software Single Request Register         */
   u32 dmacSoftLBReq;         /* 0x28  - DMA Software Last Burst Request Register     */
   u32 dmacSoftLSReq;         /* 0x2C  - DMA Software Last Single Request Register    */
   u32 dmacConfiguration;     /* 0x30  - DMA Configuration Register                   */
   u32 dmacSync;              /* 0x34  - DMA Synchronization Register                 */

   u32 dmacDummy0[50];        /* 0x38-0xFC  - DMA Unused Registers                    */

   u32 dmacC0SrcAddr;         /* 0x100  - DMA Ch0 Source Address Register              */
   u32 dmacC0DestAddr;        /* 0x104  - DMA Ch0 Destination Address Register         */
   u32 dmacC0LliAddr;         /* 0x108  - DMA Ch0 Linked List Address Register         */
   u32 dmacC0Control;         /* 0x10C  - DMA Ch0 Control Register                     */
   u32 dmacC0Configuration;   /* 0x110  - DMA Ch0 Configuration Register               */

   u32 dmacDummy1[3];         /* 0x114-0x11C  - DMA Unused Registers                   */

   u32 dmacC1SrcAddr;         /* 0x120  - DMA Ch1 Source Address Register              */
   u32 dmacC1DestAddr;        /* 0x124  - DMA Ch1 Destination Address Register         */
   u32 dmacC1LliAddr;         /* 0x128  - DMA Ch1 Linked List Address Register         */
   u32 dmacC1Control;         /* 0x12C  - DMA Ch1 Control Register                     */
   u32 dmacC1Configuration;   /* 0x130  - DMA Ch1 Configuration Register               */

   u32 dmacDummy2[3];         /* 0x134-0x13C  - DMA Unused Registers                   */

   u32 dmacC2SrcAddr;         /* 0x140  - DMA Ch2 Source Address Register              */
   u32 dmacC2DestAddr;        /* 0x144  - DMA Ch2 Destination Address Register         */
   u32 dmacC2LliAddr;         /* 0x148  - DMA Ch2 Linked List Address Register         */
   u32 dmacC2Control;         /* 0x14C  - DMA Ch2 Control Register                     */
   u32 dmacC2Configuration;   /* 0x150  - DMA Ch2 Configuration Register               */

   u32 dmacDummy3[3];         /* 0x154-0x15C  - DMA Unused Registers                   */

   u32 dmacC3SrcAddr;         /* 0x160  - DMA Ch3 Source Address Register              */
   u32 dmacC3DestAddr;        /* 0x164  - DMA Ch3 Destination Address Register         */
   u32 dmacC3LliAddr;         /* 0x168  - DMA Ch3 Linked List Address Register         */
   u32 dmacC3Control;         /* 0x16C  - DMA Ch3 Control Register                     */
   u32 dmacC3Configuration;   /* 0x170  - DMA Ch3 Configuration Register               */

   u32 dmacDummy4[3];         /* 0x174-0x17C  - DMA Unused Registers                   */

   u32 dmacC4SrcAddr;         /* 0x180  - DMA Ch4 Source Address Register              */
   u32 dmacC4DestAddr;        /* 0x184  - DMA Ch4 Destination Address Register         */
   u32 dmacC4LliAddr;         /* 0x188  - DMA Ch4 Linked List Address Register         */
   u32 dmacC4Control;         /* 0x18C  - DMA Ch4 Control Register                     */
   u32 dmacC4Configuration;   /* 0x190  - DMA Ch4 Configuration Register               */

   u32 dmacDummy5[3];         /* 0x194-0x19C  - DMA Unused Registers                   */

   u32 dmacC5SrcAddr;         /* 0x1A0  - DMA Ch5 Source Address Register              */
   u32 dmacC5DestAddr;        /* 0x1A4  - DMA Ch5 Destination Address Register         */
   u32 dmacC5LliAddr;         /* 0x1A8  - DMA Ch5 Linked List Address Register         */
   u32 dmacC5Control;         /* 0x1AC  - DMA Ch5 Control Register                     */
   u32 dmacC5Configuration;   /* 0x1B0  - DMA Ch5 Configuration Register               */

   u32 dmacDummy6[3];         /* 0x1B4-0x1BC  - DMA Unused Registers                   */

   u32 dmacC6SrcAddr;         /* 0x1C0  - DMA Ch6 Source Address Register              */
   u32 dmacC6DestAddr;        /* 0x1C4  - DMA Ch6 Destination Address Register         */
   u32 dmacC6LliAddr;         /* 0x1C8  - DMA Ch6 Linked List Address Register         */
   u32 dmacC6Control;         /* 0x1CC  - DMA Ch6 Control Register                     */
   u32 dmacC6Configuration;   /* 0x1D0  - DMA Ch6 Configuration Register               */

   u32 dmacDummy7[3];         /* 0x1D4-0x1DC  - DMA Unused Registers                   */

   u32 dmacC7SrcAddr;         /* 0x1E0  - DMA Ch7 Source Address Register              */
   u32 dmacC7DestAddr;        /* 0x1E4  - DMA Ch7 Destination Address Register         */
   u32 dmacC7LliAddr;         /* 0x1E8  - DMA Ch7 Linked List Address Register         */
   u32 dmacC7Control;         /* 0x1EC  - DMA Ch7 Control Register                     */
   u32 dmacC7Configuration;   /* 0x1F0  - DMA Ch7 Configuration Register               */

   u32 dmacDummy8[891];       /* 0x1F4-0xFDC  - DMA Unused Registers                   */

   u32 dmacPeriphId0;         /* 0xFE0  - DMA Peripheral Identification Register       */
   u32 dmacPeriphId1;         /* 0xFE4  - DMA Peripheral Identification Register       */
   u32 dmacPeriphId2;         /* 0xFE8  - DMA Peripheral Identification Register       */
   u32 dmacPeriphId3;         /* 0xFEC  - DMA Peripheral Identification Register       */

   u32 dmacCellId0;           /* 0xFF0  - DMA Primecell Identification Register        */
   u32 dmacCellId1;           /* 0xFF4  - DMA Primecell Identification Register        */
   u32 dmacCellId2;           /* 0xFF8  - DMA Primecell Identification Register        */
   u32 dmacCellId3;           /* 0xFFC  - DMA Primecell Identification Register        */
   } __PL080_Reg_File;

/************************************************************	
******************Memory Mapping of STR9X *******************
*************************************************************/

#define AHB_EMIB0_R0       (0x00000000) /* EMI bank0 with Remap=0*/
#define AHB_LOCAL_SRAM_R1  (0x00000000) /* Local SRAM with Remap=1*/
#define AHB_LOCAL_SRAM_D   (0x04000000) /* Local SRAM mapped into the DTCM space*/

#define AHB_EMIB3_B        (0x20000000) /* EMI bank3 Buffered Space*/
#define AHB_EMIB2_B        (0x24000000) /* EMI bank2 Buffered Space*/
#define AHB_EMIB1_B        (0x28000000) /* EMI bank1 Buffered Space*/
#define AHB_EMIB0_B        (0x2C000000) /* EMI bank0 Buffered Space*/

#define AHB_EMIB3_U        (0x30000000) /* EMI bank3 UnBuffered Space*/
#define AHB_EMIB2_U        (0x34000000) /* EMI bank2 UnBuffered Space*/
#define AHB_EMIB1_U        (0x38000000) /* EMI bank1 UnBuffered Space*/
#define AHB_EMIB0_U        (0x3C000000) /* EMI bank0 UnBuffered Space*/

#define AHB_LOCAL_SRAM_B   (0x40000000) /* Local SRAM Buffered Space*/
#define AHB_PFQBC_B        (0x44000000) /* PFQBC Buffered Space*/
#define AHB_APB_BRDG0_B    (0x48000000) /* AHB/APB Bridge 0 Buffered Space*/
#define AHB_APB_BRDG1_B    (0x4C000000) /* AHB/APB Bridge 1 Buffered Space*/

#define AHB_LOCAL_SRAM_U   (0x50000000) /* Local SRAM UnBuffered Space*/
#define AHB_PFQBC_U        (0x54000000) /* PFQBC UnBuffered Space*/
#define AHB_APB_BRDG0_U    (0x58000000) /* AHB/APB Bridge 0 UnBuffered Space*/
#define AHB_APB_BRDG1_U    (0x5C000000) /* AHB/APB Bridge 1 UnBuffered Space*/

#define AHB_USB_B          (0x60000000) /* USB Buffered Space*/
#define AHB_EMI_CONF_B     (0x64000000) /* EMI Config Buffered Space*/
#define AHB_DMA_CONF_B     (0x68000000) /* DMA Pl080 Config Buffered Space*/
#define AHB_MAC_CONF_B     (0x6C000000) /* MAC Config Buffered Space*/

#define AHB_USB_U          (0x70000000) /* USB UnBuffered Space*/
#define AHB_EMI_CONF_U     (0x74000000) /* EMI Config UnBuffered Space*/
#define AHB_DMA_CONF_U     (0x78000000) /* DMA Pl080 Config UnBuffered Space*/
#define AHB_MAC_CONF_U     (0x7C000000) /* MAC Config UnBuffered Space*/

#define AHB_VIC1_U         (0xFC000000) /* Secondary VIC1 UnBuffered Space*/
#define AHB_ROM_LKEY       (0xFFFF0000) /* ROM Locking Key UnBuffered Space*/
#define AHB_VIC0_U         (0xFFFFF000) /* Primary VIC0 UnBuffered Space*/


/*********************************************/
/*  Addresses related to the APB0 sub-system  */
/*********************************************/
#define APB_WAKEUP_OFST    (0x00001000) /* Offset of wake up unit */
#define APB_EFT0_OFST      (0x00002000) /* Offset of EFT0 */
#define APB_EFT1_OFST      (0x00003000) /* Offset of EFT1 */
#define APB_EFT2_OFST      (0x00004000) /* Offset of EFT2 */
#define APB_EFT3_OFST      (0x00005000) /* Offset of EFT3 */
#define APB_GPIO0_OFST     (0x00006000) /* Offset of GPIO0 */
#define APB_GPIO1_OFST     (0x00007000) /* Offset of GPIO1 */
#define APB_GPIO2_OFST     (0x00008000) /* Offset of GPIO2 */
#define APB_GPIO3_OFST     (0x00009000) /* Offset of GPIO3 */
#define APB_GPIO4_OFST     (0x0000A000) /* Offset of GPIO4 */
#define APB_GPIO5_OFST     (0x0000B000) /* Offset of GPIO5 */
#define APB_GPIO6_OFST     (0x0000C000) /* Offset of GPIO6 */
#define APB_GPIO7_OFST     (0x0000D000) /* Offset of GPIO7 */
#define APB_GPIO8_OFST     (0x0000E000) /* Offset of GPIO8 */
#define APB_GPIO9_OFST     (0x0000F000) /* Offset of GPIO9 */

/*********************************************/
/*  Addresses related to the APB1 sub-system  */
/*********************************************/
#define APB_RTC_OFST       (0x00001000) /* Offset of RTC */
#define APB_SYSTCTRL_OFST  (0x00002000) /* Offset of System Controller */
#define APB_MC_OFST        (0x00003000) /* Offset of Motor Control */
#define APB_UART0_OFST     (0x00004000) /* Offset of UART0 */
#define APB_UART1_OFST     (0x00005000) /* Offset of UART1 */
#define APB_UART2_OFST     (0x00006000) /* Offset of UART2 */
#define APB_SPI0_OFST      (0x00007000) /* Offset of SPI0 */
#define APB_SPI1_OFST      (0x00008000) /* Offset of SPI1 */
#define APB_CAN_OFST       (0x00009000) /* Offset of CAN */
#define APB_ADC_OFST       (0x0000A000) /* Offset of ADC */
#define APB_WDG_OFST       (0x0000B000) /* Offset of WDG */
#define APB_I2C0_OFST      (0x0000C000) /* Offset of I2C0 */
#define APB_I2C1_OFST      (0x0000D000) /* Offset of I2C1 */

#define SYSCNTR_BASE		(AHB_APB_BRDG1_U + APB_SYSTCTRL_OFST)
#define UART0_BASE      	(AHB_APB_BRDG1_U + APB_UART0_OFST)
#define UART1_BASE      	(AHB_APB_BRDG1_U + APB_UART1_OFST) //jerry
#define UART2_BASE      	(AHB_APB_BRDG1_U + APB_UART2_OFST) //jerry
#define VIC0_BASE			(AHB_VIC0_U)
#define VIC1_BASE			(AHB_VIC1_U)
#define EFT0_BASE			(AHB_APB_BRDG0_U + APB_EFT0_OFST) //jerry
#define EFT1_BASE			(AHB_APB_BRDG0_U + APB_EFT1_OFST)
#define EFT3_BASE			(AHB_APB_BRDG0_U + APB_EFT3_OFST)
#define RTC_BASE              (AHB_APB_BRDG1_U + APB_RTC_OFST) //jerry
#define SPI0_BASE			(AHB_APB_BRDG1_U + APB_SPI0_OFST)
#define SPI1_BASE			(AHB_APB_BRDG1_U + APB_SPI1_OFST)
#define CAN_BASE                        (AHB_APB_BRDG1_U + APB_CAN_OFST)
#define USB_BASE                       (AHB_USB_B)
#define DMA_BASE                       (AHB_DMA_CONF_B)

/*******************************************************************************
************************** IP data access defintions ***************************
*******************************************************************************/
#ifndef DEBUG
	#define SYSCNTR ((__SYSCNTR_Reg_File *)(SYSCNTR_BASE))
	#define UART0 ((__UARTAPB_Reg_File *) (UART0_BASE))
	#define UART1 ((__UARTAPB_Reg_File *) (UART1_BASE)) //jerry
        #define UART2 ((__UARTAPB_Reg_File *) (UART2_BASE)) //jerry
	#define VIC0  ((__VICAPB_Reg_File *) (VIC0_BASE))
	#define VIC1  ((__VICAPB_Reg_File *) (VIC1_BASE))
	#define EFT0  ((__EFTAPB_Reg_File *) (EFT0_BASE)) //jerry
	#define EFT1  ((__EFTAPB_Reg_File *) (EFT1_BASE)) //jerry
        #define EFT3  ((__EFTAPB_Reg_File *) (EFT3_BASE)) //jerry
        #define RTC   ((__RTCAPB_Reg_File *) (RTC_BASE))//jerry
        #define SPI0  ((__SPIAPB_Reg_File *) (SPI0_BASE))
        #define SPI1  ((__SPIAPB_Reg_File *) (SPI1_BASE))
        #define CAN   ((CAN_TypeDef*)(CAN_BASE))
        #define USB_RF   ((__USB_RF    *)   (USB_BASE))
        #define DMA_RF   ((__PL080_Reg_File    *)   (DMA_BASE))


#else   /* DEBUG */

#ifdef _SYSCNTR
	EXT __SYSCNTR_Reg_File *SYSCNTR;
#endif


#ifdef _UART
	#ifdef _UART0
  	EXT __UARTAPB_Reg_File *UART0;
	#endif
#endif
        #ifdef _UART
	#ifdef _UART1
  	EXT __UARTAPB_Reg_File *UART1;
	#endif
#endif
        #ifdef _UART
	#ifdef _UART2
  	EXT __UARTAPB_Reg_File *UART2;
	#endif
#endif

#ifdef  _VIC
	#ifdef _VIC0
	EXT __VICAPB_Reg_File *VIC0;
	#endif

	#ifdef _VIC1
	EXT __VICAPB_Reg_File *VIC1;
	#endif
#endif

#ifdef _EFT0

 EXT __EFTAPB_Reg_File *EFT0;
 #endif
 #ifdef _EFT1

 EXT __EFTAPB_Reg_File *EFT1;

 ifdef _EFT3

 EXT __EFTAPB_Reg_File *EFT3;
 #endif

 #ifdef  _SPI
	#ifdef _SPI0
	EXT __SPIAPB_Reg_File *SPI0;
	#endif

	#ifdef _SPI1
	EXT __SPIAPB_Reg_File *SPI1;
	#endif

#endif
 #ifdef _CAN
	EXT CAN_TypeDef *CAN;
#endif
#ifdef _USB
	EXT __USB_RF *USB_RF;
#endif
#ifdef _DMA
	EXT __PL080_Reg_File *DMA_RF;
#endif
#endif  /* DEBUG */


#endif  /* __91x_map_H */

/******************* (C) COPYRIGHT 2005 STMicroelectronics *****END OF FILE****/
