//////////////////////////////////////////////////////////////////
// DSPLIB\FFTtest\GENE.C * Generator for data,coefs, bit patterns, etc..
//////////////////////////////////////////////////////////////////
// 1.1 <06DEC05> creation - copied from FFT project- simplified version - not used
////////////////////////////////////////////////////////////////
#include "globals.h"


/* Claim an aligned working buffer */
#define ALIGNMENT 8  /* LDRD requires an 8-byte aligned buffer */

/* Generate a test signal of size real samples.
 * Each value of code generates a different signal.
 */

real *gen_signal(int size, int code)
{
  real *signal, scale;
  int i;
  int64 seed = 0x0123456789abcdefull;
  int64 mult;

  signal = (real *)my_malloc(size * sizeof(real));

  if (code==-1)
  {
    signal[0] = 0.9997;//instead of 1
    for (i=1; i<size; i++)    { signal[i] = 0.0;    }
    return signal;
  }

  if (code==-2)
  {
    signal[0] = 0.0;    signal[1]=  0.999 ;
    for (i=2; i<size; i++)    { signal[i] = 0.0;    }
    return signal;
  }

  if (code==-3)
  {
    signal[0] = 0.999;    signal[1]=  0.999 ;
    for (i=2; i<size; i++)    { signal[i] = 0.0;    }
    return signal;
  }

  if (code==-4)
  {
    signal[0] = 0;    signal[1]=  0.3333 ;
    signal[2] = 0.6666;    signal[3]=  0;
    for (i=4; i<size; i++)    { signal[i] = 0.0;    }
    return signal;
  }

  /* scramble code */
  mult  = code * 0x89abcdef76543210ull ^ 0xa75bc38291E6D6A5ull;
  scale = 1.0/(real)(1ull<<63);

  for (i=0; i<size; i++)
  {
    seed = seed * mult;
    signal[i] = (real)seed*scale;
  }
  return signal;
}

void *my_malloc(int size)
{
  void *p;
  unsigned int a;

  p = malloc(size+ALIGNMENT-1);
  if (!p)
  {
     exit(1);
  }
  a = (unsigned int)p & (ALIGNMENT-1);
  if (a)
  {
    /* if not aligned then align the array */
    p = (void*)((char*)p+ALIGNMENT-a);
  }
  return p;
}


void free_signal(void *data)
{
  /* data may not be the pointer we malloced */
  (void)data;
  //free(data);
}


// Convert a real to a 64 bit integer
static int64 real_to_int(real x)
{
  /* round and then cast */
  if (x>=0) x+=0.5;
  if (x<=0) x-=0.5;
  return (int64)x;
}

// Convert a test signal to the indicated format type
void *gen_data(int size, format type, real *ref)
{
  void *data;
  int tsize;
  real qscale;
  int i;

  tsize  = TSIZE(type);
  qscale = (real)(1ull<<QSHIFT(type));

  data = my_malloc(size*tsize+4);

  for (i=0; i<size; i++)
  {
    int64 d;
    d = real_to_int(ref[i]*qscale);
    switch (tsize)
    {
      case 8 : ((int8  *)data)[i] = (int8)d; break;
      case 16: ((int16 *)data)[i] = (int16)d; break;
      case 32: ((int32 *)data)[i] = (int32)d; break;
      case 64: ((int64 *)data)[i] = (int64)d; break;
    }
  }

  return data;
}

/* Compare a reference signal with a fixed point point signal
 * to check that they match with a given tolerance.
 */

int compare(real *ref, void *data, format type, int size, int maxerr)
{
  int err=0, i;
  int tsize;
  real qscale;

  tsize  = TSIZE(type);
  qscale = (real)(1ull<<QSHIFT(type));

  for (i=0; i<size; i++)
  {
    int64 out, ref_out, d;

    ref_out = real_to_int(ref[i]*qscale);
    switch (tsize)
    {
      case 8 : out = ((int8  *)data)[i]; break;
      case 16: out = ((int16 *)data)[i]; break;
      case 32: out = ((int32 *)data)[i]; break;
      case 64: out = ((int64 *)data)[i]; break;
    }
    d = out-ref_out;
    if (d<0) d=-d;
    if ((unsigned)d>=maxerr)
    {
      err++;
    }
  }

  return err;
}
