/******************** (C) COPYRIGHT 2005 STMicroelectronics ********************
* File Name          : syscntr.h
* Author             : Deepak Sharma
* Date First Issued  : 05/26/2005
* Description        : This file contains all the functions prototypes and data
*						for the SYSCNTR software library.
********************************************************************************
* History:
*  05/26/2005 : V0.1
*******************************************************************************
 THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS WITH
 CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
 AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT
 OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE CONTENT
 OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING INFORMATION
 CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/
#ifndef __SYSCNTR_H
#define __SYSCNTR_H

#include "91x_map.h"

/*******************************************************************************
********************** SYSCNTR specific definition, constants ******************
*******************************************************************************/

/* Function return values */

#define SYSCNTR_OK           (0)
#define SYSCNTR_NOK          ~0x1 //dfm
#define SYSCNTR_LSB_MASK     (0x1)
#define SYSCNTR_TWOBIT_MASK  (0x3)
#define SYSCNTR_3BIT_MASK    (0x7)


/* Register File Masks */

/* CLK CNTR */
#define SYSC_CLKCNTR_MASK              (0x7FFFF)
#define SYSC_CLKCNTR_EMIRATIO_MASK     (0x1FFFF)
#define SYSC_CLKCNTR_FMISEL_MASK       (0x6FFFF)
#define SYSC_CLKCNTR_MCSEL_MASK        (0x77FFF)
#define SYSC_CLKCNTR_EFT34SEL_MASK     (0x7BFFF)
#define SYSC_CLKCNTR_EFT12SEL_MASK     (0x7DFFF)
#define SYSC_CLKCNTR_MACSEL_MASK       (0x7EFFF)
#define SYSC_CLKCNTR_USBSEL_MASK       (0x7F3FF)
#define SYSC_CLKCNTR_BRSEL_MASK        (0x7FDFF)
#define SYSC_CLKCNTR_APBDIV_MASK       (0x7FE7F)
#define SYSC_CLKCNTR_AHBDIV_MASK       (0x7FF9F)
#define SYSC_CLKCNTR_CKDIV_MASK        (0x7FFE3)
#define SYSC_CLKCNTR_CKSEL_MASK        (0x7FFFC)

/* PLL CONFIG */
#define SYSC_PLL_MASK         (0xFFFFF)
#define SYSC_PLL_NOTEN_MASK   (0x7FFFF)
#define SYSC_PLL_EN_MASK      (0x80000)

#define SYSC_MAC_SEL_MASK 0x7EFFF
#define GPIO_ALTERNATE_FUNCTION_ONE      0x1
#define GPIO_ALTERNATE_FUNCTION_TWO     0x2
#define GPIO_ALTERNATE_FUNCTION_THREE  0x3

/* STATUS REG */
#define SYSC_STATUS_SRAMERR_MASK   (0x20)
#define SYSC_STATUS_ACKPFQBC_MASK  (0x10)
#define SYSC_STATUS_LVD_MASK       (0x08)
#define SYSC_STATUS_WDG_MASK       (0x04)
#define SYSC_STATUS_LOCKL_MASK     (0x02)
#define SYSC_STATUS_LOCK_MASK      (0x01)

/* POWER MANAG. REG */
#define SYSC_PWRMNG_MASK     (0x1F)

/* ITC MASK. REG */
#define SYSC_ITC_MASK                (0x1F)
#define SYSC_ITC_CLRSRAMERR_MASK     (0x17)
#define SYSC_ITC_CLRACKPFQ_MASK      (0xB)
#define SYSC_ITC_CLRLOCKL_MASK       (0xD)
#define SYSC_ITC_CLRLOCK_MASK        (0xE)

/* PCGR0 */
#define SYSC_PCGR0_MASK              (0xFFF)
#define SYSC_PCGR0_MAC_MASK          (0x7FF)
#define SYSC_PCGR0_USB48M_MASK       (0xBFF)
#define SYSC_PCGR0_USB_MASK          (0xDFF)
#define SYSC_PCGR0_DMA_MASK          (0xEFF)
#define SYSC_PCGR0_EXTMEMCLK_MASK    (0xF7F)
#define SYSC_PCGR0_EMI_MASK          (0xFBF)
#define SYSC_PCGR0_VIC_MASK          (0xFDF)
#define SYSC_PCGR0_SRAMARB_MASK      (0xFEF)
#define SYSC_PCGR0_SRAM_MASK         (0xFF7)
#define SYSC_PCGR0_PFQBC_MASK        (0xFFD)
#define SYSC_PCGR0_FMI_MASK          (0xFFE)

/* PCGR1 */
#define SYSC_PCGR1_MASK              (0x1FFFFFF)
#define SYSC_PCGR1_RTC_MASK          (0x0FFFFFF)
#define SYSC_PCGR1_GPIO9_MASK        (0x17FFFFF)
#define SYSC_PCGR1_GPIO8_MASK        (0x1BFFFFF)
#define SYSC_PCGR1_GPIO7_MASK        (0x1DFFFFF)
#define SYSC_PCGR1_GPIO6_MASK        (0x1EFFFFF)
#define SYSC_PCGR1_GPIO5_MASK        (0x1F7FFFF)
#define SYSC_PCGR1_GPIO4_MASK        (0x1FBFFFF)
#define SYSC_PCGR1_GPIO3_MASK        (0x1FDFFFF)
#define SYSC_PCGR1_GPIO2_MASK        (0x1FEFFFF)
#define SYSC_PCGR1_GPIO1_MASK        (0x1FF7FFF)
#define SYSC_PCGR1_GPIO0_MASK        (0x1FFBFFF)
#define SYSC_PCGR1_WAKEUP_MASK       (0x1FFDFFF)
#define SYSC_PCGR1_WDG_MASK          (0x1FFEFFF)
#define SYSC_PCGR1_ADC_MASK          (0x1FFF7FF)
#define SYSC_PCGR1_CAN_MASK          (0x1FFFBFF)
#define SYSC_PCGR1_SPI1_MASK         (0x1FFFDFF)
#define SYSC_PCGR1_SPI0_MASK         (0x1FFFEFF)
#define SYSC_PCGR1_I2C1_MASK         (0x1FFFF7F)
#define SYSC_PCGR1_I2C0_MASK         (0x1FFFFBF)
#define SYSC_PCGR1_UART2_MASK        (0x1FFFFDF)
#define SYSC_PCGR1_UART1_MASK        (0x1FFFFEF)
#define SYSC_PCGR1_UART0_MASK        (0x1FFFFF7)
#define SYSC_PCGR1_MOTCNT_MASK       (0x1FFFFFB)
#define SYSC_PCGR1_EFT34_MASK        (0x1FFFFFD)
#define SYSC_PCGR1_EFT12_MASK        (0x1FFFFFE)

/* PRR0 */
#define SYSC_PRR0_MASK              (0x1FFF)
#define SYSC_PRR0_PFQBCAHB_MASK     (0x0FFF)
#define SYSC_PRR0_MAC_MASK          (0x17FF)
#define SYSC_PRR0_USB_MASK          (0x1DFF)
#define SYSC_PRR0_DMA_MASK          (0x1EFF)
#define SYSC_PRR0_EMI_MASK          (0x1FBF)
#define SYSC_PRR0_VIC_MASK          (0x1FDF)
#define SYSC_PRR0_SRAMARB_MASK      (0x1FEF)
#define SYSC_PRR0_PFQBC_MASK        (0x1FFD)
#define SYSC_PRR0_FMI_MASK          (0x1FFE)

/* PRR1 */
#define SYSC_PRR1_MASK              (0x1FFFFFF)
#define SYSC_PRR1_RTC_MASK          (0x0FFFFFF)
#define SYSC_PRR1_GPIO9_MASK        (0x17FFFFF)
#define SYSC_PRR1_GPIO8_MASK        (0x1BFFFFF)
#define SYSC_PRR1_GPIO7_MASK        (0x1DFFFFF)
#define SYSC_PRR1_GPIO6_MASK        (0x1EFFFFF)
#define SYSC_PRR1_GPIO5_MASK        (0x1F7FFFF)
#define SYSC_PRR1_GPIO4_MASK        (0x1FBFFFF)
#define SYSC_PRR1_GPIO3_MASK        (0x1FDFFFF)
#define SYSC_PRR1_GPIO2_MASK        (0x1FEFFFF)
#define SYSC_PRR1_GPIO1_MASK        (0x1FF7FFF)
#define SYSC_PRR1_GPIO0_MASK        (0x1FFBFFF)
#define SYSC_PRR1_WAKEUP_MASK       (0x1FFDFFF)
#define SYSC_PRR1_WDG_MASK          (0x1FFEFFF)
#define SYSC_PRR1_ADC_MASK          (0x1FFF7FF)
#define SYSC_PRR1_CAN_MASK          (0x1FFFBFF)
#define SYSC_PRR1_SPI1_MASK         (0x1FFFDFF)
#define SYSC_PRR1_SPI0_MASK         (0x1FFFEFF)
#define SYSC_PRR1_I2C1_MASK         (0x1FFFF7F)
#define SYSC_PRR1_I2C0_MASK         (0x1FFFFBF)
#define SYSC_PRR1_UART2_MASK        (0x1FFFFDF)
#define SYSC_PRR1_UART1_MASK        (0x1FFFFEF)
#define SYSC_PRR1_UART0_MASK        (0x1FFFFF7)
#define SYSC_PRR1_MOTCNT_MASK       (0x1FFFFFB)
#define SYSC_PRR1_EFT34_MASK        (0x1FFFFFD)
#define SYSC_PRR1_EFT12_MASK        (0x1FFFFFE)

/* MGR0 */
#define SYSC_MGR0_MASK              (0xFFF)
#define SYSC_MGR0_MAC_MASK          (0x7FF)
#define SYSC_MGR0_USB48M_MASK       (0xBFF)
#define SYSC_MGR0_USB_MASK          (0xDFF)
#define SYSC_MGR0_DMA_MASK          (0xEFF)
#define SYSC_MGR0_EXTMEMCLK_MASK    (0xF7F)
#define SYSC_MGR0_EMI_MASK          (0xFBF)
#define SYSC_MGR0_VIC_MASK          (0xFDF)
#define SYSC_MGR0_SRAMARB_MASK      (0xFEF)
#define SYSC_MGR0_SRAM_MASK         (0xFF7)
#define SYSC_MGR0_ARM_MASK          (0xFFB)
#define SYSC_MGR0_PFQBC_MASK        (0xFFD)
#define SYSC_MGR0_FMI_MASK          (0xFFE)

/* MGR1 */
#define SYSC_MGR1_MASK              (0x1FFFFFF)
#define SYSC_MGR1_RTC_MASK          (0x0FFFFFF)
#define SYSC_MGR1_GPIO9_MASK        (0x17FFFFF)
#define SYSC_MGR1_GPIO8_MASK        (0x1BFFFFF)
#define SYSC_MGR1_GPIO7_MASK        (0x1DFFFFF)
#define SYSC_MGR1_GPIO6_MASK        (0x1EFFFFF)
#define SYSC_MGR1_GPIO5_MASK        (0x1F7FFFF)
#define SYSC_MGR1_GPIO4_MASK        (0x1FBFFFF)
#define SYSC_MGR1_GPIO3_MASK        (0x1FDFFFF)
#define SYSC_MGR1_GPIO2_MASK        (0x1FEFFFF)
#define SYSC_MGR1_GPIO1_MASK        (0x1FF7FFF)
#define SYSC_MGR1_GPIO0_MASK        (0x1FFBFFF)
#define SYSC_MGR1_WAKEUP_MASK       (0x1FFDFFF)
#define SYSC_MGR1_WDG_MASK          (0x1FFEFFF)
#define SYSC_MGR1_ADC_MASK          (0x1FFF7FF)
#define SYSC_MGR1_CAN_MASK          (0x1FFFBFF)
#define SYSC_MGR1_SPI1_MASK         (0x1FFFDFF)
#define SYSC_MGR1_SPI0_MASK         (0x1FFFEFF)
#define SYSC_MGR1_I2C1_MASK         (0x1FFFF7F)
#define SYSC_MGR1_I2C0_MASK         (0x1FFFFBF)
#define SYSC_MGR1_UART2_MASK        (0x1FFFFDF)
#define SYSC_MGR1_UART1_MASK        (0x1FFFFEF)
#define SYSC_MGR1_UART0_MASK        (0x1FFFFF7)
#define SYSC_MGR1_MOTCNT_MASK       (0x1FFFFFB)
#define SYSC_MGR1_EFT34_MASK        (0x1FFFFFD)
#define SYSC_MGR1_EFT12_MASK        (0x1FFFFFE)

/* PECGR0 */
#define SYSC_PECGR0_MASK              (0xFFF)
#define SYSC_PECGR0_MAC_MASK          (0x7FF)
#define SYSC_PECGR0_USB48M_MASK       (0xBFF)
#define SYSC_PECGR0_USB_MASK          (0xDFF)
#define SYSC_PECGR0_DMA_MASK          (0xEFF)
#define SYSC_PECGR0_EXTMEMCLK_MASK    (0xF7F)
#define SYSC_PECGR0_EMI_MASK          (0xFBF)
#define SYSC_PECGR0_VIC_MASK          (0xFDF)
#define SYSC_PECGR0_SRAMARB_MASK      (0xFEF)
#define SYSC_PECGR0_SRAM_MASK         (0xFF7)
#define SYSC_PECGR0_PFQBC_MASK        (0xFFD)
#define SYSC_PECGR0_FMI_MASK          (0xFFE)

/* PECGR1 */
#define SYSC_PECGR1_MASK              (0x1FFFFFF)
#define SYSC_PECGR1_RTC_MASK          (0x0FFFFFF)
#define SYSC_PECGR1_GPIO9_MASK        (0x17FFFFF)
#define SYSC_PECGR1_GPIO8_MASK        (0x1BFFFFF)
#define SYSC_PECGR1_GPIO7_MASK        (0x1DFFFFF)
#define SYSC_PECGR1_GPIO6_MASK        (0x1EFFFFF)
#define SYSC_PECGR1_GPIO5_MASK        (0x1F7FFFF)
#define SYSC_PECGR1_GPIO4_MASK        (0x1FBFFFF)
#define SYSC_PECGR1_GPIO3_MASK        (0x1FDFFFF)
#define SYSC_PECGR1_GPIO2_MASK        (0x1FEFFFF)
#define SYSC_PECGR1_GPIO1_MASK        (0x1FF7FFF)
#define SYSC_PECGR1_GPIO0_MASK        (0x1FFBFFF)
#define SYSC_PECGR1_WAKEUP_MASK       (0x1FFDFFF)
#define SYSC_PECGR1_WDG_MASK          (0x1FFEFFF)
#define SYSC_PECGR1_ADC_MASK          (0x1FFF7FF)
#define SYSC_PECGR1_CAN_MASK          (0x1FFFBFF)
#define SYSC_PECGR1_SPI1_MASK         (0x1FFFDFF)
#define SYSC_PECGR1_SPI0_MASK         (0x1FFFEFF)
#define SYSC_PECGR1_I2C1_MASK         (0x1FFFF7F)
#define SYSC_PECGR1_I2C0_MASK         (0x1FFFFBF)
#define SYSC_PECGR1_UART2_MASK        (0x1FFFFDF)
#define SYSC_PECGR1_UART1_MASK        (0x1FFFFEF)
#define SYSC_PECGR1_UART0_MASK        (0x1FFFFF7)
#define SYSC_PECGR1_MOTCNT_MASK       (0x1FFFFFB)
#define SYSC_PECGR1_EFT34_MASK        (0x1FFFFFD)
#define SYSC_PECGR1_EFT12_MASK        (0x1FFFFFE)

/* SCR0 */
#define SYSC_SCR0_MASK                (0x7FFF)
#define SYSC_SCR0_P30ETMDBG_MASK      (0x3FFF)
#define SYSC_SCR0_ETMDBG_MASK         (0x5FFF)
#define SYSC_SCR0_IRDA2_MASK          (0x6FFF)
#define SYSC_SCR0_IRDA1_MASK          (0x77FF)
#define SYSC_SCR0_IRDA0_MASK          (0x7BFF)
#define SYSC_SCR0_REMAP_MASK          (0x7DFF)
#define SYSC_SCR0_EMIALELNGT_MASK     (0x7EFF)
#define SYSC_SCR0_EMIALEPOL_MASK      (0x7F7F)
#define SYSC_SCR0_EMIMUX_MASK         (0x7FBF)
#define SYSC_SCR0_SRAMLOCK_MASK       (0x7FDF)
#define SYSC_SCR0_SRAMSIZE_MASK       (0x7FE7)
#define SYSC_SCR0_WSRAHB_MASK         (0x7FFB)
#define SYSC_SCR0_WSRDTCM_MASK        (0x7FFD)
#define SYSC_SCR0_ENPFQBC_MASK        (0x7FFE)

/* SCR1 */
#define SYSC_SCR1_MASK                (0xFFFF)

/* SCR2 */
#define SYSC_SCR2_MASK                (0xFFFF)

/* SCR3 */
#define SYSC_SCR3_MASK                (0xFFFF)

/* GPIO_OUT0-7 */
#define SYSC_GPIO_OUT_MASK           (0xFFFF)
#define SYSC_GPIO_OUT_BIT7_MASK      (0x3FFF)
#define SYSC_GPIO_OUT_BIT6_MASK      (0xCFFF)
#define SYSC_GPIO_OUT_BIT5_MASK      (0xF3FF)
#define SYSC_GPIO_OUT_BIT4_MASK      (0xFCFF)
#define SYSC_GPIO_OUT_BIT3_MASK      (0xFF3F)
#define SYSC_GPIO_OUT_BIT2_MASK      (0xFFCF)
#define SYSC_GPIO_OUT_BIT1_MASK      (0xFFF3)
#define SYSC_GPIO_OUT_BIT0_MASK      (0xFFFC)

/* GPIO_IN0-7 */
#define SYSC_GPIO_IN_MASK           (0xFF)
#define SYSC_GPIO_IN_BIT7_MASK      (0x7F)
#define SYSC_GPIO_IN_BIT6_MASK      (0xBF)
#define SYSC_GPIO_IN_BIT5_MASK      (0xDF)
#define SYSC_GPIO_IN_BIT4_MASK      (0xEF)
#define SYSC_GPIO_IN_BIT3_MASK      (0xF7)
#define SYSC_GPIO_IN_BIT2_MASK      (0xFB)
#define SYSC_GPIO_IN_BIT1_MASK      (0xFD)
#define SYSC_GPIO_IN_BIT0_MASK      (0xFE)

/* GPIO_TYPE0-9 */
#define SYSC_GPIO_TYPE_MASK           (0xFF)
#define SYSC_GPIO_TYPE_BIT7_MASK      (0x7F)
#define SYSC_GPIO_TYPE_BIT6_MASK      (0xBF)
#define SYSC_GPIO_TYPE_BIT5_MASK      (0xDF)
#define SYSC_GPIO_TYPE_BIT4_MASK      (0xEF)
#define SYSC_GPIO_TYPE_BIT3_MASK      (0xF7)
#define SYSC_GPIO_TYPE_BIT2_MASK      (0xFB)
#define SYSC_GPIO_TYPE_BIT1_MASK      (0xFD)
#define SYSC_GPIO_TYPE_BIT0_MASK      (0xFE)

/* GPIO_EMI */
#define SYSC_GPIO_EMI_MASK            (0x1)

/* Wake_up */
#define SYSC_WUKP_SEL_MASK            (0xFFF)

/* USB test */
#define SYSC_USB_TST_MASK             (0x3)

/* Locking key */
#define SYSC_LOCK_KEY                 (0xA5A5F05A)

/* Locking key */
#define SYSC_GPIO_ANA_MASK           (0x3FF)
#define SYSC_GPIO_ANA_BIT9_MASK      (0x1FF)
#define SYSC_GPIO_ANA_BIT8_MASK      (0x2FF)
#define SYSC_GPIO_ANA_BIT7_MASK      (0x37F)
#define SYSC_GPIO_ANA_BIT6_MASK      (0x3BF)
#define SYSC_GPIO_ANA_BIT5_MASK      (0x3DF)
#define SYSC_GPIO_ANA_BIT4_MASK      (0x3EF)
#define SYSC_GPIO_ANA_BIT3_MASK      (0x3F7)
#define SYSC_GPIO_ANA_BIT2_MASK      (0x3FB)
#define SYSC_GPIO_ANA_BIT1_MASK      (0x3FD)
#define SYSC_GPIO_ANA_BIT0_MASK      (0x3FE)

// END of SYSCNTR specific map and constants


typedef enum {
               USB_SEL_PLL =0x0,
               USB_SEL_PLL_DIV2 =0x1,
               USB_SEL_PIN_CLK =0x2,
             } SYSCNTR_CLKCNTR_USB_SEL;

typedef enum {
               BR_SEL_DIV2 =0x00,
               BR_SEL_EQU_ARM =0x01
             } SYSCNTR_CLKCNTR_BR_SEL;

typedef enum {
               APB_DIV1=0x00,
               APB_DIV2 =0x01,
               APB_DIV4 =0x02,
			   APB_DIV8 =0x03
             } SYSCNTR_CLKCNTR_APB_DIV;

typedef enum {
               AHB_DIV1=0x00,
               AHB_DIV2 =0x01,
               AHB_DIV4 =0x02
             } SYSCNTR_CLKCNTR_AHB_DIV;

typedef enum {
               CK_DIV_DIV1 =0x00,
               CK_DIV_DIV2 =0x01,
               CK_DIV_DIV4 =0x02,
               CK_DIV_DIV8 =0x03,
               CK_DIV_DIV16 =0x04,
               CK_DIV_DIV1024 = 0x05
             } SYSCNTR_CLKCNTR_CK_DIV;

typedef enum {
               CLKSEL_PLL_CLK =0x0,
               CLKSEL_RTC_CLK =0x1,
               CLKSEL_OSC_CLK =0x2,
             } SYSCNTR_CLKCNTR_CLK_SEL;


/*******************************************************************************
********************************* SYSCNTR Functions ****************************
*******************************************************************************/
EXT s32 SYSCNTR_EnDisPll(__SYSCNTR_Reg_File *pSysCntr,u32 wSettings);
EXT s32 SYSCNTR_SetPllClk(__SYSCNTR_Reg_File *pSysCntr,u32 pDiv, u32 nDiv, u32 mDiv);
EXT s32 SYSCNTR_SetMcuClock(__SYSCNTR_Reg_File *pSysCntr,u32 wSettings);
EXT s32 SYSCNTR_SetAhbRatio(__SYSCNTR_Reg_File *pSysCntr,u32 wSettings);
EXT s32 SYSCNTR_SetApbRatio(__SYSCNTR_Reg_File *pSysCntr,u32 wSettings);
EXT s32 SYSCNTR_SetUsbSel(__SYSCNTR_Reg_File *pSysCntr,u32 wSettings);
EXT s32 SYSCNTR_Pcgr0(__SYSCNTR_Reg_File *pSysCntr,u32 Pcgr0_bit_postition, u32 EnDis);
EXT s32 SYSCNTR_Pcgr1(__SYSCNTR_Reg_File *pSysCntr,u32 Pcgr1_bit_postition, u32 EnDis);
EXT s32 SYSCNTR_Prr0(__SYSCNTR_Reg_File *pSysCntr,u32 Pcgr0_bit_postition, u32 Reset);
EXT s32 SYSCNTR_Prr1(__SYSCNTR_Reg_File *pSysCntr,u32 Pcgr1_bit_postition, u32 Reset);
EXT s32 SYSCNTR_GpioOut3(__SYSCNTR_Reg_File *pSysCntr,u32 GpioOut3_bit_postition, u32 value);
EXT s32 SYSCNTR_GpioIn3(__SYSCNTR_Reg_File *pSysCntr,u32 GpioIn3_bit_postition, u32 InputMode);
EXT s32 SYSCNTR_VicClk(__SYSCNTR_Reg_File *pSysCntr,u32 wSettings);
EXT s32 SYSCNTR_VicRst(__SYSCNTR_Reg_File *pSysCntr,u32 wSettings);
EXT s32 SYSCNTR_Scr0(__SYSCNTR_Reg_File *pRf,u32 Scr0_bit_postition, u32 value);
EXT s32 SYSCNTR_GpioConfigOut(u32 port,u8 GpioOut_bit_postition, u8 value);
EXT s32 SYSCNTR_GpioConfigIn(u32 port,u8 GpioIn_bit_postition, u8 value);
EXT s32 SYSCNTR_GpioType(u32 port,u32 GpioType_bit_postition, u32 InputMode);
EXT s32 SYSCNTR_Gpio_Emi(__SYSCNTR_Reg_File *pRf, u32 wSettings);
EXT void GpioWriteByte(u32 port , u8 value);
EXT void GpioWriteBit(u32 port ,u8 GpioWrite_bit_postition, u8 value);
EXT u8 LCDReadByte(u32 port);
EXT u8  GpioReadBit(u32 port ,u8 GpioWrite_bit_postition);

#endif	// __SYSCNTR_H

/******************* (C) COPYRIGHT 2005 STMicroelectronics *****END OF FILE****/
