/**
  ******************************************************************************
  ******************************************************************************
  * @file 3rd_CEC_Device/src/stm32f10x_it.c 
  * @author  MCD Application Team
  * @version  V2.0.0
  * @date  04/27/2009
  * @brief  Main Interrupt Service Routines.
  *         This file provides template for all exceptions handler and 
  *         peripherals interrupt service routine.
  ******************************************************************************
  * @copy
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  *
  * <h2><center>&copy; COPYRIGHT 2009 STMicroelectronics</center></h2>
  */ 

/* Includes ------------------------------------------------------------------*/
#include "stm32f10x_it.h"
#include "stm32f10x_cec.h"

/** @addtogroup 3rd_CEC_Device
  * @{
  */ 


/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define MyDeviceAddress  0x03 /* My device address: is my initiator address
                                 in case of transmit and the follower address
                                 in cas of receive */

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Receive buffer */
/* Receive buffer */
uint8_t ReceiveBuffer[10]; 
/* Transmit buffer 1 */
uint8_t TransmitBuffer1[8] = {0x32,0x96,0xaf,0xdf,0xa1,0x63,0xd9,0xab};
/* Transmit buffer 2 */
uint8_t TransmitBuffer2[5] = {0x87,0x55,0x7e,0xb0,0xc3};

extern uint8_t ReceivedFrame;
extern uint8_t SendFrame;
extern uint32_t ReceiveInfos;
uint8_t i=0;
ErrorStatus SendStatus = ERROR;
extern uint8_t *BufferPointer;
extern uint8_t ByteNumber;
extern uint8_t SendTo;

/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/******************************************************************************/
/*            Cortex-M3 Processor Exceptions Handlers                         */
/******************************************************************************/

/**
  * @brief  This function handles NMI exception.
  * @param  None
  * @retval : None
  */
void NMI_Handler(void)
{
}

/**
  * @brief  This function handles Hard Fault exception.
  * @param  None
  * @retval : None
  */
void HardFault_Handler(void)
{
  /* Go to infinite loop when Hard Fault exception occurs */
  while (1)
  {
  }
}

/**
  * @brief  This function handles Memory Manage exception.
  * @param  None
  * @retval : None
  */
void MemManage_Handler(void)
{
  /* Go to infinite loop when Memory Manage exception occurs */
  while (1)
  {
  }
}

/**
  * @brief  This function handles Bus Fault exception.
  * @param  None
  * @retval : None
  */
void BusFault_Handler(void)
{
  /* Go to infinite loop when Bus Fault exception occurs */
  while (1)
  {
  }
}

/**
  * @brief  This function handles Usage Fault exception.
  * @param  None
  * @retval : None
  */
void UsageFault_Handler(void)
{
  /* Go to infinite loop when Usage Fault exception occurs */
  while (1)
  {
  }
}

/**
  * @brief  This function handles SVCall exception.
  * @param  None
  * @retval : None
  */
void SVC_Handler(void)
{
}

/**
  * @brief  This function handles Debug Monitor exception.
  * @param  None
  * @retval : None
  */
void DebugMon_Handler(void)
{
}

/**
  * @brief  This function handles PendSVC exception.
  * @param  None
  * @retval : None
  */
void PendSV_Handler(void)
{
}

/**
  * @brief  This function handles SysTick Handler.
  * @param  None
  * @retval : None
  */
void SysTick_Handler(void)
{
   CEC_TimingDelay_Decrement();
}


/**
  * @brief  This function handles EXTI0 interrupt request.
  * @param  None
  * @retval : None
  */
void EXTI0_IRQHandler(void)
{
  if(EXTI_GetITStatus(EXTI_Line0) != RESET)
  {
    /* Receive the CEC frame with my CEC address */
    ReceiveInfos = CEC_ReceiveFrame(ReceiveBuffer, MyDeviceAddress);
    
    /* Set ReceivedFrame to say that a frame was detected on the bus */
    ReceivedFrame = 1;
	
    /* Clear EXTI line 0 pending bit */
    EXTI_ClearITPendingBit(EXTI_Line0);
  }
}

/**
  * @brief  This function handles EXTI9_5 interrupt request.
  * @param  None
  * @retval : None
  */
void EXTI9_5_IRQHandler(void)
{
  if(EXTI_GetITStatus(EXTI_Line9) != RESET)
  {
    if(i==0)
    {
      /* Initialize the pointer to buffer1 to be trasmitted */
      BufferPointer = TransmitBuffer1;
      
      /* The follower address that the frame will sent to */
      SendTo = 0x1;

      /* The size of the data frame to send */
      ByteNumber = 8;
      
       /* Send the CEC frame */
      SendStatus = CEC_SendFrame(MyDeviceAddress, SendTo, ByteNumber, BufferPointer);
      
      i++;
    }
    else
    {
      /* Initialize the pointer to buffer2 to be trasmitted */
      BufferPointer = TransmitBuffer2;
      
      /* The follower address that the frame will sent to */
      SendTo = 0x2;
      
      /* The size of the data frame to send */
      ByteNumber = 5;
            
      /* Send the CEC frame */
      SendStatus = CEC_SendFrame(MyDeviceAddress, SendTo, ByteNumber, BufferPointer);
      
      i=0;
    }
    
    /* Set SendFrame to say that a frame was sent on the bus */
    SendFrame = 1; 
    
    /* Clear EXTI line 0 pending bit */
    EXTI_ClearITPendingBit(EXTI_Line9);
  }
}
/******************************************************************************/
/*                 STM32F10x Peripherals Interrupt Handlers                   */
/*  Add here the Interrupt Handler for the used peripheral(s) (3rd_CEC_Device_src), for the  */
/*  available peripheral interrupt handler's name please refer to the startup */
/*  file (startup_stm32f10x_xx.s).                                            */
/******************************************************************************/

/**
  * @brief  This function handles 3rd_CEC_Device_src interrupt request.
  * @param  None
  * @retval : None
  */
/*void 3rd_CEC_Device_src_IRQHandler(void)
{
}*/

/**
  * @}
  */ 


/******************* (C) COPYRIGHT 2009 STMicroelectronics *****END OF FILE****/
